#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gimpfu import *
import os, glob

def do_load_files(imgfname) :
    img = pdb.gimp_file_load(imgfname + "_R.tif", "")
#                             load R ch. file as background
    img.filename = imgfname  + "_RGB.xcf" #change image's filename
    disp = pdb.gimp_display_new(img) #display image
    filenames = [imgfname + "_Fg_Mask_Yrsv.tif",
        imgfname + "_Brown_Adjst_Mask.tif",
        imgfname + "_Green_Adjst_Mask.tif",
        imgfname + "_Shadow_Mask.tif",
        imgfname + "_Periph_Adjst_Mask.tif",
        imgfname + "_Bg_Thld_Mask.tif",
        imgfname + "_Fg_Mask.tif",
        imgfname + "_B.tif",
        imgfname + "_B_Fg.tif",
        imgfname + "_Periph_Adjst.tif",
        imgfname + "_Brown_Adjst.tif",
        imgfname + "_B.tif",
        imgfname + "_Green_Adjst.tif",
        imgfname + "_B_Bg.tif",
        imgfname + "_Shadow.tif",
        imgfname + "_G.tif", 
        imgfname + "_R.tif"]
    for filename in filenames:
        try:
            image_id, layer_ids = pdb.gimp_file_load_layers(img,
                 filename)
            for id in layer_ids:
                new_layer = gimp.Item.from_id(id)
                pdb.gimp_image_add_layer(img, new_layer, 0)
                pdb.gimp_layer_add_alpha (new_layer)
        except Exception, error:
            print error
    image = gimp.image_list()[0]
#   apply_mask2layer(copying mask image, applying layer, imageß)
    apply_mask2layer(10, 8, image) # Copy Fg Mask Image to Layer
    apply_mask2layer(11, 3, image) # Copy Bg Mask Image to Layer
    apply_mask2layer(12, 7, image) # Copy Periph Mask Image to Layer
    apply_mask2layer(13, 2, image) # Copy Shadow Mask Image to Layer
    apply_mask2layer(14, 4, image) # Copy Green Adjst Mask Image to Layer
    apply_mask2layer(15, 6, image) # Copy Brown Adjst Mask Image to Layer
    apply_mask2layer(15, 5, image) # Copy Brown Adjst Mask Image to Layer(2nd)

# Back Ground Layer (image.layers[17]) to White
    color = (1.0, 1.0, 1.0, 1.0)
#    color: (R Value, G Value, B Value, Transparence)
    pdb.gimp_context_set_background(color) #Set background painting color
    pdb.gimp_edit_fill(image.layers[17], BACKGROUND_FILL)
#    Fill layer[10] with Background Painting Color
    pdb.gimp_item_set_visible(image.layers[0], FALSE) # R
    pdb.gimp_item_set_visible(image.layers[1], FALSE) # G
    pdb.gimp_item_set_visible(image.layers[5], FALSE) # Brown_Adjst
    for i in range(10, 17): # making unvisible mask images
        pdb.gimp_item_set_visible(image.layers[i], FALSE)  
#   set layer names
    pdb.gimp_item_set_name(image.layers[0], "R")
    pdb.gimp_item_set_name(image.layers[1], "G")
    pdb.gimp_item_set_name(image.layers[2], "Shadow")
    pdb.gimp_item_set_name(image.layers[7], "Periph_Adjst")
    pdb.gimp_item_set_name(image.layers[3], "B_Bg")
    pdb.gimp_item_set_name(image.layers[4], "Green_Adjst")
    pdb.gimp_item_set_name(image.layers[5], "Brown_Adjst")
    pdb.gimp_item_set_name(image.layers[6], "Brown_Adjst_Mg_cast")
    pdb.gimp_item_set_name(image.layers[8], "B_Fg")
    pdb.gimp_item_set_name(image.layers[9], "B")
    #pdb.gimp_layer_remove_mask(image.layers[9], 0) 
    pdb.gimp_item_set_name(image.layers[10], "Fg_Mask")
    pdb.gimp_item_set_name(image.layers[11], "Bg_Mask")
    pdb.gimp_item_set_name(image.layers[12], "Periph_Adjst_Mask")
    pdb.gimp_item_set_name(image.layers[13], "Shadow_Mask")
    pdb.gimp_item_set_name(image.layers[14], "Green_Adjst_Mask")
    pdb.gimp_item_set_name(image.layers[15], "Brown_Adjst_Mask")
    pdb.gimp_item_set_name(image.layers[16], "Fg_Mask_Yrsv")

    return

def apply_mask2layer(n_mask, n_layer, image):
    #pdb.gimp_edit_copy(image.layers[n_mask]) # Copy Mask Image
    mask = pdb.gimp_layer_create_mask(image.layers[n_mask], ADD_MASK_COPY)
    pdb.gimp_layer_add_mask(image.layers[n_layer], mask)

register(
    "do_load_files_v3_6j",
    "黄変写真補正素材ファイル読込(v3.6)",
    "Load files for yellowed photo editing",
    "Ohnishi, Yasuo",
    "Ohnishi, Yasuo",
    "2024 Ver3.6",
    "ファイル読込(v3.6)...",
    "",      # Alternately use RGB, RGB*, GRAY*, INDEXED etc.
    [
        (PF_FILE, "imgfname", "作成元黄変写真ファイルの指定", ""),
    ],
    [],
    do_load_files, menu="<Image>/My Plugins/黄変写真補正ツール Ver2" )
main()

