#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gimpfu import *
import os, glob

def merge_visible_layers_and_compose_rgb(img, drawable):
#           img: currect active image
#           drawable: currect active drawable
#  delete currect selections
    pdb.gimp_selection_none(img)
#   transform visible image to new layer
    new_layer = pdb.gimp_layer_new_from_visible(img, img, "New B")
    pdb.gimp_image_add_layer(img, new_layer, 2) # add new layer as 3rd layer (New B)
#   get currect image filename to "filename"
    filename = img.filename
    ext = os.path.splitext(os.path.basename(filename))[1]
# compose R, G, B image to one New color image
    pdb.gimp_edit_copy(img.layers[0])
    red = pdb.gimp_edit_paste_as_new_image()
    pdb.gimp_edit_copy(img.layers[1])
    green = pdb.gimp_edit_paste_as_new_image()
    pdb.gimp_edit_copy(img.layers[2])
    blue = pdb.gimp_edit_paste_as_new_image()
    compose = pdb.plug_in_compose(red, img.layers[3], green, blue, blue,"RGB")
#             "img.layers[3]" & second "blue" for dummy parameters
    filename = filename.replace(".tif_RGB.xcf", "_Adjst1.xcf")
    compose.filename = filename
    disp = pdb.gimp_display_new(compose)
    drawable = pdb.gimp_image_get_active_layer(compose)
# save new composed image as xcf and tiff files
    pdb.gimp_file_save(compose, drawable, compose.filename, compose.filename)
    filename = filename.replace("_Adjst1.xcf", "_Adjst1.tif")
    pdb.file_tiff_save(compose, drawable, filename, filename, 3)
    pdb.gimp_image_delete(red)
    pdb.gimp_image_delete(green)
    pdb.gimp_image_delete(blue)
    return

register(
    "make_B_image_and_compose_RGB",
    "make_B_image_and_compose_RGB",
    "make_B_image_and_compose_RGB",
    "Ohnishi, Yasuo",
    "Ohnishi, Yasuo",
    "2021 Ver 0.03",
    "Combine RGB Image...",
    "*",      # Alternately use RGB, RGB*, GRAY*, INDEXED etc.
    [
#   get currect active image and drawable to "img" and "drawable"
    (PF_IMAGE, "img", "Input image", None),
    (PF_DRAWABLE, "drawable", "Input drawable", None), 
    ],
    [],
    merge_visible_layers_and_compose_rgb, menu="<Image>/My Plugins/Yellowed Photo Correction" )
main()

