// winmain.cpp

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <mbctype.h>
#include <errno.h>
#include "msc.h"
#include "winmain.h"



// memo -D
//   NOCRT     Do not use C-Runtime Library
//   NOARG     Declared main without argc, argv

//   DEBUG_MALLOC
//   DEBUG_MALLOC_LEAK
//   DEBUG_BSEARCH
//   DEBUG_EXCEPTION



// select UNICODE entry point compulsorily
#if defined _MSC_VER && ! defined TEST_STARTUP_ANSI
#define STARTUP_UNICODE    1
#else
#define STARTUP_UNICODE    0
#endif


#if defined DEBUG_EXCEPTION
#define SET_EXCEPTION_FILTER  1
#else
#define SET_EXCEPTION_FILTER  0
#endif



static int InitProc ( void ) ;
static int PrintMessage ( const char *szMessage ) ;
static LONG WINAPI DefaultExceptionFilter ( EXCEPTION_POINTERS *p ) ;


// winmain.h
#undef main



#define INIT_ERROR_MESSAGE          "Fatal error - failed to initialize environment.\n"
#define ALERT_ON_CLOSE_MESSAGE      "Press any key to close..."



////////////////////////////////////////////
//                   CRT                  //
////////////////////////////////////////////



#ifdef __cplusplus
extern "C" {
#endif


#if ! defined NOCRT


#ifdef _MSC_VER

int __cdecl _setenvp ( void ) { return 0 ; }
int __cdecl _wsetenvp ( void ) { return 0 ; }
char *__cdecl __crtGetEnvironmentStringsA ( void ) { return NULL ; }
wchar_t *__cdecl __crtGetEnvironmentStringsW ( void ) { return NULL ; }

#if defined _WINDOWS && ! defined _USRDLL
char *__cdecl _wincmdln ( void ) { return NULL ; }
wchar_t *__cdecl _wwincmdln ( void ) { return NULL ; }
#endif // defined _WINDOWS && ! defined _USRDLL

#if defined NOARG || defined _USRDLL
int __cdecl _setargv ( void ) { return 0 ; }
int __cdecl _wsetargv ( void ) { return 0 ; }
char *__cdecl __crtGetCommandLineA ( void ) { return NULL ; }
wchar_t *__cdecl __crtGetCommandLineW ( void ) { return NULL ; }
#endif // defined NOARG || defined _USRDLL

#endif // _MSC_VER


#else // ! defined NOCRT


#ifndef NOARG
#define NOARG
#endif

#ifdef _MSC_VER

#pragma comment ( linker, "/nodefaultlib" )

#ifdef _USRDLL
#pragma comment ( linker, "/entry:DllMain" )
#else // _USRDLL
#pragma comment ( linker, "/entry:main" )
void main ( void ) { ExitProcess ( winmain_ () ) ; }
#endif // else of _USRDLL

#endif // _MSC_VER


#endif // else of ! defined NOCRT


#ifdef __cplusplus
}
#endif



////////////////////////////////////////////
//                ARGUMENT                //
////////////////////////////////////////////



#if STARTUP_UNICODE
static char **argv_dummy_ ;
#undef __argv
#define __argv argv_dummy_
#else
static wchar_t **wargv_dummy_ ;
#undef __wargv
#define __wargv wargv_dummy_
#endif



////////////////////////////////////////////
//              WINDOWS MAIN              //
////////////////////////////////////////////



#if defined _WINDOWS && ! defined _USRDLL && ! defined NOCRT



#if STARTUP_UNICODE
int WINAPI wWinMain ( HINSTANCE hInstance,
                      HINSTANCE hPrevInstance,
                      LPWSTR    lpCmdLine,
                      int       nCmdShow )
#else
int WINAPI WinMain ( HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
#endif
{

   if ( SET_EXCEPTION_FILTER ) SetUnhandledExceptionFilter ( DefaultExceptionFilter ) ;

   if ( InitProc () ) return PrintMessage ( INIT_ERROR_MESSAGE ) ;

#if defined NOARG
   return winmain_ () ;
#else
   return winmain_ ( __argc, __argv ) ;
#endif
}



#endif // defined _WINDOWS && ! defined _USRDLL && ! defined NOCRT



////////////////////////////////////////////
//              CONSOLE MAIN              //
////////////////////////////////////////////



#if defined _CONSOLE && ! defined NOCRT



#if STARTUP_UNICODE
int __cdecl wmain ( int argc, wchar_t *argv [] )
#else
int __cdecl main ( int argc, char *argv [] )
#endif
{

   if ( SET_EXCEPTION_FILTER ) SetUnhandledExceptionFilter ( DefaultExceptionFilter ) ;

   if ( InitProc () ) return PrintMessage ( INIT_ERROR_MESSAGE ) ;

#if defined NOARG
   return winmain_ () ;
#else
   return winmain_ ( __argc, __argv ) ;
#endif
}



#endif // defined _CONSOLE && ! defined NOCRT



////////////////////////////////////////////
//                DLL MAIN                //
////////////////////////////////////////////



#if defined _USRDLL && ! defined NOCRT



#undef DllMain
int WINAPI DllMain ( HINSTANCE hInst, unsigned long nReason, void *pReserved ) {

   if ( nReason == DLL_PROCESS_ATTACH ) {
      if ( InitProc () ) return FALSE ;
   }

   static int IsCalledUserMainOnAttached ;

   // InitProc () ŃG[oƂADllMain_  ATTACH  DETACH ŌĂяoȂ悤ɂ
   if ( nReason == DLL_PROCESS_ATTACH ) {
      if ( IsCalledUserMainOnAttached ) return TRUE ;    // Ô
      IsCalledUserMainOnAttached = 1 ;
   }
   else if ( nReason == DLL_PROCESS_DETACH ) {
      if ( ! IsCalledUserMainOnAttached ) return TRUE ;
      IsCalledUserMainOnAttached = 0 ;
   }

   int nRetValue = DllMain_ ( hInst, nReason, pReserved ) ;

#if _MSC_VER < 1400
   // Â CRT ł ATTACH s DETACH Ă΂Ȃ
   if ( nReason == DLL_PROCESS_ATTACH && nRetValue == FALSE ) {
      DllMain ( hInst, DLL_PROCESS_DETACH, pReserved ) ;
   }
#endif

#if defined _MT
   if ( nReason == DLL_THREAD_DETACH ) {
      FreeThreadInternalData ( GetThreadInternalData () ) ;
   }
#endif

   return nRetValue ;
}



#endif // defined _USRDLL && ! defined NOCRT



////////////////////////////////////////////
//             EXIT/INIT PROC             //
////////////////////////////////////////////



#if ! defined NOCRT



#if defined _MT
CRITICAL_SECTION LoadDllSection ;
#endif

static void __cdecl ExitProc ( void ) ;
static int InitOsverWinver ( void ) ;
static int AllocTlsIndex ( void ) ;
static int SetArgument ( void ) ;

static void AlertOnClose ( void ) ;
static void FreeTlsIndex ( void ) ;

#if defined DEBUG_MALLOC
static int init_malloc_debug ( void ) ;
static void debug_heap_on_exit ( void ) ;
#endif

#if _MSC_VER < 1300 && ! defined NOCRT
static void close_stdnul_on_exit ( void ) ;
#endif



//  0 As 0 ȊOԂ
static int InitProc ( void ) {

   if ( atexit ( ExitProc ) ) return 1 ;

   if ( InitOsverWinver () ) return 1 ;

#if defined _MT
   if ( InitializeCriticalSectionEx ( & LoadDllSection ) ) return 1 ;
   if ( AllocTlsIndex () ) return 1 ;
#endif

#if ! defined _USRDLL
   if ( InitializeThreadInternalData ( AllocThreadInternalData () ) ) return 1 ;
#endif

#if ! defined NOARG && ! defined _USRDLL
   if ( SetArgument () ) return 1 ;
#endif

#if defined DEBUG_MALLOC
   if ( init_malloc_debug () ) return 1 ;
#endif

   return 0 ;
}



static void __cdecl ExitProc ( void ) {

#if defined _CONSOLE
   AlertOnClose () ;
#endif

   FreeThreadInternalData ( GetThreadInternalData () ) ;

#if defined _MT
   FreeTlsIndex () ;
   DeleteCriticalSection ( & LoadDllSection ) ;
#endif

#if defined DEBUG_MALLOC
   debug_heap_on_exit () ;
#endif

#if _MSC_VER < 1300 && ! defined NOCRT
   close_stdnul_on_exit () ;
#endif

   return ;
}



#endif // ! defined NOCRT



////////////////////////////////////////////
//              GETARGUMENT               //
////////////////////////////////////////////



#if ! defined NOARG && ! defined _USRDLL



// 擾iANSIŁj
// s NULL Ԃ
const char *GetArgumentA ( int nCount ) {

   if ( __argv && (unsigned) nCount <= (unsigned) __argc ) return __argv [ nCount ] ;

   return NULL ;
}



// 擾iUNICODEŁj
// s NULL Ԃ
const wchar_t *GetArgumentW ( int nCount ) {

   if ( __wargv && (unsigned) nCount <= (unsigned) __argc ) return __wargv [ nCount ] ;

   return NULL ;
}



// 
//  0 As 0 ȊOԂ
static int SetArgument ( void ) {

#if STARTUP_UNICODE

   if ( ! ( __argv = malloc_array ( char*, __argc + 1 ) ) ) return 1 ;

   for ( int nCount = 0 ; nCount <= __argc ; nCount ++ ) {
      if ( ! __wargv [ nCount ] ) __argv [ nCount ] = NULL ;
      else {
         char *string = w2adup ( __wargv [ nCount ] ) ;
         if ( ! string ) return 1 ;
         __argv [ nCount ] = string ;
      }
   }

#else

   if ( ! ( __wargv = malloc_array ( wchar_t*, __argc + 1 ) ) ) return 1 ;

   for ( int nCount = 0 ; nCount <= __argc ; nCount ++ ) {
      if ( ! __argv [ nCount ] ) __wargv [ nCount ] = NULL ;
      else {
         wchar_t *string = a2wdup ( __argv [ nCount ] ) ;
         if ( ! string ) return 1 ;
         __wargv [ nCount ] = string ;
      }
   }

#endif

   return 0 ;
}



#endif // ! defined NOARG && ! defined _USRDLL



////////////////////////////////////////////
//           GET WINMAIN CMDLINE          //
////////////////////////////////////////////



#if ! defined _USRDLL



// WinMain `̈擾iANSIŁj
// s璷[̕Ԃ
const char *GetWinMainCmdLineA ( void ) {

   const char *szCommandLine ;
   int IsInQuote = 0 ;

   szCommandLine = GetCommandLineA () ;
   if ( ! szCommandLine ) return "" ;

   while ( *szCommandLine > ' ' || *szCommandLine && IsInQuote ) {
      if ( *szCommandLine == '\"' ) IsInQuote = ! IsInQuote ;
      szCommandLine += mbsnext ( szCommandLine ) ;
   }

   while ( *szCommandLine && *szCommandLine <= ' ' ) szCommandLine ++ ;

   return szCommandLine ;
}



// WinMain `̈擾iUNICODEŁj
// s璷[̕Ԃ
const wchar_t *GetWinMainCmdLineW ( void ) {

   const wchar_t *szCommandLine ;
   int IsInQuote = 0 ;

   szCommandLine = GetCommandLineW () ;
   if ( ! szCommandLine ) return L"" ;

   while ( *szCommandLine > ' ' || *szCommandLine && IsInQuote ) {
      if ( *szCommandLine == '\"' ) IsInQuote = ! IsInQuote ;
      szCommandLine += wcsnext ( szCommandLine ) ;
   }

   while ( *szCommandLine && *szCommandLine <= ' ' ) szCommandLine ++ ;

   return szCommandLine ;
}



#endif // ! defined _USRDLL



////////////////////////////////////////////
//           EXCEPTION HANDLER            //
////////////////////////////////////////////



#if ! defined _USRDLL && ! defined NOCRT



static LONG WINAPI DefaultExceptionFilter ( EXCEPTION_POINTERS *p ) {

   char szBuffer [ MAX_PATH + 0x100 ] ;

   sprintf ( szBuffer, "Fatal Exception Error\nProcess: " ) ;
   GetModuleFileNameA ( NULL, strend ( szBuffer ), MAX_PATH ) ;
   sprintf ( strend ( szBuffer ), "\nCode: %X, Address: %p\n", p->ExceptionRecord->ExceptionCode, p->ExceptionRecord->ExceptionAddress ) ;

   PrintMessage ( szBuffer ) ;

   return EXCEPTION_EXECUTE_HANDLER ;
}



#endif



////////////////////////////////////////////
//                MESSAGE                 //
////////////////////////////////////////////



#if ! defined NOCRT
#if defined _WINDOWS && ! defined _USRDLL



#define MessageBoxA MessageBoxA_
typedef int ( WINAPI *MESSAGEBOXA ) ( HWND hWnd, LPCSTR lpText, LPCSTR lpCaption, UINT uType ) ;



// bZ[W{bNXɃbZ[Wo͂
static int PrintMessage ( const char *szMessage ) {

   static HINSTANCE hUser32 ;
   static MESSAGEBOXA MessageBoxA ;

   if ( ! hUser32 ) {
      if ( IsNT () ) hUser32 = LoadLibraryW ( L"USER32.DLL" ) ;
      else           hUser32 = LoadLibraryA (  "USER32.DLL" ) ;
   }

   if ( ! GETPROCADDRESS ( hUser32, MESSAGEBOXA, MessageBoxA ) ) {
      MessageBoxA ( NULL, szMessage, "", MB_OK | MB_ICONHAND | MB_SETFOREGROUND ) ;
   }

   return ERRORLEVEL_MAX ;
}



#else



// WG[o͂ɃbZ[Wo͂
static int PrintMessage ( const char *szMessage ) {

   unsigned long nCharWritten ;
   WriteFile ( GetStdHandle ( STD_ERROR_HANDLE ), szMessage, (unsigned long) strlen ( szMessage ), & nCharWritten, NULL ) ;

   return ERRORLEVEL_MAX ;
}



#endif // else of defined _WINDOWS && ! defined _USRDLL
#endif // ! defined NOCRT



////////////////////////////////////////////
//                 ALERT                  //
////////////////////////////////////////////



#if defined _CONSOLE && ! defined NOCRT



static int nAlertOnCloseMode = ALERT_ON_CLOSE_AUTO ;



void SetAlertOnClose ( int nMode ) {
   switch ( nMode ) {
      case ALERT_ON_CLOSE_AUTO :
      case ALERT_ON_CLOSE_DISABLED :
      case ALERT_ON_CLOSE_ENABLED :
         nAlertOnCloseMode = nMode ;
         break ;
   }
}



static void WaitKey ( void ) ;



// GNXv[璼ڌĂяoꂽAOɃL[͂𑣂
static void AlertOnClose ( void ) {

   if ( nAlertOnCloseMode == ALERT_ON_CLOSE_ENABLED || nAlertOnCloseMode == ALERT_ON_CLOSE_AUTO && ! IsConsole () ) {
      if ( fisatty ( stdout ) && fisatty ( stderr ) ) {
         fflush ( NULL ) ;
         PrintMessage ( ALERT_ON_CLOSE_MESSAGE ) ;
         WaitKey () ;
      }
   }

   return ;
}



// R\[L[͂琧Ԃ
// W͂_CNgĂÂ܂ܐԂ
static void WaitKey ( void ) {

   HANDLE hConsole = fget_osfhandle ( stdin ) ;
   if ( hConsole == INVALID_HANDLE_VALUE ) return ;

   unsigned long dwDummy ;
   if ( ! GetConsoleMode ( hConsole, & dwDummy ) ) return ;

   FlushConsoleInputBuffer ( hConsole ) ;

   while ( 1 ) {

      INPUT_RECORD InputRecord ;
      unsigned long nReadLength ;

      if ( IsNT () ) {
         if ( ! ReadConsoleInputW ( hConsole, & InputRecord, 1, & nReadLength ) || ! nReadLength ) break ;
         if ( InputRecord.EventType == KEY_EVENT && InputRecord.Event.KeyEvent.bKeyDown ) break ;
      }
      else {
         if ( ! ReadConsoleInputA ( hConsole, & InputRecord, 1, & nReadLength ) || ! nReadLength ) break ;
         if ( InputRecord.EventType == KEY_EVENT && InputRecord.Event.KeyEvent.bKeyDown ) break ;
      }
   }

   return ;
}



// R\[NꂽȂ 0 ȊOԂ
int IsConsole ( void ) {

   if ( IS_NT_ONLY ) {

      STARTUPINFOW StartupInfo = { 0 } ;
      StartupInfo.cb = sizeof(STARTUPINFOW) ;
      GetStartupInfoW ( & StartupInfo ) ;

      if ( StartupInfo.dwFlags & STARTF_USESHOWWINDOW && StartupInfo.wShowWindow != SW_HIDE ) return 0 ;
      else                                                                                    return 1 ;
   }
   else {

      STARTUPINFOA StartupInfo = { 0 } ;
      StartupInfo.cb = sizeof(STARTUPINFOA) ;
      GetStartupInfoA ( & StartupInfo ) ;

      if ( StartupInfo.dwFlags & STARTF_USESHOWWINDOW && StartupInfo.wShowWindow != SW_HIDE ) return 0 ;
      else                                                                                    return 1 ;
   }
}



#endif // defined _CONSOLE && ! defined NOCRT



////////////////////////////////////////////
//            CRITICAL SECTION            //
////////////////////////////////////////////



#if ! defined NOCRT



//  0 As 0 ȊOԂ
int InitializeCriticalSectionEx ( PCRITICAL_SECTION pCriticalSection ) {

   const int nSpinCount = 4000 ;

#if _WIN32_WINNT < 0x403 || REQUIRED_MINIMUM_WINVER < 0x403

   typedef BOOL ( WINAPI *INITIALIZECRITICALSECTIONANDSPINCOUNT ) ( LPCRITICAL_SECTION lpCriticalSection, DWORD dwSpinCount ) ;
   static INITIALIZECRITICALSECTIONANDSPINCOUNT InitializeCriticalSectionAndSpinCount ;
   static int IsTried ;

   if ( IsWin2000orLater () ) {
      if ( ! IsTried ) {
         HINSTANCE hKernel32 = GetModuleHandleW ( L"KERNEL32.DLL" ) ;
         GETPROCADDRESS ( hKernel32, INITIALIZECRITICALSECTIONANDSPINCOUNT, InitializeCriticalSectionAndSpinCount ) ;
         IsTried = 1 ;
      }
   }

   if ( ! InitializeCriticalSectionAndSpinCount ) {
      __try {
         InitializeCriticalSection ( pCriticalSection ) ;
      }
      __except ( EXCEPTION_EXECUTE_HANDLER ) { return 1 ; }
      return 0 ;
   }
#endif

   return ! InitializeCriticalSectionAndSpinCount ( pCriticalSection, nSpinCount ) ;
}



#endif // ! defined NOCRT



////////////////////////////////////////////
//               MULTITHREAD              //
////////////////////////////////////////////



#if ! defined NOCRT



// }`Xbhł TLS ɂAhXۑ
// VOXbhł͐ÓIϐɂAhXۑ
// DLL ł͗vƂɃ[mۂ

#if defined _MT
static unsigned long nTlsIndex ;
#else
static THREAD_INTERNAL_DATA_ *pPrimaryThreadInternalData ;
#endif



#if defined _MT
// TLS CfbNX擾AXbh̃f[^Zbg
//  0 As 0 ȊOԂ
static int AllocTlsIndex ( void ) {
   if ( ( nTlsIndex = TlsAlloc () ) == TLS_OUT_OF_INDEXES ) return 1 ;
   return 0 ;
}
#endif



#if defined _MT
// TLS CfbNX
static void FreeTlsIndex ( void ) {
   if ( ( nTlsIndex != TLS_OUT_OF_INDEXES ) ) TlsFree ( nTlsIndex ) ;
}
#endif



// Xbhf[^̃AhX擾
// s NULL Ԃ
THREAD_INTERNAL_DATA_ *GetThreadInternalData ( void ) {
#if defined _MT
   THREAD_INTERNAL_DATA_ *p = (THREAD_INTERNAL_DATA_*) TlsGetValue ( nTlsIndex ) ;
#else
   THREAD_INTERNAL_DATA_ *p = pPrimaryThreadInternalData ;
#endif
#if defined _USRDLL
   if ( ! p ) {
      p = AllocThreadInternalData () ;
      InitializeThreadInternalData ( p ) ;
   }
#endif
   return p ;
}



// Xbhf[^mۂ
// s NULL Ԃ
THREAD_INTERNAL_DATA_ *AllocThreadInternalData ( void ) {

   THREAD_INTERNAL_DATA_ *p = malloc_array ( THREAD_INTERNAL_DATA_, 1 ) ;
   if ( p ) {
      static const THREAD_INTERNAL_DATA_ THREAD_DATA_ZERO = { 0 } ;
      *p = THREAD_DATA_ZERO ;
   }

   return p ;
}



// Xbhf[^
int InitializeThreadInternalData ( THREAD_INTERNAL_DATA_ *p ) {
#if defined _MT
   if ( ! TlsSetValue ( nTlsIndex, p ) ) return 1 ;
#else
   pPrimaryThreadInternalData = p ;
#endif
   return 0 ;
}



// Xbhf[^
void FreeThreadInternalData ( THREAD_INTERNAL_DATA_ *p ) {

   if ( ! p ) return ;

   // res.cpp
   free ( p->szGetStringA ) ;
   free ( p->szGetStringW ) ;
   free ( p->szCopyrightA ) ;

   // environ.cpp
   free ( p->szEnvironA ) ;
   free ( p->szEnvironW ) ;

   free ( p ) ;

   return ;
}



#endif // ! defined NOCRT



////////////////////////////////////////////
//             osver / winver             //
////////////////////////////////////////////



OS_VERSION_ OsVersion_ ;



//  0 As 0 ȊOԂ
static int InitOsverWinver ( void ) {

   if ( IS_NT_ONLY ) {

      OSVERSIONINFOW Info = { 0 } ;
      Info.dwOSVersionInfoSize = sizeof(OSVERSIONINFOW) ;

      if ( ! GetVersionExW ( & Info ) ) return 1 ;

      OsVersion_.Version   = ( ( Info.dwMajorVersion << 8 ) + ( Info.dwMinorVersion & 0xFF ) ) ;
      OsVersion_.Build     = ( Info.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS ) ? ( Info.dwBuildNumber & 0xFFFF ) : Info.dwBuildNumber ;
      OsVersion_.Platform  = Info.dwPlatformId ;
   }
   else {

      OSVERSIONINFOA Info = { 0 } ;
      Info.dwOSVersionInfoSize = sizeof(OSVERSIONINFOA) ;

      if ( ! GetVersionExA ( & Info ) ) return 1 ;

      OsVersion_.Version   = ( ( Info.dwMajorVersion << 8 ) + ( Info.dwMinorVersion & 0xFF ) ) ;
      OsVersion_.Build     = ( Info.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS ) ? ( Info.dwBuildNumber & 0xFFFF ) : Info.dwBuildNumber ;
      OsVersion_.Platform  = Info.dwPlatformId ;
   }

   return 0 ;
}



////////////////////////////////////////////
//                  WIN64                 //
////////////////////////////////////////////



#if ! defined _WIN64 && ! defined NOCRT



// OS  64-bit Ȃ 0 ȊOԂ
int IsWin64 ( void ) {

   static volatile long nResultSaved ; // 0: not tested, <0: no, >0: yes

   int nResult = nResultSaved ;

   if ( ! nResult ) {

      nResult = -1 ;

      if ( IsNT () ) {

         int IsFunctionNotSupported = 0 ;

#if _WIN32_WINNT < 0x501 || REQUIRED_MINIMUM_WINVER < 0x502

         typedef BOOL ( WINAPI *ISWOW64PROCESS ) ( HANDLE hProcess, PBOOL Wow64Process ) ;
         ISWOW64PROCESS IsWow64Process = NULL ;

         HINSTANCE hKernel32 = GetModuleHandleW ( L"KERNEL32.DLL" ) ;
         if ( GETPROCADDRESS ( hKernel32, ISWOW64PROCESS, IsWow64Process ) ) IsFunctionNotSupported = 1 ;
#endif

         if ( ! IsFunctionNotSupported ) {
            BOOL IsWow64 ;
            if ( IsWow64Process ( GetCurrentProcess (), & IsWow64 ) && IsWow64 ) nResult = 1 ;
         }
      }

      InterlockedExchange ( & nResultSaved, nResult ) ;
   }

   return ( nResult > 0 ) ;
}



#endif // ! defined _WIN64 && ! defined NOCRT



////////////////////////////////////////////
//             FILE MANAGEMENT            //
////////////////////////////////////////////



// t@Cʒuړ
// t@CʒuAs -1 Ԃ
int64_t SetFilePointer64 ( HANDLE hFile, int64_t nDistanceToMove, unsigned long dwMoveMethod ) {

   LARGE_INTEGER Position ;
   Position.QuadPart = nDistanceToMove ;

   Position.LowPart = SetFilePointer ( hFile, Position.LowPart, & Position.HighPart, dwMoveMethod ) ;

   if ( Position.LowPart == INVALID_SET_FILE_POINTER ) {
      if ( GetLastError () != NO_ERROR ) return -1 ;
   }

   return Position.QuadPart ;
}



// t@CTCY擾
// t@CTCYAs -1 Ԃ
int64_t GetFileSize64 ( HANDLE hFile ) {

   ULARGE_INTEGER FileSize ;

   FileSize.LowPart = GetFileSize ( hFile, & FileSize.HighPart ) ;

   if ( FileSize.LowPart == INVALID_FILE_SIZE ) {
      if ( GetLastError () != NO_ERROR ) return -1 ;
   }

   return FileSize.QuadPart ;
}



// t@Cr
// IsCompareAsDosTime  0 ȊOw肷ƁAMS-DOS `̎ɕϊr
int CompareFileTimeEx ( const FILETIME *pFileTime1, const FILETIME *pFileTime2, int IsCompareAsDosTime ) {

   const ULARGE_INTEGER T1 = MAKE_LARGE_INT ( pFileTime1->dwHighDateTime, pFileTime1->dwLowDateTime ) ;
   const ULARGE_INTEGER T2 = MAKE_LARGE_INT ( pFileTime2->dwHighDateTime, pFileTime2->dwLowDateTime ) ;

   if ( IsCompareAsDosTime ) {

      const int64_t nTwoSeconds = (int64_t) 2 * FILETIME_PER_SEC ;

      int64_t t = T1.QuadPart - T2.QuadPart ;

      if ( ! t ) return 0 ;

      if ( t < nTwoSeconds && t > - nTwoSeconds ) {

         unsigned short nDate1, nDate2, nTime1, nTime2 ;

         if (  FileTimeToDosDateTime ( pFileTime1, & nDate1, & nTime1 )
            && FileTimeToDosDateTime ( pFileTime2, & nDate2, & nTime2 )
         ) {

            if ( nDate1 > nDate2 ) return 1 ;
            if ( nDate1 < nDate2 ) return -1 ;

            if ( nTime1 > nTime2 ) return 1 ;
            if ( nTime1 < nTime2 ) return -1 ;

            return 0 ;
         }
      }

   }

   if ( T1.QuadPart > T2.QuadPart ) return 1 ;
   if ( T1.QuadPart < T2.QuadPart ) return -1 ;
   return 0 ;
}



////////////////////////////////////////////
//             DISK MANAGEMENT            //
////////////////////////////////////////////



#if ! defined NOCRT



#ifndef TEST_GETDISKSIZE
#define TEST_GETDISKSIZE   0
#endif



// fBXNTCY擾iANSIŁj
// szDirectoryName ɂ̓fBNgA܂ \\ ŏI UNCiNULLłj
// fBXÑTCYAs -1 Ԃ
int64_t GetDiskSize64A ( const char *szDirectoryName, int nMode ) {

   ULARGE_INTEGER FreeBytesAvailable, TotalNumberOfBytes, TotalNumberOfFreeBytes ;

#if REQUIRED_MINIMUM_WINVER < 0x500 || TEST_GETDISKSIZE

   typedef BOOL ( WINAPI *GETDISKFREESPACEEXA ) ( LPCSTR lpDirectoryName, PULARGE_INTEGER lpFreeBytesAvailable, PULARGE_INTEGER lpTotalNumberOfBytes, PULARGE_INTEGER lpTotalNumberOfFreeBytes ) ;
   static GETDISKFREESPACEEXA GetDiskFreeSpaceExA ;
   static int IsTried ;

   if ( ! IsTried ) {
      HINSTANCE hKernel32 = GetModuleHandleA ( "KERNEL32.DLL" ) ;
      GETPROCADDRESS ( hKernel32, GETDISKFREESPACEEXA, GetDiskFreeSpaceExA ) ;
      IsTried = 1 ;
   }

   if ( ! GetDiskFreeSpaceExA || TEST_GETDISKSIZE ) {

      unsigned long SectorsPerCluster ;
      unsigned long BytesPerSector ;
      unsigned long NumberOfFreeClusters ;
      unsigned long TotalNumberOfClusters ;

      if ( ! GetDiskFreeSpaceA ( szDirectoryName, & SectorsPerCluster, & BytesPerSector, & NumberOfFreeClusters, & TotalNumberOfClusters ) ) return -1 ;

      uint64_t BytesPerCluster = (uint64_t) SectorsPerCluster * BytesPerSector ;

      FreeBytesAvailable.QuadPart = BytesPerCluster * NumberOfFreeClusters ;
      TotalNumberOfBytes.QuadPart = BytesPerCluster * TotalNumberOfClusters ;
      TotalNumberOfFreeBytes.QuadPart = BytesPerCluster * NumberOfFreeClusters ;
   }
   else
#endif
   {
      if ( ! GetDiskFreeSpaceExA ( szDirectoryName, & FreeBytesAvailable, & TotalNumberOfBytes, & TotalNumberOfFreeBytes ) ) return -1 ;
   }

   switch ( nMode ) {
      case GETDISKSIZE_TOTAL_SIZE :       return TotalNumberOfBytes.QuadPart ;
      case GETDISKSIZE_FREE_SPACE :       return TotalNumberOfFreeBytes.QuadPart ;
      case GETDISKSIZE_AVAILABLE_SPACE :  return FreeBytesAvailable.QuadPart ;
   }

   return -1 ;
}



// fBXNTCY擾iUNICODEŁj
// szDirectoryName ɂ̓fBNgA܂ \\ ŏI UNCiNULLłj
// fBXÑTCYAs -1 Ԃ
int64_t GetDiskSize64W ( const wchar_t *szDirectoryName, int nMode ) {

   ULARGE_INTEGER FreeBytesAvailable, TotalNumberOfBytes, TotalNumberOfFreeBytes ;

#if REQUIRED_MINIMUM_WINVER < 0x500 || TEST_GETDISKSIZE

   typedef BOOL ( WINAPI *GETDISKFREESPACEEXW ) ( LPCWSTR lpDirectoryName, PULARGE_INTEGER lpFreeBytesAvailable, PULARGE_INTEGER lpTotalNumberOfBytes, PULARGE_INTEGER lpTotalNumberOfFreeBytes ) ;
   static GETDISKFREESPACEEXW GetDiskFreeSpaceExW ;
   static int IsTried ;

   if ( ! IsTried ) {
      HINSTANCE hKernel32 = GetModuleHandleW ( L"KERNEL32.DLL" ) ;
      GETPROCADDRESS ( hKernel32, GETDISKFREESPACEEXW, GetDiskFreeSpaceExW ) ;
      IsTried = 1 ;
   }

   if ( ! GetDiskFreeSpaceExW || TEST_GETDISKSIZE ) {

      unsigned long SectorsPerCluster ;
      unsigned long BytesPerSector ;
      unsigned long NumberOfFreeClusters ;
      unsigned long TotalNumberOfClusters ;

      if ( ! GetDiskFreeSpaceW ( szDirectoryName, & SectorsPerCluster, & BytesPerSector, & NumberOfFreeClusters, & TotalNumberOfClusters ) ) return -1 ;

      uint64_t BytesPerCluster = (uint64_t) SectorsPerCluster * BytesPerSector ;

      FreeBytesAvailable.QuadPart = BytesPerCluster * NumberOfFreeClusters ;
      TotalNumberOfBytes.QuadPart = BytesPerCluster * TotalNumberOfClusters ;
      TotalNumberOfFreeBytes.QuadPart = BytesPerCluster * NumberOfFreeClusters ;
   }
   else
#endif
   {
      if ( ! GetDiskFreeSpaceExW ( szDirectoryName, & FreeBytesAvailable, & TotalNumberOfBytes, & TotalNumberOfFreeBytes ) ) return -1 ;
   }

   switch ( nMode ) {
      case GETDISKSIZE_TOTAL_SIZE :       return TotalNumberOfBytes.QuadPart ;
      case GETDISKSIZE_FREE_SPACE :       return TotalNumberOfFreeBytes.QuadPart ;
      case GETDISKSIZE_AVAILABLE_SPACE :  return FreeBytesAvailable.QuadPart ;
   }

   return -1 ;
}



#endif // ! defined NOCRT



////////////////////////////////////////////
//          INTERLOCKED EXCHANGE          //
////////////////////////////////////////////



#if defined _MSC_VER && ! IS_NT_ONLY



#pragma warning ( push )
#pragma warning ( disable: 4035 )   // no return value



long WINAPI InterlockedExchangeAdd_95 ( volatile long *Addend, long Increment ) {
   __asm {
      mov   eax, Increment
      mov   ecx, Addend
      lock xadd   [ecx], eax        // 80486 or later
   }
}



long WINAPI InterlockedCompareExchange_95 ( volatile long *Destination, long Exchange, long Comperand ) {
   __asm {
      mov   eax, Comperand
      mov   ecx, Destination
      mov   edx, Exchange
      lock cmpxchg   [ecx], edx     // 80486 or later
   }
}



#pragma warning ( pop )



#endif



////////////////////////////////////////////
//                 STRING                 //
////////////////////////////////////////////



#if ! defined NOCRT



#ifndef TEST_CMPSTR_ORDINAL
#define TEST_CMPSTR_ORDINAL   0
#endif



int CompareStringOrdinalA ( const char *szString1, int nLength1, const char *szString2, int nLength2, int IsIgnoreCase ) {

   int nResult = 0 ;

   if ( IsIgnoreCase && ( ! IsNT () || TEST_CMPSTR_ORDINAL ) ) {

      int nBufferSize1 = LCMapStringA ( LOCALE_SYSTEM_DEFAULT, LCMAP_UPPERCASE, szString1, nLength1, NULL, 0 ) ;
      int nBufferSize2 = LCMapStringA ( LOCALE_SYSTEM_DEFAULT, LCMAP_UPPERCASE, szString2, nLength2, NULL, 0 ) ;

      char *szBuffer1 = malloc_array ( char, nBufferSize1 ) ;
      char *szBuffer2 = malloc_array ( char, nBufferSize2 ) ;

      if ( szBuffer1 && szBuffer2 ) {
         if (  LCMapStringA ( LOCALE_SYSTEM_DEFAULT, LCMAP_UPPERCASE, szString1, nLength1, szBuffer1, nBufferSize1 ) == nBufferSize1
            && LCMapStringA ( LOCALE_SYSTEM_DEFAULT, LCMAP_UPPERCASE, szString2, nLength2, szBuffer2, nBufferSize2 ) == nBufferSize2
         ) {
            if ( nLength1 < 0 ) nBufferSize1 -- ;
            if ( nLength2 < 0 ) nBufferSize2 -- ;
            nResult = CompareStringOrdinalA ( szBuffer1, nBufferSize1, szBuffer2, nBufferSize2, 0 ) ;
         }
      }

      free ( szBuffer1 ) ;
      free ( szBuffer2 ) ;
   }
   else {

      int nBufferSize1 = MultiByteToWideChar ( CP_ACP, 0, szString1, nLength1, NULL, 0 ) ;
      int nBufferSize2 = MultiByteToWideChar ( CP_ACP, 0, szString2, nLength2, NULL, 0 ) ;

      wchar_t *szBuffer1 = malloc_array ( wchar_t, nBufferSize1 ) ;
      wchar_t *szBuffer2 = malloc_array ( wchar_t, nBufferSize2 ) ;

      if ( szBuffer1 && szBuffer2 ) {
         if (  MultiByteToWideChar ( CP_ACP, 0, szString1, nLength1, szBuffer1, nBufferSize1 ) == nBufferSize1
            && MultiByteToWideChar ( CP_ACP, 0, szString2, nLength2, szBuffer2, nBufferSize2 ) == nBufferSize2
         ) {
            if ( nLength1 < 0 ) nBufferSize1 -- ;
            if ( nLength2 < 0 ) nBufferSize2 -- ;
            nResult = CompareStringOrdinalW ( szBuffer1, nBufferSize1, szBuffer2, nBufferSize2, IsIgnoreCase ) ;
         }
      }

      free ( szBuffer1 ) ;
      free ( szBuffer2 ) ;
   }

   return nResult ;
}



int CompareStringOrdinalW ( const wchar_t *szString1, int nLength1, const wchar_t *szString2, int nLength2, int IsIgnoreCase ) {
#undef CompareStringOrdinal

#if WINVER < 0x600 || REQUIRED_MINIMUM_WINVER < 0x600 || TEST_CMPSTR_ORDINAL

   typedef int ( WINAPI *COMPARESTRINGORDINAL ) ( LPCWSTR lpString1, int cchCount1, LPCWSTR lpString2, int cchCount2, BOOL bIgnoreCase ) ;
   static COMPARESTRINGORDINAL CompareStringOrdinal ;
   static int IsTried ;

   if ( IsWinVISTAorLater () ) {
      if ( ! IsTried ) {
         HINSTANCE hKernel32 = GetModuleHandleW ( L"KERNEL32.DLL" ) ;
         GETPROCADDRESS ( hKernel32, COMPARESTRINGORDINAL, CompareStringOrdinal ) ;
         IsTried = 1 ;
      }
   }

   if ( ! CompareStringOrdinal || TEST_CMPSTR_ORDINAL ) {

      size_t nCountMax1 = ( nLength1 < 0 ) ? wcslen ( szString1 ) : nLength1 ;
      size_t nCountMax2 = ( nLength2 < 0 ) ? wcslen ( szString2 ) : nLength2 ;
      size_t nCountMax = min ( nCountMax1, nCountMax2 ) ;

      for ( size_t nCount = 0 ; nCount < nCountMax ; nCount ++ ) {

         wchar_t C1, C2 ;
         if ( ! IsIgnoreCase || LCMapStringW ( LOCALE_SYSTEM_DEFAULT, LCMAP_UPPERCASE, szString1 + nCount, 1, & C1, 1 ) != 1 ) C1 = *( szString1 + nCount ) ;
         if ( ! IsIgnoreCase || LCMapStringW ( LOCALE_SYSTEM_DEFAULT, LCMAP_UPPERCASE, szString2 + nCount, 1, & C2, 1 ) != 1 ) C2 = *( szString2 + nCount ) ;

         if ( C1 < C2 ) return CSTR_LESS_THAN ;
         if ( C1 > C2 ) return CSTR_GREATER_THAN ;
      }

      if ( nCountMax1 < nCountMax2 ) return CSTR_LESS_THAN ;
      if ( nCountMax1 > nCountMax2 ) return CSTR_GREATER_THAN ;

      return CSTR_EQUAL ;
   }
#endif

   return CompareStringOrdinal ( szString1, nLength1, szString2, nLength2, IsIgnoreCase ) ;
}



#endif // ! defined NOCRT



////////////////////////////////////////////
//             strlcpy/cat ()             //
////////////////////////////////////////////



#if ! defined NOCRT



// w肳ꂽ܂ŕAiANSIŁj
//  SIZE_MAX ȂkI[ƌȂ
// o͂镶̖ɂ͕Kk
// bufsiz  dst Ɏ߂邱Ƃ̂łő̒iI[k܂ށj
// src  dst ̒̍vԂiI[k܂܂Ȃj
size_t strlcatlen ( char *dst, size_t dstlen, const char *src, size_t srclen, size_t bufsiz ) {

   if ( srclen == SIZE_MAX ) srclen = strlen ( src ) ;
   if ( dstlen == SIZE_MAX ) dstlen = strlen ( dst ) ;

   if ( bufsiz > dstlen ) {
      size_t cpylen = ( srclen < bufsiz - dstlen ) ? srclen : bufsiz - dstlen - 1 ;
      memmove ( dst + dstlen, src, cpylen * sizeof(char) ) ;
      dst [ dstlen + cpylen ] = 0 ;
   }
   else if ( bufsiz ) {
      dst [ bufsiz - 1 ] = 0 ;
   }

   return srclen + dstlen ;
}



// w肳ꂽ܂ŕAiUNICODEŁj
//  SIZE_MAX ȂkI[ƌȂ
// o͂镶̖ɂ͕Kk
// bufsiz  dst Ɏ߂邱Ƃ̂łő̒iI[k܂ށj
// src  dst ̒̍vԂiI[k܂܂Ȃj
size_t wcslcatlen ( wchar_t *dst, size_t dstlen, const wchar_t *src, size_t srclen, size_t bufsiz ) {

   if ( srclen == SIZE_MAX ) srclen = wcslen ( src ) ;
   if ( dstlen == SIZE_MAX ) dstlen = wcslen ( dst ) ;

   if ( bufsiz > dstlen ) {
      size_t cpylen = ( srclen < bufsiz - dstlen ) ? srclen : bufsiz - dstlen - 1 ;
      memmove ( dst + dstlen, src, cpylen * sizeof(wchar_t) ) ;
      dst [ dstlen + cpylen ] = 0 ;
   }
   else if ( bufsiz ) {
      dst [ bufsiz - 1 ] = 0 ;
   }

   return srclen + dstlen ;
}



// src  dst ̒̍vԂiI[k܂܂Ȃj
size_t strlcat ( char    *dst, const char    *src, size_t bufsiz ) { return strlcatlen ( dst, SIZE_MAX, src, SIZE_MAX, bufsiz ) ; }
size_t wcslcat ( wchar_t *dst, const wchar_t *src, size_t bufsiz ) { return wcslcatlen ( dst, SIZE_MAX, src, SIZE_MAX, bufsiz ) ; }


// src ̒ԂiI[k܂܂Ȃj
size_t strlcpylen ( char    *dst, const char    *src, size_t srclen, size_t bufsiz ) { return strlcatlen ( dst, 0, src, srclen, bufsiz ) ; }
size_t wcslcpylen ( wchar_t *dst, const wchar_t *src, size_t srclen, size_t bufsiz ) { return wcslcatlen ( dst, 0, src, srclen, bufsiz ) ; }
size_t strlcpy ( char    *dst, const char    *src, size_t bufsiz ) { return strlcatlen ( dst, 0, src, SIZE_MAX, bufsiz ) ; }
size_t wcslcpy ( wchar_t *dst, const wchar_t *src, size_t bufsiz ) { return wcslcatlen ( dst, 0, src, SIZE_MAX, bufsiz ) ; }



#endif // ! defined NOCRT



////////////////////////////////////////////
//               w/alcpy ()               //
////////////////////////////////////////////



#if ! defined NOCRT



// w肳ꂽ܂ŕRs[iANSIUNICODEŁj
//  SIZE_MAX ȂkI[ƌȂ
// o͂镶̖ɂ͕Kk
// bufsiz  dst Ɏ߂邱Ƃ̂łő̒iI[k܂ށj
// { dst ̒ԂiI[k܂܂Ȃj
// s SIZE_MAX Ԃ
size_t a2wlcpylen_cp ( wchar_t *dst, const char *src, size_t srclen, size_t bufsiz, int codepage ) {

   if ( CP_ACP && ! codepage ) codepage = CP_ACP ;    // Ô

   if ( bufsiz > INT_MAX ) bufsiz = INT_MAX ;
   if ( bufsiz ) *dst = 0 ;

   if ( srclen == SIZE_MAX ) srclen = strlen ( src ) ;
   if ( srclen > INT_MAX ) return SIZE_MAX ;
   if ( ! srclen ) return 0 ;

   size_t dstlen ;

   if ( bufsiz && ( dstlen = MultiByteToWideChar ( codepage, 0, src, (int) srclen, dst, (int) bufsiz - 1 ) ) ) {
      dst [ dstlen ] = 0 ;
   }
   else {
      // obt@Ɏ܂Ȃꍇ

      dstlen = MultiByteToWideChar ( codepage, 0, src, (int) srclen, NULL, 0 ) ;
      if ( ! dstlen ) return SIZE_MAX ;

      if ( bufsiz ) {
         size_t cpylen = ( dstlen < bufsiz ) ? dstlen : bufsiz - 1 ;
         MultiByteToWideChar ( codepage, 0, src, (int) srclen, dst, (int) cpylen ) ;
         dst [ cpylen ] = 0 ;
      }
   }

   return dstlen ;
}



// w肳ꂽ܂ŕRs[iUNICODEANSIŁj
//  SIZE_MAX ȂkI[ƌȂ
// o͂镶̖ɂ͕Kk
// bufsiz  dst Ɏ߂邱Ƃ̂łő̒iI[k܂ށj
// { dst ̒ԂiI[k܂܂Ȃj
// s SIZE_MAX Ԃ
// ϊłȂ errno  EILSEQ Zbg
size_t w2alcpylen_cp ( char *dst, const wchar_t *src, size_t srclen, size_t bufsiz, int codepage ) {

   int IsUsedDefaultChar = 0 ;

   if ( CP_ACP && ! codepage ) codepage = CP_ACP ;    // Ô

   if ( bufsiz > INT_MAX ) bufsiz = INT_MAX ;
   if ( bufsiz ) *dst = 0 ;

   if ( srclen == SIZE_MAX ) srclen = wcslen ( src ) ;
   if ( srclen > INT_MAX ) return SIZE_MAX ;
   if ( ! srclen ) return 0 ;

   size_t dstlen ;

   if ( bufsiz && ( dstlen = WideCharToMultiByte ( codepage, 0, src, (int) srclen, dst, (int) bufsiz - 1, NULL, & IsUsedDefaultChar ) ) ) {
      dst [ dstlen ] = 0 ;
   }
   else {
      // obt@Ɏ܂Ȃꍇ

      dstlen = WideCharToMultiByte ( codepage, 0, src, (int) srclen, NULL, 0, NULL, NULL ) ;
      if ( ! dstlen ) return SIZE_MAX ;

      if ( bufsiz ) {
         size_t cpylen = ( dstlen < bufsiz ) ? dstlen : bufsiz - 1 ;
         if ( cpylen ) dst [ cpylen - 1 ] = 0 ;
         WideCharToMultiByte ( codepage, 0, src, (int) srclen, dst, (int) cpylen, NULL, & IsUsedDefaultChar ) ;
         dst [ cpylen ] = 0 ;
      }
   }

   if ( IsUsedDefaultChar ) errno = EILSEQ ;

   return dstlen ;
}



size_t a2wlcpy    ( wchar_t *dst, const char    *src, size_t bufsiz )                { return a2wlcpylen_cp ( dst, src, SIZE_MAX, bufsiz, 0        ) ; }
size_t w2alcpy    ( char    *dst, const wchar_t *src, size_t bufsiz )                { return w2alcpylen_cp ( dst, src, SIZE_MAX, bufsiz, 0        ) ; }
size_t a2wlcpylen ( wchar_t *dst, const char    *src, size_t srclen, size_t bufsiz ) { return a2wlcpylen_cp ( dst, src, srclen,   bufsiz, 0        ) ; }
size_t w2alcpylen ( char    *dst, const wchar_t *src, size_t srclen, size_t bufsiz ) { return w2alcpylen_cp ( dst, src, srclen,   bufsiz, 0        ) ; }
size_t a2wlcpy_cp ( wchar_t *dst, const char    *src, size_t bufsiz, int codepage )  { return a2wlcpylen_cp ( dst, src, SIZE_MAX, bufsiz, codepage ) ; }
size_t w2alcpy_cp ( char    *dst, const wchar_t *src, size_t bufsiz, int codepage )  { return w2alcpylen_cp ( dst, src, SIZE_MAX, bufsiz, codepage ) ; }



#endif // ! defined NOCRT



////////////////////////////////////////////
//                strdup ()               //
////////////////////////////////////////////



#if ! defined NOCRT



// w肵ĕ𕡐iANSIŁj
//  SIZE_MAX ȂkI[ƌȂ
// o͂镶̖ɂ͕Kk
// o͂镶̒ maxlen ȏȂ NULL Ԃ
// w肳ꂽ]Ɋmۂ
// s NULL Ԃ
char *strduplen_expand ( const char *string, size_t srclen, size_t maxlen, size_t addlen ) {

   if ( srclen == SIZE_MAX ) srclen = strlen ( string ) ;
   if ( srclen >= maxlen ) return NULL ;

   char *buffer = malloc_array ( char, srclen + addlen + 1 ) ;
   if ( buffer ) {
      memmove ( buffer, string, srclen * sizeof(char) ) ;
      buffer [ srclen ] = 0 ;
   }

   return buffer ;
}



// w肵ĕ𕡐iUNICODEŁj
//  SIZE_MAX ȂkI[ƌȂ
// o͂镶̖ɂ͕Kk
// o͂镶̒ maxlen ȏȂ NULL Ԃ
// w肳ꂽ]Ɋmۂ
// s NULL Ԃ
wchar_t *wcsduplen_expand ( const wchar_t *string, size_t srclen, size_t maxlen, size_t addlen ) {

   if ( srclen == SIZE_MAX ) srclen = wcslen ( string ) ;
   if ( srclen >= maxlen ) return NULL ;

   wchar_t *buffer = malloc_array ( wchar_t , srclen + addlen + 1 ) ;
   if ( buffer ) {
      memmove ( buffer, string, srclen * sizeof(wchar_t) ) ;
      buffer [ srclen ] = 0 ;
   }

   return buffer ;
}



char    *strdup        ( const char    *string )                               { return strduplen_expand ( string, SIZE_MAX, SIZE_MAX, 0      ) ; }
wchar_t *wcsdup        ( const wchar_t *string )                               { return wcsduplen_expand ( string, SIZE_MAX, SIZE_MAX, 0      ) ; }
char    *strduplen     ( const char    *string, size_t srclen )                { return strduplen_expand ( string, srclen,   SIZE_MAX, 0      ) ; }
wchar_t *wcsduplen     ( const wchar_t *string, size_t srclen )                { return wcsduplen_expand ( string, srclen,   SIZE_MAX, 0      ) ; }
char    *strdup_expand ( const char    *string, size_t maxlen, size_t addlen ) { return strduplen_expand ( string, SIZE_MAX, maxlen,   addlen ) ; }
wchar_t *wcsdup_expand ( const wchar_t *string, size_t maxlen, size_t addlen ) { return wcsduplen_expand ( string, SIZE_MAX, maxlen,   addlen ) ; }



#endif // ! defined NOCRT



////////////////////////////////////////////
//                a/wdup ()               //
////////////////////////////////////////////



#if ! defined NOCRT



// ANSIChɕϊĕ
//  SIZE_MAX ȂkI[ƌȂ
// o͂镶̖ɂ͕Kk
// o͂镶̒ maxlen ȏȂ NULL Ԃ
// w肳ꂽ]Ɋmۂ
// s NULL Ԃ
wchar_t *a2wduplen_expand_cp ( const char *string, size_t srclen, size_t maxlen, size_t addlen, int codepage ) {

   size_t dstlen ;
   wchar_t *buffer ;

   if ( CP_ACP && ! codepage ) codepage = CP_ACP ;    // Ô

   if ( srclen == SIZE_MAX ) srclen = strlen ( string ) ;
   if ( srclen > INT_MAX ) return NULL ;

   if ( srclen ) {
      if ( ! ( dstlen = MultiByteToWideChar ( codepage, 0, string, (int) srclen, NULL, 0 ) ) ) return NULL ;
      if ( dstlen >= maxlen ) return NULL ;
      if ( ! ( buffer = malloc_array ( wchar_t, dstlen + addlen + 1 ) ) ) return NULL ;
      if ( ! ( dstlen = MultiByteToWideChar ( codepage, 0, string, (int) srclen, buffer, (int) dstlen ) ) ) { free ( buffer ) ; return NULL ; }
   }
   else {
      dstlen = 0 ;
      if ( dstlen >= maxlen ) return NULL ;
      if ( ! ( buffer = malloc_array ( wchar_t, dstlen + addlen + 1 ) ) ) return NULL ;
   }

   buffer [ dstlen ] = 0 ;

   return buffer ;
}



// ChANSIɕϊĕ
//  SIZE_MAX ȂkI[ƌȂ
// o͂镶̖ɂ͕Kk
// o͂镶̒ maxlen ȏȂ NULL Ԃ
// w肳ꂽ]Ɋmۂ
// s NULL Ԃ
// ϊłȂ errno  EILSEQ Zbg
char *w2aduplen_expand_cp ( const wchar_t *string, size_t srclen, size_t maxlen, size_t addlen, int codepage ) {

   int IsUsedDefaultChar = 0 ;

   size_t dstlen ;
   char *buffer ;

   if ( CP_ACP && ! codepage ) codepage = CP_ACP ;    // Ô

   if ( srclen == SIZE_MAX ) srclen = wcslen ( string ) ;
   if ( srclen > INT_MAX ) return NULL ;

   if ( srclen ) {
      if ( ! ( dstlen = WideCharToMultiByte ( codepage, 0, string, (int) srclen, NULL, 0, NULL, NULL ) ) ) return NULL ;
      if ( dstlen >= maxlen ) return NULL ;
      if ( ! ( buffer = malloc_array ( char, dstlen + addlen + 1 ) ) ) return NULL ;
      if ( ! ( dstlen = WideCharToMultiByte ( codepage, 0, string, (int) srclen, buffer, (int) dstlen, NULL, & IsUsedDefaultChar ) ) ) { free ( buffer ) ; return NULL ; }
   }
   else {
      dstlen = 0 ;
      if ( dstlen >= maxlen ) return NULL ;
      if ( ! ( buffer = malloc_array ( char, dstlen + addlen + 1 ) ) ) return NULL ;
   }

   buffer [ dstlen ] = 0 ;

   if ( IsUsedDefaultChar ) errno = EILSEQ ;

   return buffer ;
}



wchar_t *a2wdup        ( const char    *string )                               { return a2wduplen_expand_cp ( string, SIZE_MAX, SIZE_MAX, 0,      0        ) ; }
char    *w2adup        ( const wchar_t *string )                               { return w2aduplen_expand_cp ( string, SIZE_MAX, SIZE_MAX, 0,      0        ) ; }
wchar_t *a2wduplen     ( const char    *string, size_t srclen )                { return a2wduplen_expand_cp ( string, srclen,   SIZE_MAX, 0,      0        ) ; }
char    *w2aduplen     ( const wchar_t *string, size_t srclen )                { return w2aduplen_expand_cp ( string, srclen,   SIZE_MAX, 0,      0        ) ; }
wchar_t *a2wdup_expand ( const char    *string, size_t maxlen, size_t addlen ) { return a2wduplen_expand_cp ( string, SIZE_MAX, maxlen,   addlen, 0        ) ; }
char    *w2adup_expand ( const wchar_t *string, size_t maxlen, size_t addlen ) { return w2aduplen_expand_cp ( string, SIZE_MAX, maxlen,   addlen, 0        ) ; }
wchar_t *a2wdup_cp     ( const char    *string, int codepage )                 { return a2wduplen_expand_cp ( string, SIZE_MAX, SIZE_MAX, 0,      codepage ) ; }
char    *w2adup_cp     ( const wchar_t *string, int codepage )                 { return w2aduplen_expand_cp ( string, SIZE_MAX, SIZE_MAX, 0,      codepage ) ; }



#endif // ! defined NOCRT



////////////////////////////////////////////
//                  rand                  //
////////////////////////////////////////////



// XbhZ[tȗ
// ͈̔͂ 0 ` RAND_MAX
//  2^32
int rand_r ( unsigned int *seed ) {

   unsigned int result = *seed * 214013 + 2531011 ;

   *seed = result ;

   return ( result >> SHORT_BIT ) | ( ( result << ( SHORT_BIT - 1 ) ) & 0x7FFF0000 ) ;
}



static unsigned int rand_seed = 1 ;



// XbhZ[tł͂Ȃ
// ͈̔͂ 0 ` RAND_MAX
//  2^32
int rand ( void ) {
   return rand_r ( & rand_seed ) ;
}



// ̎
void srand ( unsigned int seed ) {
   rand_seed = seed ;
}



////////////////////////////////////////////
//               ARITHMETIC               //
////////////////////////////////////////////



// 擪ɘA 0 ̃rbg𐔂
int lzcnt ( unsigned long x ) {

   unsigned long y ;

   int n = 32 ;

   y = x >> 16 ; if ( y ) { n -= 16 ; x = y ; }
   y = x >>  8 ; if ( y ) { n -=  8 ; x = y ; }
   y = x >>  4 ; if ( y ) { n -=  4 ; x = y ; }
   y = x >>  2 ; if ( y ) { n -=  2 ; x = y ; }
   y = x >>  1 ; if ( y ) { n -=  1 ; x = y ; }

   return n - x ;
}



// ɘA 0 ̃rbg𐔂
int tzcnt ( unsigned long x ) {

   return popcnt ( ( ~ x ) & ( x - 1 ) ) ;
}



// rbg𐔂
int popcnt ( unsigned long x ) {

   x =   x                - ( ( x >> 1 ) & 0x55555555 ) ;
   x = ( x & 0x33333333 ) + ( ( x >> 2 ) & 0x33333333 ) ;
   x = ( x + ( x >>  4 ) ) & 0x0F0F0F0F ;
   x =   x + ( x >>  8 ) ;
   x =   x + ( x >> 16 ) ;

   return x & 0x3F ;
}



// rbgt]
unsigned long bitrev ( unsigned long x ) {

   x = ( x & 0x55555555 ) << 1 | ( x >> 1 ) & 0x55555555 ;
   x = ( x & 0x33333333 ) << 2 | ( x >> 2 ) & 0x33333333 ;
   x = ( x & 0x0F0F0F0F ) << 4 | ( x >> 4 ) & 0x0F0F0F0F ;
   x = ( x << 24) | ( ( x & 0xFF00 ) << 8 ) | ( ( x >> 8 ) & 0xFF00 ) | ( x >> 24 ) ;

   return x ;
}



////////////////////////////////////////////
//               VSCPRINTF                //
////////////////////////////////////////////



#if _MSC_VER < 1300 && ! defined NOCRT



static FILE *stdnul ;
static int init_stdnul ( void ) ;

#undef vfwprintf



int __cdecl vscprintf ( const char *format, va_list args ) {
   if ( ! stdnul && init_stdnul () ) return -1 ;
   return vfprintf ( stdnul, format, args ) ;
}



int __cdecl vscwprintf ( const wchar_t *format, va_list args ) {
   if ( ! stdnul && init_stdnul () ) return -1 ;
   return vfwprintf ( stdnul, format, args ) ;
}



int __cdecl scprintf ( const char *format,... ) {
   va_list args ;
   va_start ( args, format ) ;
   int len = vscprintf ( format, args ) ;
   va_end ( args ) ;
   return len ;
}



int __cdecl scwprintf ( const wchar_t *format,... ) {
   va_list args ;
   va_start ( args, format ) ;
   int len = vscwprintf ( format, args ) ;
   va_end ( args ) ;
   return len ;
}



static int init_stdnul ( void ) {
#ifdef _MT
   EnterCriticalSection ( & LoadDllSection ) ;
   __try {
      if ( ! stdnul ) {
#endif
         stdnul = fopen ( "NUL", "wb" ) ;
#ifdef _MT
      }
   } __finally {
      LeaveCriticalSection ( & LoadDllSection ) ;
   }
#endif
   if ( ! stdnul ) return 1 ;
   return 0 ;
}



static void close_stdnul_on_exit ( void ) {
   if ( stdnul ) fclose ( stdnul ) ;
}



#endif // _MSC_VER < 1300 && ! defined NOCRT



////////////////////////////////////////////
//              FILE HANDLE               //
////////////////////////////////////////////



#if ! defined NOCRT



FILE *fopen_osfhandle ( HANDLE hFile, const char *mode ) {

   int flag = 0 ;
   if ( _fmode != _O_BINARY ) flag = _O_TEXT ;

   const char *s = mode ;

   if ( *s == 'a' ) flag |= _O_APPEND ;

   while ( * ++ s ) {
      switch ( *s ) {
         case 't' :  flag |= _O_TEXT ; break ;
         case 'b' :  flag &= ~ _O_TEXT ; break ;
      }
   }

   int fd = _open_osfhandle ( (intptr_t) hFile, flag ) ;
   if ( fd == -1 ) return NULL ;

   return _fdopen ( fd, mode ) ;
}



FILE *wfopen_osfhandle ( HANDLE hFile, const wchar_t *mode ) {

   int flag = 0 ;
   if ( _fmode != _O_BINARY ) flag = _O_TEXT ;

   const wchar_t *s = mode ;

   if ( *s == 'a' ) flag |= _O_APPEND ;

   while ( * ++ s ) {
      switch ( *s ) {
         case 't' :  flag |= _O_TEXT ; break ;
         case 'b' :  flag &= ~ _O_TEXT ; break ;
      }
   }

   int fd = _open_osfhandle ( (intptr_t) hFile, flag ) ;
   if ( fd == -1 ) return NULL ;

   return _wfdopen ( fd, mode ) ;
}



#endif



////////////////////////////////////////////
//           DEBUG (LAST ERROR)           //
////////////////////////////////////////////



#if ! defined NOCRT



// VXẽG[l𕶎ɕϊiANSIŁj
// gp free ŉ邱
// s NULL Ԃ
char *GetLastErrorStringA ( int nError ) {

   char *szResult = NULL ;
   char *szBuffer ;

   if ( FormatMessageA ( FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM, NULL, nError, MAKELANGID ( LANG_ENGLISH, SUBLANG_DEFAULT ), (char*) & szBuffer, 0, NULL ) && szBuffer ) {

      for ( char *p = szBuffer ; *p ; p ++ ) {
         if ( *p == '\r' ) memmove ( p, p + 1, ( strlen ( p ) + 1 ) * sizeof(char) ) ;
         if ( *p == '\n' ) {
            if ( ! *( p + 1 ) ) *p = 0 ;
            else                *p = ' ' ;
         }
      }

      szResult = strdup ( szBuffer ) ;
      LocalFree ( szBuffer ) ;
   }

   return szResult ;
}



// VXẽG[l𕶎ɕϊiUNICODEŁj
// gp free ŉ邱
// s NULL Ԃ
wchar_t *GetLastErrorStringW ( int nError ) {

   wchar_t *szResult = NULL ;
   wchar_t *szBuffer ;

   if ( FormatMessageW ( FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM, NULL, nError, MAKELANGID ( LANG_ENGLISH, SUBLANG_DEFAULT ), (wchar_t*) & szBuffer, 0, NULL ) && szBuffer ) {

      for ( wchar_t *p = szBuffer ; *p ; p ++ ) {
         if ( *p == '\r' ) memmove ( p, p + 1, ( wcslen ( p ) + 1 ) * sizeof(wchar_t) ) ;
         if ( *p == '\n' ) {
            if ( ! *( p + 1 ) ) *p = 0 ;
            else                *p = ' ' ;
         }
      }

      szResult = wcsdup ( szBuffer ) ;
      LocalFree ( szBuffer ) ;
   }

   return szResult ;
}



#endif // ! defined NOCRT



////////////////////////////////////////////
//             DEBUG (MALLOC)             //
////////////////////////////////////////////



#if ! defined NOCRT



#define MALLOC_DEBUG_SENTINEL_LEN   0x40
#define CPP_FILENAME_MAX            0x20



typedef struct {
   char *end_sentinel ;
   int is_in_user_proc ;
   int line ;
   char filename [ CPP_FILENAME_MAX ] ;
   char start_sentinel [ MALLOC_DEBUG_SENTINEL_LEN ] ;
   char p [ 1 ] ;
} MALLOC_DEBUG_STRUCT ;



static const char *get_realloc_debug_sentinel ( void ) {

   static int is_initialized = 0 ;
   static char buffer [ MALLOC_DEBUG_SENTINEL_LEN ] ;

   if ( ! is_initialized ) {

      unsigned int seed = GetTickCount () ;

      for ( int i = 0 ; i < MALLOC_DEBUG_SENTINEL_LEN ; i ++ ) {
         char c ;
         do { c = (char) rand_r ( & seed ) ; } while ( ! c ) ;
         buffer [ i ] = c ;
      }

      is_initialized = 1 ;
   }

   return buffer ;
}



static int test_sentinel ( const MALLOC_DEBUG_STRUCT *p, const char *sentinel, const char *filename, int line ) {

   char buffer [ 0x100 ] ;

   if ( p ) {
      const char *q = p->end_sentinel ;
      if ( memcmp ( q, sentinel, MALLOC_DEBUG_SENTINEL_LEN ) ) {
         sprintf ( buffer, "memory error (%d): allocated at %s(%d), freed at %s(%d)\n", __LINE__, p->filename, p->line, filename, line ) ;
         PrintMessage ( buffer ) ;
         return 1 ;
      }
   }

   if ( p ) {
      const char *q = p->start_sentinel ;
      if ( memcmp ( q, sentinel, MALLOC_DEBUG_SENTINEL_LEN ) ) {
         sprintf ( buffer, "memory error (%d): allocated at %s(%d), freed at %s(%d)\n", __LINE__, p->filename, p->line, filename, line ) ;
         PrintMessage ( buffer ) ;
         return 1 ;
      }
   }

   return 0 ;
}



static HANDLE hHeapDebug ;
static int is_in_user_proc ;



void *realloc_debug ( void *mem, size_t size, int zero, const char *filename, int line ) {

   if ( ! hHeapDebug ) {
      hHeapDebug = HeapCreate ( 0, 0, 0 ) ;
      if ( ! hHeapDebug ) return NULL ;
   }

   MALLOC_DEBUG_STRUCT *p ;
   if ( mem ) p = (MALLOC_DEBUG_STRUCT*) ( (char*) mem - offsetof ( MALLOC_DEBUG_STRUCT, p ) ) ;
   else       p = NULL ;

   const char *sentinel = get_realloc_debug_sentinel () ;

   if ( test_sentinel ( p, sentinel, filename, line ) ) {
      HeapFree ( hHeapDebug, 0, p ) ;
      exit ( 1 ) ;
   }

   if ( p ) p = (MALLOC_DEBUG_STRUCT*) HeapReAlloc ( hHeapDebug, (zero) ? HEAP_ZERO_MEMORY : 0, p, size + sizeof(MALLOC_DEBUG_STRUCT) + MALLOC_DEBUG_SENTINEL_LEN ) ;
   else     p = (MALLOC_DEBUG_STRUCT*) HeapAlloc   ( hHeapDebug, (zero) ? HEAP_ZERO_MEMORY : 0,    size + sizeof(MALLOC_DEBUG_STRUCT) + MALLOC_DEBUG_SENTINEL_LEN ) ;

   if ( p ) {
      sprintf ( p->filename, "%.*s", CPP_FILENAME_MAX - 1, filename ) ;
      p->is_in_user_proc = is_in_user_proc ;
      p->line = line ;
      p->end_sentinel = p->p + size ;
      memmove ( p->start_sentinel, sentinel, MALLOC_DEBUG_SENTINEL_LEN ) ;
      memmove ( p->end_sentinel, sentinel, MALLOC_DEBUG_SENTINEL_LEN ) ;
   }

   if ( p ) return p->p ;
   else     return NULL ;
}



void free_debug ( void *mem, const char *filename, int line ) {

   if ( ! hHeapDebug ) return ;

   MALLOC_DEBUG_STRUCT *p ;
   if ( mem ) p = (MALLOC_DEBUG_STRUCT*) ( (char*) mem - offsetof ( MALLOC_DEBUG_STRUCT, p ) ) ;
   else       p = NULL ;

   const char *sentinel = get_realloc_debug_sentinel () ;

   if ( test_sentinel ( p, sentinel, filename, line ) ) {
      HeapFree ( hHeapDebug, 0, p ) ;
      exit ( 1 ) ;
   }

   HeapFree ( hHeapDebug, 0, p ) ;
}



// InitProc ̍ŌɌĂяo
static int init_malloc_debug ( void ) {
   void *dummy = malloc ( 1 ) ;
   if ( ! dummy ) return 1 ;
   is_in_user_proc = 1 ;
   return 0 ;
}



// ExitProc ̍ŌɌĂяo
static void debug_heap_on_exit ( void ) {

   if ( ! hHeapDebug ) return ;

   if ( 1 ) {

      const char *sentinel = get_realloc_debug_sentinel () ;

      PROCESS_HEAP_ENTRY Entry = { 0 } ;

      while ( HeapWalk ( hHeapDebug, & Entry ) ) {

         if ( ! ( Entry.wFlags & PROCESS_HEAP_ENTRY_BUSY ) ) continue ;

         MALLOC_DEBUG_STRUCT *p = (MALLOC_DEBUG_STRUCT*) Entry.lpData ;

         if ( test_sentinel ( p, sentinel, __FILE__, __LINE__ ) ) return ;
      }
   }

#if defined _USRDLL || defined DEBUG_MALLOC_LEAK
   const int IsTestNotFreed = 1 ;
#else
   const int IsTestNotFreed = 0 ;
#endif
   if ( IsTestNotFreed ) {

      PROCESS_HEAP_ENTRY Entry = { 0 } ;

      while ( HeapWalk ( hHeapDebug, & Entry ) ) {

         if ( ! ( Entry.wFlags & PROCESS_HEAP_ENTRY_BUSY ) ) continue ;

         MALLOC_DEBUG_STRUCT *p = (MALLOC_DEBUG_STRUCT*) Entry.lpData ;

         if ( p->is_in_user_proc ) {
            char buffer [ 0x100 ] ;
            sprintf ( buffer, "memory not yet freed (%d): allocated at %s(%d)\n", __LINE__, p->filename, p->line ) ;
            PrintMessage ( buffer ) ;
         }
      }
   }

   HeapDestroy ( hHeapDebug ) ;

   return ;
}



#endif // ! defined NOCRT



////////////////////////////////////////////
//             DEBUG (BSEARCH)            //
////////////////////////////////////////////



#if ! defined NOCRT



#undef bsearch


void *bsearch_debug ( const void *key, const void *base, size_t num, size_t width, int ( __cdecl *compare ) ( const void *, const void * ), const char *filename, int line ) {

   int error = 0 ;

   const char *p = (const char*) base ;

   for ( size_t i = 1 ; i < num ; i ++ ) {
      if ( compare ( p + ( i - 1 ) * width, p + i * width ) >= 0 ) {
         char buffer [ 0x100 ] ;
         sprintf ( buffer, "bsearch error: list not sorted at %s (%d), number %d\n", filename, line, (int) i ) ;
         PrintMessage ( buffer ) ;
         error ++ ;
      }
   }

   if ( error ) exit ( 1 ) ;

   return bsearch ( key, base, num, width, compare ) ;
}



#endif // ! defined NOCRT



