// stringex.cpp

#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <mbctype.h>
#include <errno.h>
#include "msc.h"

#undef DEBUG_CONST_STRING
#include "stringex.h"



////////////////////////////////////////////
//              ֐ (1)              //
////////////////////////////////////////////



// ̕܂ł̒ԂiANSIŁj
static inline int strnext ( const char *p ) {
   return 1 ;
}



// ̕܂ł̒ԂiUTF16Łj
static inline int wcsnext16 ( const wchar16_t *p ) {
   if ( IsUnicodeHighSurrogate ( *p ) && *( p + 1 ) ) return 2 ;
   return 1 ;
}



// ̕܂ł̒ԂiUTF32Łj
static inline int wcsnext32 ( const wchar32_t *p ) {
   return 1 ;
}



// mbsnext  msc.h
// wcsnext  msc.h



////////////////////////////////////////////
//              ֐ (2)              //
////////////////////////////////////////////



// 擪̕ԂiANSIŁj
static inline int strtochar ( const char *p, int *width ) {
   *width = 1 ;
   return (unsigned char) *p ;
}



// 擪̕ԂiUNICODEŁj
static inline int wcstochar ( const wchar_t *p, int *width ) {
   *width = 1 ;
   return *p ;
}



// 擪̕ԂiUTF16Łj
static inline int wcstochar16 ( const wchar16_t *p, int *width ) {

   if ( IsUnicodeHighSurrogate ( *p ) ) {
      if ( *( p + 1 ) ) *width = 2 ;
      else              *width = 1 ;
      return ( *p << WORD_BIT ) + *( p + 1 ) ;
   }

   *width = 1 ;
   return *p ;
}



// 擪̕ԂiUTF32Łj
static inline int wcstochar32 ( const wchar32_t *p, int *width ) {
   *width = 1 ;
   return *p ;
}



// 擪̕ԂiMULTIBYTEŁj
static inline int mbstochar ( const char *p, int *width ) {

   if ( ismbblead ( (unsigned char) *p ) ) {
      if ( *( p + 1 ) ) *width = 2 ;
      else              *width = 1 ;
      return ( (unsigned char) *p << BYTE_BIT ) + (unsigned char) *( p + 1 ) ;
   }

   *width = 1 ;
   return (unsigned char) *p ;
}



////////////////////////////////////////////
//              ֐ (3)              //
////////////////////////////////////////////



// PO̕ԂiANSIŁj
static inline int strtochar_prev ( const char *p, const char *start, int *width ) {

   *width = 1 ;

   if ( p <= start ) return 0 ;

   return (unsigned char) *( p - 1 ) ;
}



// PO̕ԂiUNICODEŁj
static inline int wcstochar_prev ( const wchar_t *p, const wchar_t *start, int *width ) {

   *width = 1 ;

   if ( p <= start ) return 0 ;

   return *( p - 1 ) ;
}



// PO̕ԂiUTF16Łj
static inline int wcstochar_prev16 ( const wchar16_t *p, const wchar16_t *start, int *width ) {

   if ( p >= start + 2 && IsUnicodeHighSurrogate ( *( p - 2 ) ) ) {
      *width = 2 ;
      return ( *( p - 2 ) << WORD_BIT ) + *( p - 1 ) ;
   }

   *width = 1 ;

   if ( p <= start ) return 0 ;

   return *( p - 1 ) ;
}



// PO̕ԂiUTF32Łj
static inline int wcstochar_prev32 ( const wchar32_t *p, const wchar32_t *start, int *width ) {

   *width = 1 ;

   if ( p <= start ) return 0 ;

   return *( p - 1 ) ;
}



// PO̕ԂiMULTIBYTEŁj
static inline int mbstochar_prev ( const char *p, const char *start, int *width ) {

   if ( p >= start + 2 && ismbblead ( (unsigned char) *( p - 2 ) ) && ismbslead ( start, p - 2 ) ) {
      *width = 2 ;
      return ( (unsigned char) *( p - 2 ) << BYTE_BIT ) + (unsigned char) *( p - 1 ) ;
   }

   *width = 1 ;

   if ( p <= start ) return 0 ;

   return (unsigned char) *( p - 1 ) ;
}



////////////////////////////////////////////
//              ֐ (4)              //
////////////////////////////////////////////



// ̕܂ł̒ԂiUTF16Łj
// Ȃ 0 Ԃ
static inline int wcsnext16_e ( const wchar_t *p ) {

   if ( IsUnicodeHighSurrogate ( *p ) ) {
      if ( *( p + 1 ) ) return 2 ;
      else              return 0 ;
   }

   return 1 ;
}



// ̕܂ł̒ԂiMULTIBYTEŁj
// Ȃ 0 Ԃ
static inline int mbsnext_e ( const char *p ) {

   if ( ismbblead ( (unsigned char) *p ) ) {
      if ( *( p + 1 ) ) return 2 ;
      else              return 0 ;
   }

   return 1 ;
}



////////////////////////////////////////////
//               strprev ()               //
////////////////////////////////////////////



// O̕܂ł̒ԂiMULTIBYTEŁj
int mbsprev ( const char *p, const char *start ) {

   if ( p <= start ) return 0 ;

   if ( p >= start + 2 && ismbblead ( (unsigned char) *( p - 2 ) ) && ismbslead ( start, p - 2 ) ) return 2 ;

   return 1 ;
}



// ̕܂ł̒ԂiUNICODEŁj
int wcsprev ( const wchar_t *p ) {
   return 1 ;
}



////////////////////////////////////////////
//               strcpy ()                //
////////////////////////////////////////////



// Rs[iUTF32Łj
wchar32_t *wcscpy32 ( wchar32_t *dst, const wchar32_t *src ) {

   wchar32_t *p = dst ;
   while ( *p ++ = *src ++ ) ;

   return dst ;
}



////////////////////////////////////////////
//               strcat ()                //
////////////////////////////////////////////



// AiUTF32Łj
wchar32_t *wcscat32 ( wchar32_t *dst, const wchar32_t *src ) {

   wchar32_t *p = dst ;
   while ( *p ) p ++ ;
   while ( *p ++ = *src ++ ) ;

   return dst ;
}



////////////////////////////////////////////
//             strlcpy/cat ()             //
////////////////////////////////////////////



// w肳ꂽ܂ŕAiUTF16Łj
//  SIZE_MAX ȂkI[ƌȂ
// o͂镶̖ɂ͕Kk
// bufsiz  dst Ɏ߂邱Ƃ̂łő̒iI[k܂ށj
// src  dst ̒̍vԂiI[k܂܂Ȃj
size_t wcslcatlen16 ( wchar_t *dst, size_t dstlen, const wchar_t *src, size_t srclen, size_t bufsiz ) {

   if ( srclen == SIZE_MAX ) srclen = wcslen ( src ) ;
   if ( dstlen == SIZE_MAX ) dstlen = wcslen ( dst ) ;

   if ( bufsiz > dstlen ) {
      size_t cpylen = ( srclen < bufsiz - dstlen ) ? srclen : bufsiz - dstlen - 1 ;
      memmove ( dst + dstlen, src, cpylen * sizeof(wchar_t) ) ;
      wcstrunc16 ( dst, dstlen + cpylen ) ;
   }
   else if ( bufsiz ) {
      wcstrunc16 ( dst, bufsiz - 1 ) ;
   }

   return srclen + dstlen ;
}



// w肳ꂽ܂ŕAiUTF32Łj
//  SIZE_MAX ȂkI[ƌȂ
// o͂镶̖ɂ͕Kk
// bufsiz  dst Ɏ߂邱Ƃ̂łő̒iI[k܂ށj
// src  dst ̒̍vԂiI[k܂܂Ȃj
size_t wcslcatlen32 ( wchar32_t *dst, size_t dstlen, const wchar32_t *src, size_t srclen, size_t bufsiz ) {

   if ( srclen == SIZE_MAX ) srclen = wcslen32 ( src ) ;
   if ( dstlen == SIZE_MAX ) dstlen = wcslen32 ( dst ) ;

   if ( bufsiz > dstlen ) {
      size_t cpylen = ( srclen < bufsiz - dstlen ) ? srclen : bufsiz - dstlen - 1 ;
      memmove ( dst + dstlen, src, cpylen * sizeof(wchar32_t) ) ;
      dst [ dstlen + cpylen ] = 0 ;
   }
   else if ( bufsiz ) {
      dst [ bufsiz - 1 ] = 0 ;
   }

   return srclen + dstlen ;
}



// w肳ꂽ܂ŕAiMULTIBYTEŁj
//  SIZE_MAX ȂkI[ƌȂ
// o͂镶̖ɂ͕Kk
// bufsiz  dst Ɏ߂邱Ƃ̂łő̒iI[k܂ށj
// src  dst ̒̍vԂiI[k܂܂Ȃj
size_t mbslcatlen ( char *dst, size_t dstlen, const char *src, size_t srclen, size_t bufsiz ) {

   if ( srclen == SIZE_MAX ) srclen = strlen ( src ) ;
   if ( dstlen == SIZE_MAX ) dstlen = strlen ( dst ) ;

   if ( bufsiz > dstlen ) {
      size_t cpylen = ( srclen < bufsiz - dstlen ) ? srclen : bufsiz - dstlen - 1 ;
      memmove ( dst + dstlen, src, cpylen * sizeof(char) ) ;
      mbstrunc ( dst, dstlen + cpylen ) ;
   }
   else if ( bufsiz ) {
      mbstrunc ( dst, bufsiz - 1 ) ;
   }

   return srclen + dstlen ;
}



// src  dst ̒̍vԂiI[k܂܂Ȃj
size_t wcslcat16 ( wchar_t   *dst, const wchar_t   *src, size_t bufsiz ) { return wcslcatlen16 ( dst, SIZE_MAX, src, SIZE_MAX, bufsiz ) ; }
size_t wcslcat32 ( wchar32_t *dst, const wchar32_t *src, size_t bufsiz ) { return wcslcatlen32 ( dst, SIZE_MAX, src, SIZE_MAX, bufsiz ) ; }
size_t mbslcat   ( char      *dst, const char      *src, size_t bufsiz ) { return mbslcatlen   ( dst, SIZE_MAX, src, SIZE_MAX, bufsiz ) ; }


// src ̒ԂiI[k܂܂Ȃj
size_t wcslcpylen16 ( wchar_t   *dst, const wchar_t   *src, size_t srclen, size_t bufsiz ) { return wcslcatlen16 ( dst, 0, src, srclen, bufsiz ) ; }
size_t wcslcpylen32 ( wchar32_t *dst, const wchar32_t *src, size_t srclen, size_t bufsiz ) { return wcslcatlen32 ( dst, 0, src, srclen, bufsiz ) ; }
size_t mbslcpylen   ( char      *dst, const char      *src, size_t srclen, size_t bufsiz ) { return mbslcatlen   ( dst, 0, src, srclen, bufsiz ) ; }
size_t wcslcpy16 ( wchar_t   *dst, const wchar_t   *src, size_t bufsiz ) { return wcslcatlen16 ( dst, 0, src, SIZE_MAX, bufsiz ) ; }
size_t wcslcpy32 ( wchar32_t *dst, const wchar32_t *src, size_t bufsiz ) { return wcslcatlen32 ( dst, 0, src, SIZE_MAX, bufsiz ) ; }
size_t mbslcpy   ( char      *dst, const char      *src, size_t bufsiz ) { return mbslcatlen   ( dst, 0, src, SIZE_MAX, bufsiz ) ; }



////////////////////////////////////////////
//               strmove ()               //
////////////////////////////////////////////



// Rs[iANSIŁj
// src  dst ̗̈悪dȂĂĂ
// Rs[̖̃AhXԂ
char *strmove ( char *dst, const char *src ) {

   size_t srclen = strlen ( src ) ;

   memmove ( dst, src, ( srclen + 1 ) * sizeof(char) ) ;

   return dst + srclen ;
}



// Rs[iUNICODEŁj
// src  dst ̗̈悪dȂĂĂ
// Rs[̖̃AhXԂ
wchar_t *wcsmove ( wchar_t *dst, const wchar_t *src ) {

   size_t srclen = wcslen ( src ) ;

   memmove ( dst, src, ( srclen + 1 ) * sizeof(wchar_t) ) ;

   return dst + srclen ;
}



// Rs[iUTF32Łj
// src  dst ̗̈悪dȂĂĂ
// Rs[̖̃AhXԂ
wchar32_t *wcsmove32 ( wchar32_t *dst, const wchar32_t *src ) {

   size_t srclen = wcslen32 ( src ) ;

   memmove ( dst, src, ( srclen + 1 ) * sizeof(wchar32_t) ) ;

   return dst + srclen ;
}



////////////////////////////////////////////
//              strinsert ()              //
////////////////////////////////////////////



// }iANSIŁj
// dstlen Ɏw肵̕Oɑ}ʒu폜
// }̖̃AhXԂ
char *strinsert ( char *dst, const char *src, size_t dstlen ) {

   size_t srclen = strlen ( src ) ;

   if ( srclen != dstlen ) strmove ( dst + srclen, dst + dstlen ) ;

   memmove ( dst, src, srclen * sizeof(char) ) ;

   return dst + srclen ;
}



// }iUNICODEŁj
// dstlen Ɏw肵̕Oɑ}ʒu폜
// }̖̃AhXԂ
wchar_t *wcsinsert ( wchar_t *dst, const wchar_t *src, size_t dstlen ) {

   size_t srclen = wcslen ( src ) ;

   if ( srclen != dstlen ) wcsmove ( dst + srclen, dst + dstlen ) ;

   memmove ( dst, src, srclen * sizeof(wchar_t) ) ;

   return dst + srclen ;
}



// }iUTF32Łj
// dstlen Ɏw肵̕Oɑ}ʒu폜
// }̖̃AhXԂ
wchar32_t *wcsinsert32 ( wchar32_t *dst, const wchar32_t *src, size_t dstlen ) {

   size_t srclen = wcslen32 ( src ) ;

   if ( srclen != dstlen ) wcsmove32 ( dst + srclen, dst + dstlen ) ;

   memmove ( dst, src, srclen * sizeof(wchar32_t) ) ;

   return dst + srclen ;
}



////////////////////////////////////////////
//               strlset ()               //
////////////////////////////////////////////



// obt@𕶎Ŗ߂iANSIŁj
// bufsiz  dst Ɏ߂邱Ƃ̂łő̒iI[k܂ށj
// ̍Ōɂ̓kt
char *strlset ( char *dst, int c, size_t bufsiz ) {

   char *start = dst ;
   char *end = dst + bufsiz - 1 ;

   if ( bufsiz ) {
      while ( dst < end ) *dst ++ = c ;
      *dst = 0 ;
   }

   return start ;
}



// obt@𕶎Ŗ߂iUNICODEŁj
// bufsiz  dst Ɏ߂邱Ƃ̂łő̒iI[k܂ށj
// ̍Ōɂ̓kt
wchar_t *wcslset ( wchar_t *dst, int c, size_t bufsiz ) {

   wchar_t *start = dst ;
   wchar_t *end = dst + bufsiz - 1 ;

   if ( bufsiz ) {
      while ( dst < end ) *dst ++ = c ;
      *dst = 0 ;
   }

   return start ;
}



// obt@𕶎Ŗ߂iUTF16Łj
// bufsiz  dst Ɏ߂邱Ƃ̂łő̒iI[k܂ށj
// ̍Ōɂ̓kt
wchar16_t *wcslset16 ( wchar16_t *dst, int c, size_t bufsiz ) {

   wchar16_t *start = dst ;
   wchar16_t *end = dst + bufsiz - 1 ;

   if ( (unsigned) c >> WORD_BIT && ! IsUnicodeHighSurrogate ( (unsigned) c >> WORD_BIT ) ) {
      if ( (unsigned) c > UTF16_MAX ) c = (wchar16_t) c ;
      else                            c = ( MAKE_UNICODE_HIGH_SURROGATE ( c ) << WORD_BIT ) + MAKE_UNICODE_LOW_SURROGATE ( c ) ;
   }

   if ( bufsiz ) {
      if ( (unsigned) c >> WORD_BIT ) {
         while ( dst < end - 1 ) {
            *dst ++ = ( c >> WORD_BIT ) ;
            *dst ++ = c ;
         }
         *dst = 0 ;
      }
      else {
         while ( dst < end ) *dst ++ = c ;
         *dst = 0 ;
      }
   }

   return start ;
}



// obt@𕶎Ŗ߂iUTF32Łj
// bufsiz  dst Ɏ߂邱Ƃ̂łő̒iI[k܂ށj
// ̍Ōɂ̓kt
wchar32_t *wcslset32 ( wchar32_t *dst, int c, size_t bufsiz ) {

   wchar32_t *start = dst ;
   wchar32_t *end = dst + bufsiz - 1 ;

   if ( bufsiz ) {
      while ( dst < end ) *dst ++ = c ;
      *dst = 0 ;
   }

   return start ;
}



// obt@𕶎Ŗ߂iMULTIBYTEŁj
// bufsiz  dst Ɏ߂邱Ƃ̂łő̒iI[k܂ށj
// ̍Ōɂ̓kt
char *mbslset ( char *dst, int c, size_t bufsiz ) {

   char *start = dst ;
   char *end = dst + bufsiz - 1 ;

   if ( bufsiz ) {
      if ( (unsigned) c >> BYTE_BIT ) {
         while ( dst < end - 1 ) {
            *dst ++ = ( c >> BYTE_BIT ) ;
            *dst ++ = c ;
         }
         *dst = 0 ;
      }
      else {
         while ( dst < end ) *dst ++ = c ;
         *dst = 0 ;
      }
   }

   return start ;
}



////////////////////////////////////////////
//               strcmp ()                //
////////////////////////////////////////////



// riANSIŁj
static int do_strncmp ( const char *string1, const char *string2, size_t count, int isignore ) {

   int c1, c2 ;

   while ( 1 ) {

      if ( ! count ) return 0 ;

      int width1, width2 ;

      c1 = strtochar ( string1, & width1 ) ;
      c2 = strtochar ( string2, & width2 ) ;

      if ( isignore ) {
         c1 = tolower ( c1 ) ;
         c2 = tolower ( c2 ) ;
      }

      if ( ! c1 || c1 != c2 ) break ;

      string1 += width1 ;
      string2 += width2 ;

      if ( width1 > 1 && (size_t) width1 > count ) count = 0 ;
      else                                         count -= width1 ;
   }

   if ( (unsigned) c1 > (unsigned) c2 ) return 1 ;
   if ( (unsigned) c1 < (unsigned) c2 ) return -1 ;
   return 0 ;
}



// riUNICODEŁj
static int do_wcsncmp ( const wchar_t *string1, const wchar_t *string2, size_t count, int isignore ) {

   int c1, c2 ;

   while ( 1 ) {

      if ( ! count ) return 0 ;

      int width1, width2 ;

      c1 = wcstochar ( string1, & width1 ) ;
      c2 = wcstochar ( string2, & width2 ) ;

      if ( isignore ) {
         c1 = tolower ( c1 ) ;
         c2 = tolower ( c2 ) ;
      }

      if ( ! c1 || c1 != c2 ) break ;

      string1 += width1 ;
      string2 += width2 ;

      if ( width1 > 1 && (size_t) width1 > count ) count = 0 ;
      else                                         count -= width1 ;
   }

   if ( (unsigned) c1 > (unsigned) c2 ) return 1 ;
   if ( (unsigned) c1 < (unsigned) c2 ) return -1 ;
   return 0 ;
}



// riUTF16Łj
static int do_wcsncmp16 ( const wchar16_t *string1, const wchar16_t *string2, size_t count, int isignore ) {

   int c1, c2 ;

   while ( 1 ) {

      if ( ! count ) return 0 ;

      int width1, width2 ;

      c1 = wcstochar16 ( string1, & width1 ) ;
      c2 = wcstochar16 ( string2, & width2 ) ;

      if ( isignore ) {
         c1 = tolower ( c1 ) ;
         c2 = tolower ( c2 ) ;
      }

      if ( ! c1 || c1 != c2 ) break ;

      string1 += width1 ;
      string2 += width2 ;

      if ( width1 > 1 && (size_t) width1 > count ) count = 0 ;
      else                                         count -= width1 ;
   }

   if ( (unsigned) c1 > (unsigned) c2 ) return 1 ;
   if ( (unsigned) c1 < (unsigned) c2 ) return -1 ;
   return 0 ;
}



// riUTF32Łj
static int do_wcsncmp32 ( const wchar32_t *string1, const wchar32_t *string2, size_t count, int isignore ) {

   int c1, c2 ;

   while ( 1 ) {

      if ( ! count ) return 0 ;

      int width1, width2 ;

      c1 = wcstochar32 ( string1, & width1 ) ;
      c2 = wcstochar32 ( string2, & width2 ) ;

      if ( isignore ) {
         c1 = tolower ( c1 ) ;
         c2 = tolower ( c2 ) ;
      }

      if ( ! c1 || c1 != c2 ) break ;

      string1 += width1 ;
      string2 += width2 ;

      if ( width1 > 1 && (size_t) width1 > count ) count = 0 ;
      else                                         count -= width1 ;
   }

   if ( (unsigned) c1 > (unsigned) c2 ) return 1 ;
   if ( (unsigned) c1 < (unsigned) c2 ) return -1 ;
   return 0 ;
}



// riMULTIBYTEŁj
static int do_mbsncmp ( const char *string1, const char *string2, size_t count, int isignore ) {

   int c1, c2 ;

   while ( 1 ) {

      if ( ! count ) return 0 ;

      int width1, width2 ;

      c1 = mbstochar ( string1, & width1 ) ;
      c2 = mbstochar ( string2, & width2 ) ;

      if ( isignore ) {
         c1 = tolower ( c1 ) ;
         c2 = tolower ( c2 ) ;
      }

      if ( ! c1 || c1 != c2 ) break ;

      string1 += width1 ;
      string2 += width2 ;

      if ( width1 > 1 && (size_t) width1 > count ) count = 0 ;
      else                                         count -= width1 ;
   }

   if ( (unsigned) c1 > (unsigned) c2 ) return 1 ;
   if ( (unsigned) c1 < (unsigned) c2 ) return -1 ;
   return 0 ;
}



// strcmp  CRT
// wcscmp  CRT
int wcscmp16 ( const wchar16_t *s1, const wchar16_t *s2 ) { return do_wcsncmp16 ( s1, s2, SIZE_MAX, 0 ) ; }
int wcscmp32 ( const wchar32_t *s1, const wchar32_t *s2 ) { return do_wcsncmp32 ( s1, s2, SIZE_MAX, 0 ) ; }
int mbscmp   ( const char      *s1, const char      *s2 ) { return do_mbsncmp   ( s1, s2, SIZE_MAX, 0 ) ; }

// strncmp  CRT
// wcsncmp  CRT
int wcsncmp16 ( const wchar16_t *s1, const wchar16_t *s2, size_t n ) { return do_wcsncmp16 ( s1, s2, n, 0 ) ; }
int wcsncmp32 ( const wchar32_t *s1, const wchar32_t *s2, size_t n ) { return do_wcsncmp32 ( s1, s2, n, 0 ) ; }
int mbsncmp   ( const char      *s1, const char      *s2, size_t n ) { return do_mbsncmp   ( s1, s2, n, 0 ) ; }

int stricmp   ( const char      *s1, const char      *s2 ) { return do_strncmp   ( s1, s2, SIZE_MAX, 1 ) ; }
int wcsicmp   ( const wchar_t   *s1, const wchar_t   *s2 ) { return do_wcsncmp   ( s1, s2, SIZE_MAX, 1 ) ; }
int wcsicmp16 ( const wchar16_t *s1, const wchar16_t *s2 ) { return do_wcsncmp16 ( s1, s2, SIZE_MAX, 1 ) ; }
int wcsicmp32 ( const wchar32_t *s1, const wchar32_t *s2 ) { return do_wcsncmp32 ( s1, s2, SIZE_MAX, 1 ) ; }
int mbsicmp   ( const char      *s1, const char      *s2 ) { return do_mbsncmp   ( s1, s2, SIZE_MAX, 1 ) ; }

int strnicmp   ( const char      *s1, const char      *s2, size_t n ) { return do_strncmp   ( s1, s2, n, 1 ) ; }
int wcsnicmp   ( const wchar_t   *s1, const wchar_t   *s2, size_t n ) { return do_wcsncmp   ( s1, s2, n, 1 ) ; }
int wcsnicmp16 ( const wchar16_t *s1, const wchar16_t *s2, size_t n ) { return do_wcsncmp16 ( s1, s2, n, 1 ) ; }
int wcsnicmp32 ( const wchar32_t *s1, const wchar32_t *s2, size_t n ) { return do_wcsncmp32 ( s1, s2, n, 1 ) ; }
int mbsnicmp   ( const char      *s1, const char      *s2, size_t n ) { return do_mbsncmp   ( s1, s2, n, 1 ) ; }



////////////////////////////////////////////
//               strrcmp ()               //
////////////////////////////////////////////



// 𖖔riANSIŁj
static int do_strrncmp ( const char *string1, const char *string2, size_t count, int isignore ) {

   int c1, c2 ;

   const char *current1 = strend ( string1 ) ;
   const char *current2 = strend ( string2 ) ;

   while ( 1 ) {

      if ( ! count ) return 0 ;

      int width1, width2 ;

      c1 = strtochar_prev ( current1, string1, & width1 ) ;
      c2 = strtochar_prev ( current2, string2, & width2 ) ;

      if ( isignore ) {
         c1 = tolower ( c1 ) ;
         c2 = tolower ( c2 ) ;
      }

      if ( ! c1 || c1 != c2 ) break ;

      current1 -= width1 ;
      current2 -= width2 ;

      if ( width1 > 1 && (size_t) width1 > count ) count = 0 ;
      else                                         count -= width1 ;
   }

   if ( (unsigned) c1 > (unsigned) c2 ) return 1 ;
   if ( (unsigned) c1 < (unsigned) c2 ) return -1 ;
   return 0 ;
}



// 𖖔riUNICODEŁj
static int do_wcsrncmp ( const wchar_t *string1, const wchar_t *string2, size_t count, int isignore ) {

   int c1, c2 ;

   const wchar_t *current1 = wcsend ( string1 ) ;
   const wchar_t *current2 = wcsend ( string2 ) ;

   while ( 1 ) {

      if ( ! count ) return 0 ;

      int width1, width2 ;

      c1 = wcstochar_prev ( current1, string1, & width1 ) ;
      c2 = wcstochar_prev ( current2, string2, & width2 ) ;

      if ( isignore ) {
         c1 = tolower ( c1 ) ;
         c2 = tolower ( c2 ) ;
      }

      if ( ! c1 || c1 != c2 ) break ;

      current1 -= width1 ;
      current2 -= width2 ;

      if ( width1 > 1 && (size_t) width1 > count ) count = 0 ;
      else                                         count -= width1 ;
   }

   if ( (unsigned) c1 > (unsigned) c2 ) return 1 ;
   if ( (unsigned) c1 < (unsigned) c2 ) return -1 ;
   return 0 ;
}



// 𖖔riUTF16Łj
static int do_wcsrncmp16 ( const wchar16_t *string1, const wchar16_t *string2, size_t count, int isignore ) {

   int c1, c2 ;

   const wchar16_t *current1 = wcsend16 ( string1 ) ;
   const wchar16_t *current2 = wcsend16 ( string2 ) ;

   while ( 1 ) {

      if ( ! count ) return 0 ;

      int width1, width2 ;

      c1 = wcstochar_prev16 ( current1, string1, & width1 ) ;
      c2 = wcstochar_prev16 ( current2, string2, & width2 ) ;

      if ( isignore ) {
         c1 = tolower ( c1 ) ;
         c2 = tolower ( c2 ) ;
      }

      if ( ! c1 || c1 != c2 ) break ;

      current1 -= width1 ;
      current2 -= width2 ;

      if ( width1 > 1 && (size_t) width1 > count ) count = 0 ;
      else                                         count -= width1 ;
   }

   if ( (unsigned) c1 > (unsigned) c2 ) return 1 ;
   if ( (unsigned) c1 < (unsigned) c2 ) return -1 ;
   return 0 ;
}



// 𖖔riUTF32Łj
static int do_wcsrncmp32 ( const wchar32_t *string1, const wchar32_t *string2, size_t count, int isignore ) {

   int c1, c2 ;

   const wchar32_t *current1 = wcsend32 ( string1 ) ;
   const wchar32_t *current2 = wcsend32 ( string2 ) ;

   while ( 1 ) {

      if ( ! count ) return 0 ;

      int width1, width2 ;

      c1 = wcstochar_prev32 ( current1, string1, & width1 ) ;
      c2 = wcstochar_prev32 ( current2, string2, & width2 ) ;

      if ( isignore ) {
         c1 = tolower ( c1 ) ;
         c2 = tolower ( c2 ) ;
      }

      if ( ! c1 || c1 != c2 ) break ;

      current1 -= width1 ;
      current2 -= width2 ;

      if ( width1 > 1 && (size_t) width1 > count ) count = 0 ;
      else                                         count -= width1 ;
   }

   if ( (unsigned) c1 > (unsigned) c2 ) return 1 ;
   if ( (unsigned) c1 < (unsigned) c2 ) return -1 ;
   return 0 ;
}



// 𖖔riMULTIBYTEŁj
static int do_mbsrncmp ( const char *string1, const char *string2, size_t count, int isignore ) {

   int c1, c2 ;

   const char *current1 = strend ( string1 ) ;
   const char *current2 = strend ( string2 ) ;

   while ( 1 ) {

      if ( ! count ) return 0 ;

      int width1, width2 ;

      c1 = mbstochar_prev ( current1, string1, & width1 ) ;
      c2 = mbstochar_prev ( current2, string2, & width2 ) ;

      if ( isignore ) {
         c1 = tolower ( c1 ) ;
         c2 = tolower ( c2 ) ;
      }

      if ( ! c1 || c1 != c2 ) break ;

      current1 -= width1 ;
      current2 -= width2 ;

      if ( width1 > 1 && (size_t) width1 > count ) count = 0 ;
      else                                         count -= width1 ;
   }

   if ( (unsigned) c1 > (unsigned) c2 ) return 1 ;
   if ( (unsigned) c1 < (unsigned) c2 ) return -1 ;
   return 0 ;
}



int strrcmp   ( const char      *s1, const char      *s2 ) { return do_strrncmp   ( s1, s2, SIZE_MAX, 0 ) ; }
int wcsrcmp   ( const wchar_t   *s1, const wchar_t   *s2 ) { return do_wcsrncmp   ( s1, s2, SIZE_MAX, 0 ) ; }
int wcsrcmp16 ( const wchar16_t *s1, const wchar16_t *s2 ) { return do_wcsrncmp16 ( s1, s2, SIZE_MAX, 0 ) ; }
int wcsrcmp32 ( const wchar32_t *s1, const wchar32_t *s2 ) { return do_wcsrncmp32 ( s1, s2, SIZE_MAX, 0 ) ; }
int mbsrcmp   ( const char      *s1, const char      *s2 ) { return do_mbsrncmp   ( s1, s2, SIZE_MAX, 0 ) ; }

int strrncmp   ( const char      *s1, const char      *s2, size_t n ) { return do_strrncmp   ( s1, s2, n, 0 ) ; }
int wcsrncmp   ( const wchar_t   *s1, const wchar_t   *s2, size_t n ) { return do_wcsrncmp   ( s1, s2, n, 0 ) ; }
int wcsrncmp16 ( const wchar16_t *s1, const wchar16_t *s2, size_t n ) { return do_wcsrncmp16 ( s1, s2, n, 0 ) ; }
int wcsrncmp32 ( const wchar32_t *s1, const wchar32_t *s2, size_t n ) { return do_wcsrncmp32 ( s1, s2, n, 0 ) ; }
int mbsrncmp   ( const char      *s1, const char      *s2, size_t n ) { return do_mbsrncmp   ( s1, s2, n, 0 ) ; }

int strricmp   ( const char      *s1, const char      *s2 ) { return do_strrncmp   ( s1, s2, SIZE_MAX, 1 ) ; }
int wcsricmp   ( const wchar_t   *s1, const wchar_t   *s2 ) { return do_wcsrncmp   ( s1, s2, SIZE_MAX, 1 ) ; }
int wcsricmp16 ( const wchar16_t *s1, const wchar16_t *s2 ) { return do_wcsrncmp16 ( s1, s2, SIZE_MAX, 1 ) ; }
int wcsricmp32 ( const wchar32_t *s1, const wchar32_t *s2 ) { return do_wcsrncmp32 ( s1, s2, SIZE_MAX, 1 ) ; }
int mbsricmp   ( const char      *s1, const char      *s2 ) { return do_mbsrncmp   ( s1, s2, SIZE_MAX, 1 ) ; }

int strrnicmp   ( const char      *s1, const char      *s2, size_t n ) { return do_strrncmp   ( s1, s2, n, 1 ) ; }
int wcsrnicmp   ( const wchar_t   *s1, const wchar_t   *s2, size_t n ) { return do_wcsrncmp   ( s1, s2, n, 1 ) ; }
int wcsrnicmp16 ( const wchar16_t *s1, const wchar16_t *s2, size_t n ) { return do_wcsrncmp16 ( s1, s2, n, 1 ) ; }
int wcsrnicmp32 ( const wchar32_t *s1, const wchar32_t *s2, size_t n ) { return do_wcsrncmp32 ( s1, s2, n, 1 ) ; }
int mbsrnicmp   ( const char      *s1, const char      *s2, size_t n ) { return do_mbsrncmp   ( s1, s2, n, 1 ) ; }



////////////////////////////////////////////
//               strlcmp ()               //
////////////////////////////////////////////



//  string ̐擪ƕ pattern riANSIŁj
// delimiter w肵Ƃ́A񋫊ȆOアꂩ^łȂƂvƌȂ
// p_len  pattern ̒ۑiNULLłj
static int do_strlcmp ( const char *string, const char *pattern, size_t *p_len, CTYPE_FUNCTION delimiter, int isignore ) {

   size_t len = strlen ( pattern ) ;

   if ( p_len ) *p_len = len ;

   int result = do_strncmp ( string, pattern, len, isignore ) ;
   if ( ! result && delimiter && len ) {
      int dummy ;
      int c1 = strtochar ( string + len, & dummy ) ;
      int c2 = strtochar_prev ( string + len, string, & dummy ) ;
      if ( c1 && delimiter ( c1 ) && delimiter ( c2 ) ) result = 1 ;
   }

   return result ;
}



//  string ̐擪ƕ pattern riUNICODEŁj
// delimiter w肵Ƃ́A񋫊ȆOアꂩ^łȂƂvƌȂ
// p_len  pattern ̒ۑiNULLłj
static int do_wcslcmp ( const wchar_t *string, const wchar_t *pattern, size_t *p_len, CTYPE_FUNCTION delimiter, int isignore ) {

   size_t len = wcslen ( pattern ) ;

   if ( p_len ) *p_len = len ;

   int result = do_wcsncmp ( string, pattern, len, isignore ) ;
   if ( ! result && delimiter && len ) {
      int dummy ;
      int c1 = wcstochar ( string + len, & dummy ) ;
      int c2 = wcstochar_prev ( string + len, string, & dummy ) ;
      if ( c1 && delimiter ( c1 ) && delimiter ( c2 ) ) result = 1 ;
   }

   return result ;
}



//  string ̐擪ƕ pattern riUTF16Łj
// delimiter w肵Ƃ́A񋫊ȆOアꂩ^łȂƂvƌȂ
// p_len  pattern ̒ۑiNULLłj
static int do_wcslcmp16 ( const wchar16_t *string, const wchar16_t *pattern, size_t *p_len, CTYPE_FUNCTION delimiter, int isignore ) {

   size_t len = wcslen ( pattern ) ;

   if ( p_len ) *p_len = len ;

   int result = do_wcsncmp16 ( string, pattern, len, isignore ) ;
   if ( ! result && delimiter && len ) {
      int dummy ;
      int c1 = wcstochar ( string + len, & dummy ) ;
      int c2 = wcstochar_prev ( string + len, string, & dummy ) ;
      if ( c1 && delimiter ( c1 ) && delimiter ( c2 ) ) result = 1 ;
   }

   return result ;
}



//  string ̐擪ƕ pattern riUTF32Łj
// delimiter w肵Ƃ́A񋫊ȆOアꂩ^łȂƂvƌȂ
// p_len  pattern ̒ۑiNULLłj
static int do_wcslcmp32 ( const wchar32_t *string, const wchar32_t *pattern, size_t *p_len, CTYPE_FUNCTION delimiter, int isignore ) {

   size_t len = wcslen32 ( pattern ) ;

   if ( p_len ) *p_len = len ;

   int result = do_wcsncmp32 ( string, pattern, len, isignore ) ;
   if ( ! result && delimiter && len ) {
      int dummy ;
      int c1 = wcstochar32 ( string + len, & dummy ) ;
      int c2 = wcstochar_prev32 ( string + len, string, & dummy ) ;
      if ( c1 && delimiter ( c1 ) && delimiter ( c2 ) ) result = 1 ;
   }

   return result ;
}



//  string ̐擪ƕ pattern riMULTIBYTEŁj
// delimiter w肵Ƃ́A񋫊ȆOアꂩ^łȂƂvƌȂ
// p_len  pattern ̒ۑiNULLłj
static int do_mbslcmp ( const char *string, const char *pattern, size_t *p_len, CTYPE_FUNCTION delimiter, int isignore ) {

   size_t len = strlen ( pattern ) ;

   if ( p_len ) *p_len = len ;

   int result = do_mbsncmp ( string, pattern, len, isignore ) ;
   if ( ! result && delimiter && len ) {
      int dummy ;
      int c1 = mbstochar ( string + len, & dummy ) ;
      int c2 = mbstochar_prev ( string + len, string, & dummy ) ;
      if ( c1 && delimiter ( c1 ) && delimiter ( c2 ) ) result = 1 ;
   }

   return result ;
}



int strlcmp   ( const char      *s, const char      *p, size_t *l ) { return do_strlcmp   ( s, p, l, NULL, 0 ) ; }
int wcslcmp   ( const wchar_t   *s, const wchar_t   *p, size_t *l ) { return do_wcslcmp   ( s, p, l, NULL, 0 ) ; }
int wcslcmp16 ( const wchar16_t *s, const wchar16_t *p, size_t *l ) { return do_wcslcmp16 ( s, p, l, NULL, 0 ) ; }
int wcslcmp32 ( const wchar32_t *s, const wchar32_t *p, size_t *l ) { return do_wcslcmp32 ( s, p, l, NULL, 0 ) ; }
int mbslcmp   ( const char      *s, const char      *p, size_t *l ) { return do_mbslcmp   ( s, p, l, NULL, 0 ) ; }

int strlicmp   ( const char      *s, const char      *p, size_t *l ) { return do_strlcmp   ( s, p, l, NULL, 1 ) ; }
int wcslicmp   ( const wchar_t   *s, const wchar_t   *p, size_t *l ) { return do_wcslcmp   ( s, p, l, NULL, 1 ) ; }
int wcslicmp16 ( const wchar16_t *s, const wchar16_t *p, size_t *l ) { return do_wcslcmp16 ( s, p, l, NULL, 1 ) ; }
int wcslicmp32 ( const wchar32_t *s, const wchar32_t *p, size_t *l ) { return do_wcslcmp32 ( s, p, l, NULL, 1 ) ; }
int mbslicmp   ( const char      *s, const char      *p, size_t *l ) { return do_mbslcmp   ( s, p, l, NULL, 1 ) ; }

int strlcmp_word   ( const char      *s, const char      *p, size_t *l, CTYPE_FUNCTION d ) { return do_strlcmp   ( s, p, l, d, 0 ) ; }
int wcslcmp_word   ( const wchar_t   *s, const wchar_t   *p, size_t *l, CTYPE_FUNCTION d ) { return do_wcslcmp   ( s, p, l, d, 0 ) ; }
int wcslcmp16_word ( const wchar16_t *s, const wchar16_t *p, size_t *l, CTYPE_FUNCTION d ) { return do_wcslcmp16 ( s, p, l, d, 0 ) ; }
int wcslcmp32_word ( const wchar32_t *s, const wchar32_t *p, size_t *l, CTYPE_FUNCTION d ) { return do_wcslcmp32 ( s, p, l, d, 0 ) ; }
int mbslcmp_word   ( const char      *s, const char      *p, size_t *l, CTYPE_FUNCTION d ) { return do_mbslcmp   ( s, p, l, d, 0 ) ; }

int strlicmp_word   ( const char      *s, const char      *p, size_t *l, CTYPE_FUNCTION d ) { return do_strlcmp   ( s, p, l, d, 1 ) ; }
int wcslicmp_word   ( const wchar_t   *s, const wchar_t   *p, size_t *l, CTYPE_FUNCTION d ) { return do_wcslcmp   ( s, p, l, d, 1 ) ; }
int wcslicmp16_word ( const wchar16_t *s, const wchar16_t *p, size_t *l, CTYPE_FUNCTION d ) { return do_wcslcmp16 ( s, p, l, d, 1 ) ; }
int wcslicmp32_word ( const wchar32_t *s, const wchar32_t *p, size_t *l, CTYPE_FUNCTION d ) { return do_wcslcmp32 ( s, p, l, d, 1 ) ; }
int mbslicmp_word   ( const char      *s, const char      *p, size_t *l, CTYPE_FUNCTION d ) { return do_mbslcmp   ( s, p, l, d, 1 ) ; }



////////////////////////////////////////////
//               strtcmp ()               //
////////////////////////////////////////////



//  string ̖ƕ pattern 𖖔riANSIŁj
// delimiter w肵Ƃ́A񋫊ȆOアꂩ^łȂƂvƌȂ
// p_len  pattern ̒ۑiNULLłj
int do_strtcmp ( const char *string, const char *pattern, size_t *p_len, CTYPE_FUNCTION delimiter, int isignore ) {

   size_t len = strlen ( pattern ) ;

   if ( p_len ) *p_len = len ;

   int result = do_strrncmp ( string, pattern, len, isignore ) ;
   if ( ! result && delimiter && len ) {
      int dummy ;
      const char *end = strend ( string ) ;
      int c1 = strtochar ( end - len, & dummy ) ;
      int c2 = strtochar_prev ( end - len, string, & dummy ) ;
      if ( c2 && delimiter ( c1 ) && delimiter ( c2 ) ) result = 1 ;
   }

   return result ;
}



//  string ̖ƕ pattern 𖖔riUNICODEŁj
// delimiter w肵Ƃ́A񋫊ȆOアꂩ^łȂƂvƌȂ
// p_len  pattern ̒ۑiNULLłj
int do_wcstcmp ( const wchar_t *string, const wchar_t *pattern, size_t *p_len, CTYPE_FUNCTION delimiter, int isignore ) {

   size_t len = wcslen ( pattern ) ;

   if ( p_len ) *p_len = len ;

   int result = do_wcsrncmp ( string, pattern, len, isignore ) ;
   if ( ! result && delimiter && len ) {
      int dummy ;
      const wchar_t *end = wcsend ( string ) ;
      int c1 = wcstochar ( end - len, & dummy ) ;
      int c2 = wcstochar_prev ( end - len, string, & dummy ) ;
      if ( c2 && delimiter ( c1 ) && delimiter ( c2 ) ) result = 1 ;
   }

   return result ;
}



//  string ̖ƕ pattern 𖖔riUTF16Łj
// delimiter w肵Ƃ́A񋫊ȆOアꂩ^łȂƂvƌȂ
// p_len  pattern ̒ۑiNULLłj
int do_wcstcmp16 ( const wchar16_t *string, const wchar16_t *pattern, size_t *p_len, CTYPE_FUNCTION delimiter, int isignore ) {

   size_t len = wcslen ( pattern ) ;

   if ( p_len ) *p_len = len ;

   int result = do_wcsrncmp16 ( string, pattern, len, isignore ) ;
   if ( ! result && delimiter && len ) {
      int dummy ;
      const wchar_t *end = wcsend ( string ) ;
      int c1 = wcstochar ( end - len, & dummy ) ;
      int c2 = wcstochar_prev ( end - len, string, & dummy ) ;
      if ( c2 && delimiter ( c1 ) && delimiter ( c2 ) ) result = 1 ;
   }

   return result ;
}



//  string ̖ƕ pattern 𖖔riUTF32Łj
// delimiter w肵Ƃ́A񋫊ȆOアꂩ^łȂƂvƌȂ
// p_len  pattern ̒ۑiNULLłj
int do_wcstcmp32 ( const wchar32_t *string, const wchar32_t *pattern, size_t *p_len, CTYPE_FUNCTION delimiter, int isignore ) {

   size_t len = wcslen32 ( pattern ) ;

   if ( p_len ) *p_len = len ;

   int result = do_wcsrncmp32 ( string, pattern, len, isignore ) ;
   if ( ! result && delimiter && len ) {
      int dummy ;
      const wchar32_t *end = wcsend32 ( string ) ;
      int c1 = wcstochar32 ( end - len, & dummy ) ;
      int c2 = wcstochar_prev32 ( end - len, string, & dummy ) ;
      if ( c2 && delimiter ( c1 ) && delimiter ( c2 ) ) result = 1 ;
   }

   return result ;
}



//  string ̖ƕ pattern 𖖔riMULTIBYTEŁj
// delimiter w肵Ƃ́A񋫊ȆOアꂩ^łȂƂvƌȂ
// p_len  pattern ̒ۑiNULLłj
int do_mbstcmp ( const char *string, const char *pattern, size_t *p_len, CTYPE_FUNCTION delimiter, int isignore ) {

   size_t len = strlen ( pattern ) ;

   if ( p_len ) *p_len = len ;

   int result = do_mbsrncmp ( string, pattern, len, isignore ) ;
   if ( ! result && delimiter && len ) {
      int dummy ;
      const char *end = strend ( string ) ;
      int c1 = mbstochar ( end - len, & dummy ) ;
      int c2 = mbstochar_prev ( end - len, string, & dummy ) ;
      if ( c2 && delimiter ( c1 ) && delimiter ( c2 ) ) result = 1 ;
   }

   return result ;
}



int strtcmp   ( const char      *s, const char      *p, size_t *l ) { return do_strtcmp   ( s, p, l, NULL, 0 ) ; }
int wcstcmp   ( const wchar_t   *s, const wchar_t   *p, size_t *l ) { return do_wcstcmp   ( s, p, l, NULL, 0 ) ; }
int wcstcmp16 ( const wchar16_t *s, const wchar16_t *p, size_t *l ) { return do_wcstcmp16 ( s, p, l, NULL, 0 ) ; }
int wcstcmp32 ( const wchar32_t *s, const wchar32_t *p, size_t *l ) { return do_wcstcmp32 ( s, p, l, NULL, 0 ) ; }
int mbstcmp   ( const char      *s, const char      *p, size_t *l ) { return do_mbstcmp   ( s, p, l, NULL, 0 ) ; }

int strticmp   ( const char      *s, const char      *p, size_t *l ) { return do_strtcmp   ( s, p, l, NULL, 1 ) ; }
int wcsticmp   ( const wchar_t   *s, const wchar_t   *p, size_t *l ) { return do_wcstcmp   ( s, p, l, NULL, 1 ) ; }
int wcsticmp16 ( const wchar16_t *s, const wchar16_t *p, size_t *l ) { return do_wcstcmp16 ( s, p, l, NULL, 1 ) ; }
int wcsticmp32 ( const wchar32_t *s, const wchar32_t *p, size_t *l ) { return do_wcstcmp32 ( s, p, l, NULL, 1 ) ; }
int mbsticmp   ( const char      *s, const char      *p, size_t *l ) { return do_mbstcmp   ( s, p, l, NULL, 1 ) ; }

int strtcmp_word   ( const char      *s, const char      *p, size_t *l, CTYPE_FUNCTION d ) { return do_strtcmp   ( s, p, l, d, 0 ) ; }
int wcstcmp_word   ( const wchar_t   *s, const wchar_t   *p, size_t *l, CTYPE_FUNCTION d ) { return do_wcstcmp   ( s, p, l, d, 0 ) ; }
int wcstcmp16_word ( const wchar16_t *s, const wchar16_t *p, size_t *l, CTYPE_FUNCTION d ) { return do_wcstcmp16 ( s, p, l, d, 0 ) ; }
int wcstcmp32_word ( const wchar32_t *s, const wchar32_t *p, size_t *l, CTYPE_FUNCTION d ) { return do_wcstcmp32 ( s, p, l, d, 0 ) ; }
int mbstcmp_word   ( const char      *s, const char      *p, size_t *l, CTYPE_FUNCTION d ) { return do_mbstcmp   ( s, p, l, d, 0 ) ; }

int strticmp_word   ( const char      *s, const char      *p, size_t *l, CTYPE_FUNCTION d ) { return do_strtcmp   ( s, p, l, d, 1 ) ; }
int wcsticmp_word   ( const wchar_t   *s, const wchar_t   *p, size_t *l, CTYPE_FUNCTION d ) { return do_wcstcmp   ( s, p, l, d, 1 ) ; }
int wcsticmp16_word ( const wchar16_t *s, const wchar16_t *p, size_t *l, CTYPE_FUNCTION d ) { return do_wcstcmp16 ( s, p, l, d, 1 ) ; }
int wcsticmp32_word ( const wchar32_t *s, const wchar32_t *p, size_t *l, CTYPE_FUNCTION d ) { return do_wcstcmp32 ( s, p, l, d, 1 ) ; }
int mbsticmp_word   ( const char      *s, const char      *p, size_t *l, CTYPE_FUNCTION d ) { return do_mbstcmp   ( s, p, l, d, 1 ) ; }



////////////////////////////////////////////
//               strchr ()                //
////////////////////////////////////////////



// iANSIŁj
//  char ƂĔr
static char *do_strchr ( const char *string, int c, int isignore, int islast ) {

   const char *result = NULL ;
   int width ;

   c = (unsigned char) c ;

   int u ;
   u = ( isignore ) ? toupper ( c ) : c ;
   c = ( isignore ) ? tolower ( c ) : c ;

   for ( ; ; string += width ) {

      int c1 = strtochar ( string, & width ) ;

      if ( c1 == c || c1 == u ) {
         result = string ;
         if ( ! islast ) break ;
      }

      if ( ! c1 ) break ;
   }

   return (char*) result ;
}



// iUNICODEŁj
//  wchar_t ƂĔr
static wchar_t *do_wcschr ( const wchar_t *string, int c, int isignore, int islast ) {

   const wchar_t *result = NULL ;
   int width ;

   c = (wchar_t) c ;

   int u ;
   u = ( isignore ) ? toupper ( c ) : c ;
   c = ( isignore ) ? tolower ( c ) : c ;

   for ( ; ; string += width ) {

      int c1 = wcstochar ( string, & width ) ;

      if ( c1 == c || c1 == u ) {
         result = string ;
         if ( ! islast ) break ;
      }

      if ( ! c1 ) break ;
   }

   return (wchar_t*) result ;
}



// iUTF16Łj
// c ̓TQ[głXJ[lł
static wchar16_t *do_wcschr16 ( const wchar16_t *string, int c, int isignore, int islast ) {

   const wchar16_t *result = NULL ;
   int width ;

   if ( (unsigned) c >> WORD_BIT && ! IsUnicodeHighSurrogate ( (unsigned) c >> WORD_BIT ) ) {
      if ( (unsigned) c > UTF16_MAX ) return NULL ;
      else                            c = ( MAKE_UNICODE_HIGH_SURROGATE ( c ) << WORD_BIT ) + MAKE_UNICODE_LOW_SURROGATE ( c ) ;
   }

   int u ;
   u = ( isignore ) ? toupper ( c ) : c ;
   c = ( isignore ) ? tolower ( c ) : c ;

   for ( ; ; string += width ) {

      int c1 = wcstochar16 ( string, & width ) ;

      if ( c1 == c || c1 == u ) {
         result = string ;
         if ( ! islast ) break ;
      }

      if ( ! c1 ) break ;
   }

   return (wchar16_t*) result ;
}



// iUTF32Łj
//  wchar32_t ƂĔr
static wchar32_t *do_wcschr32 ( const wchar32_t *string, int c, int isignore, int islast ) {

   const wchar32_t *result = NULL ;
   int width ;

   c = (wchar32_t) c ;

   int u ;
   u = ( isignore ) ? toupper ( c ) : c ;
   c = ( isignore ) ? tolower ( c ) : c ;

   for ( ; ; string += width ) {

      int c1 = wcstochar32 ( string, & width ) ;

      if ( c1 == c || c1 == u ) {
         result = string ;
         if ( ! islast ) break ;
      }

      if ( ! c1 ) break ;
   }

   return (wchar32_t*) result ;
}



// iMULTIBYTEŁj
// c ͂QoCgł
static char *do_mbschr ( const char *string, int c, int isignore, int islast ) {

   const char *result = NULL ;
   int width ;

   int u ;
   u = ( isignore ) ? toupper ( c ) : c ;
   c = ( isignore ) ? tolower ( c ) : c ;

   for ( ; ; string += width ) {

      int c1 = mbstochar ( string, & width ) ;

      if ( c1 == c || c1 == u ) {
         result = string ;
         if ( ! islast ) break ;
      }

      if ( ! c1 ) break ;
   }

   return (char*) result ;
}



// strchr  CRT
// wcschr  CRT
wchar16_t *wcschr16 ( const wchar16_t *s, int c ) { return do_wcschr16 ( s, c, 0, 0 ) ; }
wchar32_t *wcschr32 ( const wchar32_t *s, int c ) { return do_wcschr32 ( s, c, 0, 0 ) ; }
char      *mbschr   ( const char      *s, int c ) { return do_mbschr   ( s, c, 0, 0 ) ; }

char      *strchri   ( const char      *s, int c ) { return do_strchr   ( s, c, 1, 0 ) ; }
wchar_t   *wcschri   ( const wchar_t   *s, int c ) { return do_wcschr   ( s, c, 1, 0 ) ; }
wchar16_t *wcschri16 ( const wchar16_t *s, int c ) { return do_wcschr16 ( s, c, 1, 0 ) ; }
wchar32_t *wcschri32 ( const wchar32_t *s, int c ) { return do_wcschr32 ( s, c, 1, 0 ) ; }
char      *mbschri   ( const char      *s, int c ) { return do_mbschr   ( s, c, 1, 0 ) ; }

// strrchr  CRT
// wcsrchr  CRT
wchar16_t *wcsrchr16 ( const wchar16_t *s, int c ) { return do_wcschr16 ( s, c, 0, 1 ) ; }
wchar32_t *wcsrchr32 ( const wchar32_t *s, int c ) { return do_wcschr32 ( s, c, 0, 1 ) ; }
char      *mbsrchr   ( const char      *s, int c ) { return do_mbschr   ( s, c, 0, 1 ) ; }

char      *strrchri   ( const char      *s, int c ) { return do_strchr   ( s, c, 1, 1 ) ; }
wchar_t   *wcsrchri   ( const wchar_t   *s, int c ) { return do_wcschr   ( s, c, 1, 1 ) ; }
wchar16_t *wcsrchri16 ( const wchar16_t *s, int c ) { return do_wcschr16 ( s, c, 1, 1 ) ; }
wchar32_t *wcsrchri32 ( const wchar32_t *s, int c ) { return do_wcschr32 ( s, c, 1, 1 ) ; }
char      *mbsrchri   ( const char      *s, int c ) { return do_mbschr   ( s, c, 1, 1 ) ; }



////////////////////////////////////////////
//               strstr ()                //
////////////////////////////////////////////



// iANSIŁj
// delimiter w肵Ƃ́A񋫊ȆOアꂩ^łȂƂvƌȂ
// ̂߁AO pattern ̒ patlen w肷
static char *do_strstr ( const char *string, const char *pattern, size_t patlen, CTYPE_FUNCTION delimiter, int isignore, int islast ) {

   if ( ! patlen ) return (char*) string ;

   const char *result = NULL ;
   const char *prev = NULL ;

   int width ;

   int c = strtochar ( pattern, & width ) ;
   int u ;
   u = ( isignore ) ? toupper ( c ) : c ;
   c = ( isignore ) ? tolower ( c ) : c ;

   pattern += width ;
   patlen -= width ;

   while ( 1 ) {

      int c1 = strtochar ( string, & width ) ;

      if ( ! c1 ) break ;

      if ( ( c1 == c || c1 == u ) && ! do_strncmp ( string + width, pattern, patlen, isignore ) ) {
         if ( delimiter ) {
            int dummy ;
            int c2 = ( prev ) ? strtochar ( prev, & dummy ) : 0 ;
            int c3 = strtochar ( string + width + patlen, & dummy ) ;
            int c4 = strtochar_prev ( string + width + patlen, string + width, & dummy ) ;
            if ( ( ! c2 || ! delimiter ( c1 ) || ! delimiter ( c2 ) ) && ( ! c3 || ! delimiter ( c3 ) || ! delimiter ( c4 ) ) ) {
               result = string ;
               if ( ! islast ) break ;
            }
         }
         else {
            result = string ;
            if ( ! islast ) break ;
         }
      }

      prev = string ;
      string += width ;
   }

   return (char*) result ;
}



// iUNICODEŁj
// delimiter w肵Ƃ́A񋫊ȆOアꂩ^łȂƂvƌȂ
// ̂߁AO pattern ̒ patlen w肷
static wchar_t *do_wcsstr ( const wchar_t *string, const wchar_t *pattern, size_t patlen, CTYPE_FUNCTION delimiter, int isignore, int islast ) {

   if ( ! patlen ) return (wchar_t*) string ;

   const wchar_t *result = NULL ;
   const wchar_t *prev = NULL ;

   int width ;

   int c = wcstochar ( pattern, & width ) ;
   int u ;
   u = ( isignore ) ? toupper ( c ) : c ;
   c = ( isignore ) ? tolower ( c ) : c ;

   pattern += width ;
   patlen -= width ;

   while ( 1 ) {

      int c1 = wcstochar ( string, & width ) ;

      if ( ! c1 ) break ;

      if ( ( c1 == c || c1 == u ) && ! do_wcsncmp ( string + width, pattern, patlen, isignore ) ) {
         if ( delimiter ) {
            int dummy ;
            int c2 = ( prev ) ? wcstochar ( prev, & dummy ) : 0 ;
            int c3 = wcstochar ( string + width + patlen, & dummy ) ;
            int c4 = wcstochar_prev ( string + width + patlen, string + width, & dummy ) ;
            if ( ( ! c2 || ! delimiter ( c1 ) || ! delimiter ( c2 ) ) && ( ! c3 || ! delimiter ( c3 ) || ! delimiter ( c4 ) ) ) {
               result = string ;
               if ( ! islast ) break ;
            }
         }
         else {
            result = string ;
            if ( ! islast ) break ;
         }
      }

      prev = string ;
      string += width ;
   }

   return (wchar_t*) result ;
}



// iUTF32Łj
// delimiter w肵Ƃ́AO̕^̂Ƃ݈̂vƌȂ
// ̂߁AO pattern ̒ patlen w肷
static wchar32_t *do_wcsstr32 ( const wchar32_t *string, const wchar32_t *pattern, size_t patlen, CTYPE_FUNCTION delimiter, int isignore, int islast ) {

   if ( ! patlen ) return (wchar32_t*) string ;

   const wchar32_t *result = NULL ;
   const wchar32_t *prev = NULL ;

   int width ;

   int c = wcstochar32 ( pattern, & width ) ;
   int u ;
   u = ( isignore ) ? toupper ( c ) : c ;
   c = ( isignore ) ? tolower ( c ) : c ;

   pattern += width ;
   patlen -= width ;

   while ( 1 ) {

      int c1 = wcstochar32 ( string, & width ) ;

      if ( ! c1 ) break ;

      if ( ( c1 == c || c1 == u ) && ! do_wcsncmp32 ( string + width, pattern, patlen, isignore ) ) {
         if ( delimiter ) {
            int dummy ;
            int c2 = ( prev ) ? wcstochar32 ( prev, & dummy ) : 0 ;
            int c3 = wcstochar32 ( string + width + patlen, & dummy ) ;
            int c4 = wcstochar_prev32 ( string + width + patlen, string + width, & dummy ) ;
            if ( ( ! c2 || ! delimiter ( c1 ) || ! delimiter ( c2 ) ) && ( ! c3 || ! delimiter ( c3 ) || ! delimiter ( c4 ) ) ) {
               result = string ;
               if ( ! islast ) break ;
            }
         }
         else {
            result = string ;
            if ( ! islast ) break ;
         }
      }

      prev = string ;
      string += width ;
   }

   return (wchar32_t*) result ;
}



// iMULTIBYTEŁj
// delimiter w肵Ƃ́AO̕^̂Ƃ݈̂vƌȂ
// ̂߁AO pattern ̒ patlen w肷
static char *do_mbsstr ( const char *string, const char *pattern, size_t patlen, CTYPE_FUNCTION delimiter, int isignore, int islast ) {

   if ( ! patlen ) return (char*) string ;

   const char *result = NULL ;
   const char *prev = NULL ;

   int width ;

   int c = mbstochar ( pattern, & width ) ;
   int u ;
   u = ( isignore ) ? toupper ( c ) : c ;
   c = ( isignore ) ? tolower ( c ) : c ;

   pattern += width ;
   patlen -= width ;

   while ( 1 ) {

      int c1 = mbstochar ( string, & width ) ;

      if ( ! c1 ) break ;

      if ( ( c1 == c || c1 == u ) && ! do_mbsncmp ( string + width, pattern, patlen, isignore ) ) {
         if ( delimiter ) {
            int dummy ;
            int c2 = ( prev ) ? mbstochar ( prev, & dummy ) : 0 ;
            int c3 = mbstochar ( string + width + patlen, & dummy ) ;
            int c4 = mbstochar_prev ( string + width + patlen, string + width, & dummy ) ;
            if ( ( ! c2 || ! delimiter ( c1 ) || ! delimiter ( c2 ) ) && ( ! c3 || ! delimiter ( c3 ) || ! delimiter ( c4 ) ) ) {
               result = string ;
               if ( ! islast ) break ;
            }
         }
         else {
            result = string ;
            if ( ! islast ) break ;
         }
      }

      prev = string ;
      string += width ;
   }

   return (char*) result ;
}



// strstr  CRT
// wcsstr  CRT
wchar32_t *wcsstr32 ( const wchar32_t *s, const wchar32_t *p ) { return do_wcsstr32 ( s, p, wcslen32 ( p ), NULL, 0, 0 ) ; }
char      *mbsstr   ( const char      *s, const char      *p ) { return do_mbsstr   ( s, p, strlen   ( p ), NULL, 0, 0 ) ; }

char      *strstri   ( const char      *s, const char      *p ) { return do_strstr   ( s, p, strlen   ( p ), NULL, 1, 0 ) ; }
wchar_t   *wcsstri   ( const wchar_t   *s, const wchar_t   *p ) { return do_wcsstr   ( s, p, wcslen   ( p ), NULL, 1, 0 ) ; }
wchar32_t *wcsstri32 ( const wchar32_t *s, const wchar32_t *p ) { return do_wcsstr32 ( s, p, wcslen32 ( p ), NULL, 1, 0 ) ; }
char      *mbsstri   ( const char      *s, const char      *p ) { return do_mbsstr   ( s, p, strlen   ( p ), NULL, 1, 0 ) ; }

char      *strrstr   ( const char      *s, const char      *p ) { return do_strstr   ( s, p, strlen   ( p ), NULL, 0, 1 ) ; }
wchar_t   *wcsrstr   ( const wchar_t   *s, const wchar_t   *p ) { return do_wcsstr   ( s, p, wcslen   ( p ), NULL, 0, 1 ) ; }
wchar32_t *wcsrstr32 ( const wchar32_t *s, const wchar32_t *p ) { return do_wcsstr32 ( s, p, wcslen32 ( p ), NULL, 0, 1 ) ; }
char      *mbsrstr   ( const char      *s, const char      *p ) { return do_mbsstr   ( s, p, strlen   ( p ), NULL, 0, 1 ) ; }

char      *strrstri   ( const char      *s, const char      *p ) { return do_strstr   ( s, p, strlen   ( p ), NULL, 1, 1 ) ; }
wchar_t   *wcsrstri   ( const wchar_t   *s, const wchar_t   *p ) { return do_wcsstr   ( s, p, wcslen   ( p ), NULL, 1, 1 ) ; }
wchar32_t *wcsrstri32 ( const wchar32_t *s, const wchar32_t *p ) { return do_wcsstr32 ( s, p, wcslen32 ( p ), NULL, 1, 1 ) ; }
char      *mbsrstri   ( const char      *s, const char      *p ) { return do_mbsstr   ( s, p, strlen   ( p ), NULL, 1, 1 ) ; }

char      *strstr_word   ( const char      *s, const char      *p, CTYPE_FUNCTION d ) { return do_strstr   ( s, p, strlen   ( p ), d, 0, 0 ) ; }
wchar_t   *wcsstr_word   ( const wchar_t   *s, const wchar_t   *p, CTYPE_FUNCTION d ) { return do_wcsstr   ( s, p, wcslen   ( p ), d, 0, 0 ) ; }
wchar32_t *wcsstr32_word ( const wchar32_t *s, const wchar32_t *p, CTYPE_FUNCTION d ) { return do_wcsstr32 ( s, p, wcslen32 ( p ), d, 0, 0 ) ; }
char      *mbsstr_word   ( const char      *s, const char      *p, CTYPE_FUNCTION d ) { return do_mbsstr   ( s, p, strlen   ( p ), d, 0, 0 ) ; }

char      *strstri_word   ( const char      *s, const char      *p, CTYPE_FUNCTION  d ) { return do_strstr   ( s, p, strlen   ( p ), d, 1, 0 ) ; }
wchar_t   *wcsstri_word   ( const wchar_t   *s, const wchar_t   *p, CTYPE_FUNCTION  d ) { return do_wcsstr   ( s, p, wcslen   ( p ), d, 1, 0 ) ; }
wchar32_t *wcsstri32_word ( const wchar32_t *s, const wchar32_t *p, CTYPE_FUNCTION  d ) { return do_wcsstr32 ( s, p, wcslen32 ( p ), d, 1, 0 ) ; }
char      *mbsstri_word   ( const char      *s, const char      *p, CTYPE_FUNCTION  d ) { return do_mbsstr   ( s, p, strlen   ( p ), d, 1, 0 ) ; }

char      *strrstr_word   ( const char      *s, const char      *p, CTYPE_FUNCTION  d ) { return do_strstr   ( s, p, strlen   ( p ), d, 0, 1 ) ; }
wchar_t   *wcsrstr_word   ( const wchar_t   *s, const wchar_t   *p, CTYPE_FUNCTION  d ) { return do_wcsstr   ( s, p, wcslen   ( p ), d, 0, 1 ) ; }
wchar32_t *wcsrstr32_word ( const wchar32_t *s, const wchar32_t *p, CTYPE_FUNCTION  d ) { return do_wcsstr32 ( s, p, wcslen32 ( p ), d, 0, 1 ) ; }
char      *mbsrstr_word   ( const char      *s, const char      *p, CTYPE_FUNCTION  d ) { return do_mbsstr   ( s, p, strlen   ( p ), d, 0, 1 ) ; }

char      *strrstri_word   ( const char      *s, const char      *p, CTYPE_FUNCTION  d ) { return do_strstr   ( s, p, strlen   ( p ), d, 1, 1 ) ; }
wchar_t   *wcsrstri_word   ( const wchar_t   *s, const wchar_t   *p, CTYPE_FUNCTION  d ) { return do_wcsstr   ( s, p, wcslen   ( p ), d, 1, 1 ) ; }
wchar32_t *wcsrstri32_word ( const wchar32_t *s, const wchar32_t *p, CTYPE_FUNCTION  d ) { return do_wcsstr32 ( s, p, wcslen32 ( p ), d, 1, 1 ) ; }
char      *mbsrstri_word   ( const char      *s, const char      *p, CTYPE_FUNCTION  d ) { return do_mbsstr   ( s, p, strlen   ( p ), d, 1, 1 ) ; }



////////////////////////////////////////////
//               strcount ()              //
////////////////////////////////////////////



// ԂiANSIŁj
static size_t do_strcount ( const char *string, const char *pattern, CTYPE_FUNCTION delimiter, int isignore ) {

   size_t len = strlen ( pattern ) ;
   if ( ! len ) return 0 ;

   size_t n = 0 ;

   for ( ; ( string = do_strstr ( string, pattern, len, delimiter, isignore, 0 ) ) ; string += len ) n ++ ;

   return n ;
}



// ԂiUNICODEŁj
static size_t do_wcscount ( const wchar_t *string, const wchar_t *pattern, CTYPE_FUNCTION delimiter, int isignore ) {

   size_t len = wcslen ( pattern ) ;
   if ( ! len ) return 0 ;

   size_t n = 0 ;

   for ( ; ( string = do_wcsstr ( string, pattern, len, delimiter, isignore, 0 ) ) ; string += len ) n ++ ;

   return n ;
}



// ԂiUTF32Łj
static size_t do_wcscount32 ( const wchar32_t *string, const wchar32_t *pattern, CTYPE_FUNCTION delimiter, int isignore ) {

   size_t len = wcslen32 ( pattern ) ;
   if ( ! len ) return 0 ;

   size_t n = 0 ;

   for ( ; ( string = do_wcsstr32 ( string, pattern, len, delimiter, isignore, 0 ) ) ; string += len ) n ++ ;

   return n ;
}



// ԂiMULTIBYTEŁj
static size_t do_mbscount ( const char *string, const char *pattern, CTYPE_FUNCTION delimiter, int isignore ) {

   size_t len = strlen ( pattern ) ;
   if ( ! len ) return 0 ;

   size_t n = 0 ;

   for ( ; ( string = do_mbsstr ( string, pattern, len, delimiter, isignore, 0 ) ) ; string += len ) n ++ ;

   return n ;
}



size_t strcount   ( const char      *s, const char      *p ) { return do_strcount   ( s, p, NULL, 0 ) ; }
size_t wcscount   ( const wchar_t   *s, const wchar_t   *p ) { return do_wcscount   ( s, p, NULL, 0 ) ; }
size_t wcscount32 ( const wchar32_t *s, const wchar32_t *p ) { return do_wcscount32 ( s, p, NULL, 0 ) ; }
size_t mbscount   ( const char      *s, const char      *p ) { return do_mbscount   ( s, p, NULL, 0 ) ; }

size_t strcounti   ( const char      *s, const char      *p ) { return do_strcount   ( s, p, NULL, 1 ) ; }
size_t wcscounti   ( const wchar_t   *s, const wchar_t   *p ) { return do_wcscount   ( s, p, NULL, 1 ) ; }
size_t wcscounti32 ( const wchar32_t *s, const wchar32_t *p ) { return do_wcscount32 ( s, p, NULL, 1 ) ; }
size_t mbscounti   ( const char      *s, const char      *p ) { return do_mbscount   ( s, p, NULL, 1 ) ; }

size_t strcount_word   ( const char      *s, const char      *p, CTYPE_FUNCTION  d ) { return do_strcount   ( s, p, d, 0 ) ; }
size_t wcscount_word   ( const wchar_t   *s, const wchar_t   *p, CTYPE_FUNCTION  d ) { return do_wcscount   ( s, p, d, 0 ) ; }
size_t wcscount32_word ( const wchar32_t *s, const wchar32_t *p, CTYPE_FUNCTION  d ) { return do_wcscount32 ( s, p, d, 0 ) ; }
size_t mbscount_word   ( const char      *s, const char      *p, CTYPE_FUNCTION  d ) { return do_mbscount   ( s, p, d, 0 ) ; }

size_t strcounti_word   ( const char      *s, const char      *p, CTYPE_FUNCTION  d ) { return do_strcount   ( s, p, d, 1 ) ; }
size_t wcscounti_word   ( const wchar_t   *s, const wchar_t   *p, CTYPE_FUNCTION  d ) { return do_wcscount   ( s, p, d, 1 ) ; }
size_t wcscounti32_word ( const wchar32_t *s, const wchar32_t *p, CTYPE_FUNCTION  d ) { return do_wcscount32 ( s, p, d, 1 ) ; }
size_t mbscounti_word   ( const char      *s, const char      *p, CTYPE_FUNCTION  d ) { return do_mbscount   ( s, p, d, 1 ) ; }



////////////////////////////////////////////
//              strreplace ()             //
////////////////////////////////////////////



// uiANSIŁj
// max ɂ͒uső吔܂ SIZE_MAX w肷
// p_next ɂ͍Ōɒu̒̈ʒuۑiNULLłj
// us񐔂Ԃ
static size_t do_strreplace ( char *string, const char *pattern, const char *replace, char **p_next, size_t max, CTYPE_FUNCTION delimiter, int isignore ) {

   size_t patlen = strlen ( pattern ) ;
   if ( ! patlen ) return 0 ;

   size_t replen = strlen ( replace ) ;
   size_t count = 0 ;
   char *end = NULL ;

   for ( ; count < max ; count ++ ) {

      char *p = do_strstr ( string, pattern, patlen, delimiter, isignore, 0 ) ;
      if ( ! p ) break ;

      if ( replen != patlen ) {
         char *q = p + patlen ;
         if ( ! end ) end = strend ( q ) ;
         memmove ( p + replen, q, ( end - q + 1 ) * sizeof(char) ) ;
         end += ( replen - patlen ) ;
      }

      memmove ( p, replace, replen * sizeof(char) ) ;

      string = p + replen ;
   }

   if ( p_next ) *p_next = string ;

   return count ;
}



// uiUNICODEŁj
// max ɂ͒uső吔܂ SIZE_MAX w肷
// p_next ɂ͍Ōɒu̒̈ʒuۑiNULLłj
// us񐔂Ԃ
static size_t do_wcsreplace ( wchar_t *string, const wchar_t *pattern, const wchar_t *replace, wchar_t **p_next, size_t max, CTYPE_FUNCTION delimiter, int isignore ) {

   size_t patlen = wcslen ( pattern ) ;
   if ( ! patlen ) return 0 ;

   size_t replen = wcslen ( replace ) ;
   size_t count = 0 ;
   wchar_t *end = NULL ;

   for ( ; count < max ; count ++ ) {

      wchar_t *p = do_wcsstr ( string, pattern, patlen, delimiter, isignore, 0 ) ;
      if ( ! p ) break ;

      if ( replen != patlen ) {
         wchar_t *q = p + patlen ;
         if ( ! end ) end = wcsend ( q ) ;
         memmove ( p + replen, q, ( end - q + 1 ) * sizeof(wchar_t) ) ;
         end += ( replen - patlen ) ;
      }

      memmove ( p, replace, replen * sizeof(wchar_t) ) ;

      string = p + replen ;
   }

   if ( p_next ) *p_next = string ;

   return count ;
}



// uiUTF32Łj
// max ɂ͒uső吔܂ SIZE_MAX w肷
// p_next ɂ͍Ōɒu̒̈ʒuۑiNULLłj
// us񐔂Ԃ
static size_t do_wcsreplace32 ( wchar32_t *string, const wchar32_t *pattern, const wchar32_t *replace, wchar32_t **p_next, size_t max, CTYPE_FUNCTION delimiter, int isignore ) {

   size_t patlen = wcslen32 ( pattern ) ;
   if ( ! patlen ) return 0 ;

   size_t replen = wcslen32 ( replace ) ;
   size_t count = 0 ;
   wchar32_t *end = NULL ;

   for ( ; count < max ; count ++ ) {

      wchar32_t *p = do_wcsstr32 ( string, pattern, patlen, delimiter, isignore, 0 ) ;
      if ( ! p ) break ;

      if ( replen != patlen ) {
         wchar32_t *q = p + patlen ;
         if ( ! end ) end = wcsend32 ( q ) ;
         memmove ( p + replen, q, ( end - q + 1 ) * sizeof(wchar32_t) ) ;
         end += ( replen - patlen ) ;
      }

      memmove ( p, replace, replen * sizeof(wchar32_t) ) ;

      string = p + replen ;
   }

   if ( p_next ) *p_next = string ;

   return count ;
}



// uiMULTIBYTEŁj
// max ɂ͒uső吔܂ SIZE_MAX w肷
// p_next ɂ͍Ōɒu̒̈ʒuۑiNULLłj
// us񐔂Ԃ
static size_t do_mbsreplace ( char *string, const char *pattern, const char *replace, char **p_next, size_t max, CTYPE_FUNCTION delimiter, int isignore ) {

   size_t patlen = strlen ( pattern ) ;
   if ( ! patlen ) return 0 ;

   size_t replen = strlen ( replace ) ;
   size_t count = 0 ;
   char *end = NULL ;

   for ( ; count < max ; count ++ ) {

      char *p = do_mbsstr ( string, pattern, patlen, delimiter, isignore, 0 ) ;
      if ( ! p ) break ;

      if ( replen != patlen ) {
         char *q = p + patlen ;
         if ( ! end ) end = strend ( q ) ;
         memmove ( p + replen, q, ( end - q + 1 ) * sizeof(char) ) ;
         end += ( replen - patlen ) ;
      }

      memmove ( p, replace, replen * sizeof(char) ) ;

      string = p + replen ;
   }

   if ( p_next ) *p_next = string ;

   return count ;
}



size_t strreplace   ( char      *s, const char      *p, const char      *r, char      **n, size_t m ) { return do_strreplace   ( s, p, r, n, m, NULL, 0 ) ; }
size_t wcsreplace   ( wchar_t   *s, const wchar_t   *p, const wchar_t   *r, wchar_t   **n, size_t m ) { return do_wcsreplace   ( s, p, r, n, m, NULL, 0 ) ; }
size_t wcsreplace32 ( wchar32_t *s, const wchar32_t *p, const wchar32_t *r, wchar32_t **n, size_t m ) { return do_wcsreplace32 ( s, p, r, n, m, NULL, 0 ) ; }
size_t mbsreplace   ( char      *s, const char      *p, const char      *r, char      **n, size_t m ) { return do_mbsreplace   ( s, p, r, n, m, NULL, 0 ) ; }

size_t strreplacei   ( char      *s, const char      *p, const char      *r, char      **n, size_t m ) { return do_strreplace   ( s, p, r, n, m, NULL, 1 ) ; }
size_t wcsreplacei   ( wchar_t   *s, const wchar_t   *p, const wchar_t   *r, wchar_t   **n, size_t m ) { return do_wcsreplace   ( s, p, r, n, m, NULL, 1 ) ; }
size_t wcsreplacei32 ( wchar32_t *s, const wchar32_t *p, const wchar32_t *r, wchar32_t **n, size_t m ) { return do_wcsreplace32 ( s, p, r, n, m, NULL, 1 ) ; }
size_t mbsreplacei   ( char      *s, const char      *p, const char      *r, char      **n, size_t m ) { return do_mbsreplace   ( s, p, r, n, m, NULL, 1 ) ; }

size_t strreplace_word   ( char      *s, const char      *p, const char      *r, char      **n, size_t m, CTYPE_FUNCTION d ) { return do_strreplace   ( s, p, r, n, m, d, 0 ) ; }
size_t wcsreplace_word   ( wchar_t   *s, const wchar_t   *p, const wchar_t   *r, wchar_t   **n, size_t m, CTYPE_FUNCTION d ) { return do_wcsreplace   ( s, p, r, n, m, d, 0 ) ; }
size_t wcsreplace32_word ( wchar32_t *s, const wchar32_t *p, const wchar32_t *r, wchar32_t **n, size_t m, CTYPE_FUNCTION d ) { return do_wcsreplace32 ( s, p, r, n, m, d, 0 ) ; }
size_t mbsreplace_word   ( char      *s, const char      *p, const char      *r, char      **n, size_t m, CTYPE_FUNCTION d ) { return do_mbsreplace   ( s, p, r, n, m, d, 0 ) ; }

size_t strreplacei_word   ( char      *s, const char      *p, const char      *r, char      **n, size_t m, CTYPE_FUNCTION d ) { return do_strreplace   ( s, p, r, n, m, d, 1 ) ; }
size_t wcsreplacei_word   ( wchar_t   *s, const wchar_t   *p, const wchar_t   *r, wchar_t   **n, size_t m, CTYPE_FUNCTION d ) { return do_wcsreplace   ( s, p, r, n, m, d, 1 ) ; }
size_t wcsreplacei32_word ( wchar32_t *s, const wchar32_t *p, const wchar32_t *r, wchar32_t **n, size_t m, CTYPE_FUNCTION d ) { return do_wcsreplace32 ( s, p, r, n, m, d, 1 ) ; }
size_t mbsreplacei_word   ( char      *s, const char      *p, const char      *r, char      **n, size_t m, CTYPE_FUNCTION d ) { return do_mbsreplace   ( s, p, r, n, m, d, 1 ) ; }



////////////////////////////////////////////
//               strltrim ()              //
////////////////////////////////////////////



// 擪̃Xy[XE^u폜iANSIŁj
// s͕ۑ
// 폜 0 ȊOԂ
int strltrim ( char *string ) {

   int retvalue = 0 ;

   char *src = string ;
   char *dst = string ;

   while ( 1 ) {

      int width ;

      int c = strtochar ( src, & width ) ;

      if ( ! isspace ( c ) ) break ;

      if ( ! isblank ( c ) ) {
         *dst = c ;
         dst += width ;
         src += width ;
      }
      else {
         retvalue = 1 ;
         src += width ;
      }
   }

   if ( retvalue ) strmove ( dst, src ) ;

   return retvalue ;
}



// 擪̃Xy[XE^u폜iUNICODEŁj
// s͕ۑ
// 폜 0 ȊOԂ
int wcsltrim ( wchar_t *string ) {

   int retvalue = 0 ;

   wchar_t *src = string ;
   wchar_t *dst = string ;

   while ( 1 ) {

      int width ;

      int c = wcstochar ( src, & width ) ;

      if ( ! isspace ( c ) ) break ;

      if ( ! isblank ( c ) ) {
         *dst = c ;
         dst += width ;
         src += width ;
      }
      else {
         retvalue = 1 ;
         src += width ;
      }
   }

   if ( retvalue ) wcsmove ( dst, src ) ;

   return retvalue ;
}



////////////////////////////////////////////
//               strrtrim ()              //
////////////////////////////////////////////



// ̃Xy[XE^u폜iANSIŁj
// s͕ۑ
// 폜 0 ȊOԂ
int strrtrim ( char *string ) {

   char *end = string ;

   while ( 1 ) {

      int width ;

      int c = strtochar ( string, & width ) ;

      if ( ! c ) break ;

      if ( ! isspace ( c ) ) end = string + 1 ;

      string += width ;
   }

   return strltrim ( end ) ;
}



// ̃Xy[XE^u폜iUNICODEŁj
// s͕ۑ
// 폜 0 ȊOԂ
int wcsrtrim ( wchar_t *string ) {

   wchar_t *end = string ;

   while ( 1 ) {

      int width ;

      int c = wcstochar ( string, & width ) ;

      if ( ! c ) break ;

      if ( ! isspace ( c ) ) end = string + 1 ;

      string += width ;
   }

   return wcsltrim ( end ) ;
}



////////////////////////////////////////////
//               strtokex ()              //
////////////////////////////////////////////



// ؂蕶Ő؂蕪iANSIŁj
// ؂蕶 NULL ȂAPȏ̘A󔒂؂Ƃ
// ؂蕶w肵Aw肳ꂽ̂ꂩP̕؂Ƃ
// dpF
//   dpň͂܂ꂽ񒆂́u""v́u"vƂĔF
//   ȊÓu""v͒[̕ƂĔF
// ؂蕪Ԃ
// ̏I[ɒB NULL Ԃ
// p_next ɂ͎ɏׂʒuۑiNULLłj
// p_next ̏I[ɒBI[̃AhXۑ
char *strtokex ( char *string, char **p_next, const char *delimiter ) {

   if ( ! string ) {
      if ( p_next ) *p_next = string ;
      return NULL ;
   }

   if ( ! delimiter ) while ( isspace ( *string ) ) string ++ ;

   if ( ! *string ) {
      if ( p_next ) *p_next = string ;
      return NULL ;
   }

   char *src = string ;
   char *dst = string ;

   for ( int mode = 0 ; *src ; src ++ ) {
      if ( *src == '\"' ) {
         if ( mode && *( src + 1 ) == '\"' ) *dst ++ = *src ++ ;
         else                                mode = ! mode ;
         continue ;
      }
      if ( ! mode ) {
         if ( delimiter ) {
            if ( strchr ( delimiter, *src ) ) break ;
         }
         else {
            if ( isspace ( *src ) ) break ;
         }
      }
      *dst ++ = *src ;
   }

   if ( p_next ) {
      if ( *src ) *p_next = src + 1 ;
      else        *p_next = src ;
   }

   *dst = 0 ;

   return string ;
}



// ؂蕶Ő؂蕪iUNICODEŁj
// ؂蕶 NULL ȂAPȏ̘A󔒕P̋؂蕶Ƃ
// dpF
//   dpň͂܂ꂽ񒆂́u""v́u"vƂĔF
//   ȊÓu""v͒[̕ƂĔF
// ؂蕪Ԃ
// ̏I[ɒB NULL Ԃ
// p_next ɂ͎ɏׂʒuۑiNULLłj
// p_next ̏I[ɒBI[̃AhXۑ
wchar_t *wcstokex ( wchar_t *string, wchar_t **p_next, const wchar_t *delimiter ) {

   if ( ! string ) {
      if ( p_next ) *p_next = string ;
      return NULL ;
   }

   if ( ! delimiter ) while ( isspace ( *string ) ) string ++ ;

   if ( ! *string ) {
      if ( p_next ) *p_next = string ;
      return NULL ;
   }

   wchar_t *src = string ;
   wchar_t *dst = string ;

   for ( int mode = 0 ; *src ; src ++ ) {
      if ( *src == '\"' ) {
         if ( mode && *( src + 1 ) == '\"' ) *dst ++ = *src ++ ;
         else                                mode = ! mode ;
         continue ;
      }
      if ( ! mode ) {
         if ( delimiter ) {
            if ( wcschr ( delimiter, *src ) ) break ;
         }
         else {
            if ( isspace ( *src ) ) break ;
         }
      }
      *dst ++ = *src ;
   }

   if ( p_next ) {
      if ( *src ) *p_next = src + 1 ;
      else        *p_next = src ;
   }

   *dst = 0 ;

   return string ;
}



// ؂蕶Ő؂蕪iUTF32Łj
// ؂蕶 NULL ȂAPȏ̘A󔒕P̋؂蕶Ƃ
// dpF
//   dpň͂܂ꂽ񒆂́u""v́u"vƂĔF
//   ȊÓu""v͒[̕ƂĔF
// ؂蕪Ԃ
// ̏I[ɒB NULL Ԃ
// p_next ɂ͎ɏׂʒuۑiNULLłj
// p_next ̏I[ɒBI[̃AhXۑ
wchar32_t *wcstokex32 ( wchar32_t *string, wchar32_t **p_next, const wchar32_t *delimiter ) {

   if ( ! string ) {
      if ( p_next ) *p_next = string ;
      return NULL ;
   }

   if ( ! delimiter ) while ( isspace ( *string ) ) string ++ ;

   if ( ! *string ) {
      if ( p_next ) *p_next = string ;
      return NULL ;
   }

   wchar32_t *src = string ;
   wchar32_t *dst = string ;

   for ( int mode = 0 ; *src ; src ++ ) {
      if ( *src == '\"' ) {
         if ( mode && *( src + 1 ) == '\"' ) *dst ++ = *src ++ ;
         else                                mode = ! mode ;
         continue ;
      }
      if ( ! mode ) {
         if ( delimiter ) {
            if ( wcschr32 ( delimiter, *src ) ) break ;
         }
         else {
            if ( isspace ( *src ) ) break ;
         }
      }
      *dst ++ = *src ;
   }

   if ( p_next ) {
      if ( *src ) *p_next = src + 1 ;
      else        *p_next = src ;
   }

   *dst = 0 ;

   return string ;
}



////////////////////////////////////////////
//               strscan ()               //
////////////////////////////////////////////



// ɏ]񂩂當؂oiANSIŁj
//  0 As 0 ȊOԂ
//   ɂ͂P %s ܂߂邱
//    %% ́ÂP % ɑΉ
//    %s ܂ %% ȊO %  0 ȊOԂ
// 񂪏ƈvȂ 0 ȊOԂ
// ƈvAlen Ɏ̈ʒu܂ł̒ۑiNULLłj
int strscan ( const char *string, const char *format, char *buffer, size_t size, size_t *len ) {

   const char *start = string ;

   do {

      if ( *format == '%' ) {

         if ( *( format + 1 ) == 's' ) {

            for ( const char *end = start ; ; end += strnext ( end ) ) {

               if ( end >= start + size ) return 1 ;

               const char *p = format + 2 ;
               const char *s = end ;

               do {
                  if ( ! *p && ( ! *s || p > format + 2 ) ) {
                     strlcpy ( buffer, start, end - start + 1 ) ;
                     if ( len ) *len = s - string ;
                     return 0 ;
                  }
                  if ( *p == '%' ) {
                     if ( *( p + 1 ) == '%' ) p ++ ;
                     else                     return 1 ;
                  }
               } while ( *p ++ == *s ++ ) ;

               if ( ! *end ) return 1 ;
            }
         }

         if ( *( format + 1 ) == '%' ) format ++ ;
         else                          return 1 ;
      }

   } while ( *format && *format ++ == *start ++ ) ;

   return 1 ;
}



// ɏ]񂩂當؂oiUNICODEŁj
//  0 As 0 ȊOԂ
//   ɂ͂P %s ܂߂邱
//    %% ́ÂP % ɑΉ
//    %s ܂ %% ȊO %  0 ȊOԂ
// 񂪏ƈvȂ 0 ȊOԂ
// ƈvAlen Ɏ̈ʒu܂ł̒ۑiNULLłj
int wcsscan ( const wchar_t *string, const wchar_t *format, wchar_t *buffer, size_t size, size_t *len ) {

   const wchar_t *start = string ;

   do {

      if ( *format == '%' ) {

         if ( *( format + 1 ) == 's' ) {

            for ( const wchar_t *end = start ; ; end += wcsnext ( end ) ) {

               if ( end >= start + size ) return 1 ;

               const wchar_t *p = format + 2 ;
               const wchar_t *s = end ;

               do {
                  if ( ! *p && ( ! *s || p > format + 2 ) ) {
                     wcslcpy ( buffer, start, end - start + 1 ) ;
                     if ( len ) *len = s - string ;
                     return 0 ;
                  }
                  if ( *p == '%' ) {
                     if ( *( p + 1 ) == '%' ) p ++ ;
                     else                     return 1 ;
                  }
               } while ( *p ++ == *s ++ ) ;

               if ( ! *end ) return 1 ;
            }
         }

         if ( *( format + 1 ) == '%' ) format ++ ;
         else                          return 1 ;
      }

   } while ( *format && *format ++ == *start ++ ) ;

   return 1 ;
}



// ɏ]񂩂當؂oiUTF32Łj
//  0 As 0 ȊOԂ
//   ɂ͂P %s ܂߂邱
//    %% ́ÂP % ɑΉ
//    %s ܂ %% ȊO %  0 ȊOԂ
// 񂪏ƈvȂ 0 ȊOԂ
// ƈvAlen Ɏ̈ʒu܂ł̒ۑiNULLłj
int wcsscan ( const wchar32_t *string, const wchar32_t *format, wchar32_t *buffer, size_t size, size_t *len ) {

   const wchar32_t *start = string ;

   do {

      if ( *format == '%' ) {

         if ( *( format + 1 ) == 's' ) {

            for ( const wchar32_t *end = start ; ; end += wcsnext32 ( end ) ) {

               if ( end >= start + size ) return 1 ;

               const wchar32_t *p = format + 2 ;
               const wchar32_t *s = end ;

               do {
                  if ( ! *p && ( ! *s || p > format + 2 ) ) {
                     wcslcpy32 ( buffer, start, end - start + 1 ) ;
                     if ( len ) *len = s - string ;
                     return 0 ;
                  }
                  if ( *p == '%' ) {
                     if ( *( p + 1 ) == '%' ) p ++ ;
                     else                     return 1 ;
                  }
               } while ( *p ++ == *s ++ ) ;

               if ( ! *end ) return 1 ;
            }
         }

         if ( *( format + 1 ) == '%' ) format ++ ;
         else                          return 1 ;
      }

   } while ( *format && *format ++ == *start ++ ) ;

   return 1 ;
}



// ɏ]񂩂當؂oiMULTIBYTEŁj
//  0 As 0 ȊOԂ
//   ɂ͂P %s ܂߂邱
//    %% ́ÂP % ɑΉ
//    %s ܂ %% ȊO %  0 ȊOԂ
// 񂪏ƈvȂ 0 ȊOԂ
// ƈvAlen Ɏ̈ʒu܂ł̒ۑiNULLłj
int mbsscan ( const char *string, const char *format, char *buffer, size_t size, size_t *len ) {

   const char *start = string ;

   do {

      if ( *format == '%' ) {

         if ( *( format + 1 ) == 's' ) {

            for ( const char *end = start ; ; end += mbsnext ( end ) ) {

               if ( end >= start + size ) return 1 ;

               const char *p = format + 2 ;
               const char *s = end ;

               do {
                  if ( ! *p && ( ! *s || p > format + 2 ) ) {
                     strlcpy ( buffer, start, end - start + 1 ) ;
                     if ( len ) *len = s - string ;
                     return 0 ;
                  }
                  if ( *p == '%' ) {
                     if ( *( p + 1 ) == '%' ) p ++ ;
                     else                     return 1 ;
                  }
               } while ( *p ++ == *s ++ ) ;

               if ( ! *end ) return 1 ;
            }
         }

         if ( *( format + 1 ) == '%' ) format ++ ;
         else                          return 1 ;
      }

   } while ( *format && *format ++ == *start ++ ) ;

   return 1 ;
}



////////////////////////////////////////////
//           strduplen_expand ()          //
////////////////////////////////////////////



// w肵ĕ𕡐iUTF32Łj
//  SIZE_MAX ȂkI[ƌȂ
// string ̒ maxlen ȏȂ NULL Ԃ
// w肳ꂽ]Ɋmۂ
// s NULL Ԃ
wchar32_t *wcsduplen_expand32 ( const wchar32_t *string, size_t srclen, size_t maxlen, size_t addlen ) {

   if ( srclen == SIZE_MAX ) srclen = wcslen32 ( string ) ;
   if ( srclen >= maxlen ) return NULL ;

   wchar32_t *buffer = malloc_array ( wchar32_t, srclen + addlen + 1 ) ;
   if ( buffer ) {
      memmove ( buffer, string, srclen * sizeof(wchar32_t) ) ;
      buffer [ srclen ] = 0 ;
   }

   return buffer ;
}



wchar32_t *wcsduplen32     ( const wchar32_t *string, size_t srclen )                { return wcsduplen_expand32 ( string, srclen,   SIZE_MAX, 0 )      ; }
wchar32_t *wcsdup_expand32 ( const wchar32_t *string, size_t maxlen, size_t addlen ) { return wcsduplen_expand32 ( string, SIZE_MAX, maxlen,   addlen ) ; }
wchar32_t *wcsdup32        ( const wchar32_t *string )                               { return wcsduplen_expand32 ( string, SIZE_MAX, SIZE_MAX, 0 )      ; }



////////////////////////////////////////////
//                strspn ()               //
////////////////////////////////////////////



// keys ɑȂ string ōŏɏoʒuԂiUTF16Łj
// ȂΖԂ
size_t wcsspn16 ( const wchar16_t *string, const wchar16_t *keys ) {

   const wchar16_t *current ;
   int width ;

   for ( current = string ; ; current += width ) {

      int c = wcstochar16 ( current, & width ) ;
      if ( ! c ) break ;

      if ( ! wcschr16 ( keys, c ) ) break ;
   }

   return current - string ;
}



// keys ɑȂ string ōŏɏoʒuԂiUTF32Łj
// ȂΖԂ
size_t wcsspn32 ( const wchar32_t *string, const wchar32_t *keys ) {

   const wchar32_t *current ;
   int width ;

   for ( current = string ; ; current += width ) {

      int c = wcstochar32 ( current, & width ) ;
      if ( ! c ) break ;

      if ( ! wcschr32 ( keys, c ) ) break ;
   }

   return current - string ;
}



// keys ɑȂ string ōŏɏoʒuԂiMULTIBYTEŁj
// ȂΖԂ
size_t mbsspn ( const char *string, const char *keys ) {

   const char *current ;
   int width ;

   for ( current = string ; ; current += width ) {

      int c = mbstochar ( current, & width ) ;
      if ( ! c ) break ;

      if ( ! mbschr ( keys, c ) ) break ;
   }

   return current - string ;
}



////////////////////////////////////////////
//                strcspn ()              //
////////////////////////////////////////////



// keys ɑ string ōŏɏoʒuԂiUTF16Łj
// ȂΖԂ
size_t wcscspn16 ( const wchar16_t *string, const wchar16_t *keys ) {

   const wchar16_t *current ;
   int width ;

   for ( current = string ; ; current += width ) {

      int c = wcstochar16 ( current, & width ) ;
      if ( ! c ) break ;

      if ( wcschr16 ( keys, c ) ) break ;
   }

   return current - string ;
}



// keys ɑ string ōŏɏoʒuԂiUTF32Łj
// ȂΖԂ
size_t wcscspn32 ( const wchar32_t *string, const wchar32_t *keys ) {

   const wchar32_t *current ;
   int width ;

   for ( current = string ; ; current += width ) {

      int c = wcstochar32 ( current, & width ) ;
      if ( ! c ) break ;

      if ( wcschr32 ( keys, c ) ) break ;
   }

   return current - string ;
}



// keys ɑ string ōŏɏoʒuԂiMULTIBYTEŁj
// ȂΖԂ
size_t mbscspn ( const char *string, const char *keys ) {

   const char *current ;
   int width ;

   for ( current = string ; ; current += width ) {

      int c = mbstochar ( current, & width ) ;
      if ( ! c ) break ;

      if ( mbschr ( keys, c ) ) break ;
   }

   return current - string ;
}



////////////////////////////////////////////
//               strspnp ()               //
////////////////////////////////////////////



// keys ɑȂ string ōŏɏoʒuԂiANSIŁj
// Ȃ NULL Ԃ
char *strspnp ( const char *string, const char *keys ) {

   const char *result = string + strspn ( string, keys ) ;
   if ( *result ) return (char*) result ;

   return NULL ;
}



// keys ɑȂ string ōŏɏoʒuԂiUNICODEŁj
// Ȃ NULL Ԃ
wchar_t *wcsspnp ( const wchar_t *string, const wchar_t *keys ) {

   const wchar_t *result = string + wcsspn ( string, keys ) ;
   if ( *result ) return (wchar_t*) result ;

   return NULL ;
}



// keys ɑȂ string ōŏɏoʒuԂiUTF16Łj
// Ȃ NULL Ԃ
wchar16_t *wcsspnp16 ( const wchar16_t *string, const wchar16_t *keys ) {

   const wchar16_t *result = string + wcsspn16 ( string, keys ) ;
   if ( *result ) return (wchar16_t*) result ;

   return NULL ;
}



// keys ɑȂ string ōŏɏoʒuԂiUTF32Łj
// Ȃ NULL Ԃ
wchar32_t *wcsspnp32 ( const wchar32_t *string, const wchar32_t *keys ) {

   const wchar32_t *result = string + wcsspn32 ( string, keys ) ;
   if ( *result ) return (wchar32_t*) result ;

   return NULL ;
}



// keys ɑȂ string ōŏɏoʒuԂiMULTIBYTEŁj
// Ȃ NULL Ԃ
char *mbsspnp ( const char *string, const char *keys ) {

   const char *result = string + mbsspn ( string, keys ) ;
   if ( *result ) return (char*) result ;

   return NULL ;
}



////////////////////////////////////////////
//               strpbrk ()               //
////////////////////////////////////////////



// keys ɑ string ōŏɏoʒuԂiUTF16Łj
// Ȃ NULL Ԃ
wchar16_t *wcspbrk16 ( const wchar16_t *string, const wchar16_t *keys ) {

   const wchar16_t *result = string + wcscspn16 ( string, keys ) ;
   if ( *result ) return (wchar16_t*) result ;

   return NULL ;
}



// keys ɑ string ōŏɏoʒuԂiUTF32Łj
// Ȃ NULL Ԃ
wchar32_t *wcspbrk32 ( const wchar32_t *string, const wchar32_t *keys ) {

   const wchar32_t *result = string + wcscspn32 ( string, keys ) ;
   if ( *result ) return (wchar32_t*) result ;

   return NULL ;
}



// keys ɑ string ōŏɏoʒuԂiMULTIBYTEŁj
// Ȃ NULL Ԃ
char *mbspbrk ( const char *string, const char *keys ) {

   const char *result = string + mbscspn ( string, keys ) ;
   if ( *result ) return (char*) result ;

   return NULL ;
}



////////////////////////////////////////////
//               strlwr ()                //
////////////////////////////////////////////



// ɁiANSIŁj
char *strlwr ( char *string ) {

   int width ;

   for ( char *current = string ; ; current += width ) {

      int c = strtochar ( current, & width ) ;
      if ( ! c ) break ;

      *current = tolower ( c ) ;
   }

   return string ;
}



// ɁiUNICODEŁj
wchar_t *wcslwr ( wchar_t *string ) {

   int width ;

   for ( wchar_t *current = string ; ; current += width ) {

      int c = wcstochar ( current, & width ) ;
      if ( ! c ) break ;

      *current = tolower ( c ) ;
   }

   return string ;
}



// ɁiUTF32Łj
wchar32_t *wcslwr32 ( wchar32_t *string ) {

   int width ;

   for ( wchar32_t *current = string ; ; current += width ) {

      int c = wcstochar32 ( current, & width ) ;
      if ( ! c ) break ;

      *current = tolower ( c ) ;
   }

   return string ;
}



// ɁiMULTIBYTEŁj
char *mbslwr ( char *string ) {

   int width ;

   for ( char *current = string ; ; current += width ) {

      int c = mbstochar ( current, & width ) ;
      if ( ! c ) break ;

      if ( width == 1 ) *current = tolower ( c ) ;
   }

   return string ;
}



// ɁiUNICODEŁj
// U+00`U+FF ̕ɑΉ
wchar_t *wcslwrex ( wchar_t *string ) {

   int width ;

   for ( wchar_t *current = string ; ; current += width ) {

      int c = wcstochar ( current, & width ) ;
      if ( ! c ) break ;

      if ( IS_BETWEEN ( c, 0xC0, 0xDE ) && c != 0xD7 ) *current = c + ( 0xE0 - 0xC0 ) ;
      else                                             *current = tolower ( c ) ;
   }

   return string ;
}



////////////////////////////////////////////
//               strupr ()                //
////////////////////////////////////////////



// 啶ɁiANSIŁj
char *strupr ( char *string ) {

   int width ;

   for ( char *current = string ; ; current += width ) {

      int c = strtochar ( current, & width ) ;
      if ( ! c ) break ;

      *current = toupper ( c ) ;
   }

   return string ;
}



// 啶ɁiUNICODEŁj
wchar_t *wcsupr ( wchar_t *string ) {

   int width ;

   for ( wchar_t *current = string ; ; current += width ) {

      int c = wcstochar ( current, & width ) ;
      if ( ! c ) break ;

      *current = toupper ( c ) ;
   }

   return string ;
}



// 啶ɁiUTF32Łj
wchar32_t *wcsupr32 ( wchar32_t *string ) {

   int width ;

   for ( wchar32_t *current = string ; ; current += width ) {

      int c = wcstochar32 ( current, & width ) ;
      if ( ! c ) break ;

      *current = toupper ( c ) ;
   }

   return string ;
}



// 啶ɁiMULTIBYTEŁj
char *mbsupr ( char *string ) {

   int width ;

   for ( char *current = string ; ; current += width ) {

      int c = mbstochar ( current, & width ) ;
      if ( ! c ) break ;

      if ( width == 1 ) *current = tolower ( c ) ;
   }

   return string ;
}



// 啶ɁiUNICODEŁj
// U+00`U+FF ̕ɑΉ
wchar_t *wcsuprex ( wchar_t *string ) {

   int width ;

   for ( wchar_t *current = string ; ; current += width ) {

      int c = wcstochar ( current, & width ) ;
      if ( ! c ) break ;

      if ( IS_BETWEEN ( c, 0xE0, 0xFE ) && c != 0xF7 ) *current = c + ( 0xC0 - 0xE0 ) ;
      else                                             *current = tolower ( c ) ;
   }

   return string ;
}



////////////////////////////////////////////
//               strquote ()              //
////////////////////////////////////////////



// ̑Oʕň͂ށiANSIŁj
// ̖̃AhXԂ
char *strquote ( char *string, const char *left, const char *right ) {

   string = strinsert ( string, left, 0 ) ;

   return strinsert ( strend ( string ), right, 0 ) ;
}



// ̑Oʕň͂ށiUNICODEŁj
// ̖̃AhXԂ
wchar_t *wcsquote ( wchar_t *string, const wchar_t *left, const wchar_t *right ) {

   string = wcsinsert ( string, left, 0 ) ;

   return wcsinsert ( wcsend ( string ), right, 0 ) ;
}



// ̑Oʕň͂ށiUTF32Łj
// ̖̃AhXԂ
wchar32_t *wcsquote32 ( wchar32_t *string, const wchar32_t *left, const wchar32_t *right ) {

   string = wcsinsert32 ( string, left, 0 ) ;

   return wcsinsert32 ( wcsend32 ( string ), right, 0 ) ;
}



////////////////////////////////////////////
//               strrev ()                //
////////////////////////////////////////////



#define swap_inline_func(type)   static inline void swap_##type ( type *x, type *y ) { type t = *x ; *x = *y ; *y = t ; }
swap_inline_func(char)
swap_inline_func(wchar_t)
swap_inline_func(wchar32_t)



// t]iANSIŁj
char *strrev ( char *string ) {

   char *left = string ;
   char *right = strend ( string ) - 1 ;

   for ( ; left < right ; left ++, right -- ) swap_char ( left, right ) ;

   return string ;
}



// t]iUNICODEŁj
wchar_t *wcsrev ( wchar_t *string ) {

   wchar_t *left = string ;
   wchar_t *right = wcsend ( string ) - 1 ;

   for ( ; left < right ; left ++, right -- ) swap_wchar_t ( left, right ) ;

   return string ;
}



// t]iUTF16Łj
wchar16_t *wcsrev16 ( wchar16_t *string ) {

   int width ;

   for ( wchar16_t *current = string ; *current ; current += width ) {
      width = wcsnext16_e ( current ) ;
      if ( width == 0 ) {
         *current = 0 ;
         break ;
      }
      if ( width > 1 ) {
         wchar_t *left = current ;
         wchar_t *right = current + width - 1 ;
         for ( ; left < right ; left ++, right -- ) swap_wchar_t ( left, right ) ;
      }
   }

   return wcsrev ( string ) ;
}



// t]iUTF32Łj
wchar32_t *wcsrev32 ( wchar32_t *string ) {

   wchar32_t *left = string ;
   wchar32_t *right = wcsend32 ( string ) - 1 ;

   for ( ; left < right ; left ++, right -- ) swap_wchar32_t ( left, right ) ;

   return string ;
}



// t]iMULTIBYTEŁj
char *mbsrev ( char *string ) {

   int width ;

   for ( char *current = string ; *current ; current += width ) {
      width = mbsnext_e ( current ) ;
      if ( width == 0 ) {
         *current = 0 ;
         break ;
      }
      if ( width > 1 ) {
         char *left = current ;
         char *right = current + width - 1 ;
         for ( ; left < right ; left ++, right -- ) swap_char ( left, right ) ;
      }
   }

   return strrev ( string ) ;
}



////////////////////////////////////////////
//               strtrunc ()              //
////////////////////////////////////////////



// ZkiANSIŁj
// len ͍ő厚iI[k܂܂Ȃj
char *strtrunc ( char *string, size_t len ) {

   char *end = string + len ;
   const int width = 1 ;

   for ( char *current = string ; *current ; current += width ) {
      if ( current + width > end ) {
         *current = 0 ;
         break ;
      }
   }

   return string ;
}



// ZkiUNICODEŁj
// len ͍ő厚iI[k܂܂Ȃj
wchar_t *wcstrunc ( wchar_t *string, size_t len ) {

   wchar_t *end = string + len ;
   const int width = 1 ;

   for ( wchar_t *current = string ; *current ; current += width ) {
      if ( current + width > end ) {
         *current = 0 ;
         break ;
      }
   }

   return string ;
}



// ZkiUTF16Łj
// len ͍ő厚iI[k܂܂Ȃj
wchar16_t *wcstrunc16 ( wchar16_t *string, size_t len ) {

   wchar16_t *end = string + len ;
   int width ;

   for ( wchar16_t *current = string ; *current ; current += width ) {
      width = wcsnext16_e ( current ) ;
      if ( width == 0 ) {
         *current = 0 ;
         break ;
      }
      if ( current + width > end ) {
         *current = 0 ;
         break ;
      }
   }

   return string ;
}



// ZkiUTF32Łj
// len ͍ő厚iI[k܂܂Ȃj
wchar32_t *wcstrunc32 ( wchar32_t *string, size_t len ) {

   wchar32_t *end = string + len ;
   const int width = 1 ;

   for ( wchar32_t *current = string ; *current ; current += width ) {
      if ( current + width > end ) {
         *current = 0 ;
         break ;
      }
   }

   return string ;
}



// ZkiMULTIBYTEŁj
// len ͍ő厚iI[k܂܂Ȃj
char *mbstrunc ( char *string, size_t len ) {

   char *end = string + len ;
   int width ;

   for ( char *current = string ; *current ; current += width ) {
      width = mbsnext_e ( current ) ;
      if ( width == 0 ) {
         *current = 0 ;
         break ;
      }
      if ( current + width > end ) {
         *current = 0 ;
         break ;
      }
   }

   return string ;
}



////////////////////////////////////////////
//                strlen ()               //
////////////////////////////////////////////



// ԂiUTF16Łj
// TQ[gyA͂PƂĐ
size_t wcslen16 ( const wchar16_t *string ) {

   size_t n = 0 ;

   for ( ; *string ; string += wcsnext16 ( string ) ) n ++ ;

   return n ;
}



// ԂiUTF32Łj
size_t wcslen32 ( const wchar32_t *string ) {

   size_t n = 0 ;

   for ( ; *string ; string += wcsnext32 ( string ) ) n ++ ;

   return n ;
}



// ԂiMULTIBYTEŁj
// QoCg͂PƂĐ
size_t mbslen ( const char *string ) {

   size_t n = 0 ;

   for ( ; *string ; string += mbsnext ( string ) ) n ++ ;

   return n ;
}



////////////////////////////////////////////
//             strspn_type ()             //
////////////////////////////////////////////



// w肳ꂽł͂ȂŏɌʒuԂiANSIŁj
// ȂƂ͕̏I[Ԃ
size_t strspn_type ( const char *string, CTYPE_FUNCTION istype ) {

   const char *start = string ;

   int width ;

   for ( ; ; string += width ) {

      int c = strtochar ( string, & width ) ;
      if ( ! c ) break ;

      if ( ! istype ( c ) ) break ;
   }

   return string - start ;
}



// w肳ꂽł͂ȂŏɌʒuԂiUNICODEŁj
// ȂƂ͕̏I[Ԃ
size_t wcsspn_type ( const wchar_t *string, CTYPE_FUNCTION istype ) {

   const wchar_t *start = string ;

   int width ;

   for ( ; ; string += width ) {

      int c = wcstochar ( string, & width ) ;
      if ( ! c ) break ;

      if ( ! istype ( c ) ) break ;
   }

   return string - start ;
}



// w肳ꂽł͂ȂŏɌʒuԂiUTF16Łj
// ȂƂ͕̏I[Ԃ
size_t wcsspn16_type ( const wchar16_t *string, CTYPE_FUNCTION istype ) {

   const wchar16_t *start = string ;

   int width ;

   for ( ; ; string += width ) {

      int c = wcstochar16 ( string, & width ) ;
      if ( ! c ) break ;

      if ( ! istype ( c ) ) break ;
   }

   return string - start ;
}



// w肳ꂽł͂ȂŏɌʒuԂiUTF32Łj
// ȂƂ͕̏I[Ԃ
size_t wcsspn32_type ( const wchar32_t *string, CTYPE_FUNCTION istype ) {

   const wchar32_t *start = string ;

   int width ;

   for ( ; ; string += width ) {

      int c = wcstochar32 ( string, & width ) ;
      if ( ! c ) break ;

      if ( ! istype ( c ) ) break ;
   }

   return string - start ;
}



// w肳ꂽł͂ȂŏɌʒuԂiMULTIBYTEŁj
// ȂƂ͕̏I[Ԃ
size_t mbsspn_type ( const char *string, CTYPE_FUNCTION istype ) {

   const char *start = string ;

   int width ;

   for ( ; ; string += width ) {

      int c = mbstochar ( string, & width ) ;
      if ( ! c ) break ;

      if ( ! istype ( c ) ) break ;
   }

   return string - start ;
}



////////////////////////////////////////////
//             strspnp_type ()            //
////////////////////////////////////////////



// w肳ꂽł͂ȂŏɌʒuԂiANSIŁj
// ȂƂ NULL Ԃ
char *strspnp_type ( const char *string, CTYPE_FUNCTION istype ) {

   const char *result = string + strspn_type ( string, istype ) ;
   if ( *result ) return (char*) result ;

   return NULL ;
}



// w肳ꂽł͂ȂŏɌʒuԂiUNICODEŁj
// ȂƂ NULL Ԃ
wchar_t *wcsspnp_type ( const wchar_t *string, CTYPE_FUNCTION istype ) {

   const wchar_t *result = string + wcsspn_type ( string, istype ) ;
   if ( *result ) return (wchar_t*) result ;

   return NULL ;
}



// w肳ꂽł͂ȂŏɌʒuԂiUTF16Łj
// ȂƂ NULL Ԃ
wchar16_t *wcsspnp16_type ( const wchar16_t *string, CTYPE_FUNCTION istype ) {

   const wchar16_t *result = string + wcsspn16_type ( string, istype ) ;
   if ( *result ) return (wchar16_t*) result ;

   return NULL ;
}



// w肳ꂽł͂ȂŏɌʒuԂiUTF32Łj
// ȂƂ NULL Ԃ
wchar32_t *wcsspnp32_type ( const wchar32_t *string, CTYPE_FUNCTION istype ) {

   const wchar32_t *result = string + wcsspn32_type ( string, istype ) ;
   if ( *result ) return (wchar32_t*) result ;

   return NULL ;
}



// w肳ꂽł͂ȂŏɌʒuԂiMULTIBYTEŁj
// ȂƂ NULL Ԃ
char *mbsspnp_type ( const char *string, CTYPE_FUNCTION istype ) {

   const char *result = string + mbsspn_type ( string, istype ) ;
   if ( *result ) return (char*) result ;

   return NULL ;
}



////////////////////////////////////////////
//              isstrtype ()              //
////////////////////////////////////////////



// 񂪎w肳ꂽ킾ō\Ă邩ԂiANSIŁj
int isstrtype ( const char *string, CTYPE_FUNCTION istype ) {
   if ( strspnp_type ( string, istype ) ) return 0 ;
   else                                   return 1 ;
}



// 񂪎w肳ꂽ킾ō\Ă邩ԂiUNICODEŁj
int iswcstype ( const wchar_t *string, CTYPE_FUNCTION istype ) {
   if ( wcsspnp_type ( string, istype ) ) return 0 ;
   else                                   return 1 ;
}



// 񂪎w肳ꂽ킾ō\Ă邩ԂiUTF16Łj
int iswcstype16 ( const wchar16_t *string, CTYPE_FUNCTION istype ) {
   if ( wcsspnp16_type ( string, istype ) ) return 0 ;
   else                                     return 1 ;
}



// 񂪎w肳ꂽ킾ō\Ă邩ԂiUTF32Łj
int iswcstype32 ( const wchar32_t *string, CTYPE_FUNCTION istype ) {
   if ( wcsspnp32_type ( string, istype ) ) return 0 ;
   else                                     return 1 ;
}



// 񂪎w肳ꂽ킾ō\Ă邩ԂiMULTIBYTEŁj
int ismbstype ( const char *string, CTYPE_FUNCTION istype ) {
   if ( mbsspnp_type ( string, istype ) ) return 0 ;
   else                                   return 1 ;
}



////////////////////////////////////////////
//               mbsbtype ()              //
////////////////////////////////////////////



// }`oCg𔻒
int mbsbtype ( const char *string, size_t count ) {

   int isprevlead = 0 ;

   for ( const char *current = string ; *current ; current ++ ) {

      if ( size_t ( current - string ) == count ) {
         if ( isprevlead ) {
            if ( ismbbtrail ( (unsigned char) *current ) ) return _MBC_TRAIL ;
            else                                           return _MBC_ILLEGAL ;
         }
         else {
            if ( ismbblead ( (unsigned char) *current ) ) return _MBC_LEAD ;
            else if ( *current )                          return _MBC_SINGLE ;
            else                                          return _MBC_ILLEGAL ;
         }
      }

      if ( ! isprevlead && ismbblead ( (unsigned char) *current ) ) isprevlead = 1 ;
      else                                                          isprevlead = 0 ;
   }

   return _MBC_ILLEGAL ;
}



// }`oCg𔻒
int ismbslead ( const char *string, const char *current ) {
   if ( mbsbtype ( string, current - string ) == _MBC_LEAD ) return -1 ;
   return 0 ;
}



// }`oCg𔻒
int ismbstrail ( const char *string, const char *current ) {
   if ( mbsbtype ( string, current - string ) == _MBC_TRAIL ) return -1 ;
   return 0 ;
}



////////////////////////////////////////////
//            ėpʊ֐            //
////////////////////////////////////////////



int IS_CTYPE_ASCII  ( int c ) { return isascii  ( c ) ; }
int IS_CTYPE_ALPHA  ( int c ) { return isalpha  ( c ) ; }
int IS_CTYPE_UPPER  ( int c ) { return isupper  ( c ) ; }
int IS_CTYPE_LOWER  ( int c ) { return islower  ( c ) ; }
int IS_CTYPE_DIGIT  ( int c ) { return isdigit  ( c ) ; }
int IS_CTYPE_XDIGIT ( int c ) { return isxdigit ( c ) ; }
int IS_CTYPE_SPACE  ( int c ) { return isspace  ( c ) ; }
int IS_CTYPE_PUNCT  ( int c ) { return ispunct  ( c ) ; }
int IS_CTYPE_ALNUM  ( int c ) { return isalnum  ( c ) ; }
int IS_CTYPE_PRINT  ( int c ) { return isprint  ( c ) ; }
int IS_CTYPE_GRAPH  ( int c ) { return isgraph  ( c ) ; }
int IS_CTYPE_CNTRL  ( int c ) { return iscntrl  ( c ) ; }
int IS_CTYPE_BLANK  ( int c ) { return isblank  ( c ) ; }
int IS_CTYPE_CSYM   ( int c ) { return iscsym   ( c ) ; }

int IS_CTYPE_NO_ASCII  ( int c ) { return ! isascii  ( c ) ; }
int IS_CTYPE_NO_ALPHA  ( int c ) { return ! isalpha  ( c ) ; }
int IS_CTYPE_NO_UPPER  ( int c ) { return ! isupper  ( c ) ; }
int IS_CTYPE_NO_LOWER  ( int c ) { return ! islower  ( c ) ; }
int IS_CTYPE_NO_DIGIT  ( int c ) { return ! isdigit  ( c ) ; }
int IS_CTYPE_NO_XDIGIT ( int c ) { return ! isxdigit ( c ) ; }
int IS_CTYPE_NO_SPACE  ( int c ) { return ! isspace  ( c ) ; }
int IS_CTYPE_NO_PUNCT  ( int c ) { return ! ispunct  ( c ) ; }
int IS_CTYPE_NO_ALNUM  ( int c ) { return ! isalnum  ( c ) ; }
int IS_CTYPE_NO_PRINT  ( int c ) { return ! isprint  ( c ) ; }
int IS_CTYPE_NO_GRAPH  ( int c ) { return ! isgraph  ( c ) ; }
int IS_CTYPE_NO_CNTRL  ( int c ) { return ! iscntrl  ( c ) ; }
int IS_CTYPE_NO_BLANK  ( int c ) { return ! isblank  ( c ) ; }
int IS_CTYPE_NO_CSYM   ( int c ) { return ! iscsym   ( c ) ; }



