// storestr.cpp

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "msc.h"
#include "storestr.h"



#define DEBUG_STORESTR  0
static int DebugMemoryA ( void *szNewBuffer, size_t nNewBufferSize, void *szOldBuffer, size_t nOldBufferSize, const char *szString ) ;
static int DebugMemoryW ( void *szNewBuffer, size_t nNewBufferSize, void *szOldBuffer, size_t nOldBufferSize, const wchar_t *szString ) ;


// obt@̏TCY
#define INIT_BUFFER_SIZE   KILOBYTE

// obt@̃TCY̐Lij
// (0)    0x400
// (1)   0x1000
// (2)   0x4000
// (3)  0x10000
// (4)  0x40000
// (5) 0x100000
// ȍ~ 0x100000 ƂɑĂ



// qsort ()
typedef int ( __cdecl *QSORT_COMPARE_FUNCTION ) ( const void *, const void * ) ;



////////////////////////////////////////////
//                 ANSI                 //
////////////////////////////////////////////



// STOREDSTRINGS \
struct STOREDSTRINGSA_TAG {
   char  *szBuffer ;       // obt@̐擪AhX
   char  *szWrite ;        // obt@̏ݗp̃AhX
   char  *szRead ;         // obt@̓ǂݏop̃AhX
   size_t   nBufferSize ;     // mۂobt@̒
   size_t   nWriteCount ;     // vf̌
   size_t   nReadCount ;      // ǂݏo
} ;



// obt@ɂ߂iANSIŁj
// [̓̕obt@Ɋi[A0 ȊOԂ
// sAobt@NA STOREDSTRINGS_ERROR i[āA0 ȊOԂ
//  0 Ԃ
// obt@܂ŁAǉ邱Ƃł
int StoreStringA ( STOREDSTRINGSA **pStoredStrings, const char *szString ) {

   if ( ! szString || ! pStoredStrings || *pStoredStrings == STOREDSTRINGS_ERROR ) return 1 ;

   size_t nStringLen = strlen ( szString ) ;
   if ( ! nStringLen ) return 1 ;

   STOREDSTRINGSA *StoredStrings = *pStoredStrings ;

   if ( ! StoredStrings ) {
      StoredStrings = malloc_array ( STOREDSTRINGSA, 1 ) ;
      if ( ! StoredStrings ) {
         *pStoredStrings = (STOREDSTRINGSA*) STOREDSTRINGS_ERROR ;
         return 1 ;
      }
      static const STOREDSTRINGSA STOREDSTRINGS_ZERO = { 0 } ;
      *StoredStrings = STOREDSTRINGS_ZERO ;
   }

   size_t nRequiredBufferSize = StoredStrings->szWrite - StoredStrings->szBuffer + nStringLen + 2 ;

   // obt@g
   if ( StoredStrings->nBufferSize < nRequiredBufferSize ) {

      size_t nBufferSize = StoredStrings->nBufferSize ;
      do {
         if ( ! nBufferSize )               nBufferSize = INIT_BUFFER_SIZE ;
         else if ( nBufferSize < MEGABYTE ) nBufferSize = nBufferSize * 4 ;
         else                               nBufferSize = nBufferSize + MEGABYTE ;
      } while ( nBufferSize < nRequiredBufferSize ) ;

      char *szBuffer = realloc_array ( StoredStrings->szBuffer, char, nBufferSize ) ;

      if ( ! szBuffer ) {
         FreeStoredStringsA ( & StoredStrings ) ;
         *pStoredStrings = (STOREDSTRINGSA*) STOREDSTRINGS_ERROR ;
         return 1 ;
      }

      if ( DEBUG_STORESTR ) DebugMemoryA ( szBuffer, nBufferSize, StoredStrings->szBuffer, StoredStrings->nBufferSize, szString ) ;

      StoredStrings->szWrite += szBuffer - StoredStrings->szBuffer ;
      StoredStrings->szRead += szBuffer - StoredStrings->szBuffer ;
      StoredStrings->szBuffer = szBuffer ;
      StoredStrings->nBufferSize = nBufferSize ;
   }

   // i[
   strcpy ( StoredStrings->szWrite, szString ) ;
   StoredStrings->szWrite += nStringLen + 1 ;
   *( StoredStrings->szWrite ) = 0 ;
   StoredStrings->nWriteCount ++ ;

   *pStoredStrings = StoredStrings ;

   return 0 ;
}



// obt@
void FreeStoredStringsA ( STOREDSTRINGSA **pStoredStrings ) {

   if ( ! pStoredStrings ) return ;

   if ( ! *pStoredStrings || *pStoredStrings == STOREDSTRINGS_ERROR ) {
      *pStoredStrings = NULL ;
      return ;
   }

   STOREDSTRINGSA *StoredStrings = *pStoredStrings ;

   if ( DEBUG_STORESTR ) DebugMemoryA ( StoredStrings->szBuffer, StoredStrings->nBufferSize, NULL, 0, NULL ) ;

   free ( StoredStrings->szBuffer ) ;
   free ( StoredStrings ) ;

   *pStoredStrings = NULL ;
}



// obt@ŏ̕ԂiANSIŁj
// 񂪂Ȃ΁ANULL Ԃ
const char *GetFirstStringA ( STOREDSTRINGSA *StoredStrings ) {

   if ( ! StoredStrings || StoredStrings == STOREDSTRINGS_ERROR ) return NULL ;

   StoredStrings->nReadCount = 0 ;

   return StoredStrings->szRead = StoredStrings->szBuffer ;
}



// obt@玟̕ԂiANSIŁj
// 񂪂Ȃ΁ANULL Ԃ
// GetFirstString () ĂяoOȂA͕s
const char *GetNextStringA ( STOREDSTRINGSA *StoredStrings ) {

   if ( ! StoredStrings || StoredStrings == STOREDSTRINGS_ERROR ) return NULL ;

   if ( ! *StoredStrings->szRead ) return NULL ;

   StoredStrings->nReadCount ++ ;

   StoredStrings->szRead = strend ( StoredStrings->szRead ) + 1 ;
   if ( ! *StoredStrings->szRead ) return NULL ;

   return StoredStrings->szRead ;
}



// obt@̌̕ԂiANSIŁj
size_t GetStringsCountA ( const STOREDSTRINGSA *StoredStrings ) {

   if ( ! StoredStrings || StoredStrings == STOREDSTRINGS_ERROR ) return 0 ;

   return StoredStrings->nWriteCount ;
}



// ʂ̃obt@𕶎ǉiANSIŁj
// ʂ̃obt@͎IɉȂ
// sAobt@NA STOREDSTRINGS_ERROR i[āA0 ȊOԂ
int MergeStoredStringsA ( STOREDSTRINGSA **pStoredStrings, const STOREDSTRINGSA *StoredStringsToAdd ) {

   if ( ! StoredStringsToAdd ) return 0 ;
   if ( StoredStringsToAdd == STOREDSTRINGS_ERROR ) return 1 ;

   for ( const char *szString = StoredStringsToAdd->szBuffer ; *szString ; szString = strend ( szString ) + 1 ) {
      if ( StoreStringA ( pStoredStrings, szString ) ) break ;
   }

   return 0 ;
}



// obt@̈ʒuۑiANSIŁj
int GetStringPositionA ( const STOREDSTRINGSA *StoredStrings, STOREDSTRINGS_POSITION *Position, int IsReadingPosition ) {

   if ( ! Position || StoredStrings == STOREDSTRINGS_ERROR ) return 1 ;

   if ( ! StoredStrings ) {
      Position->nOffset = 0 ;
      Position->nCount = 0 ;
   }
   else if ( IsReadingPosition ) {
      Position->nOffset = StoredStrings->szRead - StoredStrings->szBuffer ;
      Position->nCount = StoredStrings->nReadCount ;
   }
   else {
      Position->nOffset = StoredStrings->szWrite - StoredStrings->szBuffer ;
      Position->nCount = StoredStrings->nWriteCount ;
   }

   return 0 ;
}



static int __cdecl CompareStoredStringsCrtA ( const char **pArg1, const char **pArg2 ) ;
static int __cdecl CompareStoredStringsSystemA ( const char **pArg1, const char **pArg2 ) ;
static int __cdecl CompareStoredStringsNumericalA ( const char **pArg1, const char **pArg2 ) ;



// obt@̕\[giANSIŁj
// CompareFuntion  NULL ̏ꍇ́AdwMode Ŏw肳ꂽr֐gp
// Start  End Ŏw肳ꂽԂ̂݃\[giNULLłj
int SortStoredStringsA ( const STOREDSTRINGSA *StoredStrings, const STOREDSTRINGS_POSITION *Start, const STOREDSTRINGS_POSITION *End, int ( __cdecl *CompareFunction ) ( const char **, const char ** ), unsigned long dwMode ) {

   if ( ! StoredStrings ) return 0 ;
   if ( StoredStrings == STOREDSTRINGS_ERROR ) return 1 ;

   if ( Start ) {
      if ( Start->nOffset > (size_t) ( StoredStrings->szWrite - StoredStrings->szBuffer ) ) return 1 ;
      if ( Start->nCount > StoredStrings->nWriteCount ) return 1 ;
   }
   if ( End ) {
      if ( End->nCount > StoredStrings->nWriteCount ) return 1 ;
      if ( Start && End->nCount < Start->nCount ) return 1 ;
   }

   size_t nItem = ( ( End ) ? End->nCount : StoredStrings->nWriteCount ) - ( ( Start ) ? Start->nCount : 0 ) ;
   if ( nItem <= 1 ) return 0 ;

   int nResult = 1 ;

   const char **pPointerToString = malloc_array ( const char*, nItem ) ;
   if ( pPointerToString ) {

      char *szSrc = StoredStrings->szBuffer + ( ( Start ) ? Start->nOffset : 0 ) ;

      const char *szSrcEnd = szSrc ;
      for ( size_t nCount = 0 ; nCount < nItem ; nCount ++ ) {
         pPointerToString [ nCount ] = szSrcEnd ;
         szSrcEnd = strend ( szSrcEnd ) + 1 ;
      }
      size_t nBufferSize = szSrcEnd - szSrc ;

      if ( ! CompareFunction ) {
         if      ( dwMode & STORESTR_SORT_NUMERICAL ) CompareFunction = CompareStoredStringsNumericalA ;
         else if ( dwMode & STORESTR_SORT_SYSTEM )    CompareFunction = CompareStoredStringsSystemA ;
         else                                         CompareFunction = CompareStoredStringsCrtA ;
      }

      qsort ( pPointerToString, nItem, sizeof(char*), (QSORT_COMPARE_FUNCTION) CompareFunction ) ;

      char *szDst = malloc_array ( char, nBufferSize ) ;
      if ( szDst ) {

         char *szDstEnd = szDst ;
         for ( size_t nCount = 0 ; nCount < nItem ; nCount ++ ) {
            if ( dwMode & STORESTR_SORT_REVERSE ) strcpy ( szDstEnd, pPointerToString [ nItem - nCount - 1 ] ) ;
            else                                  strcpy ( szDstEnd, pPointerToString [ nCount ] ) ;
            szDstEnd = strend ( szDstEnd ) + 1 ;
         }

         memmove ( szSrc, szDst, nBufferSize * sizeof(char) ) ;
         free ( szDst ) ;

         nResult = 0 ;
      }

      free ( pPointerToString ) ;
   }

   return nResult ;
}



static int CallCompareStringOrdinalA ( const char *szSrc, int nSrc, const char *szDst, int nDst, int IsIgnoreCase ) ;



// obt@̕iANSIŁj
// ̃CfbNX pIndex Ɋi[iNULLłj
// 當As NULL Ԃ
const char *FindStoredStringA ( const STOREDSTRINGSA *StoredStrings, const char *szPattern, size_t *pIndex, unsigned long dwMode ) {

   if ( ! StoredStrings || StoredStrings == STOREDSTRINGS_ERROR ) return NULL ;
   if ( ! szPattern ) return NULL ;

   size_t nCount = 0 ;

   for ( char *szString = StoredStrings->szBuffer ; *szString ; szString = strend ( szString ) + 1, nCount ++ ) {

      int nResult ;
      if ( dwMode & STORESTR_CMP_IGNORECASE ) nResult = CallCompareStringOrdinalA ( szString, -1, szPattern, -1, 1 ) ;
      else                                    nResult = strcmp ( szString, szPattern ) ;

      if ( ! nResult ) {
         if ( pIndex ) *pIndex = nCount ;
         return szString ;
      }
   }

   return NULL ;
}



////////////////////////////////////////////
//               UNICODE                //
////////////////////////////////////////////



// STOREDSTRINGS \
struct STOREDSTRINGSW_TAG {
   wchar_t  *szBuffer ;       // obt@̐擪AhX
   wchar_t  *szWrite ;        // obt@̏ݗp̃AhX
   wchar_t  *szRead ;         // obt@̓ǂݏop̃AhX
   size_t   nBufferSize ;     // mۂobt@̒
   size_t   nWriteCount ;     // vf̌
   size_t   nReadCount ;      // ǂݏo
} ;



// obt@ɂ߂iUNICODEŁj
// [̓̕obt@Ɋi[A0 ȊOԂ
// sAobt@NA STOREDSTRINGS_ERROR i[āA0 ȊOԂ
//  0 Ԃ
// obt@܂ŁAǉ邱Ƃł
int StoreStringW ( STOREDSTRINGSW **pStoredStrings, const wchar_t *szString ) {

   if ( ! szString || ! pStoredStrings || *pStoredStrings == STOREDSTRINGS_ERROR ) return 1 ;

   size_t nStringLen = wcslen ( szString ) ;
   if ( ! nStringLen ) return 1 ;

   STOREDSTRINGSW *StoredStrings = *pStoredStrings ;

   if ( ! StoredStrings ) {
      StoredStrings = malloc_array ( STOREDSTRINGSW, 1 ) ;
      if ( ! StoredStrings ) {
         *pStoredStrings = (STOREDSTRINGSW*) STOREDSTRINGS_ERROR ;
         return 1 ;
      }
      static const STOREDSTRINGSW STOREDSTRINGS_ZERO = { 0 } ;
      *StoredStrings = STOREDSTRINGS_ZERO ;
   }

   size_t nRequiredBufferSize = StoredStrings->szWrite - StoredStrings->szBuffer + nStringLen + 2 ;

   // obt@g
   if ( StoredStrings->nBufferSize < nRequiredBufferSize ) {

      size_t nBufferSize = StoredStrings->nBufferSize ;
      do {
         if ( ! nBufferSize )               nBufferSize = INIT_BUFFER_SIZE ;
         else if ( nBufferSize < MEGABYTE ) nBufferSize = nBufferSize * 4 ;
         else                               nBufferSize = nBufferSize + MEGABYTE ;
      } while ( nBufferSize < nRequiredBufferSize ) ;

      wchar_t *szBuffer = realloc_array ( StoredStrings->szBuffer, wchar_t, nBufferSize ) ;

      if ( ! szBuffer ) {
         FreeStoredStringsW ( & StoredStrings ) ;
         *pStoredStrings = (STOREDSTRINGSW*) STOREDSTRINGS_ERROR ;
         return 1 ;
      }

      if ( DEBUG_STORESTR ) DebugMemoryW ( szBuffer, nBufferSize, StoredStrings->szBuffer, StoredStrings->nBufferSize, szString ) ;

      StoredStrings->szWrite += szBuffer - StoredStrings->szBuffer ;
      StoredStrings->szRead += szBuffer - StoredStrings->szBuffer ;
      StoredStrings->szBuffer = szBuffer ;
      StoredStrings->nBufferSize = nBufferSize ;
   }

   // i[
   wcscpy ( StoredStrings->szWrite, szString ) ;
   StoredStrings->szWrite += nStringLen + 1 ;
   *( StoredStrings->szWrite ) = 0 ;
   StoredStrings->nWriteCount ++ ;

   *pStoredStrings = StoredStrings ;

   return 0 ;
}



// obt@
void FreeStoredStringsW ( STOREDSTRINGSW **pStoredStrings ) {

   if ( ! pStoredStrings ) return ;

   if ( ! *pStoredStrings || *pStoredStrings == STOREDSTRINGS_ERROR ) {
      *pStoredStrings = NULL ;
      return ;
   }

   STOREDSTRINGSW *StoredStrings = *pStoredStrings ;

   if ( DEBUG_STORESTR ) DebugMemoryW ( StoredStrings->szBuffer, StoredStrings->nBufferSize, NULL, 0, NULL ) ;

   free ( StoredStrings->szBuffer ) ;
   free ( StoredStrings ) ;

   *pStoredStrings = NULL ;
}



// obt@ŏ̕ԂiUNICODEŁj
// 񂪂Ȃ΁ANULL Ԃ
const wchar_t *GetFirstStringW ( STOREDSTRINGSW *StoredStrings ) {

   if ( ! StoredStrings || StoredStrings == STOREDSTRINGS_ERROR ) return NULL ;

   StoredStrings->nReadCount = 0 ;

   return StoredStrings->szRead = StoredStrings->szBuffer ;
}



// obt@玟̕ԂiUNICODEŁj
// 񂪂Ȃ΁ANULL Ԃ
// GetFirstString () ĂяoOȂA͕s
const wchar_t *GetNextStringW ( STOREDSTRINGSW *StoredStrings ) {

   if ( ! StoredStrings || StoredStrings == STOREDSTRINGS_ERROR ) return NULL ;

   if ( ! *StoredStrings->szRead ) return NULL ;

   StoredStrings->nReadCount ++ ;

   StoredStrings->szRead = wcsend ( StoredStrings->szRead ) + 1 ;
   if ( ! *StoredStrings->szRead ) return NULL ;

   return StoredStrings->szRead ;
}



// obt@̌̕ԂiUNICODEŁj
size_t GetStringsCountW ( const STOREDSTRINGSW *StoredStrings ) {

   if ( ! StoredStrings || StoredStrings == STOREDSTRINGS_ERROR ) return 0 ;

   return StoredStrings->nWriteCount ;
}



// ʂ̃obt@𕶎ǉiUNICODEŁj
// ʂ̃obt@͎IɉȂ
// sAobt@NA STOREDSTRINGS_ERROR i[āA0 ȊOԂ
int MergeStoredStringsW ( STOREDSTRINGSW **pStoredStrings, const STOREDSTRINGSW *StoredStringsToAdd ) {

   if ( ! StoredStringsToAdd ) return 0 ;
   if ( StoredStringsToAdd == STOREDSTRINGS_ERROR ) return 1 ;

   for ( const wchar_t *szString = StoredStringsToAdd->szBuffer ; *szString ; szString = wcsend ( szString ) + 1 ) {
      if ( StoreStringW ( pStoredStrings, szString ) ) break ;
   }

   return 0 ;
}



// obt@̈ʒuۑiUNICODEŁj
int GetStringPositionW ( const STOREDSTRINGSW *StoredStrings, STOREDSTRINGS_POSITION *Position, int IsReadingPosition ) {

   if ( ! Position || StoredStrings == STOREDSTRINGS_ERROR ) return 1 ;

   if ( ! StoredStrings ) {
      Position->nOffset = 0 ;
      Position->nCount = 0 ;
   }
   else if ( IsReadingPosition ) {
      Position->nOffset = StoredStrings->szRead - StoredStrings->szBuffer ;
      Position->nCount = StoredStrings->nReadCount ;
   }
   else {
      Position->nOffset = StoredStrings->szWrite - StoredStrings->szBuffer ;
      Position->nCount = StoredStrings->nWriteCount ;
   }

   return 0 ;
}



static int __cdecl CompareStoredStringsCrtW ( const wchar_t **pArg1, const wchar_t **pArg2 ) ;
static int __cdecl CompareStoredStringsSystemW ( const wchar_t **pArg1, const wchar_t **pArg2 ) ;
static int __cdecl CompareStoredStringsNumericalW ( const wchar_t **pArg1, const wchar_t **pArg2 ) ;



// obt@̕\[giUNICODEŁj
// CompareFuntion  NULL ̏ꍇ́AdwMode Ŏw肳ꂽr֐gp
// Start  End Ŏw肳ꂽԂ̂݃\[giNULLłj
int SortStoredStringsW ( const STOREDSTRINGSW *StoredStrings, const STOREDSTRINGS_POSITION *Start, const STOREDSTRINGS_POSITION *End, int ( __cdecl *CompareFunction ) ( const wchar_t **, const wchar_t ** ), unsigned long dwMode ) {

   if ( ! StoredStrings ) return 0 ;
   if ( StoredStrings == STOREDSTRINGS_ERROR ) return 1 ;

   if ( Start ) {
      if ( Start->nOffset > (size_t) ( StoredStrings->szWrite - StoredStrings->szBuffer ) ) return 1 ;
      if ( Start->nCount > StoredStrings->nWriteCount ) return 1 ;
   }
   if ( End ) {
      if ( End->nCount > StoredStrings->nWriteCount ) return 1 ;
      if ( Start && End->nCount < Start->nCount ) return 1 ;
   }

   size_t nItem = ( ( End ) ? End->nCount : StoredStrings->nWriteCount ) - ( ( Start ) ? Start->nCount : 0 ) ;
   if ( nItem <= 1 ) return 0 ;

   int nResult = 1 ;

   const wchar_t **pPointerToString = malloc_array ( const wchar_t*, nItem ) ;
   if ( pPointerToString ) {

      wchar_t *szSrc = StoredStrings->szBuffer + ( ( Start ) ? Start->nOffset : 0 ) ;

      const wchar_t *szSrcEnd = szSrc ;
      for ( size_t nCount = 0 ; nCount < nItem ; nCount ++ ) {
         pPointerToString [ nCount ] = szSrcEnd ;
         szSrcEnd = wcsend ( szSrcEnd ) + 1 ;
      }
      size_t nBufferSize = szSrcEnd - szSrc ;

      if ( ! CompareFunction ) {
         if      ( dwMode & STORESTR_SORT_NUMERICAL ) CompareFunction = CompareStoredStringsNumericalW ;
         else if ( dwMode & STORESTR_SORT_SYSTEM )    CompareFunction = CompareStoredStringsSystemW ;
         else                                         CompareFunction = CompareStoredStringsCrtW ;
      }

      qsort ( pPointerToString, nItem, sizeof(wchar_t*), (QSORT_COMPARE_FUNCTION) CompareFunction ) ;

      wchar_t *szDst = malloc_array ( wchar_t, nBufferSize ) ;
      if ( szDst ) {

         wchar_t *szDstEnd = szDst ;
         for ( size_t nCount = 0 ; nCount < nItem ; nCount ++ ) {
            if ( dwMode & STORESTR_SORT_REVERSE ) wcscpy ( szDstEnd, pPointerToString [ nItem - nCount - 1 ] ) ;
            else                                  wcscpy ( szDstEnd, pPointerToString [ nCount ] ) ;
            szDstEnd = wcsend ( szDstEnd ) + 1 ;
         }

         memmove ( szSrc, szDst, nBufferSize * sizeof(wchar_t) ) ;
         free ( szDst ) ;

         nResult = 0 ;
      }

      free ( pPointerToString ) ;
   }

   return nResult ;
}



static int CallCompareStringOrdinalW ( const wchar_t *szSrc, int nSrc, const wchar_t *szDst, int nDst, int IsIgnoreCase ) ;



// obt@̕iUNICODEŁj
// ̃CfbNX pIndex Ɋi[iNULLłj
// 當As NULL Ԃ
const wchar_t *FindStoredStringW ( const STOREDSTRINGSW *StoredStrings, const wchar_t *szPattern, size_t *pIndex, unsigned long dwMode ) {

   if ( ! StoredStrings || StoredStrings == STOREDSTRINGS_ERROR ) return NULL ;
   if ( ! szPattern ) return NULL ;

   size_t nCount = 0 ;

   for ( wchar_t *szString = StoredStrings->szBuffer ; *szString ; szString = wcsend ( szString ) + 1, nCount ++ ) {

      int nResult ;
      if ( dwMode & STORESTR_CMP_IGNORECASE ) nResult = CallCompareStringOrdinalW ( szString, -1, szPattern, -1, 1 ) ;
      else                                    nResult = wcscmp ( szString, szPattern ) ;

      if ( ! nResult ) {
         if ( pIndex ) *pIndex = nCount ;
         return szString ;
      }
   }

   return NULL ;
}



////////////////////////////////////////////
//             r֐iCRTj            //
////////////////////////////////////////////



// CRT Ń\[giANSIŁj
static int __cdecl CompareStoredStringsCrtA ( const char **pArg1, const char **pArg2 ) {
   return strcmp ( *pArg1, *pArg2 ) ;
}



// CRT Ń\[giUNICODEŁj
static int __cdecl CompareStoredStringsCrtW ( const wchar_t **pArg1, const wchar_t **pArg2 ) {
   return wcscmp ( *pArg1, *pArg2 ) ;
}



////////////////////////////////////////////
//           r֐iLOCALEj           //
////////////////////////////////////////////



static int CallCompareStringA ( LCID Locale, unsigned long dwFlags, const char *szSrc, int nSrc, const char *szDst, int nDst ) ;
static int CallCompareStringW ( LCID Locale, unsigned long dwFlags, const wchar_t *szSrc, int nSrc, const wchar_t *szDst, int nDst ) ;



// VXẽP[Ń\[giANSIŁj
static int __cdecl CompareStoredStringsSystemA ( const char **pArg1, const char **pArg2 ) {
   return CallCompareStringA ( LOCALE_SYSTEM_DEFAULT, 0, *pArg1, -1, *pArg2, -1 ) ;
}



// VXẽP[Ń\[giUNICODEŁj
static int __cdecl CompareStoredStringsSystemW ( const wchar_t **pArg1, const wchar_t **pArg2 ) {
   return CallCompareStringW ( LOCALE_SYSTEM_DEFAULT, 0, *pArg1, -1, *pArg2, -1 ) ;
}



////////////////////////////////////////////
//          r֐iNUMERICALj         //
////////////////////////////////////////////



// ]ă\[giANSIŁj
static int __cdecl CompareStoredStringsNumericalA ( const char **pArg1, const char **pArg2 ) {
   return CompareStringLogicalA ( *pArg1, *pArg2 ) ;
}



// ]ă\[giUNICODEŁj
static int __cdecl CompareStoredStringsNumericalW ( const wchar_t **pArg1, const wchar_t **pArg2 ) {
   return CompareStringLogicalW ( *pArg1, *pArg2 ) ;
}



////////////////////////////////////////////
//            CompareString ()            //
////////////////////////////////////////////



static char *w2aduplen_escape ( const wchar_t *string, size_t srclen ) ;



// CompareString () Ɠ
// v 0 Ԃ
static int CallCompareStringA ( LCID Locale, unsigned long dwFlags, const char *szSrc, int nSrc, const char *szDst, int nDst ) {

   int nResult = CompareStringA ( Locale, dwFlags, szSrc, nSrc, szDst, nDst ) ;
   switch ( nResult ) {
      case CSTR_LESS_THAN : return -1 ;
      case CSTR_GREATER_THAN : return 1 ;
      case CSTR_EQUAL : return 0 ;
   }

   return 0 ;
}



// CompareString () Ɠ
// Win95/98/Me łgp
// v 0 Ԃ
static int CallCompareStringW ( LCID Locale, unsigned long dwFlags, const wchar_t *szSrc, int nSrc, const wchar_t *szDst, int nDst ) {

   int nResult ;

   if ( IsNT () ) nResult = CompareStringW ( Locale, dwFlags, szSrc, nSrc, szDst, nDst ) ;
   else {

      char *szSrcA = w2aduplen_escape ( szSrc, nSrc ) ;
      char *szDstA = w2aduplen_escape ( szDst, nDst ) ;

      if ( szSrcA && szDstA ) nResult = CompareStringA ( Locale, dwFlags, szSrcA, -1, szDstA, -1 ) ;
      else                    nResult = 0 ;

      free ( szSrcA ) ;
      free ( szDstA ) ;
   }

   switch ( nResult ) {
      case CSTR_LESS_THAN : return -1 ;
      case CSTR_GREATER_THAN : return 1 ;
      case CSTR_EQUAL : return 0 ;
   }

   return 0 ;
}



////////////////////////////////////////////
//         CompareStringOrdinal ()        //
////////////////////////////////////////////



// CompareStringOrdinal () Ɠ
// v 0 Ԃ
static int CallCompareStringOrdinalA ( const char *szSrc, int nSrc, const char *szDst, int nDst, int IsIgnoreCase ) {

   int nResult = CompareStringOrdinalA ( szSrc, -1, szDst, -1, IsIgnoreCase ) ;
   switch ( nResult ) {
      case CSTR_LESS_THAN : return -1 ;
      case CSTR_GREATER_THAN : return 1 ;
      case CSTR_EQUAL : return 0 ;
   }

   return 0 ;
}



// CompareStringOrdinal () Ɠ
// Win95/98/Me łgp
// v 0 Ԃ
static int CallCompareStringOrdinalW ( const wchar_t *szSrc, int nSrc, const wchar_t *szDst, int nDst, int IsIgnoreCase ) {

   int nResult ;

   if ( IsNT () ) nResult = CompareStringOrdinalW ( szSrc, nSrc, szDst, nDst, IsIgnoreCase ) ;
   else {

      char *szSrcA = w2aduplen_escape ( szSrc, nSrc ) ;
      char *szDstA = w2aduplen_escape ( szDst, nDst ) ;

      if ( szSrcA && szDstA ) nResult = CompareStringOrdinalA ( szSrcA, -1, szDstA, -1, IsIgnoreCase ) ;
      else                    nResult = 0 ;

      free ( szSrcA ) ;
      free ( szDstA ) ;
   }

   switch ( nResult ) {
      case CSTR_LESS_THAN : return -1 ;
      case CSTR_GREATER_THAN : return 1 ;
      case CSTR_EQUAL : return 0 ;
   }

   return 0 ;
}



////////////////////////////////////////////
//            StrCmpLogical ()            //
////////////////////////////////////////////



// StrCmpLogical () Ɠ
// v 0 Ԃ
int CompareStringLogicalA ( const char *szSrc, const char *szDst ) {

   if ( ! szSrc || ! szDst ) return 0 ;

   wchar_t *szSrcW = a2wdup ( szSrc ) ;
   wchar_t *szDstW = a2wdup ( szDst ) ;

   int nResult = CompareStringLogicalW ( szSrcW, szDstW ) ;

   free ( szSrcW ) ;
   free ( szDstW ) ;

   return nResult ;
}



static int DigitToZeroW ( int C ) ;
static int CompareDigitsW ( const wchar_t *szSrc, const wchar_t **pszSrcNext, const wchar_t *szDst, const wchar_t **pszDstNext ) ;



#define StrCmpLogicalW StrCmpLogicalW_
typedef int ( WINAPI *STRCMPLOGICALW ) ( LPCWSTR psz1, LPCWSTR psz2 ) ;
static HINSTANCE hShlwapi ;

static int FreeLibraryOnDetach ( void ) ;



// StrCmpLogical () Ɠ
// Win95/98/Me łgp
// v 0 Ԃ
int CompareStringLogicalW ( const wchar_t *szSrc, const wchar_t *szDst ) {

   if ( ! szSrc || ! szDst ) return 0 ;


   static STRCMPLOGICALW StrCmpLogicalW ;
   static volatile int IsTried ;

#ifndef STRCMP_LOGICAL_TEST
   if ( ! IsTried ) {
#ifdef _MT
      EnterCriticalSection ( & LoadDllSection ) ;
      __try {
         if ( ! IsTried ) {
#endif
            if ( ! hShlwapi && ( hShlwapi = LoadLibraryW ( L"SHLWAPI.DLL" ) ) ) FreeLibraryOnDetach () ;
            GETPROCADDRESS ( hShlwapi, STRCMPLOGICALW, StrCmpLogicalW ) ;
            IsTried = 1 ;
#ifdef _MT
         }
      } __finally {
         LeaveCriticalSection ( & LoadDllSection ) ;
      }
#endif
   }
#endif

   if ( StrCmpLogicalW ) return StrCmpLogicalW ( szSrc, szDst ) ;


   const wchar_t *szSrcStart = szSrc ;
   const wchar_t *szDstStart = szDst ;
   int IsFoundDigits = 0 ;

   while ( *szSrc || *szDst ) {

      if ( DigitToZeroW ( *szSrc ) && DigitToZeroW ( *szDst ) ) {

         int nResult = CompareDigitsW ( szSrc, & szSrc, szDst, & szDst ) ;
         if ( nResult ) return nResult ;

         IsFoundDigits = 1 ;
      }
      else if ( *szSrc && *szDst ) {

         const wchar_t *szSrcSaved = szSrc ;
         const wchar_t *szDstSaved = szDst ;

         while ( *szSrc && ! DigitToZeroW ( *szSrc ) ) szSrc ++ ;
         while ( *szDst && ! DigitToZeroW ( *szDst ) ) szDst ++ ;

         int nResult = CallCompareStringW ( LOCALE_SYSTEM_DEFAULT, NORM_IGNORECASE, szSrcSaved, (int) ( szSrc - szSrcSaved ), szDstSaved, (int) ( szDst - szDstSaved ) ) ;
         if ( nResult ) return nResult ;
      }
      else {
         if ( *szSrc ) return 1 ;
         if ( *szDst ) return -1 ;
      }
   }

   if ( IsFoundDigits ) return CallCompareStringW ( LOCALE_SYSTEM_DEFAULT, NORM_IGNORECASE, szSrcStart, -1, szDstStart, -1 ) ;

   return 0 ;
}



#define CASE_DIGIT_TO_ZERO(c)    case (c): case (c)+1: case (c)+2: case (c)+3: case (c)+4: case (c)+5: case (c)+6: case (c)+7: case (c)+8: case (c)+9: return (c)

static int DigitToZeroW ( int C ) {
   switch ( C ) {
      CASE_DIGIT_TO_ZERO ( 0x0030 ) ;     // DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x0660 ) ;     // ARABIC-INDIC DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x06F0 ) ;     // EXTENDED ARABIC-INDIC DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x07C0 ) ;     // -- NKO DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x0966 ) ;     // DEVANAGARI DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x09E6 ) ;     // BENGALI DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x0A66 ) ;     // GURMUKHI DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x0AE6 ) ;     // GUJARATI DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x0B66 ) ;     // ORIYA DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x0BE6 ) ;     // -- TAMIL DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x0C66 ) ;     // TELUGU DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x0CE6 ) ;     // KANNADA DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x0D66 ) ;     // MALAYALAM DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x0DE6 ) ;     // -- SINHALA LITH DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x0E50 ) ;     // THAI DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x0ED0 ) ;     // LAO DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x0F20 ) ;     // TIBETAN DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x1040 ) ;     // MYANMAR DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x17E0 ) ;     // KHMER DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x1810 ) ;     // MONGOLIAN DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x1946 ) ;     // -- LIMBU DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x19D0 ) ;     // -- NEW TAI LUE DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x1A80 ) ;     // -- TAI THAM HORA DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x1A90 ) ;     // -- TAI THAM THAM DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x1B50 ) ;     // -- BALINESE DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x1BB0 ) ;     // -- SUNDANESE DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x1C40 ) ;     // -- LEPCHA DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0x1C50 ) ;     // -- OL CHIKI DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0xA8D0 ) ;     // -- SAURASHTRA DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0xA900 ) ;     // -- KAYAH LI DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0xA9D0 ) ;     // -- JAVANESE DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0xAA50 ) ;     // -- CHAM DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0xABF0 ) ;     // -- MEETEI MAYEK DIGIT ZERO
      CASE_DIGIT_TO_ZERO ( 0xFF10 ) ;     // FULLWIDTH DIGIT ZERO
   }
   return 0 ;
}



static int CompareDigitsW ( const wchar_t *szSrc, const wchar_t **pszSrcNext, const wchar_t *szDst, const wchar_t **pszDstNext ) {

   const int cSrcZero = DigitToZeroW ( *szSrc ) ;
   while ( *szSrc == cSrcZero ) szSrc ++ ;

   const wchar_t *szSrcEnd = szSrc ;
   while ( IS_BETWEEN ( *szSrcEnd, cSrcZero, cSrcZero + 9 ) ) szSrcEnd ++ ;
   *pszSrcNext = szSrcEnd ;

   const int cDstZero = DigitToZeroW ( *szDst ) ;
   while ( *szDst == cDstZero ) szDst ++ ;

   const wchar_t *szDstEnd = szDst ;
   while ( IS_BETWEEN ( *szDstEnd, cDstZero, cDstZero + 9 ) ) szDstEnd ++ ;
   *pszDstNext = szDstEnd ;

   if ( szSrcEnd - szSrc > szDstEnd - szDst ) return 1 ;
   if ( szSrcEnd - szSrc < szDstEnd - szDst ) return -1 ;

   while ( szSrc < szSrcEnd ) {
      int nSrcDigit = *( szSrc ++ ) - cSrcZero ;
      int nDstDigit = *( szDst ++ ) - cDstZero ;
      if ( nSrcDigit < nDstDigit ) return -1 ;
      if ( nSrcDigit > nDstDigit ) return 1 ;
   }

   return 0 ;
}



////////////////////////////////////////////
//                ʊ֐                //
////////////////////////////////////////////



// ChANSIɕϊĕ
//  SIZE_MAX ȂkI[ƌȂ
// ϊłȂ 0x7F + 16i4 ɕϊ
static char *w2aduplen_escape ( const wchar_t *string, size_t srclen ) {

   if ( srclen == SIZE_MAX ) srclen = wcslen ( string ) ;
   if ( srclen > INT_MAX ) return NULL ;

   size_t dstlen = 0 ;

   for ( size_t i = 0 ; i < srclen ; i ++ ) {
      if ( *( string + i ) < 0x7F ) dstlen ++ ;
      else                          dstlen += 5 ;
   }

   char *buffer ;
   if ( ! ( buffer = malloc_array ( char, dstlen + 1 ) ) ) return NULL ;

   char *dst = buffer ;

   for ( size_t i = 0 ; i < srclen ; i ++ ) {
      if ( *( string + i ) < 0x7F ) *dst ++ = (char) *( string + i ) ;
      else {
         int IsUsedDefaultChar = 0 ;
         wchar_t C ;
         int nLength = WideCharToMultiByte ( CP_ACP, 0, string + i, 1, dst, (int) ( dstlen - ( dst - buffer ) ), NULL, & IsUsedDefaultChar ) ;
         if ( ! IsUsedDefaultChar ) MultiByteToWideChar ( CP_ACP, 0, dst, nLength, & C, 1 ) ;
         if ( IsUsedDefaultChar || C != *( string + i ) || C == 0x7F ) dst += sprintf ( dst, "%c%04X", 0x7F, *( string + i ) ) ;
         else                                                          dst += nLength ;
      }
   }

   *dst = 0 ;

   return buffer ;
}



static void __cdecl ExitProc ( void ) {
   if ( hShlwapi ) FreeLibrary ( hShlwapi ) ;
}



static int FreeLibraryOnDetach ( void ) {
#ifdef _USRDLL
   return atexit ( ExitProc ) ;
#else
   return 0 ;
#endif
}



////////////////////////////////////////////
//                 DEBUG                  //
////////////////////////////////////////////



static int DebugMemoryA ( void *szNewBuffer, size_t nNewBufferSize, void *szOldBuffer, size_t nOldBufferSize, const char *szString ) {

   FILE *Fout = fopen ( "storestr.debug.txt", "ac" ) ;
   if ( ! Fout ) return 1 ;

   int nWidth = ( IS_WIN64 ) ? 16 : 8 ;

   if ( szString ) {
      if ( szOldBuffer ) fprintf ( Fout, "%-8s %p,%8IX  <--%p,%8IX,  \"%s\"\n", "Alloc:", szNewBuffer, nNewBufferSize, szOldBuffer, nOldBufferSize, szString ) ;
      else               fprintf ( Fout, "%-8s %p,%8IX  <--%*s,%8s   \"%s\"\n", "Alloc:", szNewBuffer, nNewBufferSize, nWidth, "", "", szString ) ;
   }
   else                  fprintf ( Fout, "%-8s %p,%8IX\n", "Free:", szNewBuffer, nNewBufferSize ) ;

   fclose ( Fout ) ;

   return 0 ;
}



static int DebugMemoryW ( void *szNewBuffer, size_t nNewBufferSize, void *szOldBuffer, size_t nOldBufferSize, const wchar_t *szString ) {

   char *szTmp = ( szString ) ? w2adup ( szString ) : NULL ;

   int nResult = DebugMemoryA ( szNewBuffer, nNewBufferSize, szOldBuffer, nOldBufferSize, szTmp ) ;

   free ( szTmp ) ;

   return nResult ;
}



