// shfileop.h

#ifndef SHFILEOP_H
#define SHFILEOP_H

#ifdef __cplusplus
extern "C" {
#endif


int ShellDeleteMultipleFilesA ( HWND hWnd, const char *szFileName, unsigned long dwMode ) ;
int ShellDeleteFileA ( HWND hWnd, const char *szFileName, unsigned long dwMode ) ;
int ShellDeleteMultipleFilesW ( HWND hWnd, const wchar_t *szFileName, unsigned long dwMode ) ;
int ShellDeleteFileW ( HWND hWnd, const wchar_t *szFileName, unsigned long dwMode ) ;

int ShellCopyMultipleFilesA ( HWND hWnd, const char *szSrcFileName, const char *szDstFileName, unsigned long dwMode ) ;
int ShellCopyFileA ( HWND hWnd, const char *szSrcFileName, const char *szDstFileName, unsigned long dwMode ) ;
int ShellCopyMultipleFilesW ( HWND hWnd, const wchar_t *szSrcFileName, const wchar_t *szDstFileName, unsigned long dwMode ) ;
int ShellCopyFileW ( HWND hWnd, const wchar_t *szSrcFileName, const wchar_t *szDstFileName, unsigned long dwMode ) ;


#ifdef UNICODE
#define ShellDeleteMultipleFiles ShellDeleteMultipleFilesW
#define ShellDeleteFile ShellDeleteFileW
#define ShellCopyMultipleFiles ShellCopyMultipleFilesW
#define ShellCopyFile ShellCopyFileW
#else
#define ShellDeleteMultipleFiles ShellDeleteMultipleFilesA
#define ShellDeleteFile ShellDeleteFileA
#define ShellCopyMultipleFiles ShellCopyMultipleFilesA
#define ShellCopyFile ShellCopyFileA
#endif


// dwMode (delete)
#define SHDELETE_NO_RECYCLEBIN   1
#define SHDELETE_VERBOSE         0x8000

// dwMode (copy)
#define SHCOPY_MOVEFILE          1
#define SHCOPY_VERBOSE           SHDELETE_VERBOSE


#ifdef __cplusplus
}
#endif

#endif


