// oemio.h

#ifndef OEMIO_H
#define OEMIO_H

#ifdef __cplusplus
extern "C" {
#endif


FILE *oem_fopen ( const char *filename, const char *mode ) ;
FILE *oem_fsopen ( const char *filename, const char *mode, int shflag ) ;
FILE *oem_wfopen ( const wchar_t *filename, const wchar_t *mode ) ;
FILE *oem_wfsopen ( const wchar_t *filename, const wchar_t *mode, int shflag ) ;
int oem_fclose ( FILE *stream ) ;


int oem_fseek ( FILE *stream, long offset, int origin ) ;
int oem_fseek64 ( FILE *stream, int64_t offset, int origin ) ;
int oem_fsetpos ( FILE *stream, const fpos_t *pos ) ;
void oem_rewind ( FILE *stream ) ;
int oem_ferror ( FILE *stream ) ;
int oem_feof ( FILE *stream ) ;


int fwide ( FILE *stream, int mode ) ;


int __cdecl oem_printf ( const char *format,... ) ;
int __cdecl oem_fprintf ( FILE *stream, const char *format,... ) ;
int __cdecl oem_vfprintf ( FILE *stream, const char *format, va_list args ) ;

int __cdecl oem_wprintf ( const wchar_t *format,... ) ;
int __cdecl oem_fwprintf ( FILE *stream, const wchar_t *format,... ) ;
int __cdecl oem_vfwprintf ( FILE *stream, const wchar_t *format, va_list args ) ;

int __cdecl oem_fputs ( const char *string, FILE *stream ) ;
int __cdecl oem_fputws ( const wchar_t *string, FILE *stream ) ;
size_t __cdecl oem_fwrites ( const char *string, size_t length, FILE *stream ) ;
size_t __cdecl oem_fwritews ( const wchar_t *string, size_t length, FILE *stream ) ;


char *__cdecl oem_fgets ( char *string, int count, FILE *stream ) ;
wchar_t *__cdecl oem_fgetws ( wchar_t *string, int count, FILE *stream ) ;
size_t __cdecl oem_freads ( char *string, size_t count, FILE *stream ) ;
size_t __cdecl oem_freadws ( wchar_t *string, size_t count, FILE *stream ) ;


int fputs_line ( const char *string, FILE *stream ) ;
int fputws_line ( const wchar_t *string, FILE *stream ) ;
int console_clear_line ( int is_start_from_linetop ) ;


int fiscon ( FILE *stream ) ;


#undef fopen
#undef fsopen
#undef wfopen
#undef wfsopen

#define fopen oem_fopen
#define fsopen oem_fsopen
#define wfopen oem_wfopen
#define wfsopen oem_wfsopen

#define fclose oem_fclose

#undef fseek
#undef fseek64
#undef fsetpos
#undef rewind
#undef ferror
#undef feof

#define fseek oem_fseek
#define fseek64 oem_fseek64
#define fsetpos oem_fsetpos
#define rewind oem_rewind
#define ferror oem_ferror
#define feof oem_feof

#define printf oem_printf
#define fprintf oem_fprintf
#define vfprintf oem_vfprintf
#define wprintf oem_wprintf
#define fwprintf oem_fwprintf
#define vfwprintf oem_vfwprintf

#define fputs oem_fputs
#define fputws oem_fputws
#define fwrites oem_fwrites
#define fwritews oem_fwritews

#define fgets oem_fgets
#define fgetws oem_fgetws
#define freads oem_freads
#define freadws oem_freadws


#ifdef __cplusplus
}
#endif

#endif


