// findfile.cpp

#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include "msc.h"
#include "filename.h"
#include "findfile.h"
#include "storestr.h"



////////////////////////////////////////////
//                 ANSI                 //
////////////////////////////////////////////



// FINDFILES \
struct FINDFILESA_TAG {
   STOREDSTRINGSA *StoredNames ;    // t@C
} ;



// p
typedef struct {
   WIN32_FIND_DATAA *pFindData ;
   volatile const int *pIsAbort ;
   unsigned long dwSortMode ;
} DATAA ;



static FINDFILESA *DoFindFilesA ( FINDFILESA *pFindFiles, const char *szPath, unsigned long dwMode, FINDFILES_CALLBACKA Callback, LPARAM lParam, int nDepth, DATAA *pData ) ;
static inline int IsDotDirectoryA ( const char *szString ) ;



// t@CEfBNg񋓂iANSIŁj
// t@CȂANULLԂ
// G[NAobt@ FINDFILES_ERROR Ԃ
// pIsAbort ̎QƂϐ 0 ȊOɂȂAobt@ FINDFILES_ERROR ԂiNULLłj
// fBNǧn߂OAуt@CƂAR[obN֐ĂяoiNULLłj
// OɃR[obN֐ĂяoƂ́ApFindData  NULL n
// R[obN֐ 0 ԂA񋓂p
//                    ԂÃt@Cr
//                    ԂÃfBNg̗񋓂~
// 񋓒~̌ʂTufBNgɋyԂǂ́AR[obN֐Ăяo_ɂ
FINDFILESA *FindFilesA ( const char *szPath, unsigned long dwMode, volatile const int *pIsAbort, FINDFILES_CALLBACKA Callback, LPARAM lParam ) {

   const char *szLastPart = GetFileNameA ( szPath ) ;
   if ( ! szLastPart || IsDotDirectoryA ( szLastPart ) ) return NULL ;

   DATAA Data = { 0 } ;

   WIN32_FIND_DATAA FindData ;
   Data.pFindData = & FindData ;

   static const int IsAbortDummy = 0 ;
   Data.pIsAbort = ( pIsAbort ) ? pIsAbort : & IsAbortDummy ;

   // t@CfBNg̎w肪Ȃ΃t@Cw
   if ( ! ( dwMode & ( FINDFILES_FILE | FINDFILES_DIR ) ) ) dwMode |= FINDFILES_FILE ;

   if ( dwMode & FINDFILES_NO_EMPTY_DIR && dwMode & FINDFILES_ONLY_EMPTY_DIR ) dwMode &= ~ FINDFILES_DIR ;


   // \[gp[hI
   if ( IsWinXPorLater () && ! ( dwMode & ( FINDFILES_SORT_NUMERIC | FINDFILES_SORT_CLASSIC ) ) ) dwMode |= FINDFILES_SORT_NUMERIC ;
   if ( dwMode & FINDFILES_SORT_NUMERIC ) Data.dwSortMode |= STORESTR_SORT_NUMERICAL ;
   if ( dwMode & FINDFILES_SORT_REVERSE ) Data.dwSortMode |= STORESTR_SORT_REVERSE ;
   if ( ! ( Data.dwSortMode & STORESTR_SORT_NUMERICAL ) ) Data.dwSortMode |= STORESTR_SORT_SYSTEM ;


   return DoFindFilesA ( NULL, szPath, dwMode, Callback, lParam, 0, & Data ) ;
}



static int IsFoundAnyFileA ( const char *szPath, int IsFindHidden, int IsExcludeDir ) ;
static inline HANDLE CallFindFirstFileA ( const char *szFileName, WIN32_FIND_DATAA *pFindData, int *pIsError, int IsUseOldFunc ) ;
static inline int CallFindNextFileA ( HANDLE hFindFile, WIN32_FIND_DATAA *pFindData, int *pIsError ) ;



// FindFiles () ̉֐
// ċAĂяo
static FINDFILESA *DoFindFilesA ( FINDFILESA *pFindFiles, const char *szPath, unsigned long dwMode, FINDFILES_CALLBACKA Callback, LPARAM lParam, int nDepth, DATAA *pData ) {

   if ( pFindFiles == FINDFILES_ERROR ) return (FINDFILESA*) FINDFILES_ERROR ;

   if ( *pData->pIsAbort ) {
      CloseFindFilesA ( pFindFiles ) ;
      return (FINDFILESA*) FINDFILES_ERROR ;
   }

   // ŗ񋓂~ATufBNg̗񋓂~
   if ( Callback && Callback ( szPath, NULL, nDepth, lParam ) < 0 ) return pFindFiles ;


   WIN32_FIND_DATAA *const pFindData = pData->pFindData ;

   char *szFileName = strdup_expand ( szPath, MAX_PATH_LONG, MAX_PATH + 8 ) ; // TufBNg \* 邽
   if ( ! szFileName ) {
      CloseFindFilesA ( pFindFiles ) ;
      return (FINDFILESA*) FINDFILES_ERROR ;
   }
   char *szLastPart = GetFileNameA ( szFileName ) ;


   int IsError = 0 ;

   // ̃fBNg̃t@C
   HANDLE hFindFile = CallFindFirstFileA ( szPath, pFindData, & IsError, dwMode & FINDFILES_SHORTNAME ) ;
   if ( hFindFile != INVALID_HANDLE_VALUE ) {

      int IsFound = 0 ;
      STOREDSTRINGS_POSITION SortStartPosition = { 0 } ;

      do {

         if ( *pData->pIsAbort ) { IsError = 1 ; break ; }

         if ( pFindData->dwFileAttributes & ( FILE_ATTRIBUTE_HIDDEN | FILE_ATTRIBUTE_SYSTEM ) ) {
            if ( ! ( dwMode & FINDFILES_HIDDEN ) ) continue ;
         }

         if ( pFindData->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) {

            if ( ! ( dwMode & FINDFILES_DIR ) ) continue ;
            if ( IsDotDirectoryA ( pFindData->cFileName ) ) continue ;

            // ̃fBNg
            if ( dwMode & ( FINDFILES_NO_EMPTY_DIR | FINDFILES_ONLY_EMPTY_DIR ) ) {
               strcpy ( szLastPart, pFindData->cFileName ) ;
               strcat ( szLastPart, "\\*" ) ;
               if ( dwMode & FINDFILES_NO_EMPTY_DIR && ! IsFoundAnyFileA ( szFileName, dwMode & FINDFILES_HIDDEN, 1 ) ) continue ;
               if ( dwMode & FINDFILES_ONLY_EMPTY_DIR && IsFoundAnyFileA ( szFileName, dwMode & FINDFILES_HIDDEN, 0 ) ) continue ;
            }
         }
         else {
            if ( ! ( dwMode & FINDFILES_FILE ) ) continue ;
         }

         // Ot@CƃV[gt@ĈǂD
         char *szPriorName = ( dwMode & FINDFILES_SHORTNAME ) ? pFindData->cAlternateFileName : pFindData->cFileName ;
         char *szAlternateName = ( dwMode & FINDFILES_SHORTNAME ) ? pFindData->cFileName : pFindData->cAlternateFileName ;
         if ( ! *szPriorName && *szAlternateName ) szPriorName = szAlternateName ;

         if ( Callback ) {
            int nResult = Callback ( szPath, pFindData, nDepth, lParam ) ;
            if ( nResult > 0 ) continue ;
            // ŗ񋓂~ĂATufBNg̗񋓂͌p
            if ( nResult < 0 ) break ;
         }

         // \̂̃m
         if ( ! pFindFiles ) {
            pFindFiles = malloc_array ( FINDFILESA, 1 ) ;
            if ( ! pFindFiles ) { IsError = 1 ; break ; }
            static const FINDFILESA FINDFILES_ZERO = { 0 } ;
            *pFindFiles = FINDFILES_ZERO ;
         }

         // fBNgo
         if ( ! IsFound ) {
            IsFound = 1 ;
            if ( ! ( dwMode & ( FINDFILES_NO_PIVOT_DIR | FINDFILES_WITHPATH ) ) ) {
               strcpy ( szLastPart, "" ) ;
               if ( *szFileName && StoreStringA ( & pFindFiles->StoredNames, szFileName ) ) { IsError = 1 ; break ; }
            }
            GetStringPositionA ( pFindFiles->StoredNames, & SortStartPosition, 0 ) ;
         }

         // vt@Co
         if ( dwMode & FINDFILES_WITHPATH ) {
            strcpy ( szLastPart, szPriorName ) ;
            if ( StoreStringA ( & pFindFiles->StoredNames, szFileName ) ) { IsError = 1 ; break ; }
         }
         else {
            if ( StoreStringA ( & pFindFiles->StoredNames, szPriorName ) ) { IsError = 1 ; break ; }
         }

         if ( dwMode & FINDFILES_QUIT_AT_FIRST_FILE ) break ;

      } while ( CallFindNextFileA ( hFindFile, pFindData, & IsError ) ) ;

      FindClose ( hFindFile ) ;

      // t@C\[g
      if ( ! IsError && IsFound && dwMode & ( FINDFILES_SORT | FINDFILES_SORT_REVERSE ) ) {
         if ( SortStoredStringsA ( pFindFiles->StoredNames, & SortStartPosition, NULL, NULL, pData->dwSortMode ) ) IsError = 1 ;
      }
   }

   // G[܂͒~
   if ( IsError ) {
      CloseFindFilesA ( pFindFiles ) ;
      free ( szFileName ) ;
      return (FINDFILESA*) FINDFILES_ERROR ;
   }

   if ( dwMode & FINDFILES_QUIT_AT_FIRST_FILE && pFindFiles ) return pFindFiles ;


   // TufBNgAċAĂяosȂ
   if ( dwMode & FINDFILES_SUBDIR ) {

      strcpy ( szLastPart, "*" ) ;

      unsigned long dwModeSub = FINDFILES_DIR | FINDFILES_NO_PIVOT_DIR | ( dwMode & ( FINDFILES_SHORTNAME | FINDFILES_SORT | FINDFILES_SORT_REVERSE ) ) ;
      if ( dwMode & FINDFILES_HIDDEN_SUBDIR ) dwModeSub |= FINDFILES_HIDDEN ;

      FINDFILESA *pFindFilesSub = DoFindFilesA ( NULL, szFileName, dwModeSub, NULL, 0, 0, pData ) ;

      if ( pFindFilesSub == FINDFILES_ERROR ) {
         CloseFindFilesA ( pFindFiles ) ;
         free ( szFileName ) ;
         return (FINDFILESA*) FINDFILES_ERROR ;
      }

      // fBNg݂ꍇ
      if ( pFindFilesSub ) {

         for ( const char *szString = GetFirstFileA ( pFindFilesSub ) ; szString ; szString = GetNextFileA ( pFindFilesSub ) ) {

            strcpy ( szLastPart, szString ) ;
            strcat ( szLastPart, "\\" ) ;
            strcat ( szLastPart, szPath + ( szLastPart - szFileName ) ) ;     // GetFileNameA ( szPath )

            // ċAĂяo
            pFindFiles = DoFindFilesA ( pFindFiles, szFileName, dwMode, Callback, lParam, nDepth + 1, pData ) ;
            if ( pFindFiles == FINDFILES_ERROR ) break ;

            if ( dwMode & FINDFILES_QUIT_AT_FIRST_FILE && pFindFiles ) return pFindFiles ;
         }

         CloseFindFilesA ( pFindFilesSub ) ;
      }
   }

   free ( szFileName ) ;
   return pFindFiles ;
}



// t@Cobt@iANSIŁj
void CloseFindFilesA ( FINDFILESA *pFindFiles ) {

   if ( ! pFindFiles || pFindFiles == FINDFILES_ERROR ) return ;

   FreeStoredStringsA ( & pFindFiles->StoredNames ) ;
   free ( pFindFiles ) ;
}



// t@Cobt@̃t@ČԂiANSIŁj
size_t GetFilesCountA ( FINDFILESA *pFindFiles ) {

   if ( pFindFiles == NULL || pFindFiles == FINDFILES_ERROR ) return 0 ;

   return GetStringsCountA ( pFindFiles->StoredNames ) ;
}



// t@Cobt@ŏ̃t@CԂiANSIŁj
// t@CȂ΁ANULL Ԃ
const char *GetFirstFileA ( FINDFILESA *pFindFiles ) {

   if ( pFindFiles == NULL || pFindFiles == FINDFILES_ERROR ) return NULL ;

   return GetFirstStringA ( pFindFiles->StoredNames ) ;
}



// t@Cobt@玟̃t@CԂiANSIŁj
// t@CȂ΁ANULL Ԃ
// GetFirstFile () ĂяoOȂA͕s
const char *GetNextFileA ( FINDFILESA *pFindFiles ) {

   if ( pFindFiles == NULL || pFindFiles == FINDFILES_ERROR ) return NULL ;

   return GetNextStringA ( pFindFiles->StoredNames ) ;
}



// "."  ".." Ȃ 0 ȊOԂ
static inline int IsDotDirectoryA ( const char *szString ) {
   if ( 1 ) {
      return ( *szString == '.' && ( ! *( szString + 1 ) || *( szString + 1 ) == '.' && ! *( szString + 2 ) ) ) ;
   }
   else {
      return ( ! strcmp ( szString, "." ) || ! strcmp ( szString, ".." ) ) ;
   }
}



// t@CfBNg 0 ȊOAȂ 0 Ԃ
static int IsFoundAnyFileA ( const char *szPath, int IsFindHidden, int IsExcludeDir ) {

   int nResult = 0 ;
   int IsError = 0 ;

   WIN32_FIND_DATAA FindData ;

   HANDLE hFindFile = CallFindFirstFileA ( szPath, & FindData, & IsError, 0 ) ;
   if ( hFindFile != INVALID_HANDLE_VALUE ) {
      do {

         if ( FindData.dwFileAttributes & ( FILE_ATTRIBUTE_HIDDEN | FILE_ATTRIBUTE_SYSTEM ) ) {
            if ( ! IsFindHidden ) continue ;
         }
         if ( FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) {
            if ( IsExcludeDir ) continue ;
            if ( IsDotDirectoryA ( FindData.cFileName ) ) continue ;
         }

         nResult = 1 ;
         break ;

      } while ( CallFindNextFileA ( hFindFile, & FindData, & IsError ) ) ;

      FindClose ( hFindFile ) ;
   }

   return nResult ;
}



// ߂l FindFirstFile () Ɠ
// G[NApIsError  0 ȊOi[
static inline HANDLE CallFindFirstFileA ( const char *szFileName, WIN32_FIND_DATAA *pFindData, int *pIsError, int IsUseOldFunc ) {

#if _WIN32_WINNT < 0x400
   typedef enum { FindExInfoStandard } FINDEX_INFO_LEVELS ;
   typedef enum { FindExSearchNameMatch } FINDEX_SEARCH_OPS ;
#endif
#if _WIN32_WINNT < 0x601
   const FINDEX_INFO_LEVELS FindExInfoBasic = (FINDEX_INFO_LEVELS) 1 ;
#endif

#if _WIN32_WINNT < 0x400 || REQUIRED_MINIMUM_WINVER < 0x500
   typedef HANDLE ( WINAPI *FINDFIRSTFILEEXA ) ( LPCSTR lpFileName, FINDEX_INFO_LEVELS fInfoLevelId, LPVOID lpFindFileData, FINDEX_SEARCH_OPS fSearchOp, LPVOID lpSearchFilter, DWORD dwAdditionalFlags ) ;
   static FINDFIRSTFILEEXA FindFirstFileExA ;
   static int IsTried ;

   if ( ! IsUseOldFunc && IsWin7orLater () ) {
      if ( ! IsTried ) {
#ifdef _MT
         EnterCriticalSection ( & LoadDllSection ) ;
         __try {
#endif
            HINSTANCE hKernel32 = GetModuleHandleA ( "KERNEL32.DLL" ) ;
            GETPROCADDRESS ( hKernel32, FINDFIRSTFILEEXA, FindFirstFileExA ) ;
            IsTried = 1 ;
#ifdef _MT
         } __finally {
            LeaveCriticalSection ( & LoadDllSection ) ;
         }
#endif
      }
      if ( ! FindFirstFileExA ) IsUseOldFunc = 1 ;
   }
#endif


   HANDLE hFindFile ;
   if ( ! IsUseOldFunc && IsWin7orLater () ) hFindFile = FindFirstFileExA ( szFileName, FindExInfoBasic, pFindData, FindExSearchNameMatch, NULL, 0 ) ;
   else                                      hFindFile = FindFirstFileA ( szFileName, pFindData ) ;
   if ( hFindFile == INVALID_HANDLE_VALUE ) {
      switch ( GetLastError () ) {
         case ERROR_NOT_ENOUGH_MEMORY :
         case ERROR_MORE_DATA :
            *pIsError = 1 ;
            break ;
         default :
            break ;
      }
   }

   return hFindFile ;
}



// ߂l FindNextFile () Ɠ
// G[NApIsError  0 ȊOi[
static inline int CallFindNextFileA ( HANDLE hFindFile, WIN32_FIND_DATAA *pFindData, int *pIsError ) {

   BOOL nRetValue = FindNextFileA ( hFindFile, pFindData ) ;
   if ( ! nRetValue ) {
      switch ( GetLastError () ) {
         case ERROR_NOT_ENOUGH_MEMORY :
         case ERROR_MORE_DATA :
            *pIsError = 1 ;
            break ;
         default :
            break ;
      }
   }

   return nRetValue ;
}



////////////////////////////////////////////
//               UNICODE                //
////////////////////////////////////////////



// FINDFILES \
struct FINDFILESW_TAG {
   STOREDSTRINGSW *StoredNames ;    // t@C
} ;



// p
typedef struct {
   WIN32_FIND_DATAW *pFindData ;
   volatile const int *pIsAbort ;
   unsigned long dwSortMode ;
} DATAW ;



static FINDFILESW *DoFindFilesW ( FINDFILESW *pFindFiles, const wchar_t *szPath, unsigned long dwMode, FINDFILES_CALLBACKW Callback, LPARAM lParam, int nDepth, DATAW *pData ) ;
static inline int IsDotDirectoryW ( const wchar_t *szString ) ;



// t@CEfBNg񋓂iUNICODEŁj
// t@CȂANULLԂ
// G[NAobt@ FINDFILES_ERROR Ԃ
// pIsAbort ̎QƂϐ 0 ȊOɂȂAobt@ FINDFILES_ERROR ԂiNULLłj
// fBNǧn߂OAуt@CƂAR[obN֐ĂяoiNULLłj
// OɃR[obN֐ĂяoƂ́ApFindData  NULL n
// R[obN֐ 0 ԂA񋓂p
//                    ԂÃt@Cr
//                    ԂÃfBNg̗񋓂~
// 񋓒~̌ʂTufBNgɋyԂǂ́AR[obN֐Ăяo_ɂ
FINDFILESW *FindFilesW ( const wchar_t *szPath, unsigned long dwMode, volatile const int *pIsAbort, FINDFILES_CALLBACKW Callback, LPARAM lParam ) {

   const wchar_t *szLastPart = GetFileNameW ( szPath ) ;
   if ( ! szLastPart || IsDotDirectoryW ( szLastPart ) ) return NULL ;

   DATAW Data = { 0 } ;

   WIN32_FIND_DATAW FindData ;
   Data.pFindData = & FindData ;

   static const int IsAbortDummy = 0 ;
   Data.pIsAbort = ( pIsAbort ) ? pIsAbort : & IsAbortDummy ;

   // t@CfBNg̎w肪Ȃ΃t@Cw
   if ( ! ( dwMode & ( FINDFILES_FILE | FINDFILES_DIR ) ) ) dwMode |= FINDFILES_FILE ;

   if ( dwMode & FINDFILES_NO_EMPTY_DIR && dwMode & FINDFILES_ONLY_EMPTY_DIR ) dwMode &= ~ FINDFILES_DIR ;


   // \[gp[hI
   if ( IsWinXPorLater () && ! ( dwMode & ( FINDFILES_SORT_NUMERIC | FINDFILES_SORT_CLASSIC ) ) ) dwMode |= FINDFILES_SORT_NUMERIC ;
   if ( dwMode & FINDFILES_SORT_NUMERIC ) Data.dwSortMode |= STORESTR_SORT_NUMERICAL ;
   if ( dwMode & FINDFILES_SORT_REVERSE ) Data.dwSortMode |= STORESTR_SORT_REVERSE ;
   if ( ! ( Data.dwSortMode & STORESTR_SORT_NUMERICAL ) ) Data.dwSortMode |= STORESTR_SORT_SYSTEM ;


   return DoFindFilesW ( NULL, szPath, dwMode, Callback, lParam, 0, & Data ) ;
}



static int IsFoundAnyFileW ( const wchar_t *szPath, int IsFindHidden, int IsExcludeDir ) ;
static inline HANDLE CallFindFirstFileW ( const wchar_t *szFileName, WIN32_FIND_DATAW *pFindData, int *pIsError, int IsUseOldFunc ) ;
static inline int CallFindNextFileW ( HANDLE hFindFile, WIN32_FIND_DATAW *pFindData, int *pIsError ) ;



// FindFiles () ̉֐
// ċAĂяo
static FINDFILESW *DoFindFilesW ( FINDFILESW *pFindFiles, const wchar_t *szPath, unsigned long dwMode, FINDFILES_CALLBACKW Callback, LPARAM lParam, int nDepth, DATAW *pData ) {

   if ( pFindFiles == FINDFILES_ERROR ) return (FINDFILESW*) FINDFILES_ERROR ;

   if ( *pData->pIsAbort ) {
      CloseFindFilesW ( pFindFiles ) ;
      return (FINDFILESW*) FINDFILES_ERROR ;
   }

   // ŗ񋓂~ATufBNg̗񋓂~
   if ( Callback && Callback ( szPath, NULL, nDepth, lParam ) < 0 ) return pFindFiles ;


   WIN32_FIND_DATAW *const pFindData = pData->pFindData ;

   wchar_t *szFileName = wcsdup_expand ( szPath, MAX_PATH_LONG, MAX_PATH + 8 ) ; // TufBNg \* 邽
   if ( ! szFileName ) {
      CloseFindFilesW ( pFindFiles ) ;
      return (FINDFILESW*) FINDFILES_ERROR ;
   }
   wchar_t *szLastPart = GetFileNameW ( szFileName ) ;


   int IsError = 0 ;

   // ̃fBNg̃t@C
   HANDLE hFindFile = CallFindFirstFileW ( szPath, pFindData, & IsError, dwMode & FINDFILES_SHORTNAME ) ;
   if ( hFindFile != INVALID_HANDLE_VALUE ) {

      int IsFound = 0 ;
      STOREDSTRINGS_POSITION SortStartPosition = { 0 } ;

      do {

         if ( *pData->pIsAbort ) { IsError = 1 ; break ; }

         if ( pFindData->dwFileAttributes & ( FILE_ATTRIBUTE_HIDDEN | FILE_ATTRIBUTE_SYSTEM ) ) {
            if ( ! ( dwMode & FINDFILES_HIDDEN ) ) continue ;
         }

         if ( pFindData->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) {

            if ( ! ( dwMode & FINDFILES_DIR ) ) continue ;
            if ( IsDotDirectoryW ( pFindData->cFileName ) ) continue ;

            // ̃fBNg
            if ( dwMode & ( FINDFILES_NO_EMPTY_DIR | FINDFILES_ONLY_EMPTY_DIR ) ) {
               wcscpy ( szLastPart, pFindData->cFileName ) ;
               wcscat ( szLastPart, L"\\*" ) ;
               if ( dwMode & FINDFILES_NO_EMPTY_DIR && ! IsFoundAnyFileW ( szFileName, dwMode & FINDFILES_HIDDEN, 1 ) ) continue ;
               if ( dwMode & FINDFILES_ONLY_EMPTY_DIR && IsFoundAnyFileW ( szFileName, dwMode & FINDFILES_HIDDEN, 0 ) ) continue ;
            }
         }
         else {
            if ( ! ( dwMode & FINDFILES_FILE ) ) continue ;
         }

         // Ot@CƃV[gt@ĈǂD
         wchar_t *szPriorName = ( dwMode & FINDFILES_SHORTNAME ) ? pFindData->cAlternateFileName : pFindData->cFileName ;
         wchar_t *szAlternateName = ( dwMode & FINDFILES_SHORTNAME ) ? pFindData->cFileName : pFindData->cAlternateFileName ;
         if ( ! *szPriorName && *szAlternateName ) szPriorName = szAlternateName ;

         if ( Callback ) {
            int nResult = Callback ( szPath, pFindData, nDepth, lParam ) ;
            if ( nResult > 0 ) continue ;
            // ŗ񋓂~ĂATufBNg̗񋓂͌p
            if ( nResult < 0 ) break ;
         }

         // \̂̃m
         if ( ! pFindFiles ) {
            pFindFiles = malloc_array ( FINDFILESW, 1 ) ;
            if ( ! pFindFiles ) { IsError = 1 ; break ; }
            static const FINDFILESW FINDFILES_ZERO = { 0 } ;
            *pFindFiles = FINDFILES_ZERO ;
         }

         // fBNgo
         if ( ! IsFound ) {
            IsFound = 1 ;
            if ( ! ( dwMode & ( FINDFILES_NO_PIVOT_DIR | FINDFILES_WITHPATH ) ) ) {
               wcscpy ( szLastPart, L"" ) ;
               if ( *szFileName && StoreStringW ( & pFindFiles->StoredNames, szFileName ) ) { IsError = 1 ; break ; }
            }
            GetStringPositionW ( pFindFiles->StoredNames, & SortStartPosition, 0 ) ;
         }

         // vt@Co
         if ( dwMode & FINDFILES_WITHPATH ) {
            wcscpy ( szLastPart, szPriorName ) ;
            if ( StoreStringW ( & pFindFiles->StoredNames, szFileName ) ) { IsError = 1 ; break ; }
         }
         else {
            if ( StoreStringW ( & pFindFiles->StoredNames, szPriorName ) ) { IsError = 1 ; break ; }
         }

         if ( dwMode & FINDFILES_QUIT_AT_FIRST_FILE ) break ;

      } while ( CallFindNextFileW ( hFindFile, pFindData, & IsError ) ) ;

      FindClose ( hFindFile ) ;

      // t@C\[g
      if ( ! IsError && IsFound && dwMode & ( FINDFILES_SORT | FINDFILES_SORT_REVERSE ) ) {
         if ( SortStoredStringsW ( pFindFiles->StoredNames, & SortStartPosition, NULL, NULL, pData->dwSortMode ) ) IsError = 1 ;
      }
   }

   // G[܂͒~
   if ( IsError ) {
      CloseFindFilesW ( pFindFiles ) ;
      free ( szFileName ) ;
      return (FINDFILESW*) FINDFILES_ERROR ;
   }

   if ( dwMode & FINDFILES_QUIT_AT_FIRST_FILE && pFindFiles ) return pFindFiles ;


   // TufBNgAċAĂяosȂ
   if ( dwMode & FINDFILES_SUBDIR ) {

      wcscpy ( szLastPart, L"*" ) ;

      unsigned long dwModeSub = FINDFILES_DIR | FINDFILES_NO_PIVOT_DIR | ( dwMode & ( FINDFILES_SHORTNAME | FINDFILES_SORT | FINDFILES_SORT_REVERSE ) ) ;
      if ( dwMode & FINDFILES_HIDDEN_SUBDIR ) dwModeSub |= FINDFILES_HIDDEN ;

      FINDFILESW *pFindFilesSub = DoFindFilesW ( NULL, szFileName, dwModeSub, NULL, 0, 0, pData ) ;

      if ( pFindFilesSub == FINDFILES_ERROR ) {
         CloseFindFilesW ( pFindFiles ) ;
         free ( szFileName ) ;
         return (FINDFILESW*) FINDFILES_ERROR ;
      }

      // fBNg݂ꍇ
      if ( pFindFilesSub ) {

         for ( const wchar_t *szString = GetFirstFileW ( pFindFilesSub ) ; szString ; szString = GetNextFileW ( pFindFilesSub ) ) {

            wcscpy ( szLastPart, szString ) ;
            wcscat ( szLastPart, L"\\" ) ;
            wcscat ( szLastPart, szPath + ( szLastPart - szFileName ) ) ;     // GetFileNameW ( szPath )

            // ċAĂяo
            pFindFiles = DoFindFilesW ( pFindFiles, szFileName, dwMode, Callback, lParam, nDepth + 1, pData ) ;
            if ( pFindFiles == FINDFILES_ERROR ) break ;

            if ( dwMode & FINDFILES_QUIT_AT_FIRST_FILE && pFindFiles ) return pFindFiles ;
         }

         CloseFindFilesW ( pFindFilesSub ) ;
      }
   }

   free ( szFileName ) ;
   return pFindFiles ;
}



// t@Cobt@iUNICODEŁj
void CloseFindFilesW ( FINDFILESW *pFindFiles ) {

   if ( ! pFindFiles || pFindFiles == FINDFILES_ERROR ) return ;

   FreeStoredStringsW ( & pFindFiles->StoredNames ) ;
   free ( pFindFiles ) ;
}



// t@Cobt@̃t@ČԂiUNICODEŁj
size_t GetFilesCountW ( FINDFILESW *pFindFiles ) {

   if ( pFindFiles == NULL || pFindFiles == FINDFILES_ERROR ) return 0 ;

   return GetStringsCountW ( pFindFiles->StoredNames ) ;
}



// t@Cobt@ŏ̃t@CԂiUNICODEŁj
// t@CȂ΁ANULL Ԃ
const wchar_t *GetFirstFileW ( FINDFILESW *pFindFiles ) {

   if ( pFindFiles == NULL || pFindFiles == FINDFILES_ERROR ) return NULL ;

   return GetFirstStringW ( pFindFiles->StoredNames ) ;
}



// t@Cobt@玟̃t@CԂiUNICODEŁj
// t@CȂ΁ANULL Ԃ
// GetFirstFile () ĂяoOȂA͕s
const wchar_t *GetNextFileW ( FINDFILESW *pFindFiles ) {

   if ( pFindFiles == NULL || pFindFiles == FINDFILES_ERROR ) return NULL ;

   return GetNextStringW ( pFindFiles->StoredNames ) ;
}



// "."  ".." Ȃ 0 ȊOԂ
static inline int IsDotDirectoryW ( const wchar_t *szString ) {
   if ( 1 ) {
      return ( *szString == '.' && ( ! *( szString + 1 ) || *( szString + 1 ) == '.' && ! *( szString + 2 ) ) ) ;
   }
   else {
      return ( ! wcscmp ( szString, L"." ) || ! wcscmp ( szString, L".." ) ) ;
   }
}



// t@CfBNg 0 ȊOAȂ 0 Ԃ
static int IsFoundAnyFileW ( const wchar_t *szPath, int IsFindHidden, int IsExcludeDir ) {

   int nResult = 0 ;
   int IsError = 0 ;

   WIN32_FIND_DATAW FindData ;

   HANDLE hFindFile = CallFindFirstFileW ( szPath, & FindData, & IsError, 0 ) ;
   if ( hFindFile != INVALID_HANDLE_VALUE ) {
      do {

         if ( FindData.dwFileAttributes & ( FILE_ATTRIBUTE_HIDDEN | FILE_ATTRIBUTE_SYSTEM ) ) {
            if ( ! IsFindHidden ) continue ;
         }
         if ( FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) {
            if ( IsExcludeDir ) continue ;
            if ( IsDotDirectoryW ( FindData.cFileName ) ) continue ;
         }

         nResult = 1 ;
         break ;

      } while ( CallFindNextFileW ( hFindFile, & FindData, & IsError ) ) ;

      FindClose ( hFindFile ) ;
   }

   return nResult ;
}



// ߂l FindFirstFile () Ɠ
// G[NApIsError  0 ȊOi[
static inline HANDLE CallFindFirstFileW ( const wchar_t *szFileName, WIN32_FIND_DATAW *pFindData, int *pIsError, int IsUseOldFunc ) {

#if _WIN32_WINNT < 0x400
   typedef enum { FindExInfoStandard } FINDEX_INFO_LEVELS ;
   typedef enum { FindExSearchNameMatch } FINDEX_SEARCH_OPS ;
#endif
#if _WIN32_WINNT < 0x601
   const FINDEX_INFO_LEVELS FindExInfoBasic = (FINDEX_INFO_LEVELS) 1 ;
#endif

#if _WIN32_WINNT < 0x400 || REQUIRED_MINIMUM_WINVER < 0x500
   typedef HANDLE ( WINAPI *FINDFIRSTFILEEXW ) ( LPCWSTR lpFileName, FINDEX_INFO_LEVELS fInfoLevelId, LPVOID lpFindFileData, FINDEX_SEARCH_OPS fSearchOp, LPVOID lpSearchFilter, DWORD dwAdditionalFlags ) ;
   static FINDFIRSTFILEEXW FindFirstFileExW ;
   static int IsTried ;

   if ( ! IsUseOldFunc && IsWin7orLater () ) {
      if ( ! IsTried ) {
#ifdef _MT
         EnterCriticalSection ( & LoadDllSection ) ;
         __try {
#endif
            HINSTANCE hKernel32 = GetModuleHandleW ( L"KERNEL32.DLL" ) ;
            GETPROCADDRESS ( hKernel32, FINDFIRSTFILEEXW, FindFirstFileExW ) ;
            IsTried = 1 ;
#ifdef _MT
         } __finally {
            LeaveCriticalSection ( & LoadDllSection ) ;
         }
#endif
      }
      if ( ! FindFirstFileExW ) IsUseOldFunc = 1 ;
   }
#endif


   HANDLE hFindFile ;
   if ( ! IsUseOldFunc && IsWin7orLater () ) hFindFile = FindFirstFileExW ( szFileName, FindExInfoBasic, pFindData, FindExSearchNameMatch, NULL, 0 ) ;
   else                                      hFindFile = FindFirstFileW ( szFileName, pFindData ) ;
   if ( hFindFile == INVALID_HANDLE_VALUE ) {
      switch ( GetLastError () ) {
         case ERROR_NOT_ENOUGH_MEMORY :
         case ERROR_MORE_DATA :
            *pIsError = 1 ;
            break ;
         default :
            break ;
      }
   }

   return hFindFile ;
}



// ߂l FindNextFile () Ɠ
// G[NApIsError  0 ȊOi[
static inline int CallFindNextFileW ( HANDLE hFindFile, WIN32_FIND_DATAW *pFindData, int *pIsError ) {

   BOOL nRetValue = FindNextFileW ( hFindFile, pFindData ) ;
   if ( ! nRetValue ) {
      switch ( GetLastError () ) {
         case ERROR_NOT_ENOUGH_MEMORY :
         case ERROR_MORE_DATA :
            *pIsError = 1 ;
            break ;
         default :
            break ;
      }
   }

   return nRetValue ;
}



