#This is a makefile for nmake.exe

OUTDIR=Release_x64
OBJDIR=Release_x64
PROGRAM=delete.exe

ALL : "$(OUTDIR)" "$(OBJDIR)" "$(OUTDIR)\$(PROGRAM)"

CLEAN :
	-@erase "$(OBJDIR)\access.obj"
	-@erase "$(OBJDIR)\ask.obj"
	-@erase "$(OBJDIR)\delete.obj"
	-@erase "$(OBJDIR)\filename.obj"
	-@erase "$(OBJDIR)\findfile.obj"
	-@erase "$(OBJDIR)\int64.obj"
	-@erase "$(OBJDIR)\longpath.obj"
	-@erase "$(OBJDIR)\oemio.obj"
	-@erase "$(OBJDIR)\res.obj"
	-@erase "$(OBJDIR)\shfileop.obj"
	-@erase "$(OBJDIR)\storestr.obj"
	-@erase "$(OBJDIR)\stringex.obj"
	-@erase "$(OBJDIR)\systime.obj"
	-@erase "$(OBJDIR)\winmain.obj"
	-@erase "$(OBJDIR)\delete.res"
	-@erase "$(OBJDIR)\$(PROGRAM).tmp"

"$(OUTDIR)" :
	if not exist "$(OUTDIR)"\ mkdir "$(OUTDIR)"

CC=cl.exe
CCFLAGS=/nologo /c /W3 /O2 /Ob1i- /EHsc /D __STDC__=1 /D "_CRT_DISABLE_PERFCRIT_LOCKS" /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /Fo"$(OBJDIR)\\"

.cpp{$(OBJDIR)}.obj::
	$(CC) @<<
	$(CCFLAGS) $<
<<

RC=rc.exe
RCFLAGS=/l 0x411 /d "NDEBUG" /n

LD=link.exe
LDFLAGS=kernel32.lib user32.lib gdi32.lib comdlg32.lib comctl32.lib shell32.lib ole32.lib oleaut32.lib advapi32.lib winmm.lib /nologo /opt:ref /opt:icf /subsystem:console
OBJS= "$(OBJDIR)\access.obj" "$(OBJDIR)\ask.obj" "$(OBJDIR)\delete.obj" "$(OBJDIR)\filename.obj" "$(OBJDIR)\findfile.obj" "$(OBJDIR)\int64.obj" "$(OBJDIR)\longpath.obj" "$(OBJDIR)\oemio.obj" "$(OBJDIR)\res.obj" "$(OBJDIR)\shfileop.obj" "$(OBJDIR)\storestr.obj" "$(OBJDIR)\stringex.obj" "$(OBJDIR)\systime.obj" "$(OBJDIR)\winmain.obj" "$(OBJDIR)\delete.res"

"$(OUTDIR)\$(PROGRAM)" : $(OBJS) "delete_x64.xml"
	$(LD) @<<
	$(LDFLAGS) /out:"$(OBJDIR)\$(PROGRAM).tmp" $(OBJS)
<<
	mt.exe -nologo -manifest "delete_x64.xml" -outputresource:"$(OBJDIR)\$(PROGRAM).tmp";1
	move /y >nul "$(OBJDIR)\$(PROGRAM).tmp" $@

"$(OBJDIR)\access.obj" : access.cpp msc.h access.h filename.h
"$(OBJDIR)\ask.obj" : ask.cpp msc.h ask.h oemio.h
"$(OBJDIR)\delete.obj" : delete.cpp msc.h access.h ask.h filename.h findfile.h int64.h longpath.h oemio.h res.h resource.h shfileop.h stringex.h systime.h winmain.h
"$(OBJDIR)\filename.obj" : filename.cpp msc.h filename.h
"$(OBJDIR)\findfile.obj" : findfile.cpp msc.h filename.h findfile.h storestr.h
"$(OBJDIR)\int64.obj" : int64.cpp msc.h int64.h
"$(OBJDIR)\longpath.obj" : longpath.cpp msc.h longpath.h
"$(OBJDIR)\oemio.obj" : oemio.cpp msc.h oemio.h
"$(OBJDIR)\res.obj" : res.cpp msc.h res.h
"$(OBJDIR)\shfileop.obj" : shfileop.cpp msc.h shfileop.h
"$(OBJDIR)\storestr.obj" : storestr.cpp msc.h storestr.h
"$(OBJDIR)\stringex.obj" : stringex.cpp msc.h stringex.h
"$(OBJDIR)\systime.obj" : systime.cpp msc.h systime.h
"$(OBJDIR)\winmain.obj" : winmain.cpp msc.h winmain.h
"$(OBJDIR)\delete.res" : delete.rc resource.h msc.h
	$(RC) $(RCFLAGS) /fo$@ delete.rc

