// ask.cpp

#include <windows.h>
#include <stdio.h>
#include "msc.h"
#include "ask.h"
#include "oemio.h"



static int InterpretConsoleKey ( int nType ) ;



// R\[L[擾AOK  CHANCELԂiANSIŁj
// bZ[W͕WG[o͂ɕ\
// W͂_CNgĂ 0 Ԃ
// nType  MB_OK ̏ꍇF         ^C  1AȊO 0 Ԃ
// nType  MB_OKCANCEL ̏ꍇF   ^C  ESC  1AȊO 0 Ԃ
// nType  MB_YESNO ̏ꍇF      ^CEESCEN  1AENTEREY  0 Ԃ
// nType  MB_YESNOCANCEL ̏ꍇF^CEESC  -1AN  1AENTEREY  0 Ԃ
int AskA ( const char *szMessage, int nType ) {

   // bZ[Wo͂ꍇ
   if ( szMessage && *szMessage ) {

      if ( fisatty ( stdout ) ) fflush ( stdout ) ;
      fflush ( stderr ) ;

      fputs ( szMessage, stderr ) ;
      fflush ( stderr ) ;

      int nResult = InterpretConsoleKey ( nType ) ;

      console_clear_line ( 1 ) ;

      return nResult ;
   }

   // bZ[Wo͂Ȃꍇ
   return InterpretConsoleKey ( nType ) ;
}



// R\[L[擾AOK  CHANCELԂiUNICODEŁj
// bZ[W͕WG[o͂ɕ\
// W͂_CNgĂ 0 Ԃ
// nType  MB_OK ̏ꍇF      ^C  1AȊO 0 Ԃ
// nType  MB_OKCANCEL ̏ꍇF^C  ESC  1AȊO 0 Ԃ
// nType  MB_YESNO ̏ꍇF   ^CEESCEN  1AENTEREY  0 Ԃ
int AskW ( const wchar_t *szMessage, int nType ) {

   // bZ[Wo͂ꍇ
   if ( szMessage && *szMessage ) {

      if ( fisatty ( stdout ) ) fflush ( stdout ) ;
      fflush ( stderr ) ;

      fputws ( szMessage, stderr ) ;
      fflush ( stderr ) ;

      int nResult = InterpretConsoleKey ( nType ) ;

      console_clear_line ( 1 ) ;

      return nResult ;
   }

   // bZ[Wo͂Ȃꍇ
   return InterpretConsoleKey ( nType ) ;
}



static int ReadConsoleKey ( HANDLE hConsole, int *pVirtualKey, int *pShiftKeyStatus ) ;

#define CHAR_RETURN  '\r'
#define CHAR_ESCAPE  0x1B
#define CHAR_CTRL_C  0x03



// L[擾A0  1 Ԃ
// W͂_CNgĂ 0 Ԃ
static int InterpretConsoleKey ( int nType ) {


   // W͂
   HANDLE hConsole = fget_osfhandle ( stdin ) ;

   unsigned long dwOldMode ;
   if ( ! GetConsoleMode ( hConsole, & dwOldMode ) ) return 0 ;   // error

   FlushConsoleInputBuffer ( hConsole ) ;
   SetConsoleMode ( hConsole, 0 ) ;    // ^C ̉߂𖳌ɂ


   int nResult = 0 ;


   while ( 1 ) {

      int nVirtualKey, nShiftKeyStatus ;
      int C = ReadConsoleKey ( hConsole, & nVirtualKey, & nShiftKeyStatus ) ;

      if ( nType == MB_YESNOCANCEL ) {
         if ( C == 'Y' || C == 'y' || C == CHAR_RETURN ) {
            break ;
         }
         if ( C == 'N' || C == 'n' ) {
            nResult = 1 ;
            break ;
         }
         if ( C == CHAR_ESCAPE || C == CHAR_CTRL_C ) {
            nResult = -1 ;
            break ;
         }
      }

      if ( nType == MB_YESNO ) {
         if ( C == 'Y' || C == 'y' || C == CHAR_RETURN ) {
            break ;
         }
         if ( C == 'N' || C == 'n' || C == CHAR_ESCAPE || C == CHAR_CTRL_C ) {
            nResult = 1 ;
            break ;
         }
      }

      if ( nType == MB_OKCANCEL ) {
         if ( C == CHAR_CTRL_C || C == CHAR_ESCAPE ) {
            nResult = 1 ;
            break ;
         }
         if ( C || nVirtualKey ) {
            break ;
         }
      }

      if ( nType == MB_OK ) {
         if ( C == CHAR_CTRL_C ) {
            nResult = 1 ;
            break ;
         }
         if ( C || nVirtualKey ) {
            break ;
         }
      }

   }


   FlushConsoleInputBuffer ( hConsole ) ;
   SetConsoleMode ( hConsole, dwOldMode ) ;


   return nResult ;
}



//    ̓L[    C     VirtualKey  ShiftKeyStatus
//    'a'         61,      41,      00
//    'A'         41,      41,      10
//    SPACE       20,      20,      00
//    ENTER       0D,      0D,      00
//    CTRL+C      03,      43,      08
//    ESCAPE      1B,      1B,      00



static int ReadConsoleKey ( HANDLE hConsole, int *pVirtualKey, int *pShiftKeyStatus ) {

   if ( pVirtualKey ) *pVirtualKey = 0 ;
   if ( pShiftKeyStatus ) *pShiftKeyStatus = 0 ;


   INPUT_RECORD InputRecord ;
   int C = 0 ;

   while ( 1 ) {
      unsigned long nReadLength ;
      if ( IsNT () ) {
         if ( ! ReadConsoleInputW ( hConsole, & InputRecord, 1, & nReadLength ) || ! nReadLength ) break ;  // error
         if ( InputRecord.EventType == KEY_EVENT && InputRecord.Event.KeyEvent.bKeyDown ) {
            C = (wchar_t) InputRecord.Event.KeyEvent.uChar.UnicodeChar ;
            break ;
         }
      }
      else {
         if ( ! ReadConsoleInputA ( hConsole, & InputRecord, 1, & nReadLength ) || ! nReadLength ) break ;  // error
         if ( InputRecord.EventType == KEY_EVENT && InputRecord.Event.KeyEvent.bKeyDown ) {
            C = (unsigned char) InputRecord.Event.KeyEvent.uChar.AsciiChar ;
            break ;
         }
      }
   }

   if ( pVirtualKey ) {
      switch ( InputRecord.Event.KeyEvent.wVirtualKeyCode ) {
         case VK_CAPITAL :    // CAPS LOCK key
         case VK_MENU :       // ALT key
         case VK_CONTROL :    // CTRL key
         case VK_SHIFT :      // SHIFT key
         case VK_NUMLOCK :    // NUM LOCK key
         case VK_SCROLL :     // SCROLL LOCK key
            break ;
         default :
            *pVirtualKey = InputRecord.Event.KeyEvent.wVirtualKeyCode ;
            break ;
      }
   }

   if ( pShiftKeyStatus ) {
      *pShiftKeyStatus = ( InputRecord.Event.KeyEvent.dwControlKeyState & ( RIGHT_ALT_PRESSED | LEFT_ALT_PRESSED | RIGHT_CTRL_PRESSED | LEFT_CTRL_PRESSED | SHIFT_PRESSED ) ) ;
   }

   return C ;
}



#ifdef TEST_ASK_CPP
int TestAsk ( void ) {

   // W͂
   HANDLE hConsole = fget_osfhandle ( stdin ) ;

   unsigned long dwOldMode ;
   if ( ! GetConsoleMode ( hConsole, & dwOldMode ) ) return 0 ;   // error

   FlushConsoleInputBuffer ( hConsole ) ;
   SetConsoleMode ( hConsole, 0 ) ;    // ^C ̉߂𖳌ɂ


   fprintf ( stderr, "Press ESC to exist...\n" ) ;


   while ( 1 ) {
      int nVirtualKey, nShiftKeyStatus ;
      int C = ReadConsoleKey ( hConsole, & nVirtualKey, & nShiftKeyStatus ) ;
      printf ( "%02X, %02X, %02X\n", C, nVirtualKey, nShiftKeyStatus ) ;
      if ( nVirtualKey == VK_ESCAPE ) break ;
   }


   FlushConsoleInputBuffer ( hConsole ) ;
   SetConsoleMode ( hConsole, dwOldMode ) ;

   return 0 ;
}
#endif



