' Debug monitor program for PicBasic Pro 2.2+
'  Requires PICmicro with hardware serial port

DEBUG_STACK     var     byte bank0 system       ' Stack level
DEBUG_ADDRESS   var     word bank0 system       ' Program address
debugchar       var     byte bank0      ' Debug monitor command character
debugflags      var     byte bank0      ' Debug monitor flags
debugi          var     byte    bank0   ' Loop counter

        DEBUG_STACK = 0         ' Start stack level at 0
        debugflags = 0          ' Zero all debug flags
        Goto skipdebug          ' Skip around debug monitor

debugmon:
        ' Check for single step mode
        If debugflags.0 Then
                Hserout [ihex DEBUG_ADDRESS, $d, $a]    ' Display program address
                Goto debugloop  ' Go to command loop
        Endif

        ' Check for trace on
        If debugflags.1 Then
                Hserout [ihex DEBUG_ADDRESS, $d, $a]    ' Display program address
        Endif

        ' Check for monitor command from serial in
        Hserin 0, exitdebug, [debugchar]
        If debugchar != "m" Then exitdebug


' Main debug monitor loop to get command and execute
debugloop:
        ' Wait for command
        Hserout ["?"]           ' Display prompt
        Hserin [debugchar]      ' Get command character
        Hserout [debugchar, $d, $a]     ' Echo command character to display

        ' Interpret command
        Lookdown debugchar, ["dghrst"], debugchar
        Branch debugchar, [debugdump, debuggo, debughelp, debugreset, debugstep, debugtrace]

        Hserout ["Invalid command", $d, $a]
        Goto debugloop

' Dump - display stack level and register contents
debugdump:
        Hserout ["Stack level: ", #DEBUG_STACK] ' Display stack level

        For debugi = $0 to $7f  ' Display all registers in bank 0
                If (debugi // 16) = 0 Then
                        Hserout [$d, $a, hex2 debugi, ":"]      ' Display address
                Endif
                Peek debugi, debugchar  ' Read variable
                Hserout [" ", hex2 debugchar]   ' Display variable
        Next debugi
        Hserout [$d, $a]        ' Send cr lf

        Goto debugloop

' Help - display commands
debughelp:
        Hserout ["Debug Monitor ver. .1", $d, $a]
        Hserout ["d - display registers", $d, $a]
        Hserout ["g - go", $d, $a]
        Hserout ["h - help", $d, $a]
        Hserout ["m - enter monitor", $d, $a]
        Hserout ["r - run from reset", $d, $a]
        Hserout ["s - single step", $d, $a]
        Hserout ["t - trace", $d, $a]
        Goto debugloop

' Go - return to program execution
debuggo:
        debugflags.0 = 0        ' Step off
        debugflags.1 = 0        ' Trace off
        Goto exitdebug

' Reset - start program over from reset address
debugreset:
  asm
        clrf    PCLATH
        goto    0
  endasm

' Step - single step one program instruction
debugstep:
        debugflags.0 = 1        ' Step on
        debugflags.1 = 0        ' Trace off
        Goto exitdebug

' Trace - run program displaying instruction addresses
debugtrace:
        debugflags.0 = 0        ' Step off
        debugflags.1 = 1        ' Trace on
'        Goto exitdebug

exitdebug:
' End of debug monitor routine - go back to main program
  asm
        movf    DEBUG_ADDRESS + 1, W    ; Set PCLATH with top byte of return address
        movwf   PCLATH
        movf    DEBUG_ADDRESS, W        ; Go back to main program
        movwf   PCL
  endasm

skipdebug:
        On Debug Goto debugmon
