// (C) All copyrights reserved by Seiko I ASIC Co., Ltd. 2001.
// We prepared this sample software in order that a customer evaluates our product.
// We promise nothing that a actually product of a customer
// includes this sample software and the part.
//

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// for Microsoft C/C++ Optimizing Compiler Version 8.00c.
//cl /AL /c sspt10.c
//cl /AL /c s7601a.c
//link sspt10+s7601a,sspt,,, /ST:10000

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#define DEBUG	0

// Define TRUE and FALSE
#define TRUE    1
#define FALSE   0

typedef unsigned char U8;
typedef unsigned int  U16;

// SoftWare setting for PC
#define TEXT_SIZE 4096
#define BUF_SIZE  TEXT_SIZE + 4

// HardWare setting for Chip
#define CLK  1000000L
#define BAUD   38400L

#define REMOTE_PORT  7

#define USER "test"
#define PASS "test"

#define TOUT_SP_DATA         10
#define TOUT_DIAL_UP        260
#define TOUT_PPP_UP         180
#define TOUT_PPP_DOWN        20


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// header files
#include <stdio.h>
#include <process.h>
#include <conio.h>
#include <ctype.h>
#undef toupper
#include <string.h>
#include <time.h>

#include "s7601a.h"
#include "exfunc.h"


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// internal function prototypes
int  SPSampTerminal(long);

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void main(void)
{
	int keyin = 0;
	char str[32];
	U8 rip[4], lip[4];
	U16 lport;

	printf("SII Serial Port sample program easy Terminal Ver.1.0\n");
	printf("for S-7601A ISA SDK Board 2.x\n");
	printf("(C) All copyrights reserved by Seiko I ASIC Co., Ltd. 2001.\n");
	printf("\n");

	SoftReset();

	DialDown_STD_MODEM();
    DialDisConnect_STD_MODEM(FALSE);
	#if DEBUG
		DISP_Rev();
	#endif
	ChipConf(CLK);
	#if DEBUG
		DISP_Div();
	#endif
	
	#if DEBUG
		DISP_SP_Rev();
	#endif
	SPConf(CLK, BAUD, TRUE);
	index_write(INDEX_PPP, SP_Int_En, 0x60);
	if(SPSampTerminal(TOUT_SP_DATA) == FALSE){
		printf("\n");
		FailExit("Serial Port : ");
	}
	else{
		printf("\n");
	}
	if(DialConnect_STD_MODEM(TOUT_DIAL_UP) == FALSE){
		printf("\n");
		ToutExit("Dial Up : ");
	}
	SPBufClr();

	#if DEBUG
		DISP_PPP_Rev();
	#endif
	PPPPreConf_PAP(lip);
	PPPConf_PAP(lip, FALSE, TRUE, USER, PASS);
	PPPUp_PAP(TRUE);
	PPPConnect(TOUT_PPP_UP);

	while(1){
		printf("\n");
		printf("**** Menu ****    Key in Character    A : Application   E : Exit\n");
		while(1){
			if(kbhit() != 0){
				break;
			}
			if(isSPException_STD_MODEM() == TRUE){
				printf("\n");
				FailExit("Serial Port : ");
			}
			if(isPPPException(str, TOUT_PPP_DOWN) == TRUE){
				printf("\n");
				FailExit(str);
			}
		}
		keyin = toupper(getch());
		if (keyin == 'A')
		{
			printf("%c\n", keyin);
			printf("\n");
			printf("Please refer to the other sample program.\n");
		}
		else if (keyin == 'E')
		{
			printf("%c\n", keyin);
			printf("\n");
			PPPDown();
			PPPDisConnect(TOUT_PPP_DOWN);
			if(SPSampTerminal(TOUT_SP_DATA) == FALSE){
				printf("\n");
				FailExit("Serial Port : ");
			}
			else{
				printf("\n");
			}
			DialDown_STD_MODEM();
			DialDisConnect_STD_MODEM(FALSE);
			SPBufClr();
			
			SoftReset();
			printf("Normaly End\n");
			exit(0);
		}
		else{
			printf("\n");
		}
	}
}


//---------------------------------------------------------------------------
int SPSampTerminal(long mtout)
// mtout	MPU Timer Timeout for data send (sec). FALSE : Infinity
// return	TRUE : Serial Port Normal, FALSE : Serial Port Abnormal
{
	U8 data, spint;
	U8 buf[BUF_SIZE];
	unsigned int buflen, offset;
	int bufval, tab, lf, esc; 
	long starttime, nowtime;
	int startdata, nodata;
	U8 mem_index;
	int rtc;
	
	mem_index = x_read(Index);
	x_write(Index, INDEX_PPP);
	
	data = x_read(SP_Conf);
	data = data & 0x20;
	x_write(SP_Conf, data);
	SPBufClr();
	
	printf("\n");
	printf("Key in text.\n");
	printf("And end with \"Enter\" for Send data with CR ( 0x0D ).\n");
	printf("Or end with \"Ctrl + Enter\" for Send data without CR ( 0x0D ).\n");
	printf("Key in \"Tab\" for exit Terminal mode.\n");
	printf("\n");

	bufval = FALSE;
	buflen = 0;
	offset = 0;
	startdata = FALSE;
	nodata = TRUE;
	tab = FALSE;
	lf = FALSE;
	esc = FALSE;
	while(1){
		if(nodata == TRUE){
			KeyinStr(&bufval, &buflen, buf, &tab, &lf, &esc, FALSE);
			if(esc == TRUE){
				EscExit();
			}
			if((lf == TRUE) && (buflen != 0)){
				if(bufval == FALSE){
					printf("\n");
					lf = FALSE;
					bufval = TRUE;
				}
			}
		}
		else{
			if(isESC() == TRUE){
				EscExit();
			}
		}
		spint = x_read(SP_Int);
		if(startdata == TRUE){
		 	if((spint & 0x40) != 0){
				startdata = FALSE;
				if(offset == buflen){
					bufval = FALSE;
					buflen = 0;
					offset = 0;
					nodata = TRUE;
				}
			}
		}
		while((x_read(SP_Int) & 0x20) != 0){
			data = x_read(SP_Data);
			printf("%c", data);
		}
		if(startdata == TRUE){
			if(mtout != FALSE){
				time(&nowtime);
				if(nowtime - starttime >= mtout){
					printf("\n");
					printf("MPU Timer Timeout occur ( DATA Send ).\n");
					rtc = FALSE;
					break;
				}
			}
		}
		else if(tab == TRUE){
			rtc = TRUE;
			break;
		}
		if((spint & 0x40) != 0){
			if((startdata == FALSE) && (bufval == TRUE)){
				time(&starttime);
				startdata = TRUE;
				nodata = FALSE;
				x_write(SP_Data, buf[offset]);
				offset = offset + 1;
				continue;
			}
		}
	}

	x_write(Index, mem_index);

	return(rtc);
}


