// (C) All copyrights reserved by Seiko I ASIC Co., Ltd. 2001.
// We prepared this sample software in order that a customer evaluates our product.
// We promise nothing that a actually product of a customer
// includes this sample software and the part.
//

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// for Microsoft C/C++ Optimizing Compiler Version 8.00c.
//cl /AL /c stes10.c
//cl /AL /c s7601a.c
//link stes10+s7601a,stes,,, /ST:10000

#define DEBUG	0

// Define TRUE and FALSE
#define TRUE    1
#define FALSE   0

typedef unsigned char U8;
typedef unsigned int  U16;

// HardWare setting for Chip
#define CLK  1000000L
#define BAUD   38400L

// Custom Value
#define LOCAL_PORT 7
#define REMOTE_PORT 0

#define USER "test"
#define PASS "test"

#define TOUT_DIAL_DOWN        5
#define TOUT_PPP_UP         180
#define TOUT_PPP_DOWN        20
#define TOUT_SOC_BUSY        60
#define TOUT_TCP_ACT_SERV FALSE
#define TOUT_TCP_DATA       360
#define TOUT_TCP_FIN        360
#define TOUT_TCP_TIME_WAIT    5

// DEFAULT Value
#define DEF_DELAY_ACK   0x00
#define DEF_TCLK_EN     FALSE
#define DEF_TCLK_DIV    0x03e7


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// header files
#include <stdio.h>
#include <process.h>
#include <conio.h>
#include <ctype.h>
#undef toupper
#include <string.h>
#include <time.h>

#include "s7601a.h"
#include "exfunc.h"


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int  TCPSampEcho_Serv(U8, long);
void TCPRecv(U8);
void TCPSend(U8);
void TCPSendFin(U8);

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void main(void)
{
	char str[32];
	U8 rip[4], lip[4];
	U16 lport;

	printf("SII Tcp sample program easy Echo Server Ver.1.0\n");
	printf("for S-7601A ISA SDK Board 2.x\n");
	printf("(C) All copyrights reserved by Seiko I ASIC Co., Ltd. 2001.\n");
	printf("\n");

	SoftReset();

	DialDown_NULL_MODEM();
    DialDisConnect_NULL_MODEM(TOUT_DIAL_DOWN);
	#if DEBUG
		DISP_Rev();
	#endif
	ChipConf(CLK);
	#if DEBUG
		DISP_Div();
	#endif
	
	#if DEBUG
		DISP_SP_Rev();
	#endif
	SPConf(CLK, BAUD, TRUE);
	DialUp_NULL_MODEM();
	DialConnect_NULL_MODEM(FALSE);

	#if DEBUG
		DISP_PPP_Rev();
	#endif
	PPPPreConf_PAP(lip);
	PPPConf_PAP(lip, FALSE, TRUE, USER, PASS);
	PPPUp_PAP(TRUE);
	PPPConnect(TOUT_PPP_UP);

	while(1){
		printf("\n");
		if(isSPException_NULL_MODEM() == TRUE){
			printf("\n");
			FailExit("Serial Port : ");
		}
		if(isPPPException(str, TOUT_PPP_DOWN) == TRUE){
			printf("\n");
			FailExit(str);
		}

		SocPreConf(SOC0, &lport, rip);
		lport = LOCAL_PORT;
		SocConf(SOC0, TCP_SERV_MODE, lport, FALSE, rip, FALSE, REMOTE_PORT);
		TCPTimerConf(SOC0, DEF_DELAY_ACK, DEF_TCLK_EN, DEF_TCLK_DIV);
		TCPAct(SOC0);
		if(TCPConnect(SOC0, TOUT_TCP_ACT_SERV) == FALSE){
			SocReset(SOC0, TOUT_SOC_BUSY);
			#if DEBUG
				DISP_TCP_Stat(SOC0, TRUE);
			#endif
			continue;
		}
		if(TCPSampEcho_Serv(SOC0, TOUT_TCP_DATA) == FALSE){
			printf("\n");
			SocReset(SOC0, TOUT_SOC_BUSY);
			#if DEBUG
				DISP_TCP_Stat(SOC0, TRUE);
			#endif
			continue;
		}
		else{
			printf("\n");
			if(TCPDisConnect(SOC0, TOUT_TCP_FIN, TOUT_TCP_TIME_WAIT) == FALSE){
				SocReset(SOC0, TOUT_SOC_BUSY);
				#if DEBUG
					DISP_TCP_Stat(SOC0, TRUE);
				#endif
				continue;
			}
			else{
				SocReset(SOC0, TOUT_SOC_BUSY);
				#if DEBUG
					DISP_TCP_Stat(SOC0, TRUE);
				#endif
				continue;
			}
		}
	}
}

//---------------------------------------------------------------------------
int TCPSampEcho_Serv(U8 soc, long mtout)
// soc		Socket number
// mtout	MPU Timer Timeout for data send (sec). FALSE : Infinity
// return	TRUE : Return After send FIN, FALSE : Socket Abnormal
{
	U8 data, stat0, stat1;
	char str[32];
	int sndfin; 
	long starttime, nowtime;
	int startdata;
	int keyin;

	if(isSPException_NULL_MODEM() == TRUE){
		FailExit("Serial Port : ");
	}
	if(isPPPException(str, TOUT_PPP_DOWN) == TRUE){
		FailExit(str);
	}
	#if DEBUG
		DISP_TCP_Stat(soc, TRUE);
	#endif
	if(TCPStat(soc) != ESTABLISHED){
		printf("Socket%d ", soc);
		FailExit("Check state before TCP Communication : ");
	}
	#if DEBUG
		DISP_TCP_Stat(soc, TRUE);
	#endif
	printf("\n");
	printf("If Key in \"Tab\", Send FIN and Change status to LISTEN\n");
	printf("\n");

	sndfin = FALSE;
	startdata = FALSE;
	while(1){
		if(isSPException_NULL_MODEM() == TRUE){
			printf("\n");
			FailExit("Serial Port : ");
		}
		if(isPPPException(str, TOUT_PPP_DOWN) == TRUE){
			printf("\n");
			FailExit(str);
		}
		if(startdata == FALSE){
			if(kbhit() != 0){
				keyin = getch();
				if(keyin == 0x1b){
					EscExit();
				}
				if(keyin == 0x09){
					sndfin = TRUE;
				}
			}
		}
		else{
			if(isESC() == TRUE){
				EscExit();
			}
		}
		if(startdata == FALSE){
			TCPRecv(soc);
		}
		stat0 = index_read(soc, Soc_Stat0);
		stat1 = index_read(soc, Soc_Stat1);
		if(startdata == TRUE){
		 	if((stat0 & 0x40) != 0){
				startdata = FALSE;
			}
		}
		if((stat1 & 0x40) != 0){
			printf("\n");
			printf("TCP RST Received\n");
			return(FALSE);
		}
		if((stat0 & 0x80) != 0){
			printf("\n");
			printf("TCP Timeout occur.\n");
			return(FALSE);
		}
		if((startdata == TRUE) && (mtout != FALSE)){
			time(&nowtime);
			if(nowtime - starttime >= mtout){
				printf("\n");
				printf("MPU Timer Timeout occur ( DATA Send ).\n");
				return(FALSE);
			}
		}
		if((stat0 & 0x40) == 0){
			if(startdata == FALSE){
				time(&starttime);
				startdata = TRUE;
				TCPSend(soc);
				continue;
			}
		}
		if((stat0 & 0x10) == 0){
			if((stat1 & 0x20) != 0){
				data = TCPStat(soc);
				if (data == CLOSE_WAIT){
					TCPSendFin(soc);
					return(TRUE);
				}
			}
			if(sndfin == TRUE){
				data = TCPStat(soc);
				if (data == ESTABLISHED){
					TCPSendFin(soc);
					return(TRUE);
				}
			}
		}
		if((stat1 & 0x80) != 0){
			// URG
			continue;
		}
		else if((stat1 & 0x10) != 0){
			// Con_Up
			continue;
		}
	}
}


//---------------------------------------------------------------------------
// Receive DATA from buffer and Display
void TCPRecv(U8 soc)
// soc		Socket number
{
	U8 data;
	U8 mem_index;
	
	mem_index = x_read(Index);
	x_write(Index, soc);
	
	while(((x_read(Soc_Stat0) & 0x10) != 0) && (x_read_w(Buff_Out0) != 0)){
		data = x_read(Soc_Data);
		x_write(Soc_Data, data);
		printf("%c", data);
	}
	
	x_write(Index, mem_index);
}


//---------------------------------------------------------------------------
// Send DATA from buffer
void TCPSend(U8 soc)
// soc		Socket number
{
	index_write(soc, Soc_Com, 0x01);
}


//---------------------------------------------------------------------------
// TCP Socket DisConnection Request
void TCPSendFin(U8 soc)
// soc		Socket number
{
	U8 tmp;
	
	tmp = x_read(Soc_Act);
	tmp = tmp & ~(0x01 << soc);
	x_write(Soc_Act, tmp);

}


