// (C) All copyrights reserved by Seiko I ASIC Co., Ltd. 2001.
// We prepared this sample software in order that a customer evaluates our product.
// We promise nothing that a actually product of a customer
// includes this sample software and the part.
//

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// for Microsoft C/C++ Optimizing Compiler Version 8.00c.
//cl /AL /c s7601a.c

#define DEBUG	0

// Define TRUE and FALSE
#define TRUE    1
#define FALSE   0

typedef unsigned char U8;
typedef unsigned int  U16;


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// header files
#include <stdio.h>
#include <process.h>
#include <conio.h>
#include <ctype.h>
#undef toupper
#include <string.h>
#include <time.h>

#include "s7601a.h"
#include "exfunc.h"


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//---------------------------------------------------------------------------
int TCPConnect(U8 soc, long mtout)
// soc		Socket number
// mtout	MPU Timer Timeout (sec). FALSE : Infinity
// return	TRUE : Success, FALSE : Timeout
{
	U8 data, stat0;
	long starttime, nowtime;
	char str[32];

	if(isSPException_NULL_MODEM() == TRUE){
		FailExit("Serial Port : ");
	}
	if(isPPPException(str, TOUT_PPP_DOWN) == TRUE){
		FailExit(str);
	}
	#if DEBUG
		DISP_TCP_Stat(soc, TRUE);
	#endif
	time(&starttime);
	while(1){
		if(isSPException_NULL_MODEM() == TRUE){
			FailExit("Serial Port : ");
		}
		if(isPPPException(str, TOUT_PPP_DOWN) == TRUE){
			FailExit(str);
		}
		if(mtout != FALSE){
			time(&nowtime);
			if(nowtime - starttime >= mtout){
				printf("MPU Timer Timeout occur.\n");
				return(FALSE);
			}
		}
		if(isESC() == TRUE){
			EscExit();
		}
		stat0 = index_read(soc, Soc_Stat0);
		if((stat0 & 0x80) != 0){
			printf("TCP Timeout occur.\n");
			return(FALSE);
		}
		data = TCPStat(soc);
		if(data == ESTABLISHED){
			break;
		}
		switch(data){
			case CLOSE_WAIT :   FailExit("CLOSE_WAIT : ");
							  break;
			case LAST_ACK   :   FailExit("LAST_ACK : ");
							  break;
			case FIN_WAIT1  :   FailExit("FIN_WAIT1 : ");
							  break;
			case FIN_WAIT2  :   FailExit("FIN_WAIT2 : ");
							  break;
			case CLOSING    :   FailExit("CLOSING : ");
							  break;
			case TIME_WAIT  :   FailExit("TIME_WAIT : ");
							  break;
			case LISTEN     :
			case CLOSED     :
			case SYN_SENT   :
			case SYN_RECVD  :
			default         : break;
		}
		#if DEBUG
			DISP_TCP_Stat(soc, FALSE);
		#endif
	}
	#if DEBUG
		DISP_TCP_Stat(soc, TRUE);
	#endif
	PPPInfo();
	SocInfo(soc);
	return(TRUE);
}


//---------------------------------------------------------------------------
int TCPDisConnect(U8 soc, long mtout, long mtoclose)
// soc		Socket number
// mtout	MPU Timer Timeout for FIN send (sec). FALSE : Infinity
// mtoclose	MPU Timer Timeout for TIME_WAIT to CLOSED (sec). FALSE : Infinity
// return	TRUE : Success CLOSED, FALSE : Socket Abnormal
{
	U8 data, stat0, stat1;
	long starttime, nowtime;
	long timewait;
	char str[32];

	if(isSPException_NULL_MODEM() == TRUE){
		FailExit("Serial Port : ");
	}
	if(isPPPException(str, TOUT_PPP_DOWN) == TRUE){
		FailExit(str);
	}
	#if DEBUG
		DISP_TCP_Stat(soc, TRUE);
	#endif
	data = TCPStat(soc);
	if(data == CLOSED){
		return(TRUE);
	}
	if((data == ESTABLISHED) ||
	   (data == FIN_WAIT1)   ||
	   (data == FIN_WAIT2)   ||
	   (data == CLOSING)     ||
	   (data == TIME_WAIT)   ||
	   (data == CLOSE_WAIT)  ||
	   (data == LAST_ACK)){
		time(&starttime);
		while(1){
			if(isSPException_NULL_MODEM() == TRUE){
				FailExit("Serial Port : ");
			}
			if(isPPPException(str, TOUT_PPP_DOWN) == TRUE){
				FailExit(str);
			}
			stat0 = index_read(soc, Soc_Stat0);
			stat1 = index_read(soc, Soc_Stat1);
			if((stat1 & 0x40) != 0){
				printf("TCP RST Received\n");
				return(FALSE);
			}
			if((stat0 & 0x80) != 0){
				printf("TCP Timeout occur.\n");
				return(FALSE);
			}
			if(mtout != FALSE){
				time(&nowtime);
				if(nowtime - starttime >= mtout){
					printf("MPU Timer Timeout occur.\n");
					return(FALSE);
				}
			}
			if(isESC() == TRUE){
				EscExit();
			}
			data = TCPStat(soc);
			if(data == CLOSED){
				#if DEBUG
					DISP_TCP_Stat(soc, TRUE);
				#endif
				return(TRUE);
			}
			switch(data){
				case TIME_WAIT  : if(mtoclose == FALSE){
								      break;
								  }
								  time(&timewait);
								  while(1){
									  if(isSPException_NULL_MODEM() == TRUE){
										  FailExit("Serial Port : ");
									  }
									  if(isPPPException(str, TOUT_PPP_DOWN) == TRUE){
										  FailExit(str);
									  }
									  if(isESC() == TRUE){
										  EscExit();
									  }
									  stat0 = index_read(soc, Soc_Stat0);
									  stat1 = index_read(soc, Soc_Stat1);
									  if((stat1 & 0x40) != 0){
										  printf("TCP RST Received\n");
										  return(FALSE);
									  }
									  if((stat0 & 0x80) != 0){
										  printf("TCP Timeout occur.\n");
										  return(FALSE);
									  }
									  if((stat0 & 0x10) != 0){
										  printf("TCP Received Delayed DATA packet.\n");
										  return(FALSE);
									  }
									  #if DEBUG
									      DISP_TCP_Stat(soc, FALSE);
									  #endif
									  data = TCPStat(soc);
									  if(data == CLOSED){
										  #if DEBUG
										      DISP_TCP_Stat(soc, TRUE);
										  #endif
										  return(TRUE);
									  }
									  if(data != TIME_WAIT){
										  #if DEBUG
										      DISP_TCP_Stat(soc, TRUE);
										  #endif
									      return(FALSE);
									  }
									  else{
										  time(&nowtime);
										  if(nowtime - timewait >= mtoclose){
											  #if DEBUG
											      DISP_TCP_Stat(soc, TRUE);
											  #endif
											  return(FALSE);
										  }
									  }
								  }
								  break;
				case CLOSE_WAIT :
				case LAST_ACK   :
				case FIN_WAIT1  :
				case FIN_WAIT2  :
				case CLOSING    : 
								  stat0 = index_read(soc, Soc_Stat0);
								  if((stat0 & 0x10) != 0){
									  printf("TCP Received Delayed DATA packet.\n");
									  return(FALSE);
								  }
								  break;
				case ESTABLISHED: break;
				case LISTEN     :
				case CLOSED     :
				case SYN_SENT   :
				case SYN_RECVD  :
				default         : 
								  #if DEBUG
									  DISP_TCP_Stat(soc, TRUE);
								  #endif
								  return(FALSE);
			}
			#if DEBUG
				DISP_TCP_Stat(soc, FALSE);
			#endif
		}
	}
	else{
		return(FALSE);
	}
}


//---------------------------------------------------------------------------
void TCPTimerConf(U8 soc, U8 delayack, U8 tclken, U16 tclkdiv)
// soc		Socket number
// delayack	Delayed ACK Control
// tclken	TRUE : TCP Clk Divider Enable
// tclkdiv	TCP Clk Divider value
{
	index_write(soc, Delayed_Ack, delayack);
	
	index_write(SOC0, Tcp_Clk_En, tclken);
	if(tclken == TRUE){
		index_write_w(SOC0, Tcp_Div0, tclkdiv);
	}
	
}


//---------------------------------------------------------------------------
// TCP Socket Connection Request
void TCPAct(U8 soc)
// soc		Socket number
{
	char str[32];
	U8 tmp;
	U8 mem_index;
	
	mem_index = x_read(Index);
	x_write(Index, soc);
	
	if(isSPException_NULL_MODEM() == TRUE){
		FailExit("Serial Port : ");
	}
	if(isPPPException(str, TOUT_PPP_DOWN) == TRUE){
		FailExit(str);
	}
	#if DEBUG
		DISP_TCP_Stat(soc, TRUE);
	#endif
	if(TCPStat(soc) != CLOSED){
		printf("Socket%d ", soc);
		FailExit("Check state before TCP Active : ");
	}
	printf("Waiting for Socket%d TCP Active ... \n", soc);
	#if DEBUG
		DISP_TCP_Stat(soc, TRUE);
	#endif
	tmp = x_read(Soc_Act);
	tmp = tmp | (0x01 << soc);
	x_write(Soc_Act, tmp);

	x_write(Index, mem_index);
}


//---------------------------------------------------------------------------
// TCP State
U8  TCPStat(U8 soc)
// soc		Socket number
// return	TCP State
{
	U8 data;

	data = index_read(soc, Soc_Stat2) & 0x0f;
	return(data);
}


//---------------------------------------------------------------------------
// TCP State to Definition string
void TCP_Stat2Str(U8 stat, char *str)
// stat		TCP State
// str		Definition string
{
	switch(stat){
		case(0x00) : strcpy(str, "CLOSED");
					 break;
		case(0x01) : strcpy(str, "SYN_SENT");
					 break;
		case(0x02) : strcpy(str, "ESTABLISHED");
					 break;
		case(0x03) : strcpy(str, "CLOSE_WAIT");
					 break;
		case(0x04) : strcpy(str, "LAST_ACK");
					 break;
		case(0x05) : strcpy(str, "FIN_WAIT1");
					 break;
		case(0x06) : strcpy(str, "FIN_WAIT2");
					 break;
		case(0x07) : strcpy(str, "CLOSING");
					 break;
		case(0x08) : strcpy(str, "TIME_WAIT");
					 break;
		case(0x09) : strcpy(str, "LISTEN");
					 break;
		case(0x0a) : strcpy(str, "SYN_RECVD");
					 break;
		default    : strcpy(str, "  N/A   ");
					 break;
	}
}


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//---------------------------------------------------------------------------
// UDP Socket Active
void UDPAct(U8 soc)
// soc		Socket number
{
	char str[32];
	U8 tmp;
	
	if(isSPException_NULL_MODEM() == TRUE){
		FailExit("Serial Port : ");
	}
	if(isPPPException(str, TOUT_PPP_DOWN) == TRUE){
		FailExit(str);
	}
	printf("Socket%d UDP Active ... \n", soc);
	tmp = x_read(Soc_Act);
	tmp = tmp | (0x01 << soc);
	x_write(Soc_Act, tmp);
}


//---------------------------------------------------------------------------
// Display UDP Socket Information
void UDPSocInfo(U8 soc)
// soc		Socket number
{
	U8 mem_index;
	U8 data[4];
	U16 dataw;

	mem_index = x_read(Index);
	x_write(Index, soc);

	printf("UDP Socket%d Information\n", soc);

	printf("Local  Port Number : ");
	dataw = x_read_w(Local_Port0);
	printf("0x%04X,      %d\n", dataw, dataw);

	printf("Remote IP Address  : ");
	data[0] = x_read(Remote_Ip0);
	data[1] = x_read(Remote_Ip1);
	data[2] = x_read(Remote_Ip2);
	data[3] = x_read(Remote_Ip3);
	printf("%02X-%02X-%02X-%02X, ",data[3], data[2], data[1], data[0]);
	printf("%d.%d.%d.%d\n",data[3], data[2], data[1], data[0]);
	
	printf("Remote Port Number : ");
	dataw = x_read_w(Remote_Port0);
	printf("0x%04X,      %d\n", dataw, dataw);

	x_write(Index, mem_index);
}


//---------------------------------------------------------------------------
// Display UDP Receive data Information
void UDPRcvInfo(unsigned int length, unsigned int csum)
// length	UDP data length
// csum		Check Sum
{
	printf("Data Length        : 0x%04X,      %d\n", length, length);
	printf("Check Sum          : 0x%04X\n", csum);
}


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//---------------------------------------------------------------------------
void SocConf(U8 soc, U8 type, U16 lport, int ripen, U8 *rip, int rporten, U16 rport)
// soc		Socket number
// type		Socket type
// lport	Local Port number
// ripen	Remote IP address setting enable
// rip		Remote IP address
// rporten	Remote Port number setting enable
// rport	Remote Port number
{
	U8 mem_index;
	
	mem_index = x_read(Index);
	x_write(Index, soc);

	x_write(Soc_Conf, type);
	
	x_write_w(Local_Port0, lport);
	
	if(ripen == TRUE){
		x_write(Remote_Ip0, rip[0]);
		x_write(Remote_Ip1, rip[1]);
		x_write(Remote_Ip2, rip[2]);
		x_write(Remote_Ip3, rip[3]);
	}
	
	if(rporten == TRUE){
		x_write_w(Remote_Port0, rport);
	}
	
	x_write(Soc_Int_En0, DEF_SOC_INT_EN0);
	x_write(Soc_Int_En1, DEF_SOC_INT_EN1);
	x_write(Soc_Tos, DEF_TOS);
	
	x_write(Index, mem_index);
}


//---------------------------------------------------------------------------
void SocPreConf(U8 soc, U16 *lport, U8 *rip)
// soc		Socket number
// lport	local port number
// rip		remote IP address
{
	SocReset(soc, TOUT_SOC_BUSY);
	*lport = index_read_w(soc, Local_Port0);
	*lport = *lport + 1;
	*lport = *lport & 0x0fff;
	switch(soc){
		case SOC0 : *lport = *lport | 0x1000;
					break;
		case SOC1 : *lport = *lport | 0x2000;
					break;
	}
	
	#if DEBUG
		DISP_TCP_Stat(soc, TRUE);
	#endif
	rip[0] = REMOTE_IP0;
	rip[1] = REMOTE_IP1;
	rip[2] = REMOTE_IP2;
	rip[3] = REMOTE_IP3;
}


//---------------------------------------------------------------------------
void SocReset(U8 soc, long mtout)
// soc		Socket number
// mtout	MPU Timer Timeout (sec). FALSE : Infinity
{
	U16 lport;
	long starttime, nowtime;

	#if DEBUG
		DISP_Soc_Rev(soc);
	#endif
	printf("Waiting for Socket%d Reset ... \n", soc);
	time(&starttime);
	while(1){
		if(mtout != FALSE){
			time(&nowtime);
			if(nowtime - starttime >= mtout){
				ToutExit("Socket Busy Infinity : ");
			}
		}
		if(isESC() == TRUE){
			EscExit();
		}
		if(isSocBusy(soc) == FALSE){
			break;
		}
	}
	lport = index_read_w(soc, Local_Port0);
	index_write(soc, Soc_Com, 0x10);
	if(lport !=  0){
		index_write_w(soc, Local_Port0, lport);
	}
}


//---------------------------------------------------------------------------
// Chack Socket Busy
int isSocBusy(U8 soc)
// soc		Socket number
// return	TRUE : Socket is Busy
{
	int data;

	data = index_read(soc, Soc_Stat2);
	data = data & 0x10;
	if(data == 0){
		return(FALSE);
	}
	else{
		return(TRUE);
	}
}


//---------------------------------------------------------------------------
// Display Socket Information
void SocInfo(U8 soc)
// soc		Socket number
{
	U8 mem_index;
	U8 data[4];
	U16 dataw;

	mem_index = x_read(Index);
	x_write(Index, soc);

	printf("Socket%d Information\n", soc);

	printf("Local  Port Number : ");
	dataw = x_read_w(Local_Port0);
	printf("0x%04X,      %d\n", dataw, dataw);

	printf("Remote IP Address  : ");
	data[0] = x_read(Remote_Ip0);
	data[1] = x_read(Remote_Ip1);
	data[2] = x_read(Remote_Ip2);
	data[3] = x_read(Remote_Ip3);
	printf("%02X-%02X-%02X-%02X, ",data[3], data[2], data[1], data[0]);
	printf("%d.%d.%d.%d\n",data[3], data[2], data[1], data[0]);
	
	printf("Remote Port Number : ");
	dataw = x_read_w(Remote_Port0);
	printf("0x%04X,      %d\n", dataw, dataw);

	printf("MSS                : ");
	dataw = x_read_w(Soc_Mss0);
	printf("0x%04X,      %d\n", dataw, dataw);

	x_write(Index, mem_index);
}


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//---------------------------------------------------------------------------
void PPPConnect(long mtout)
// mtout	MPU Timer Timeout (sec). FALSE : Infinity
{
	U8 data;
	long starttime, nowtime;

	if(isSPException_NULL_MODEM() == TRUE){
		FailExit("Serial Port : ");
	}
	#if DEBUG
		DISP_PPP_Stat(TRUE);
	#endif
	time(&starttime);
	while(1){
		if(isSPException_NULL_MODEM() == TRUE){
			FailExit("Serial Port : ");
		}
		if(mtout != FALSE){
			time(&nowtime);
			if(nowtime - starttime >= mtout){
				ToutExit("PPP connection phase : ");
			}
		}
		if(isESC() == TRUE){
			EscExit();
		}
		data = PPPCode();
		if(data == PPP_UP){
			break;
		}
		switch(data){
			case FAIL_LCP : FailExit("PPP LCP phase : ");
							break;
			case FAIL_NCP : FailExit("PPP NCP phase : ");
							break;
			case FAIL_PAP : FailExit("PPP PAP phase : ");
							break;
			case PPP_DOWN : FailExit("PPP Unexpected DOWN : ");
							break;
			case CHAP_CHA : ChapExit("CHALLENGE : ");
							break;
			case CHAP_ACK : ChapExit("ACK : ");
							break;
			case CHAP_NAK : ChapExit("NAK : ");
							break;
			case RESERVED :
			case TERM_RCV :
			default       : break;
		}
		#if DEBUG
			DISP_PPP_Stat(FALSE);
		#endif
	}
	#if DEBUG
		DISP_PPP_Stat(TRUE);
	#endif
	PPPInfo();
}


//---------------------------------------------------------------------------
void PPPDisConnect(long mtout)
// mtout	MPU Timer Timeout (sec). FALSE : Infinity
{
	U8 data;
	long starttime, nowtime;

	if(isSPException_NULL_MODEM() == TRUE){
		FailExit("Serial Port : ");
	}
	#if DEBUG
		DISP_PPP_Stat(TRUE);
	#endif
	time(&starttime);
	while(1){
		if(isSPException_NULL_MODEM() == TRUE){
			FailExit("Serial Port : ");
		}
		if(mtout != FALSE){
			time(&nowtime);
			if(nowtime - starttime >= mtout){
				printf("MPU Timer Timeout occur.\n");
				break;
			}
		}
		if(isESC() == TRUE){
			EscExit();
		}
		data = PPPCode();
		if(isPPPDown() == TRUE){
			#if DEBUG
				DISP_PPP_Stat(TRUE);
			#endif
			break;
		}
		if(data == FAIL_LCP){
			printf("PPP LCP phase :  FAIL occur.\n");
			break;
		}
		switch(data){
			case FAIL_NCP : FailExit("PPP NCP phase : ");
							break;
			case FAIL_PAP : FailExit("PPP PAP phase : ");
							break;
			case CHAP_CHA : ChapExit("CHALLENGE : ");
							break;
			case CHAP_ACK : ChapExit("ACK : ");
							break;
			case CHAP_NAK : ChapExit("NAK : ");
							break;
			case RESERVED :
			case TERM_RCV :
			case PPP_UP   :
			default       : break;
		}
		#if DEBUG
			DISP_PPP_Stat(FALSE);
		#endif
	}
	index_write(INDEX_PPP, PPP_Ctrl, 0x00);
	#if DEBUG
		DISP_PPP_Stat(TRUE);
	#endif
}


//---------------------------------------------------------------------------
// PPP Configuration Value
void PPPConf_PAP(U8 *locip, int ipaden, int papen, char *user, char *pass)
// locip	Local IP Address for request to peer
// ipaden	IP Address Assignment Mode Enable
// papen	PAP Authentification Enable
// user		USER name
// pass		PASS name
{
	U8 mem_index;
	U8 tmp;
	int i, len;
	
	mem_index = x_read(Index);
	x_write(Index, INDEX_PPP);

	x_write(PPP_Ctrl, 0x81);
	x_write(LOCAL_Ip0, locip[0]);
	x_write(LOCAL_Ip1, locip[1]);
	x_write(LOCAL_Ip2, locip[2]);
	x_write(LOCAL_Ip3, locip[3]);

	if(papen == TRUE){
		x_write(PPP_Ctrl, 0x60);
		tmp = 0x1a;
		if(ipaden == TRUE){
			tmp = tmp | 0x80;
		}
		x_write(PPP_Retry, tmp);
		len = strlen(user);
		x_write(PAP_Str, (U8)(len));
		for(i = 0; i < len; i++){
			x_write(PAP_Str, (U8)(user[i]));
		}
		len = strlen(pass);
		x_write(PAP_Str, (U8)(len));
		for(i = 0; i < len; i++){
			x_write(PAP_Str, (U8)(pass[i]));
		}
	}
	else{
		x_write(PPP_Ctrl, 0x40);
		tmp = 0x0a;
		if(ipaden == TRUE){
			tmp = tmp | 0x80;
		}
		x_write(PPP_Retry, tmp);
	}

	x_write(Index, mem_index);
}


//---------------------------------------------------------------------------
void PPPPreConf_PAP(U8 *locip)
// locip	Local IP Address for request to peer
{

	#if DEBUG
		DISP_PPP_Stat(TRUE);
	#endif
	locip[0] = LOCAL_IP0;
	locip[1] = LOCAL_IP1;
	locip[2] = LOCAL_IP2;
	locip[3] = LOCAL_IP3;

}


//---------------------------------------------------------------------------
// PPP Connection Request
void PPPUp_PAP(int papen)
// papen	PAP Authentification Enable
{
	U8 mem_index;
	U8 tmp;
	
	mem_index = x_read(Index);
	x_write(Index, INDEX_PPP);

	if(isSPException_NULL_MODEM() == TRUE){
		FailExit("Serial Port : ");
	}
	#if DEBUG
		DISP_PPP_Stat(TRUE);
	#endif
	if(PPPStat() != 0x02){
		FailExit("Check state before PPP Up : ");
	}
	printf("Waiting for PPP Up ... \n");
	#if DEBUG
		DISP_PPP_Stat(TRUE);
	#endif
	tmp = x_read(SP_Conf);
	tmp = tmp & 0x20;
	tmp = tmp | 0x01;
	x_write(SP_Conf, tmp);
	tmp = 0x42;
	if(papen == TRUE){
		tmp = tmp | 0x20;
	}
	x_write(PPP_Ctrl, tmp);

	x_write(Index, mem_index);
}


//---------------------------------------------------------------------------
// PPP Disconnection Request
void PPPDown(void)
{
	U8 mem_index;
	U8 data;

	mem_index = x_read(Index);
	x_write(Index, INDEX_PPP);

	#if DEBUG
		DISP_PPP_Stat(TRUE);
	#endif
	if(PPPCode() != PPP_UP){
		FailExit("Check state before PPP Down : ");
	}
	printf("Waiting for PPP Down ... \n");
	#if DEBUG
		DISP_PPP_Stat(TRUE);
	#endif
	data = x_read(PPP_Ctrl);
	data = data & 0x68;
	x_write(PPP_Ctrl, data);
	
	x_write(Index, mem_index);
}


//---------------------------------------------------------------------------
// PPP Exception
int isPPPException(char *str, long mtout)
// return	TRUE : Exception, FALSE : Normal
// mtout	MPU Timer Timeout (sec). FALSE : Infinity
{
	U8 data;
	long starttime, nowtime;

	data = PPPCode();
	if(data == PPP_DOWN){
		#if DEBUG
			DISP_PPP_Stat(TRUE);
		#endif
		strcpy(str, "PPP DOWN : ");
		return(TRUE);
	}
	if(data == FAIL_LCP){
		#if DEBUG
			DISP_PPP_Stat(TRUE);
		#endif
		strcpy(str, "PPP LCP phase : ");
		return(TRUE);
	}
	if(data != PPP_UP){
		#if DEBUG
			DISP_PPP_Stat(TRUE);
		#endif
		time(&starttime);
		while(1){
			data = PPPCode();
			if(data == PPP_DOWN){
				#if DEBUG
					DISP_PPP_Stat(TRUE);
				#endif
				strcpy(str, "PPP DOWN : ");
				return(TRUE);
			}
			if(data == FAIL_LCP){
				#if DEBUG
					DISP_PPP_Stat(TRUE);
				#endif
				strcpy(str, "PPP LCP phase : ");
				return(TRUE);
			}
			if(mtout != FALSE){
				time(&nowtime);
				if(nowtime - starttime >= mtout){
					#if DEBUG
						DISP_PPP_Stat(TRUE);
					#endif
					strcpy(str, "PPP Code : ");
					return(TRUE);
				}
			}
		}
	}
	else{
		return(FALSE);
	}
}


//---------------------------------------------------------------------------
// Check PPP CLOSED
int  isPPPDown(void)
{
	if((PPPCode() == PPP_DOWN) && (PPPStat() ==0x02)){
		return(TRUE);
	}
	else{
		return(FALSE);
	}
}


//---------------------------------------------------------------------------
// PPP Interruput Status Code
U8  PPPCode(void)
// return	PPP Interruput Status Code
{
	U8 data;

	data = index_read(INDEX_PPP, PPP_Code);
	return(data);
}


//---------------------------------------------------------------------------
// PPP State
U8  PPPStat(void)
// return	PPP State
{
	U8 data;

	data = index_read(INDEX_PPP, PPP_Stat);
	return(data);
}


//---------------------------------------------------------------------------
// Display PPP Information
void  PPPInfo(void)
{
	U8 mem_index;
	U8 data[4];
	U16 mru;

	mem_index = x_read(Index);
	x_write(Index, INDEX_PPP);

	printf("PPP Information\n");
	printf("Local IP Address : ");
	data[0] = x_read(LOCAL_Ip0);
	data[1] = x_read(LOCAL_Ip1);
	data[2] = x_read(LOCAL_Ip2);
	data[3] = x_read(LOCAL_Ip3);
	printf("%02X-%02X-%02X-%02X, ",data[3], data[2], data[1], data[0]);
	printf("%d.%d.%d.%d\n",data[3], data[2], data[1], data[0]);
	
	printf("Peer  IP Address : ");
	data[0] = x_read(PEER_Ip0);
	data[1] = x_read(PEER_Ip1);
	data[2] = x_read(PEER_Ip2);
	data[3] = x_read(PEER_Ip3);
	printf("%02X-%02X-%02X-%02X, ",data[3], data[2], data[1], data[0]);
	printf("%d.%d.%d.%d\n",data[3], data[2], data[1], data[0]);
	
	printf("MRU              : ");
	mru = x_read_w(PPP_Mru0);
	printf("0x%04X,      %d\n", mru, mru);

	x_write(Index, mem_index);
}


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//---------------------------------------------------------------------------
void DialConnect_NULL_MODEM(long mtout)
// mtout	MPU Timer Timeout (sec). FALSE : Infinity
{
	long starttime, nowtime;

	#if DEBUG
		DISP_Baud(CLK, BAUD);
	#endif
	printf("Waiting for Dial Up ... \n");
	time(&starttime);
	while(1){
		if(mtout != FALSE){
			time(&nowtime);
			if(nowtime - starttime >= mtout){
				break;
			}
		}
		if(isESC() == TRUE){
			EscExit();
		}
		if(isDialUp_NULL_MODEM() == TRUE){
			break;
		}
	}
}


//---------------------------------------------------------------------------
void DialDisConnect_NULL_MODEM(long mtout)
// mtout	MPU Timer Timeout (sec). FALSE : Infinity
{
	long starttime, nowtime;

	printf("Waiting for Dial Down ... \n");
	time(&starttime);
	while(1){
		if(mtout != FALSE){
			time(&nowtime);
			if(nowtime - starttime >= mtout){
				break;
			}
		}
		if(isESC() == TRUE){
			EscExit();
		}
		if(isDialUp_NULL_MODEM() == FALSE){
			break;
		}
	}
}


//---------------------------------------------------------------------------
// Serial Port Configuration Value
void SPConf(unsigned long clk, unsigned long baud, int hwfcen)
// clk		Chip clock frequency
// baud		Serial Port BAUD rate
// hwfcen	HWFC enable
{
	U8  mem_index;
	U16 ratio;
	
	mem_index = x_read(Index);
	x_write(Index, INDEX_PPP);
	
	ratio = (U16)((clk / baud) - 1);
	x_write_w(SP_Baud0, ratio);
	if(hwfcen == TRUE){
		x_write(SP_Conf, 0x20);
	}
	else{
		x_write(SP_Conf, 0x00);
	}
	x_write(SP_Int_En, 0x00);
	
	x_write(Index, mem_index);
}


//---------------------------------------------------------------------------
// Dial Up for NULL MODEM
void DialUp_NULL_MODEM(void)
{
	U8 data;

	data = index_read(INDEX_PPP, SP_Conf);
	data = data & 0x20;
	index_write(INDEX_PPP, SP_Conf, data);
}


//---------------------------------------------------------------------------
// Dial Down for NULL MODEM
void DialDown_NULL_MODEM(void)
{
	U8 data;

	data = index_read(INDEX_PPP, SP_Conf);
	data = data & 0x26;
	data = data | 0x06;
	index_write(INDEX_PPP, SP_Conf, data);
}


//---------------------------------------------------------------------------
// Serial Port Exception
int  isSPException_NULL_MODEM(void)
// return	TRUE : Exception, FALSE : Normal
{
	U8	data;

	data = index_read(INDEX_PPP, SP_Stat);
	data = data & 0x20;
	if(data == 0x00){
		return(FALSE);
	}
	else{
		return(TRUE);
	}
}


//---------------------------------------------------------------------------
// Check Dial Up
int  isDialUp_NULL_MODEM(void)
// return	TRUE : Connect, FALSE : DisConnect
{
	U8	data;

	data = index_read(INDEX_PPP, SP_Stat);
	data = data & 0x20;
	if(data == 0x00){
		return(TRUE);
	}
	else{
		return(FALSE);
	}
}


//---------------------------------------------------------------------------
int DialConnect_STD_MODEM(long mtout)
// mtout	MPU Timer Timeout (sec). FALSE : Infinity
// return	TRUE : normal, FALSE : Timeout occur
{
	long starttime, nowtime;

	#if DEBUG
		DISP_Baud(CLK, BAUD);
	#endif
	printf("Waiting for Dial Up ... \n");
	time(&starttime);
	while(1){
		if(mtout != FALSE){
			time(&nowtime);
			if(nowtime - starttime >= mtout){
				return(FALSE);
			}
		}
		if(isESC() == TRUE){
			EscExit();
		}
		if(isDialUp_STD_MODEM() == TRUE){
			return(TRUE);
		}
	}
}


//---------------------------------------------------------------------------
int DialDisConnect_STD_MODEM(long mtout)
// mtout	MPU Timer Timeout (sec). FALSE : Infinity
// return	TRUE : normal, FALSE : Timeout occur
{
	long starttime, nowtime;

	printf("Waiting for Dial Down ... \n");
	time(&starttime);
	while(1){
		if(mtout != FALSE){
			time(&nowtime);
			if(nowtime - starttime >= mtout){
				return(FALSE);
			}
		}
		if(isESC() == TRUE){
			EscExit();
		}
		if(isDialUp_STD_MODEM() == FALSE){
			return(TRUE);
		}
	}
}


//---------------------------------------------------------------------------
// Dial Down for STANDARD MODEM
void DialDown_STD_MODEM(void)
{
	U8 data;

	data = index_read(INDEX_PPP, SP_Conf);
	data = data & 0x26;
	data = data | 0x06;
	index_write(INDEX_PPP, SP_Conf, data);
}


//---------------------------------------------------------------------------
// Serial Port Exception
int  isSPException_STD_MODEM(void)
// return	TRUE : Exception, FALSE : Normal
{
	U8	data;

	data = index_read(INDEX_PPP, SP_Stat);
	data = data & 0x60;
	if(data == 0x00){
		return(FALSE);
	}
	else{
		return(TRUE);
	}
}


//---------------------------------------------------------------------------
// Check Dial Up
int  isDialUp_STD_MODEM(void)
// return	TRUE : Connect, FALSE : DisConnect
{
	U8	data;

	data = index_read(INDEX_PPP, SP_Stat);
	data = data & 0x40;
	if(data == 0x00){
		return(TRUE);
	}
	else{
		return(FALSE);
	}
}


//---------------------------------------------------------------------------
// Serial Port receive buffer clear
void SPBufClr(void)
{
	U8 mem_index;
	
	mem_index = x_read(Index);
	x_write(Index, INDEX_PPP);

	printf("Serial Port receive buffer clear ... ");
	while(1){
		if(isESC() == TRUE){
			printf("\n");
			EscExit();
		}
		if((x_read(SP_Int) & 0x20) != 0){
			x_read(SP_Data);
			printf(".");

		}
		else{
			printf("\n");
			break;
		}
	}

	x_write(Index, mem_index);
}


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//---------------------------------------------------------------------------
// Chip Clock Divider Configuration Value
void ChipConf(unsigned long clk)
// clk		Chip clock frequency
{
	U16 ratio;

	ratio = (U16)((clk / 1000L) - 1);
	x_write_w(Clk_Div0, ratio);
}


//---------------------------------------------------------------------------
// Software Reset
void SoftReset(void)
{
	printf("\n");
	printf("Software Reset\n");
	x_write(Gen_Cont, 0x04);
	x_write(Index, INDEX_PPP);
	x_write(SP_Int_En, 0x00);
	x_write(Gen_Cont, 0x01);
	x_write(Gen_Cont, 0x01);
	x_write(Gen_Cont, 0x04);
	x_write(Index, INDEX_PPP);
	x_write(SP_Int, 0x10);
	x_write(SP_Conf, 0x06);
	x_write(SP_Baud0, 0x00);
	x_write(SP_Baud1, 0x00);
	x_write(Index, 0x00);
}


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//---------------------------------------------------------------------------
// Abnormal end for Timeout
void ToutExit(char *str)
// str		display strings
{
	printf("\n");
	printf("%s MPU Timer Timeout occur.\n", str);
	SoftReset();
	printf("Break!\n");
	exit(1);
}


//---------------------------------------------------------------------------
// Abnormal end for FAIL
void FailExit(char *str)
// str		display strings
{
	printf("\n");
	printf("%s FAIL occur.\n", str);
	SoftReset();
	printf("Break!\n");
	exit(1);
}


//---------------------------------------------------------------------------
// Abnormal end for CHAP
void ChapExit(char *str)
// str		display strings
{
	printf("\n");
	printf("%s CHAP packet received.\n", str);
	printf("This sample program does not support CHAP.\n");
	SoftReset();
	printf("Break!\n");
	exit(1);
}


//---------------------------------------------------------------------------
// Abnormal end for keyin ESC
void EscExit(void)
{
	printf("\n");
	printf("User key in \"Esc\"\n");
	SoftReset();
	printf("Break!\n");
	exit(0);
}


//---------------------------------------------------------------------------
// Keyin String
void KeyinStr(int *bufval, unsigned int *bufaddr, U8 *buf, 
               int *tab, int *lf, int *esc, int addLF)
// bufval	TRUE : MPU buffer valid
// bufaddr	MPU buffer pointer
// buf		MPU buffer
// tab		TRUE : Key in TAB detected
// lf		TRUE : Key in LF  detected
// esc		TRUE : Key in ESC detected
// addLF	TRUE : LF add to CR , 0x0d -> [0x0d, 0x0a]
{
	int keyin;

	if(kbhit() != 0){
		keyin = getch();
		if(keyin == 0x0d){
			printf("\n");
			buf[*bufaddr] = 0x0d;
			*bufaddr = *bufaddr + 1;
			if(addLF == TRUE){
				buf[*bufaddr] = 0x0a;
				*bufaddr = *bufaddr + 1;
			}
			*bufval = TRUE;
		}
		else if(keyin == 0x08){
			printf(" \b\b \b");
			if(*bufaddr != 0){
				*bufaddr = *bufaddr - 1;
			}
			if((*bufval == TRUE) && (*bufaddr <= 1)){
				*bufaddr = 0;
				*bufval = FALSE;
			}
		}
		else if(keyin == 0x09){
			*tab = TRUE;
		}
		else if(keyin == 0x0a){
			*lf = TRUE;
		}
		else if(keyin == 0x1b){
			*esc = TRUE;
		}
		else if(isprint(keyin) != 0){
			if(*bufaddr < TEXT_SIZE){
				printf("%c", keyin);
				buf[*bufaddr] = keyin;
				*bufaddr = *bufaddr + 1;
				if(*bufaddr >= TEXT_SIZE){
					printf("\n");
					printf("Key Buffer FULL ( %d byte ). ", TEXT_SIZE);
					printf("Key in end with \"Enter\"\n");
				}
			}
			else{
				printf("Key Buffer FULL ( %d byte ). ", TEXT_SIZE);
				printf("Key in end with \"Enter\"\n");
			}
		}
	}
}


//---------------------------------------------------------------------------
// Check Keyin TAB
int  isTAB(void)
// return	TRUE : Keyin TAB
{
	if(kbhit() != 0){
		if(getch() == 0x09){
			return(TRUE);
		}
	}
	return(FALSE);
}


//---------------------------------------------------------------------------
// Check Keyin ESC
int  isESC(void)
// return	TRUE : Keyin ESC
{
	if(kbhit() != 0){
		if(getch() == 0x1b){
			return(TRUE);
		}
	}
	return(FALSE);
}


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//---------------------------------------------------------------------------
// Write to Index Register 
void index_write_w(U8 index, U8 addr, U16 data)
// index	Value of Index
// addr		Index register address
// data		Write data (Valid 16bit)
{
	U8 mem_index;

	mem_index = x_read(Index);
	x_write(Index, index);

	x_write(addr, (U8)(data & 0x00ff));
	x_write((U8)(addr + 1), (U8)((data & 0xff00) >> 8));
	
	x_write(Index, mem_index);
}


//---------------------------------------------------------------------------
// Read from Index Register 
U16 index_read_w(U8 index, U8 addr)
// index	Value of Index
// addr		Index register address
// return	Read data (Valid 16bit)
{
	U8 mem_index;
	U16 data;

	mem_index = x_read(Index);
	x_write(Index, index);

	data = (U16)(x_read(addr));
	data = data + ((U16)(x_read((U8)(addr + 1))) << 8);
	
	x_write(Index, mem_index);

	return(data);
}


//---------------------------------------------------------------------------
// Write to Index Register 
void index_write(U8 index, U8 addr, U8 data)
// index	Value of Index
// addr		Index register address
// data		Write data (Valid 8bit)
{
	U8 mem_index;

	mem_index = x_read(Index);
	x_write(Index, index);

	x_write(addr, data);
	
	x_write(Index, mem_index);
}


//---------------------------------------------------------------------------
// Read from Index Register 
U8 index_read(U8 index, U8 addr)
// index	Value of Index
// addr		Index register address
// return	Read data (Valid 8bit)
{
	U8 mem_index;
	U8 data;

	mem_index = x_read(Index);
	x_write(Index, index);

	data = x_read(addr);
	
	x_write(Index, mem_index);

	return(data);
}


//---------------------------------------------------------------------------
// Write to Register 
void x_write_w(U8 addr, U16 data)
// addr		Register address
// data		Write data (Valid 16bit)
{
	x_write(addr, (U8)(data & 0x00ff));
	x_write((U8)(addr + 1), (U8)((data & 0xff00) >> 8));
	
}


//---------------------------------------------------------------------------
// Read from Register 
U16 x_read_w(U8 addr)
// addr		Register address
// return	Read data (Valid 16bit)
{
	U16 data;

	data = (U16)(x_read(addr));
	data = data + ((U16)(x_read((U8)(addr + 1))) << 8);
	return(data);
}


//---------------------------------------------------------------------------
// Write to Register 
void x_write(U8 addr, U8 data)
// addr		Register address
// data		Write data (Valid 8bit)
{
	int busyx;

	do {
		busyx = INPORT((unsigned  int)(HW_PORT_BUSYX)) & 0x80;
	}while (busyx == 0);
	OUTPORT((unsigned int)(HW_PORT_INDEX), (int)(addr));
	OUTPORT((unsigned int)(HW_PORT_DATA), (int)(data));
}


//---------------------------------------------------------------------------
// Read from Register 
U8 x_read(U8 addr)
// addr		Register address
// return	Read data (Valid 8bit)
{
	int busyx;

	do {
		busyx = INPORT((unsigned int)(HW_PORT_BUSYX)) & 0x80;
	}while (busyx == 0);
	OUTPORT((unsigned int)(HW_PORT_INDEX), (int)(addr));
	INPORT((unsigned int)(HW_PORT_INDEX));
	do {
		busyx = INPORT((unsigned int)(HW_PORT_BUSYX)) & 0x80;
	}while (busyx == 0);
	return((U8)(INPORT(HW_PORT_DATA)));
}


#if DEBUG
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//---------------------------------------------------------------------------
// Display TCP State
void DISP_TCP_Stat(U8 soc, int force)
// force	TRUE : anytime display
{
	static U8 oldstat = 0xff;
	U8 stat;
	char str[16];
	
	stat = TCPStat(soc);
	if((force == TRUE) || (oldstat != stat)){
		TCP_Stat2Str(stat, str);
		printf("TCP state : %s\n",str);
	}
	oldstat = stat;
}


//---------------------------------------------------------------------------
// Display Socket Revision
void DISP_Soc_Rev(U8 soc)
// soc		Socket number
{
	U8 mem_index;
	
	mem_index = x_read(Index);
	x_write(Index, soc);

	printf("Socket%d App ID = 0x%02X, ", soc, x_read(Soc_Id));
	printf("Socket%d Revision = 0x%02X\n", soc, x_read(Soc_Rev));

	x_write(Index, mem_index);
}


//---------------------------------------------------------------------------
// Display PPP Revision
void DISP_PPP_Rev(void)
{
	U8 mem_index;
	
	mem_index = x_read(Index);
	x_write(Index, INDEX_PPP);

	printf("PPP App ID = 0x%02X, ", x_read(PPP_Id));
	printf("PPP Revision = 0x%02X\n", x_read(PPP_Rev));

	x_write(Index, mem_index);
}


//---------------------------------------------------------------------------
// Display PPP State
void DISP_PPP_Stat(int force)
// force	TRUE : anytime display
{
	static U8 oldstat = 0xff;
	U8 stat;
	char str[16];
	
	stat = index_read(INDEX_PPP, PPP_Stat);
	if((force == TRUE) || (oldstat != stat)){
		DISP_PPP_Stat2Str((U8)((stat & 0x00f0) >> 4), str);
		printf("NCP state : %s, ",str);
		DISP_PPP_Stat2Str((U8)(stat & 0x0f), str);
		printf("LCP state : %s\n",str);
	}
	oldstat = stat;
}


//---------------------------------------------------------------------------
// PPP State to Definition string
void DISP_PPP_Stat2Str(U8 stat, char *str)
// stat		PPP State
// str		Definition string
{
	switch(stat){
		case 0 : strcpy(str, "Initial ");
				 break;
		case 1 : strcpy(str, "Starting");
				 break;
		case 2 : strcpy(str, "Closed  ");
				 break;
		case 3 : strcpy(str, "Stopped ");
				 break;
		case 4 : strcpy(str, "Closing ");
				 break;
		case 5 : strcpy(str, "Stopping");
				 break;
		case 6 : strcpy(str, "Req_Sent");
				 break;
		case 7 : strcpy(str, "ACK_Rcvd");
				 break;
		case 8 : strcpy(str, "ACK_Sent");
				 break;
		case 9 : strcpy(str, "Opened  ");
				 break;
		default :strcpy(str, "  N/A   ");
				 break;
	}
}


//---------------------------------------------------------------------------
// Display Serial Port Revision
void DISP_SP_Rev(void)
{
	printf("Serial Port Revision = 0x%02X\n", index_read(INDEX_PPP, SP_Rev));
}


//---------------------------------------------------------------------------
// Display BAUD rate setting
void DISP_Baud(unsigned long clk, unsigned long baud)
// clk		Chip clock frequency
// baud		Serial Port BAUD rate
{
	U8 mem_index;
	unsigned int ratio;
	unsigned long real;
	float margin;
	
	mem_index = x_read(Index);
	x_write(Index, INDEX_PPP);

	ratio = x_read_w(SP_Baud0);
	printf("Baud Div = 0x%04X\n", ratio);
	real = clk / (ratio + 1);
	margin = (((float)(real) / (float)(baud)) - 1.0) * 100.0;
	printf("Real Baud rate = %ldBPS, Margin Error = %f%%\n", real, margin);
	
	x_write(Index, mem_index);
}


//---------------------------------------------------------------------------
// Display revision
void DISP_Rev(void)
{
	printf("Revision = 0x%02X, ", x_read(Rev));
	printf("Socket Location = 0x%02X\n", x_read(Soc_Loc));
}


//---------------------------------------------------------------------------
// Display Clock Divider setting
void DISP_Div(void)
{
	printf("Clk Div = 0x%02X%02X\n", x_read(Clk_Div1), x_read(Clk_Div0));
}


#endif
