// (C) All copyrights reserved by Seiko I ASIC Co., Ltd. 2001.
// We prepared this sample software in order that a customer evaluates our product.
// We promise nothing that a actually product of a customer
// includes this sample software and the part.
//

// HardWare setting for PC
#define OUTPORT _outp
#define INPORT  _inp

#define HW_PORT_INDEX   0x430
#define HW_PORT_DATA    (HW_PORT_INDEX + 1)
#define HW_PORT_BUSYX   (HW_PORT_INDEX + 2)

// SoftWare setting for PC
#define TEXT_SIZE 4096

// HardWare setting for Chip
#define CLK  1000000L
#define BAUD   38400L

// Custom Value
#define LOCAL_IP3 192
#define LOCAL_IP2 168
#define LOCAL_IP1  55
#define LOCAL_IP0   1

#define REMOTE_IP3 0
#define REMOTE_IP2 0
#define REMOTE_IP1 0
#define REMOTE_IP0 0

#define TOUT_PPP_DOWN        20
#define TOUT_SOC_BUSY        60

// DEFAULT Value
#define DEF_SOC_INT_EN0 0x00
#define DEF_SOC_INT_EN1 0x00
#define DEF_TOS         0x00


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// DISPLAY for DEBUG
#if DEBUG
void DISP_TCP_Stat(U8, int);
void DISP_Soc_Rev(U8);
void DISP_PPP_Rev(void);
void DISP_PPP_Stat(int);
void DISP_PPP_Stat2Str(U8, char *);
void DISP_SP_Rev(void);
void DISP_Baud(unsigned long, unsigned long);
void DISP_Rev(void);
void DISP_Div(void);
#endif

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// internal function prototypes
int  TCPConnect(U8, long);
int  TCPDisConnect(U8, long, long);
void TCPTimerConf(U8, U8, U8, U16);
void TCPAct(U8);
U8   TCPStat(U8);
void TCP_Stat2Str(U8, char *);

void UDPAct(U8);
void UDPSocInfo(U8);
void UDPRcvInfo(unsigned int, unsigned int);

void SocConf(U8, U8, U16, int, U8 *, int, U16);
void SocPreConf(U8, U16 *, U8 *);
void SocReset(U8, long);
int  isSocBusy(U8);
void SocInfo(U8);

void PPPConnect(long);
void PPPDisConnect(long);
void PPPConf_PAP(U8 *, int, int, char *, char *);
void PPPPreConf_PAP(U8 *);
void PPPUp_PAP(int);
void PPPDown(void);
int  isPPPException(char *, long);
int  isPPPDown(void);
U8   PPPCode(void);
U8   PPPStat(void);
void PPPInfo(void);

void DialConnect_NULL_MODEM(long);
void DialDisConnect_NULL_MODEM(long);
void SPConf(unsigned long, unsigned long, int);
void DialUp_NULL_MODEM(void);
void DialDown_NULL_MODEM(void);
int  isSPException_NULL_MODEM(void);
int  isDialUp_NULL_MODEM(void);

int  DialConnect_STD_MODEM(long);
int  DialDisConnect_STD_MODEM(long);
void DialUp_STD_MODEM(void);
void DialDown_STD_MODEM(void);
int  isSPException_STD_MODEM(void);
int  isDialUp_STD_MODEM(void);
void SPBufClr(void);

void ChipConf(unsigned long);
void SoftReset(void);

void ToutExit(char *);
void FailExit(char *);
void ChapExit(char *);
void EscExit(void);
void KeyinStr(int *, unsigned int *, U8 *, int *, int *, int *, int);
int  isTAB(void);
int  isESC(void);

void index_write_w(U8, U8, U16);
U16  index_read_w(U8, U8);
void index_write(U8, U8, U8);
U8   index_read(U8, U8);
void x_write_w(U8, U16);
U16  x_read_w(U8);
void x_write(U8, U8);
U8   x_read(U8);
