// (C) All copyrights reserved by Seiko I ASIC Co., Ltd. 2001.
// We prepared this sample software in order that a customer evaluates our product.
// We promise nothing that a actually product of a customer
// includes this sample software and the part.
//

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// for Microsoft C/C++ Optimizing Compiler Version 8.00c.
//cl /AL /c sttc10.c
//cl /AL /c s7601a.c
//link sttc10+s7601a,sttc,,, /ST:10000

#define DEBUG	0

// Define TRUE and FALSE
#define TRUE    1
#define FALSE   0

typedef unsigned char U8;
typedef unsigned int  U16;

// SoftWare setting for PC
#define TEXT_SIZE 4096
#define BUF_SIZE  TEXT_SIZE + 4

// HardWare setting for Chip
#define CLK  1000000L
#define BAUD   38400L

// Custom Value
#define REMOTE_PORT 80

#define USER "test"
#define PASS "test"

#define TOUT_DIAL_DOWN        5
#define TOUT_PPP_UP         180
#define TOUT_PPP_DOWN        20
#define TOUT_SOC_BUSY        60
#define TOUT_TCP_ACT_CLI    360
#define TOUT_TCP_DATA       360
#define TOUT_TCP_FIN_ACK     10
#define TOUT_TCP_FIN        360
#define TOUT_TCP_TIME_WAIT    5

// DEFAULT Value
#define DEF_DELAY_ACK   0x00
#define DEF_TCLK_EN     FALSE
#define DEF_TCLK_DIV    0x03e7


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// header files
#include <stdio.h>
#include <process.h>
#include <conio.h>
#include <ctype.h>
#undef toupper
#include <string.h>
#include <time.h>

#include "s7601a.h"
#include "exfunc.h"


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int  TCPSampTerminal_Cli(U8, long, long);
void TCPRecv(U8);
void TCPSend(U8, unsigned int *, unsigned int, U8 *);
void TCPSendFin(U8);

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void main(void)
{
	int keyin = 0;
	char str[32];
	U8 rip[4], lip[4];
	U16 lport;

	printf("SII Tcp sample program easy Terminal Client Ver.1.0\n");
	printf("for S-7601A ISA SDK Board 2.x\n");
	printf("(C) All copyrights reserved by Seiko I ASIC Co., Ltd. 2001.\n");
	printf("\n");

	SoftReset();

	DialDown_NULL_MODEM();
    DialDisConnect_NULL_MODEM(TOUT_DIAL_DOWN);
	#if DEBUG
		DISP_Rev();
	#endif
	ChipConf(CLK);
	#if DEBUG
		DISP_Div();
	#endif
	
	#if DEBUG
		DISP_SP_Rev();
	#endif
	SPConf(CLK, BAUD, TRUE);
	DialUp_NULL_MODEM();
	DialConnect_NULL_MODEM(FALSE);

	#if DEBUG
		DISP_PPP_Rev();
	#endif
	PPPPreConf_PAP(lip);
	PPPConf_PAP(lip, FALSE, TRUE, USER, PASS);
	PPPUp_PAP(TRUE);
	PPPConnect(TOUT_PPP_UP);

	while(1){
		printf("\n");
		printf("**** Menu ****    Key in Character    A : Application   E : Exit\n");
		while(1){
			if(kbhit() != 0){
				break;
			}
			if(isSPException_NULL_MODEM() == TRUE){
				printf("\n");
				FailExit("Serial Port : ");
			}
			if(isPPPException(str, TOUT_PPP_DOWN) == TRUE){
				printf("\n");
				FailExit(str);
			}
		}
		keyin = toupper(getch());
		if (keyin == 'A')
		{
			printf("%c\n", keyin);
			printf("\n");

			SocPreConf(SOC0, &lport, rip);
			SocConf(SOC0, TCP_CLI_MODE, lport, TRUE, rip, TRUE, REMOTE_PORT);
			TCPTimerConf(SOC0, DEF_DELAY_ACK, DEF_TCLK_EN, DEF_TCLK_DIV);
			TCPAct(SOC0);
			if(TCPConnect(SOC0, TOUT_TCP_ACT_CLI) == FALSE){
				SocReset(SOC0, TOUT_SOC_BUSY);
				#if DEBUG
					DISP_TCP_Stat(SOC0, TRUE);
				#endif
				continue;
			}
			if(TCPSampTerminal_Cli(SOC0, TOUT_TCP_DATA, TOUT_TCP_FIN_ACK) == FALSE){
				printf("\n");
				SocReset(SOC0, TOUT_SOC_BUSY);
				#if DEBUG
					DISP_TCP_Stat(SOC0, TRUE);
				#endif
				continue;
			}
			else{
				printf("\n");
				if(TCPDisConnect(SOC0, TOUT_TCP_FIN, TOUT_TCP_TIME_WAIT) == FALSE){
					SocReset(SOC0, TOUT_SOC_BUSY);
					#if DEBUG
						DISP_TCP_Stat(SOC0, TRUE);
					#endif
					continue;
				}
				else{
					SocReset(SOC0, TOUT_SOC_BUSY);
					#if DEBUG
						DISP_TCP_Stat(SOC0, TRUE);
					#endif
					continue;
				}
			}
		}
		else if (keyin == 'E')
		{
			printf("%c\n", keyin);
			printf("\n");
			PPPDown();
			PPPDisConnect(TOUT_PPP_DOWN);
			DialDown_NULL_MODEM();
		    DialDisConnect_NULL_MODEM(TOUT_DIAL_DOWN);
			
			SoftReset();

			printf("Normaly End\n");
			exit(0);
		}
		else{
			printf("\n");
		}
	}
}

//---------------------------------------------------------------------------
int TCPSampTerminal_Cli(U8 soc, long mtout, long mtofin)
// soc		Socket number
// mtout	MPU Timer Timeout for data send (sec). FALSE : Infinity
// mtofin	MPU Timer Timeout for FIN send (sec). FALSE : Infinity
// return	TRUE : Return After send FIN, FALSE : Socket Abnormal
{
	U8 data, stat0, stat1;
	U8 buf[BUF_SIZE];
	char str[32];
	unsigned int buflen, offset;
	int bufval, sndfin, lf, esc; 
	long starttime, nowtime, fintime;
	int startdata, nodata, startfin;

	if(isSPException_NULL_MODEM() == TRUE){
		FailExit("Serial Port : ");
	}
	if(isPPPException(str, TOUT_PPP_DOWN) == TRUE){
		FailExit(str);
	}
	#if DEBUG
		DISP_TCP_Stat(soc, TRUE);
	#endif
	if(TCPStat(soc) != ESTABLISHED){
		printf("Socket%d ", soc);
		FailExit("Check state before TCP Communication : ");
	}
	#if DEBUG
		DISP_TCP_Stat(soc, TRUE);
	#endif
	printf("\n");
	printf("Key in text. And end with \"Enter\" for TCP Socket%d\n", soc);
	printf("If Key in \"Tab\", Send FIN and return to MENU\n");
	printf("\n");

	bufval = FALSE;
	sndfin = FALSE;
	esc = FALSE;
	buflen = 0;
	offset = 0;
	startdata = FALSE;
	nodata = TRUE;
	startfin = FALSE;
	while(1){
		if(isSPException_NULL_MODEM() == TRUE){
			printf("\n");
			FailExit("Serial Port : ");
		}
		if(isPPPException(str, TOUT_PPP_DOWN) == TRUE){
			printf("\n");
			FailExit(str);
		}
		if(nodata == TRUE){
			KeyinStr(&bufval, &buflen, buf, &sndfin, &lf, &esc, TRUE);
			if(esc == TRUE){
				EscExit();
			}
		}
		else{
			if(isESC() == TRUE){
				EscExit();
			}
		}
		stat0 = index_read(soc, Soc_Stat0);
		stat1 = index_read(soc, Soc_Stat1);
		if(startdata == TRUE){
		 	if((stat0 & 0x40) != 0){
				startdata = FALSE;
				if(offset == buflen){
					bufval = FALSE;
					buflen = 0;
					offset = 0;
					nodata = TRUE;
				}
			}
		}
		if((stat0 & 0x10) != 0){
			TCPRecv(soc);
			continue;
		}
		if(startfin == TRUE){
			data = TCPStat(soc);
			if((data == CLOSE_WAIT) ||
			   (data == LAST_ACK)   || 
			   (data == CLOSED)){
				printf("\n");
				return(TRUE);
			}
			if(data == TIME_WAIT){
				printf("\n");
				return(TRUE);
			}
			if(mtofin != FALSE){
				time(&nowtime);
				if(nowtime - fintime >= mtofin){
					printf("\n");
					return(TRUE);
				}
			}
		}
		if((stat1 & 0x40) != 0){
			printf("\n");
			printf("TCP RST Received\n");
			return(FALSE);
		}
		if((stat0 & 0x80) != 0){
			printf("\n");
			printf("TCP Timeout occur.\n");
			return(FALSE);
		}
		if((startdata == TRUE) && (mtout != FALSE)){
			time(&nowtime);
			if(nowtime - starttime >= mtout){
				printf("\n");
				printf("MPU Timer Timeout occur ( DATA Send ).\n");
				return(FALSE);
			}
		}
		if((stat0 & 0x10) == 0){
			if((stat1 & 0x20) != 0){
				data = TCPStat(soc);
				if ((data == CLOSE_WAIT) && (startfin == FALSE)){
					TCPSendFin(soc);
					return(TRUE);
				}
			}
			if((sndfin == TRUE) && (startfin == FALSE)){
				data = TCPStat(soc);
				if (data == ESTABLISHED){
					TCPSendFin(soc);
					startfin = TRUE;
					time(&fintime);
					continue;
				}
			}
		}
		if((stat0 & 0x40) != 0){
			if((startdata == FALSE) && (bufval == TRUE) && (startfin == FALSE)){
				time(&starttime);
				startdata = TRUE;
				nodata = FALSE;
				TCPSend(soc, &offset, buflen, buf);
				continue;
			}
		}
		if((stat1 & 0x80) != 0){
			// URG
			continue;
		}
		else if((stat1 & 0x10) != 0){
			// Con_Up
			continue;
		}
	}
}


//---------------------------------------------------------------------------
// Receive DATA from buffer and Display
void TCPRecv(U8 soc)
// soc		Socket number
{
	U8 data;
	U8 mem_index;
	
	mem_index = x_read(Index);
	x_write(Index, soc);
	
	while((x_read(Soc_Stat0) & 0x10) != 0){
		data = x_read(Soc_Data);
		printf("%c", data);
	}
	
	x_write(Index, mem_index);
}


//---------------------------------------------------------------------------
// Send DATA from buffer
void TCPSend(U8 soc, unsigned int *offset, unsigned int buflen, U8 *buf)
// soc		Socket number
// offset	MPU buffer pointer start offset
// buflen	MPU buffer length
// buf		MPU buffer
{
	U8 mem_index;
	
	mem_index = x_read(Index);
	x_write(Index, soc);
	
	while((x_read_w(Buff_Out0) != 0) && (*offset < buflen)){
		x_write(Soc_Data, buf[*offset]);
		*offset = *offset + 1;
	}
	x_write(Soc_Com, 0x01);
	
	x_write(Index, mem_index);
}


//---------------------------------------------------------------------------
// TCP Socket DisConnection Request
void TCPSendFin(U8 soc)
// soc		Socket number
{
	U8 tmp;
	
	tmp = x_read(Soc_Act);
	tmp = tmp & ~(0x01 << soc);
	x_write(Soc_Act, tmp);

}


