// winmain.h

#ifndef WINMAIN_H
#define WINMAIN_H


#ifdef __cplusplus
extern "C" {
#endif


#if defined _CONSOLE || defined _WINDOWS && ! defined _USRDLL
#if defined NOARG || defined NOCRT
int winmain_ ( void ) ;
#else
int winmain_ ( int argc, char *argv [] ) ;
#endif
#define main   winmain_
#endif


#if defined _USRDLL && ! defined NOCRT && defined _MT
int WINAPI DllMain_ ( HINSTANCE hInst, unsigned long nReason, void *pReserved ) ;
#define DllMain DllMain_
#endif


#if defined _CONSOLE
int IsConsole ( void ) ;
void SetAlertOnClose ( int nMode ) ;
#endif


#define ALERT_ON_CLOSE_AUTO      0
#define ALERT_ON_CLOSE_DISABLED  1
#define ALERT_ON_CLOSE_ENABLED   2


#if defined _CONSOLE || defined _WINDOWS && ! defined _USRDLL
const char *GetArgumentA ( int nCount ) ;
const wchar_t *GetArgumentW ( int nCount ) ;
#endif


#ifdef UNICODE
#define GetArgument GetArgumentW
#else
#define GetArgument GetArgumentA
#endif


#if ! defined _USRDLL
const char *GetWinMainCmdLineA ( void ) ;
const wchar_t *GetWinMainCmdLineW ( void ) ;
#endif


#ifdef UNICODE
#define GetWinMainCmdLine GetWinMainCmdLineW
#else
#define GetWinMainCmdLine GetWinMainCmdLineA
#endif


#ifdef __cplusplus
}
#endif


#endif


