// systime.h

#ifndef SYSTIME_H
#define SYSTIME_H

#ifdef __cplusplus
extern "C" {
#endif


int AddSystemTime ( SYSTEMTIME *pX, const SYSTEMTIME *pY, unsigned long dwMode ) ;
int SubtractSystemTime ( SYSTEMTIME *pX, const SYSTEMTIME *pY, unsigned long dwMode ) ;
int DifferenceSystemTime ( SYSTEMTIME *pX, const SYSTEMTIME *pY ) ;
int CompareSystemTime ( const SYSTEMTIME *pX, const SYSTEMTIME *pY ) ;

// dwMode
#define SYSTIME_CALC_CEILING              1
#define SYSTIME_CALC_CEILING_SAVE_TIME    2

int SystemTimeToLocalTime ( SYSTEMTIME *X, const TIME_ZONE_INFORMATION *TimeZoneInformation ) ;
int LocalTimeToSystemTime ( SYSTEMTIME *X, const TIME_ZONE_INFORMATION *TimeZoneInformation ) ;

int MaxDayOfMonth ( int nYear, int nMonth ) ;
int DayOfWeek ( int nYear, int nMonth, int nDay ) ;

int AddFileTime ( FILETIME *pX, const FILETIME *pY ) ;
int SubtractFileTime ( FILETIME *pX, const FILETIME *pY ) ;
int MakeFileTime ( const SYSTEMTIME *pX, FILETIME *pY ) ;
int ParseFileTime ( const FILETIME *pX, SYSTEMTIME *pY ) ;

int ScanDateTimeA ( const char *szString, char **pNext, FILETIME *pFileTime, SYSTEMTIME *pLocalTime, unsigned long dwMode ) ;
int ScanDateTimeW ( const wchar_t *szString, wchar_t **pNext, FILETIME *pFileTime, SYSTEMTIME *pLocalTime, unsigned long dwMode ) ;

// dwMode
#define SYSTIME_SCAN_CEILING        1
#define SYSTIME_SCAN_DD_MM_YYYY     2
#define SYSTIME_SCAN_MM_DD_YYYY     4


#ifdef UNICODE
#define ScanDateTime ScanDateTimeW
#else
#define ScanDateTime ScanDateTimeA
#endif



// Bias (TIME_ZONE_INFORMATION)
#define TIME_ZONE_BIAS_WEST_12      (   ( 12 * 60 ) )
#define TIME_ZONE_BIAS_WEST_11      (   ( 11 * 60 ) )
#define TIME_ZONE_BIAS_WEST_10      (   ( 10 * 60 ) )
#define TIME_ZONE_BIAS_WEST_9_30    (   (  9 * 60 + 30 ) )
#define TIME_ZONE_BIAS_WEST_9       (   (  9 * 60 ) )
#define TIME_ZONE_BIAS_WEST_8       (   (  8 * 60 ) )
#define TIME_ZONE_BIAS_WEST_7       (   (  7 * 60 ) )
#define TIME_ZONE_BIAS_WEST_6       (   (  6 * 60 ) )
#define TIME_ZONE_BIAS_WEST_5       (   (  5 * 60 ) )
#define TIME_ZONE_BIAS_WEST_4_30    (   (  4 * 60 + 30 ) )
#define TIME_ZONE_BIAS_WEST_4       (   (  4 * 60 ) )
#define TIME_ZONE_BIAS_WEST_3_30    (   (  3 * 60 + 30 ) )
#define TIME_ZONE_BIAS_WEST_3       (   (  3 * 60 ) )
#define TIME_ZONE_BIAS_WEST_2       (   (  2 * 60 ) )
#define TIME_ZONE_BIAS_WEST_1       (   (  1 * 60 ) )
#define TIME_ZONE_BIAS_0            (   (  0 * 60 ) )
#define TIME_ZONE_BIAS_EAST_1       ( - (  1 * 60 ) )
#define TIME_ZONE_BIAS_EAST_2       ( - (  2 * 60 ) )
#define TIME_ZONE_BIAS_EAST_3       ( - (  3 * 60 ) )
#define TIME_ZONE_BIAS_EAST_3_30    ( - (  3 * 60 + 30 ) )
#define TIME_ZONE_BIAS_EAST_4       ( - (  4 * 60 ) )
#define TIME_ZONE_BIAS_EAST_4_30    ( - (  4 * 60 + 30 ) )
#define TIME_ZONE_BIAS_EAST_5       ( - (  5 * 60 ) )
#define TIME_ZONE_BIAS_EAST_5_30    ( - (  5 * 60 + 30 ) )
#define TIME_ZONE_BIAS_EAST_5_45    ( - (  5 * 60 + 45 ) )
#define TIME_ZONE_BIAS_EAST_6       ( - (  6 * 60 ) )
#define TIME_ZONE_BIAS_EAST_6_30    ( - (  6 * 60 + 30 ) )
#define TIME_ZONE_BIAS_EAST_7       ( - (  7 * 60 ) )
#define TIME_ZONE_BIAS_EAST_8       ( - (  8 * 60 ) )
#define TIME_ZONE_BIAS_EAST_8_45    ( - (  8 * 60 + 45 ) )
#define TIME_ZONE_BIAS_EAST_9       ( - (  9 * 60 ) )
#define TIME_ZONE_BIAS_EAST_9_30    ( - (  9 * 60 + 30 ) )
#define TIME_ZONE_BIAS_EAST_10      ( - ( 10 * 60 ) )
#define TIME_ZONE_BIAS_EAST_10_30   ( - ( 10 * 60 + 30 ) )
#define TIME_ZONE_BIAS_EAST_11      ( - ( 11 * 60 ) )
#define TIME_ZONE_BIAS_EAST_11_30   ( - ( 11 * 60 + 30 ) )
#define TIME_ZONE_BIAS_EAST_12      ( - ( 12 * 60 ) )
#define TIME_ZONE_BIAS_EAST_12_45   ( - ( 12 * 60 + 45 ) )
#define TIME_ZONE_BIAS_EAST_13      ( - ( 13 * 60 ) )
#define TIME_ZONE_BIAS_EAST_14      ( - ( 14 * 60 ) )


#if 0
// https://en.wikipedia.org/wiki/Time_zone

// TIME_ZONE_BIAS_WEST_12     // Baker Island (uninhabited)
// TIME_ZONE_BIAS_WEST_12     // Howland Island (uninhabited)

// TIME_ZONE_BIAS_WEST_11     // American Samoa
// TIME_ZONE_BIAS_WEST_11     // Niue

// TIME_ZONE_BIAS_WEST_10     // Most of French Polynesia
// TIME_ZONE_BIAS_WEST_10     // United States (Aleutian Islands, Hawaii)

// TIME_ZONE_BIAS_WEST_9_30   // Marquesas Islands

// TIME_ZONE_BIAS_WEST_9      // Gambier Islands
// TIME_ZONE_BIAS_WEST_9      // United States (most of Alaska)

// TIME_ZONE_BIAS_WEST_8      // Canada (most of British Columbia)
// TIME_ZONE_BIAS_WEST_8      // Mexico (Baja California)
// TIME_ZONE_BIAS_WEST_8      // United States (California, most of Nevada, most of Oregon, Washington state)

// TIME_ZONE_BIAS_WEST_7      // Canada (Alberta, northeastern British Columbia)
// TIME_ZONE_BIAS_WEST_7      // Mexico (Chihuahua, Sonora)
// TIME_ZONE_BIAS_WEST_7      // United States (Arizona, Colorado)

// TIME_ZONE_BIAS_WEST_6      // Canada (Manitoba, almost all of Saskatchewan)
// TIME_ZONE_BIAS_WEST_6      // Costa Rica
// TIME_ZONE_BIAS_WEST_6      // Ecuador (Galapagos Islands)
// TIME_ZONE_BIAS_WEST_6      // El Salvador
// TIME_ZONE_BIAS_WEST_6      // Guatemala
// TIME_ZONE_BIAS_WEST_6      // Honduras
// TIME_ZONE_BIAS_WEST_6      // Mexico (most)
// TIME_ZONE_BIAS_WEST_6      // Nicaragua
// TIME_ZONE_BIAS_WEST_6      // United States (Illinois, most of Texas)

// TIME_ZONE_BIAS_WEST_5      // Bahamas
// TIME_ZONE_BIAS_WEST_5      // Brazil (Acre)
// TIME_ZONE_BIAS_WEST_5      // Canada (most of Ontario, most of Quebec)
// TIME_ZONE_BIAS_WEST_5      // Colombia
// TIME_ZONE_BIAS_WEST_5      // Cuba
// TIME_ZONE_BIAS_WEST_5      // Ecuador (continental)
// TIME_ZONE_BIAS_WEST_5      // Haiti
// TIME_ZONE_BIAS_WEST_5      // Jamaica
// TIME_ZONE_BIAS_WEST_5      // Panama
// TIME_ZONE_BIAS_WEST_5      // Peru
// TIME_ZONE_BIAS_WEST_5      // United States (most of Florida, Georgia, Massachusetts, most of Michigan, most of Indiana, New York, North Carolina, Ohio, Washington, D.C.)

// TIME_ZONE_BIAS_WEST_4_30   // Venezuela

// TIME_ZONE_BIAS_WEST_4      // Barbados
// TIME_ZONE_BIAS_WEST_4      // Bolivia
// TIME_ZONE_BIAS_WEST_4      // Brazil (Amazonas, Rondonia, Roraima, Mato Grosso)
// TIME_ZONE_BIAS_WEST_4      // Canada (Nova Scotia)
// TIME_ZONE_BIAS_WEST_4      // Dominican Republic
// TIME_ZONE_BIAS_WEST_4      // Falkland Islands
// TIME_ZONE_BIAS_WEST_4      // Mato Grosso do Sul)
// TIME_ZONE_BIAS_WEST_4      // Puerto Rico
// TIME_ZONE_BIAS_WEST_4      // Trinidad and Tobago

// TIME_ZONE_BIAS_WEST_3_30   // Canada (island of Newfoundland and southern Labrador)

// TIME_ZONE_BIAS_WEST_3      // Argentina
// TIME_ZONE_BIAS_WEST_3      // Brazil (Bahia, Ceara, Maranhao, Para, Pernambuco, Federal District, Minas Gerais, Parana, Rio Grande do Sul, Rio de Janeiro, Sao Paulo)
// TIME_ZONE_BIAS_WEST_3      // Chile (continental)
// TIME_ZONE_BIAS_WEST_3      // Greenland (most)
// TIME_ZONE_BIAS_WEST_3      // Paraguay
// TIME_ZONE_BIAS_WEST_3      // Uruguay

// TIME_ZONE_BIAS_WEST_2      // Brazil (Fernando de Noronha)
// TIME_ZONE_BIAS_WEST_2      // South Georgia and the South Sandwich Islands

// TIME_ZONE_BIAS_WEST_1      // Cape Verde
// TIME_ZONE_BIAS_WEST_1      // Portugal (Azores)

// TIME_ZONE_0       // Cote d'Ivoire
// TIME_ZONE_0       // Faroe Islands
// TIME_ZONE_0       // Ghana
// TIME_ZONE_0       // Iceland
// TIME_ZONE_0       // Ireland
// TIME_ZONE_0       // Mali
// TIME_ZONE_0       // Morocco
// TIME_ZONE_0       // Portugal (continental and Madeira)
// TIME_ZONE_0       // Saint Helena
// TIME_ZONE_0       // Senegal
// TIME_ZONE_0       // Spain (Canary Islands)
// TIME_ZONE_0       // United Kingdom
// TIME_ZONE_0       // Western Sahara

// TIME_ZONE_BIAS_EAST_1      // Albania
// TIME_ZONE_BIAS_EAST_1      // Algeria
// TIME_ZONE_BIAS_EAST_1      // Angola
// TIME_ZONE_BIAS_EAST_1      // Austria
// TIME_ZONE_BIAS_EAST_1      // Belgium
// TIME_ZONE_BIAS_EAST_1      // Benin
// TIME_ZONE_BIAS_EAST_1      // Bosnia and Herzegovina
// TIME_ZONE_BIAS_EAST_1      // Cameroon
// TIME_ZONE_BIAS_EAST_1      // Congo (west)
// TIME_ZONE_BIAS_EAST_1      // Croatia
// TIME_ZONE_BIAS_EAST_1      // Czech
// TIME_ZONE_BIAS_EAST_1      // Denmark
// TIME_ZONE_BIAS_EAST_1      // France (metropolitan)
// TIME_ZONE_BIAS_EAST_1      // Gabon
// TIME_ZONE_BIAS_EAST_1      // Germany
// TIME_ZONE_BIAS_EAST_1      // Hungary
// TIME_ZONE_BIAS_EAST_1      // Italy
// TIME_ZONE_BIAS_EAST_1      // Macedonia
// TIME_ZONE_BIAS_EAST_1      // Malta
// TIME_ZONE_BIAS_EAST_1      // Namibia
// TIME_ZONE_BIAS_EAST_1      // Niger
// TIME_ZONE_BIAS_EAST_1      // Nigeria
// TIME_ZONE_BIAS_EAST_1      // Norway
// TIME_ZONE_BIAS_EAST_1      // Poland
// TIME_ZONE_BIAS_EAST_1      // Serbia
// TIME_ZONE_BIAS_EAST_1      // Slovakia
// TIME_ZONE_BIAS_EAST_1      // Slovenia
// TIME_ZONE_BIAS_EAST_1      // Spain (continental)
// TIME_ZONE_BIAS_EAST_1      // Sweden
// TIME_ZONE_BIAS_EAST_1      // Switzerland
// TIME_ZONE_BIAS_EAST_1      // Tunisia
// TIME_ZONE_BIAS_EAST_1      // the Netherlands

// TIME_ZONE_BIAS_EAST_2      // Bulgaria
// TIME_ZONE_BIAS_EAST_2      // Burundi
// TIME_ZONE_BIAS_EAST_2      // Cyprus
// TIME_ZONE_BIAS_EAST_2      // Egypt
// TIME_ZONE_BIAS_EAST_2      // Estonia
// TIME_ZONE_BIAS_EAST_2      // Finland
// TIME_ZONE_BIAS_EAST_2      // Greece
// TIME_ZONE_BIAS_EAST_2      // Israel
// TIME_ZONE_BIAS_EAST_2      // Jordan
// TIME_ZONE_BIAS_EAST_2      // Latvia
// TIME_ZONE_BIAS_EAST_2      // Lebanon
// TIME_ZONE_BIAS_EAST_2      // Lithuania
// TIME_ZONE_BIAS_EAST_2      // Malawi
// TIME_ZONE_BIAS_EAST_2      // Moldova
// TIME_ZONE_BIAS_EAST_2      // Mozambique
// TIME_ZONE_BIAS_EAST_2      // Northern Cyprus
// TIME_ZONE_BIAS_EAST_2      // Palestine
// TIME_ZONE_BIAS_EAST_2      // Romania
// TIME_ZONE_BIAS_EAST_2      // Russia (Kaliningrad Oblast)
// TIME_ZONE_BIAS_EAST_2      // Rwanda
// TIME_ZONE_BIAS_EAST_2      // South Africa
// TIME_ZONE_BIAS_EAST_2      // Swaziland
// TIME_ZONE_BIAS_EAST_2      // Syria
// TIME_ZONE_BIAS_EAST_2      // Turkey
// TIME_ZONE_BIAS_EAST_2      // Ukraine
// TIME_ZONE_BIAS_EAST_2      // Zambia
// TIME_ZONE_BIAS_EAST_2      // Zimbabwe

// TIME_ZONE_BIAS_EAST_3      // Belarus
// TIME_ZONE_BIAS_EAST_3      // Djibouti
// TIME_ZONE_BIAS_EAST_3      // Eritrea
// TIME_ZONE_BIAS_EAST_3      // Ethiopia
// TIME_ZONE_BIAS_EAST_3      // Iraq
// TIME_ZONE_BIAS_EAST_3      // Kenya
// TIME_ZONE_BIAS_EAST_3      // Madagascar
// TIME_ZONE_BIAS_EAST_3      // Russia (European)
// TIME_ZONE_BIAS_EAST_3      // Saudi Arabia
// TIME_ZONE_BIAS_EAST_3      // Somalia
// TIME_ZONE_BIAS_EAST_3      // South Sudan
// TIME_ZONE_BIAS_EAST_3      // Sudan
// TIME_ZONE_BIAS_EAST_3      // Tanzania
// TIME_ZONE_BIAS_EAST_3      // Uganda
// TIME_ZONE_BIAS_EAST_3      // Yemen|

// TIME_ZONE_BIAS_EAST_3_30   // Iran

// TIME_ZONE_BIAS_EAST_4      // Armenia
// TIME_ZONE_BIAS_EAST_4      // Azerbaijan
// TIME_ZONE_BIAS_EAST_4      // Georgia
// TIME_ZONE_BIAS_EAST_4      // Mauritius
// TIME_ZONE_BIAS_EAST_4      // Oman
// TIME_ZONE_BIAS_EAST_4      // Seychelles
// TIME_ZONE_BIAS_EAST_4      // United Arab Emirates

// TIME_ZONE_BIAS_EAST_4_30   // Afghanistan

// TIME_ZONE_BIAS_EAST_5      // Kazakhstan (west)
// TIME_ZONE_BIAS_EAST_5      // Maldives
// TIME_ZONE_BIAS_EAST_5      // Pakistan
// TIME_ZONE_BIAS_EAST_5      // Uzbekistan

// TIME_ZONE_BIAS_EAST_5_30   // India
// TIME_ZONE_BIAS_EAST_5_30   // Sri Lanka

// TIME_ZONE_BIAS_EAST_5_45   // Nepal

// TIME_ZONE_BIAS_EAST_6      // Bangladesh
// TIME_ZONE_BIAS_EAST_6      // Bhutan
// TIME_ZONE_BIAS_EAST_6      // Kazakhstan (most)
// TIME_ZONE_BIAS_EAST_6      // Russia (Ural: Sverdlovsk Oblast, Chelyabinsk Oblast)

// TIME_ZONE_BIAS_EAST_6_30   // Cocos Islands
// TIME_ZONE_BIAS_EAST_6_30   // Myanmar

// TIME_ZONE_BIAS_EAST_7      // Cambodia
// TIME_ZONE_BIAS_EAST_7      // Laos
// TIME_ZONE_BIAS_EAST_7      // Russia (Novosibirsk Oblast)
// TIME_ZONE_BIAS_EAST_7      // Thailand
// TIME_ZONE_BIAS_EAST_7      // Vietnam
// TIME_ZONE_BIAS_EAST_7      // Western Indonesia

// TIME_ZONE_BIAS_EAST_8      // Australia (Eucla-official, Western Australia)
// TIME_ZONE_BIAS_EAST_8      // Brunei
// TIME_ZONE_BIAS_EAST_8      // Central Indonesia
// TIME_ZONE_BIAS_EAST_8      // China
// TIME_ZONE_BIAS_EAST_8      // Hong Kong
// TIME_ZONE_BIAS_EAST_8      // Macau
// TIME_ZONE_BIAS_EAST_8      // Malaysia
// TIME_ZONE_BIAS_EAST_8      // Mongolia (most)
// TIME_ZONE_BIAS_EAST_8      // Philippines
// TIME_ZONE_BIAS_EAST_8      // Russia (Krasnoyarsk Krai)
// TIME_ZONE_BIAS_EAST_8      // Singapore
// TIME_ZONE_BIAS_EAST_8      // Taiwan

// TIME_ZONE_BIAS_EAST_8_45   // Australia (Eucla-unofficial)

// TIME_ZONE_BIAS_EAST_9      // East Timor
// TIME_ZONE_BIAS_EAST_9      // Eastern Indonesia
// TIME_ZONE_BIAS_EAST_9      // Japan
// TIME_ZONE_BIAS_EAST_9      // North Korea
// TIME_ZONE_BIAS_EAST_9      // Russia (Irkutsk Oblast)
// TIME_ZONE_BIAS_EAST_9      // South Korea

// TIME_ZONE_BIAS_EAST_9_30   // Australia (Northern Territory, South Australia)

// TIME_ZONE_BIAS_EAST_10     // Australia (New South Wales, Tasmania, Victoria, Queensland)
// TIME_ZONE_BIAS_EAST_10     // Papua New Guinea
// TIME_ZONE_BIAS_EAST_10     // Russia (Zabaykalsky Krai)

// TIME_ZONE_BIAS_EAST_10_30  // Lord Howe Island

// TIME_ZONE_BIAS_EAST_11     // New Caledonia
// TIME_ZONE_BIAS_EAST_11     // Russia (Primorsky Krai)
// TIME_ZONE_BIAS_EAST_11     // Solomon Islands
// TIME_ZONE_BIAS_EAST_11     // Vanuatu

// TIME_ZONE_BIAS_EAST_11_30  // Norfolk Island

// TIME_ZONE_BIAS_EAST_12     // Fiji
// TIME_ZONE_BIAS_EAST_12     // Kiribati (Gilbert Islands)
// TIME_ZONE_BIAS_EAST_12     // New Zealand
// TIME_ZONE_BIAS_EAST_12     // Russia (Kamchatka Krai)

// TIME_ZONE_BIAS_EAST_12_45  // Chatham Islands

// TIME_ZONE_BIAS_EAST_13     // Kiribati (Phoenix Islands)
// TIME_ZONE_BIAS_EAST_13     // Tokelau Samoa
// TIME_ZONE_BIAS_EAST_13     // Tonga

// TIME_ZONE_BIAS_EAST_14     // Kiribati (Line Islands)

#endif


////////////////////////////////////////////

#ifdef __cplusplus
}
#endif



#if defined DEBUG_CONST_STRING && defined __cplusplus    // for debug

#define FUNC_STR_STR_FT_ST_UL(func,type)  \
   static int func##_ ( const type *s, const type **p, FILETIME *f, SYSTEMTIME *t, unsigned long m ) { return func ( s, (type**) p, f, t, m ) ; } \
   static int func##_ (       type *s,       type **p, FILETIME *f, SYSTEMTIME *t, unsigned long m ) { return func ( s,          p, f, t, m ) ; }

FUNC_STR_STR_FT_ST_UL ( ScanDateTimeA, char )
FUNC_STR_STR_FT_ST_UL ( ScanDateTimeW, wchar_t )

#undef FUNC_STR_STR_FT_ST_UL

#define ScanDateTimeA      ScanDateTimeA_
#define ScanDateTimeW      ScanDateTimeW_

#else

#define ScanDateTimeA(s,p,f,t,m)    ScanDateTimeA ( s, (char**) (p), f, t, m )
#define ScanDateTimeW(s,p,f,t,m)    ScanDateTimeW ( s, (wchar_t**) (p), f, t, m )

#endif // else of defined DEBUG_CONST_STRING && defined __cplusplus



#endif


