// systime.cpp

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "msc.h"

#undef DEBUG_CONST_STRING
#include "systime.h"


// DEBUG_CONST_STRING
#undef ScanDateTimeA
#undef ScanDateTimeW



////////////////////////////////////////////
//           SYSTEMTIME ̌vZ            //
////////////////////////////////////////////



static void AdjustInvalidDate ( SYSTEMTIME *pX, unsigned long dwMode ) ;
static int IsInvalidSystemTime ( const SYSTEMTIME *pX ) ;



// Z
//  pX ɂ͐ΎԂw肷
//  pY ɂ͑ΎԂw肷iKĂȂlj
// ʂ pX ɐΎԂŊi[
//  0 As 0 ȊOԂ
int AddSystemTime ( SYSTEMTIME *pX, const SYSTEMTIME *pY, unsigned long dwMode ) {

   if ( IsInvalidSystemTime ( pX ) ) return 1 ;

   SYSTEMTIME X = *pX ;

   // NEvZ
   if ( 1 ) {

      unsigned int nMonthX = (unsigned int) X.wYear * 12 + ( X.wMonth - 1 ) ;
      unsigned int nMonthY = (unsigned int) pY->wYear * 12 + pY->wMonth ;

      nMonthX += nMonthY ;

      if ( nMonthX / 12 > USHRT_MAX ) return 1 ;

      X.wYear = nMonthX / 12 ;
      X.wMonth = nMonthX % 12 + 1 ;

      AdjustInvalidDate ( & X, dwMode ) ;
   }

   // EvZ
   if ( 1 ) {

      FILETIME FileTimeX ;
      if ( ! SystemTimeToFileTime ( & X, & FileTimeX ) ) return 1 ;

      SYSTEMTIME Y = *pY ;
      Y.wYear = Y.wMonth = 0 ;

      FILETIME FileTimeY ;
      if ( MakeFileTime ( & Y, & FileTimeY ) ) return 1 ;
      if ( AddFileTime ( & FileTimeX, & FileTimeY ) ) return 1 ;

      if ( ! FileTimeToSystemTime ( & FileTimeX, & X ) ) return 1 ;
   }

   *pX = X ;

   return 0 ;
}



// Z
//  pX ɂ͐ΎԂw肷
//  pY ɂ͑ΎԂw肷iKĂȂlj
// ʂ pX ɐΎԂŊi[
//  0 As 0 ȊOԂ
int SubtractSystemTime ( SYSTEMTIME *pX, const SYSTEMTIME *pY, unsigned long dwMode ) {

   if ( IsInvalidSystemTime ( pX ) ) return 1 ;

   SYSTEMTIME X = *pX ;

   // NEvZ
   if ( 1 ) {

      unsigned int nMonthX = (unsigned int) X.wYear * 12 + ( X.wMonth - 1 ) ;
      unsigned int nMonthY = (unsigned int) pY->wYear * 12 + pY->wMonth ;

      if ( nMonthX < nMonthY ) return 1 ;

      nMonthX -= nMonthY ;

      X.wYear = nMonthX / 12 ;
      X.wMonth = nMonthX % 12 + 1 ;

      AdjustInvalidDate ( & X, dwMode ) ;
   }

   // EvZ
   if ( 1 ) {

      FILETIME FileTimeX ;
      if ( ! SystemTimeToFileTime ( & X, & FileTimeX ) ) return 1 ;

      SYSTEMTIME Y = *pY ;
      Y.wYear = Y.wMonth = 0 ;

      FILETIME FileTimeY ;
      if ( MakeFileTime ( & Y, & FileTimeY ) ) return 1 ;
      if ( SubtractFileTime ( & FileTimeX, & FileTimeY ) ) return 1 ;

      if ( ! FileTimeToSystemTime ( & FileTimeX, & X ) ) return 1 ;
   }

   *pX = X ;

   return 0 ;
}



// ̍߂
//  pX, pY ɂ͐ΎԂw肷
// ʂ pX ɑΎԂŊi[
// pX  pY ꍇ͎s
//  0 As 0 ȊOԂ
int DifferenceSystemTime ( SYSTEMTIME *pX, const SYSTEMTIME *pY ) {

   if ( IsInvalidSystemTime ( pY ) ) return 1 ;

   SYSTEMTIME X = *pX ;

   // vZ
   if ( 1 ) {

      FILETIME FileTimeX ;
      if ( ! SystemTimeToFileTime ( & X, & FileTimeX ) ) return 1 ;

      SYSTEMTIME Y = *pY ;
      Y.wYear = Y.wMonth = Y.wDay = 0 ;

      FILETIME FileTimeY ;
      if ( MakeFileTime ( & Y, & FileTimeY ) ) return 1 ;
      if ( SubtractFileTime ( & FileTimeX, & FileTimeY ) ) return 1 ;

      if ( ! FileTimeToSystemTime ( & FileTimeX, & X ) ) return 1 ;
   }

   // NEEvZ
   if ( 1 ) {

      if ( X.wDay < pY->wDay ) {
         X.wMonth -- ;
         if ( X.wMonth < 1 ) {
            X.wYear -- ;
            X.wMonth += 12 ;
         }
         X.wDay += MaxDayOfMonth ( X.wYear, X.wMonth ) ;
      }
      X.wDay -= pY->wDay ;

      if ( X.wMonth < pY->wMonth ) {
         X.wYear -- ;
         X.wMonth += 12 ;
      }
      X.wMonth -= pY->wMonth ;

      if ( X.wYear < pY->wYear ) return 1 ;
      X.wYear -= pY->wYear ;
   }

   *pX = X ;

   return 0 ;
}



static void AdjustInvalidDate ( SYSTEMTIME *pX, unsigned long dwMode ) {

   int nDaysOfMonth = MaxDayOfMonth ( pX->wYear, pX->wMonth ) ;
   if ( nDaysOfMonth < 0 ) return ;

   if ( nDaysOfMonth < pX->wDay ) {
      if ( dwMode & SYSTIME_CALC_CEILING ) {
         pX->wDay = 1 ;
         pX->wMonth ++ ;
         if ( ! IS_BETWEEN ( pX->wMonth, 1, 12 ) ) {
            pX->wMonth -= 12 ;
            pX->wYear ++ ;
         }
         if ( ! ( dwMode & SYSTIME_CALC_CEILING_SAVE_TIME ) ) {
            pX->wHour = 0 ;
            pX->wMinute = 0 ;
            pX->wSecond = 0 ;
            pX->wMilliseconds = 0 ;
         }
      }
      else {
         pX->wDay = nDaysOfMonth ;
         if ( ! ( dwMode & SYSTIME_CALC_CEILING_SAVE_TIME ) ) {
            pX->wHour = 23 ;
            pX->wMinute = 59 ;
            pX->wSecond = 59 ;
            pX->wMilliseconds = 999 ;
         }
      }
   }

   return ;
}



static int IsInvalidSystemTime ( const SYSTEMTIME *pX ) {

   if (  pX->wYear < 1601
      || pX->wMonth < 1 || pX->wMonth > 12
      || pX->wDay < 1   || pX->wDay > MaxDayOfMonth ( pX->wYear, pX->wMonth )
      || pX->wHour > 23
      || pX->wMinute > 59
      || pX->wSecond > 59
      || pX->wMilliseconds > 999
   ) return 1 ;

   return 0 ;
}



// r
// wDayOfWeek ͖
int CompareSystemTime ( const SYSTEMTIME *pX, const SYSTEMTIME *pY ) {

   if ( pX->wYear > pY->wYear ) return 1 ;
   if ( pX->wYear < pY->wYear ) return -1 ;

   if ( pX->wMonth > pY->wMonth ) return 1 ;
   if ( pX->wMonth < pY->wMonth ) return -1 ;

   if ( pX->wDay > pY->wDay ) return 1 ;
   if ( pX->wDay < pY->wDay ) return -1 ;

   if ( pX->wHour > pY->wHour ) return 1 ;
   if ( pX->wHour < pY->wHour ) return -1 ;

   if ( pX->wMinute > pY->wMinute ) return 1 ;
   if ( pX->wMinute < pY->wMinute ) return -1 ;

   if ( pX->wSecond > pY->wSecond ) return 1 ;
   if ( pX->wSecond < pY->wSecond ) return -1 ;

   if ( pX->wMilliseconds > pY->wMilliseconds ) return 1 ;
   if ( pX->wMilliseconds < pY->wMilliseconds ) return -1 ;

   return 0 ;
}



////////////////////////////////////////////
//                 W                 //
////////////////////////////////////////////



static int InterpretTimeZone ( SYSTEMTIME *X ) ;
static int AddBias ( SYSTEMTIME *X, int nBias ) ;



// ^C][w肵ăVXe^C[J^Cɕϊ
// ^C][ NULL w肷ƁA݂ OS ̐ݒɏ]
//  0 As 0 ȊOԂ
int SystemTimeToLocalTime ( SYSTEMTIME *X, const TIME_ZONE_INFORMATION *TimeZoneInformation ) {

   TIME_ZONE_INFORMATION T ;

   if ( TimeZoneInformation ) T = *TimeZoneInformation ;
   else if ( GetTimeZoneInformation ( & T ) == TIME_ZONE_ID_INVALID ) return 1 ;

   AddBias ( X, - T.Bias ) ;

   if ( T.StandardDate.wMonth && T.DaylightDate.wMonth ) {

      SYSTEMTIME S = T.StandardDate ;
      if ( ! S.wYear ) {
         S.wYear = X->wYear ;
         InterpretTimeZone ( & S ) ;
      }

      SYSTEMTIME D = T.DaylightDate ;
      if ( ! D.wYear ) {
         D.wYear = X->wYear ;
         InterpretTimeZone ( & D ) ;
      }

      if ( CompareSystemTime ( & S, & D ) > 0 ) {
         AddBias ( X, - T.StandardBias ) ;
         if ( CompareSystemTime ( X, & D ) >= 0 ) AddBias ( X, - ( T.DaylightBias - T.StandardBias ) ) ;
         if ( CompareSystemTime ( X, & S ) >= 0 ) AddBias ( X, - ( T.StandardBias - T.DaylightBias ) ) ;
      }
      else {
         AddBias ( X, - T.DaylightBias ) ;
         if ( CompareSystemTime ( X, & S ) >= 0 ) AddBias ( X, - ( T.StandardBias - T.DaylightBias ) ) ;
         if ( CompareSystemTime ( X, & D ) >= 0 ) AddBias ( X, - ( T.DaylightBias - T.StandardBias ) ) ;
      }
   }

   return 0 ;
}



// ^C][w肵ă[J^CVXe^Cɕϊ
// ^C][ NULL w肷ƁA݂ OS ̐ݒɏ]
//  0 As 0 ȊOԂ
int LocalTimeToSystemTime ( SYSTEMTIME *X, const TIME_ZONE_INFORMATION *TimeZoneInformation ) {

   TIME_ZONE_INFORMATION T ;

   if ( TimeZoneInformation ) T = *TimeZoneInformation ;
   else if ( GetTimeZoneInformation ( & T ) == TIME_ZONE_ID_INVALID ) return 1 ;

   if ( T.StandardDate.wMonth && T.DaylightDate.wMonth ) {

      SYSTEMTIME S = T.StandardDate ;
      if ( ! S.wYear ) {
         S.wYear = X->wYear ;
         InterpretTimeZone ( & S ) ;
      }

      SYSTEMTIME D = T.DaylightDate ;
      if ( ! D.wYear ) {
         D.wYear = X->wYear ;
         InterpretTimeZone ( & D ) ;
      }

      if ( CompareSystemTime ( & S, & D ) > 0 ) {
         if ( CompareSystemTime ( X, & S ) >= 0 ) AddBias ( X, ( T.StandardBias - T.DaylightBias ) ) ;
         if ( CompareSystemTime ( X, & D ) >= 0 ) AddBias ( X, ( T.DaylightBias - T.StandardBias ) ) ;
         AddBias ( X, T.StandardBias ) ;
      }
      else {
         if ( CompareSystemTime ( X, & D ) >= 0 ) AddBias ( X, ( T.DaylightBias - T.StandardBias ) ) ;
         if ( CompareSystemTime ( X, & S ) >= 0 ) AddBias ( X, ( T.StandardBias - T.DaylightBias ) ) ;
         AddBias ( X, T.DaylightBias ) ;
      }
   }

   AddBias ( X, T.Bias ) ;

   return 0 ;
}



static int InterpretTimeZone ( SYSTEMTIME *X ) {

   SYSTEMTIME A = *X ;
   A.wDay = 1 ;
   A.wDayOfWeek = DayOfWeek ( A.wYear, A.wMonth, A.wDay ) ;

   int nDayOfWeek = X->wDayOfWeek ;
   if ( nDayOfWeek < A.wDayOfWeek ) nDayOfWeek += 7 ;

   A.wDay += nDayOfWeek - A.wDayOfWeek ;
   A.wDay += ( X->wDay - 1 ) * 7 ;

   int nMax = MaxDayOfMonth ( A.wYear, A.wMonth ) ;
   while ( A.wDay > nMax ) A.wDay -= 7 ;

   *X = A ;

   return 0 ;
}



static int AddBias ( SYSTEMTIME *X, int nBias ) {

   if ( nBias < 0 ) {
      SYSTEMTIME Y = { 0 } ;
      Y.wMinute = (unsigned short) ( - nBias ) ;
      SubtractSystemTime ( X, & Y, 0 ) ;
   }
   else {
      SYSTEMTIME Y = { 0 } ;
      Y.wMinute = (unsigned short) nBias ;
      AddSystemTime ( X, & Y, 0 ) ;
   }

   return 0 ;
}



////////////////////////////////////////////
//               e̓               //
////////////////////////////////////////////



// e̓Ԃ
// s畉Ԃ
int MaxDayOfMonth ( int nYear, int nMonth ) {

   if ( nYear < 1583 || nYear > USHRT_MAX ) return -1 ;
   if ( nMonth < 1 || nMonth > 12 ) return -1 ;

   if ( ! ( nYear % 400 ) || ( ( nYear % 100 ) && ! ( nYear % 4 ) ) ) {
      static const unsigned char Array [] = { 0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 } ;
      return Array [ nMonth ] ;
   }
   else {
      static const unsigned char Array [] = { 0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 } ;
      return Array [ nMonth ] ;
   }
}



////////////////////////////////////////////
//               e̗j               //
////////////////////////////////////////////



// NjԂ
// j𐳐ŕԂi[jj
// s畉Ԃ
int DayOfWeek ( int nYear, int nMonth, int nDay ) {

   if ( nYear < 1583 || nYear > USHRT_MAX ) return -1 ;
   if ( nMonth < 1 || nMonth > 12 ) return -1 ;
   if ( nDay < 1 || nDay > MaxDayOfMonth ( nYear, nMonth ) ) return -1 ;

   // 1`2ON13`14ƂĈ
   if ( nMonth <= 2 ) {
      nYear -- ;
      nMonth += 12 ;
   }

   return ( nYear + nYear / 4 - nYear / 100 + nYear / 400 + ( 13 * nMonth + 8 ) / 5 + nDay ) % 7 ;
}



////////////////////////////////////////////
//            FILETIME ̌vZ             //
////////////////////////////////////////////



static inline uint64_t FileTimeToInt64 ( const FILETIME *pFileTime ) ;
static inline void Int64ToFileTime ( uint64_t nTime, FILETIME *pFileTime ) ;



// t@CZ
//  pX ɂ͐ΎԂw肷
//  pY ɂ͑ΎԂw肷
// ʂ pX ɐΎԂŊi[
// I[o[t[ 0 ȊOԂ
int AddFileTime ( FILETIME *pX, const FILETIME *pY ) {

   uint64_t X = FileTimeToInt64 ( pX ) ;
   uint64_t Y = FileTimeToInt64 ( pY ) ;

   uint64_t Z = X + Y ;
   Int64ToFileTime ( Z, pX ) ;

   if ( Z < X ) return 1 ;
   return 0 ;
}



// t@CZ
//  pX ɂ͐ΎԂw肷
//  pY ɐΎԂw肵Aʂ pX ɑΎԂŊi[
//  pY ɑΎԂw肵Aʂ pX ɐΎԂŊi[
// A_[t[ 0 ȊOԂ
int SubtractFileTime ( FILETIME *pX, const FILETIME *pY ) {

   uint64_t X = FileTimeToInt64 ( pX ) ;
   uint64_t Y = FileTimeToInt64 ( pY ) ;

   uint64_t Z = X - Y ;
   Int64ToFileTime ( Z, pX ) ;

   if ( Z > X ) return 1 ;
   return 0 ;
}



static inline uint64_t FileTimeToInt64 ( const FILETIME *pFileTime ) {

   const ULARGE_INTEGER T = MAKE_LARGE_INT ( pFileTime->dwHighDateTime, pFileTime->dwLowDateTime ) ;

   return T.QuadPart ;
}



static inline void Int64ToFileTime ( uint64_t nTime, FILETIME *pFileTime ) {

   ULARGE_INTEGER T ;

   T.QuadPart = nTime ;

   pFileTime->dwHighDateTime = T.HighPart ;
   pFileTime->dwLowDateTime = T.LowPart ;
}



////////////////////////////////////////////
//         FILETIME ̍쐬Ɖ          //
////////////////////////////////////////////



// SYSTEMTIME  FILETIME 
//  pX ɂ͑ΎԂw肷iKĂȂlj
//  pX  wYear, wMonth ɂ̓[w肷邱
// ʂ pX ɑΎԂŊi[
//  0 As 0 ȊOԂ
int MakeFileTime ( const SYSTEMTIME *pX, FILETIME *pY ) {

   if ( pX->wYear ) return 1 ;
   if ( pX->wMonth ) return 1 ;

   uint64_t Y = 0 ;

   Y += pX->wDay ;
   Y *= 24 ;

   Y += pX->wHour ;
   Y *= 60 ;

   Y += pX->wMinute ;
   Y *= 60 ;

   Y += pX->wSecond ;
   Y *= MILLISEC_PER_SEC ;

   Y += pX->wMilliseconds ;
   Y *= ( FILETIME_PER_SEC / MILLISEC_PER_SEC ) ;

   Int64ToFileTime ( Y, pY ) ;

   return 0 ;
}



// FILETIME  SYSTEMTIME 
//  pX ɂ͑ΎԂw肷
// ʂ pY ɑΎԂŊi[
// wYear, wMonth, wDayOfWeek ɂ̓[i[
// ~b͐؂̂Ă
//  0 As 0 ȊOԂ
int ParseFileTime ( const FILETIME *pX, SYSTEMTIME *pY ) {

   pY->wYear = 0 ;
   pY->wMonth = 0 ;
   pY->wDayOfWeek = 0 ;

   uint64_t X = FileTimeToInt64 ( pX ) ;

   X /= ( FILETIME_PER_SEC / MILLISEC_PER_SEC ) ;

   pY->wMilliseconds = (unsigned short) ( X % MILLISEC_PER_SEC ) ;
   X /= MILLISEC_PER_SEC ;

   pY->wSecond = (unsigned short) ( X % 60 ) ;
   X /= 60 ;

   pY->wMinute = (unsigned short) ( X % 60 ) ;
   X /= 60 ;

   pY->wHour = (unsigned short) ( X % 24 ) ;
   X /= 24 ;

   pY->wDay = (unsigned short) ( X ) ;

   if ( pY->wDay != X ) return 1 ;
   return 0 ;
}



////////////////////////////////////////////
//            ̓ǂݎ            //
////////////////////////////////////////////



static int strlcmp_word ( const char *string, const char *pattern, size_t *p_len ) ;
static int wcslcmp_word ( const wchar_t *string, const wchar_t *pattern, size_t *p_len ) ;
static void SwapDMY ( SYSTEMTIME *pX ) ;
static void SwapMDY ( SYSTEMTIME *pX ) ;
static int DebugDateTime ( SYSTEMTIME *pX ) ;



// 񂩂tEǂݎiANSIŁj
// 擪̋󔒂͓ǂݔ΂
// ~b͓ǂݎ̂Ă
// pNext ɒ̈̕ʒuۑiNULLłj
// ȗƂASYSTIME_SCAN_CEILING w肳Ă 23:59:59.999 Ƃ
// tȗƂA݂̓tw肵̂Ƃ
// pLocalTime ɂ̓[J̎i[ApFileTime ɂ UTC ɊÂt@Ci[iNULLłj
//  0 As 0 ȊOԂ
int ScanDateTimeA ( const char *szString, char **pNext, FILETIME *pFileTime, SYSTEMTIME *pLocalTime, unsigned long dwMode ) {

   SYSTEMTIME LocalTime ;

   while ( isspace ( *szString ) ) szString ++ ;
   if ( pNext ) *pNext = (char*) szString ;

   if ( ! isdigit ( *szString ) ) return 1 ;

   const char *szNext ;
   int nTmp = strtoul ( szString, & szNext, 10 ) ;
   if ( nTmp <= USHRT_MAX && isalpha ( *szNext ) ) {

      // Βl

      size_t nLength ;

      szString = szNext ;
      if ( pNext ) *pNext = (char*) szString ;

      SYSTEMTIME TimeAgo = { 0 } ;
      SYSTEMTIME TimeLater = { 0 } ;

      if      ( ! strlcmp_word ( szString, "yearsago",   & nLength ) ) TimeAgo.wYear = nTmp ;
      else if ( ! strlcmp_word ( szString, "monthsago",  & nLength ) ) TimeAgo.wMonth = nTmp ;
      else if ( ! strlcmp_word ( szString, "daysago",    & nLength ) ) TimeAgo.wDay = nTmp ;
      else if ( ! strlcmp_word ( szString, "hoursago",   & nLength ) ) TimeAgo.wHour = nTmp ;
      else if ( ! strlcmp_word ( szString, "minutesago", & nLength ) ) TimeAgo.wMinute = nTmp ;
      else if ( ! strlcmp_word ( szString, "secondsago", & nLength ) ) TimeAgo.wSecond = nTmp ;
      else if ( ! strlcmp_word ( szString, "yearslater",   & nLength ) ) TimeLater.wYear = nTmp ;
      else if ( ! strlcmp_word ( szString, "monthslater",  & nLength ) ) TimeLater.wMonth = nTmp ;
      else if ( ! strlcmp_word ( szString, "dayslater",    & nLength ) ) TimeLater.wDay = nTmp ;
      else if ( ! strlcmp_word ( szString, "hourslater",   & nLength ) ) TimeLater.wHour = nTmp ;
      else if ( ! strlcmp_word ( szString, "minuteslater", & nLength ) ) TimeLater.wMinute = nTmp ;
      else if ( ! strlcmp_word ( szString, "secondslater", & nLength ) ) TimeLater.wSecond = nTmp ;
      else return 1 ;

      szString += nLength ;
      if ( pNext ) *pNext = (char*) szString ;

      GetLocalTime ( & LocalTime ) ;
      if ( SubtractSystemTime ( & LocalTime, & TimeAgo, 0 ) ) return 1 ;
      if ( AddSystemTime ( & LocalTime, & TimeLater, 0 ) ) return 1 ;

   }
   else {

      // Βl

      int nLength ;

      if (  sscanf ( szString, "%hu-%hu-%hu%n", & LocalTime.wYear, & LocalTime.wMonth, & LocalTime.wDay, & nLength ) == 3
         || sscanf ( szString, "%hu/%hu/%hu%n", & LocalTime.wYear, & LocalTime.wMonth, & LocalTime.wDay, & nLength ) == 3
         || sscanf ( szString, "%hu.%hu.%hu%n", & LocalTime.wYear, & LocalTime.wMonth, & LocalTime.wDay, & nLength ) == 3
      ) {

         switch ( dwMode & ( SYSTIME_SCAN_DD_MM_YYYY | SYSTIME_SCAN_MM_DD_YYYY ) ) {
            case 0 : break ;
            case SYSTIME_SCAN_DD_MM_YYYY : SwapDMY ( & LocalTime ) ; break ;
            case SYSTIME_SCAN_MM_DD_YYYY : SwapMDY ( & LocalTime ) ; break ;
            default : return 1 ;
         }

         szString += nLength ;

         if ( *szString == ',' ) szString ++ ;

         if ( pNext ) *pNext = (char*) szString ;
         while ( isspace ( *szString ) ) szString ++ ;
      }
      else {
         GetLocalTime ( & LocalTime ) ;
      }

      if ( dwMode & SYSTIME_SCAN_CEILING ) {
         LocalTime.wHour = 23 ;
         LocalTime.wMinute = 59 ;
         LocalTime.wSecond = 59 ;
         LocalTime.wMilliseconds = 999 ;
      }
      else {
         LocalTime.wHour = 0 ;
         LocalTime.wMinute = 0 ;
         LocalTime.wSecond = 0 ;
         LocalTime.wMilliseconds = 0 ;
      }

      if ( isdigit ( *szString ) ) {

         if ( sscanf ( szString, "%hu:%hu:%hu%n", & LocalTime.wHour, & LocalTime.wMinute, & LocalTime.wSecond, & nLength ) == 3 ) {
            szString += nLength ;
            if ( ( *szString == ',' || *szString == '.' ) && isdigit ( *( szString + 1 ) ) ) {
               szString ++ ;
               // _ȉ͌ɂ炸A0,5  0,50  0,500 ꎋ
               for ( int nBase = MILLISEC_PER_SEC ; ( nBase /= 10 ) && isdigit ( *szString ) ; szString ++ ) {
                  LocalTime.wMilliseconds += ( *szString - '0' ) * nBase ;
               }
               // ɐꍇ́Aēǂݔ΂
               while ( isdigit ( *szString ) ) szString ++ ;
            }
         }
         else if ( sscanf ( szString, "%hu:%hu%n", & LocalTime.wHour, & LocalTime.wMinute, & nLength ) == 2 ) {
            szString += nLength ;
         }
         else return 1 ;

         if ( pNext ) *pNext = (char*) szString ;
      }
   }


   if ( 0 ) DebugDateTime ( & LocalTime ) ;

   SYSTEMTIME SystemTime = LocalTime ;
   FILETIME FileTime ;

   if ( LocalTimeToSystemTime ( & SystemTime, NULL ) ) return 1 ;
   if ( ! SystemTimeToFileTime ( & SystemTime, & FileTime ) ) return 1 ;

   if ( pLocalTime ) *pLocalTime = LocalTime ;
   if ( pFileTime ) *pFileTime = FileTime ;

   return 0 ;
}



// 񂩂tEǂݎiUNICODEŁj
// 擪̋󔒂͓ǂݔ΂
// ~b͓ǂݎ̂Ă
// pNext ɒ̈̕ʒuۑiNULLłj
// ȗƂASYSTIME_SCAN_CEILING w肳Ă 23:59:59.999 Ƃ
// tȗƂA݂̓tw肵̂Ƃ
// pLocalTime ɂ̓[J̎i[ApFileTime ɂ UTC ɊÂt@Ci[iNULLłj
//  0 As 0 ȊOԂ
int ScanDateTimeW ( const wchar_t *szString, wchar_t **pNext, FILETIME *pFileTime, SYSTEMTIME *pLocalTime, unsigned long dwMode ) {

   SYSTEMTIME LocalTime ;

   while ( isspace ( *szString ) ) szString ++ ;
   if ( pNext ) *pNext = (wchar_t*) szString ;

   if ( ! isdigit ( *szString ) ) return 1 ;

   const wchar_t *szNext ;
   int nTmp = wcstoul ( szString, & szNext, 10 ) ;
   if ( nTmp <= USHRT_MAX && isalpha ( *szNext ) ) {

      // Βl

      size_t nLength ;

      szString = szNext ;
      if ( pNext ) *pNext = (wchar_t*) szString ;

      SYSTEMTIME TimeAgo = { 0 } ;
      SYSTEMTIME TimeLater = { 0 } ;

      if      ( ! wcslcmp_word ( szString, L"yearsago",   & nLength ) ) TimeAgo.wYear = nTmp ;
      else if ( ! wcslcmp_word ( szString, L"monthsago",  & nLength ) ) TimeAgo.wMonth = nTmp ;
      else if ( ! wcslcmp_word ( szString, L"daysago",    & nLength ) ) TimeAgo.wDay = nTmp ;
      else if ( ! wcslcmp_word ( szString, L"hoursago",   & nLength ) ) TimeAgo.wHour = nTmp ;
      else if ( ! wcslcmp_word ( szString, L"minutesago", & nLength ) ) TimeAgo.wMinute = nTmp ;
      else if ( ! wcslcmp_word ( szString, L"secondsago", & nLength ) ) TimeAgo.wSecond = nTmp ;
      else if ( ! wcslcmp_word ( szString, L"yearslater",   & nLength ) ) TimeLater.wYear = nTmp ;
      else if ( ! wcslcmp_word ( szString, L"monthslater",  & nLength ) ) TimeLater.wMonth = nTmp ;
      else if ( ! wcslcmp_word ( szString, L"dayslater",    & nLength ) ) TimeLater.wDay = nTmp ;
      else if ( ! wcslcmp_word ( szString, L"hourslater",   & nLength ) ) TimeLater.wHour = nTmp ;
      else if ( ! wcslcmp_word ( szString, L"minuteslater", & nLength ) ) TimeLater.wMinute = nTmp ;
      else if ( ! wcslcmp_word ( szString, L"secondslater", & nLength ) ) TimeLater.wSecond = nTmp ;
      else return 1 ;

      szString += nLength ;
      if ( pNext ) *pNext = (wchar_t*) szString ;

      GetLocalTime ( & LocalTime ) ;
      if ( SubtractSystemTime ( & LocalTime, & TimeAgo, 0 ) ) return 1 ;
      if ( AddSystemTime ( & LocalTime, & TimeLater, 0 ) ) return 1 ;

   }
   else {

      // Βl

      int nLength ;

      if (  swscanf ( szString, L"%hu-%hu-%hu%n", & LocalTime.wYear, & LocalTime.wMonth, & LocalTime.wDay, & nLength ) == 3
         || swscanf ( szString, L"%hu/%hu/%hu%n", & LocalTime.wYear, & LocalTime.wMonth, & LocalTime.wDay, & nLength ) == 3
         || swscanf ( szString, L"%hu.%hu.%hu%n", & LocalTime.wYear, & LocalTime.wMonth, & LocalTime.wDay, & nLength ) == 3
      ) {

         switch ( dwMode & ( SYSTIME_SCAN_DD_MM_YYYY | SYSTIME_SCAN_MM_DD_YYYY ) ) {
            case 0 : break ;
            case SYSTIME_SCAN_DD_MM_YYYY : SwapDMY ( & LocalTime ) ; break ;
            case SYSTIME_SCAN_MM_DD_YYYY : SwapMDY ( & LocalTime ) ; break ;
            default : return 1 ;
         }

         szString += nLength ;

         if ( *szString == ',' ) szString ++ ;

         if ( pNext ) *pNext = (wchar_t*) szString ;
         while ( isspace ( *szString ) ) szString ++ ;
      }
      else {
         GetLocalTime ( & LocalTime ) ;
      }

      if ( dwMode & SYSTIME_SCAN_CEILING ) {
         LocalTime.wHour = 23 ;
         LocalTime.wMinute = 59 ;
         LocalTime.wSecond = 59 ;
         LocalTime.wMilliseconds = 999 ;
      }
      else {
         LocalTime.wHour = 0 ;
         LocalTime.wMinute = 0 ;
         LocalTime.wSecond = 0 ;
         LocalTime.wMilliseconds = 0 ;
      }

      if ( isdigit ( *szString ) ) {

         if ( swscanf ( szString, L"%hu:%hu:%hu%n", & LocalTime.wHour, & LocalTime.wMinute, & LocalTime.wSecond, & nLength ) == 3 ) {
            szString += nLength ;
            if ( ( *szString == ',' || *szString == '.' ) && isdigit ( *( szString + 1 ) ) ) {
               szString ++ ;
               // _ȉ͌ɂ炸A0,5  0,50  0,500 ꎋ
               for ( int nBase = MILLISEC_PER_SEC ; ( nBase /= 10 ) && isdigit ( *szString ) ; szString ++ ) {
                  LocalTime.wMilliseconds += ( *szString - '0' ) * nBase ;
               }
               // ɐꍇ́Aēǂݔ΂
               while ( isdigit ( *szString ) ) szString ++ ;
            }
         }
         else if ( swscanf ( szString, L"%hu:%hu%n", & LocalTime.wHour, & LocalTime.wMinute, & nLength ) == 2 ) {
            szString += nLength ;
         }
         else return 1 ;

         if ( pNext ) *pNext = (wchar_t*) szString ;
      }
   }


   if ( 0 ) DebugDateTime ( & LocalTime ) ;

   SYSTEMTIME SystemTime = LocalTime ;
   FILETIME FileTime ;

   if ( LocalTimeToSystemTime ( & SystemTime, NULL ) ) return 1 ;
   if ( ! SystemTimeToFileTime ( & SystemTime, & FileTime ) ) return 1 ;

   if ( pLocalTime ) *pLocalTime = LocalTime ;
   if ( pFileTime ) *pFileTime = FileTime ;

   return 0 ;
}



static int strlcmp_word ( const char *string, const char *pattern, size_t *p_len ) {

   size_t len = strlen ( pattern ) ;

   *p_len = len ;

   return strncmp ( string, pattern, len ) || isalnum ( *( string + len ) ) ;
}



static int wcslcmp_word ( const wchar_t *string, const wchar_t *pattern, size_t *p_len ) {

   size_t len = wcslen ( pattern ) ;

   *p_len = len ;

   return wcsncmp ( string, pattern, len ) || isalnum ( *( string + len ) ) ;
}



static inline void SwapUshort ( unsigned short *pX, unsigned short *pY ) {
   unsigned short T = *pX ;
   *pX = *pY ;
   *pY = T ;
}



static void SwapDMY ( SYSTEMTIME *pX ) {

   SwapUshort ( & pX->wYear, & pX->wDay ) ;

   if ( 0 ) DebugDateTime ( pX ) ;
}



static void SwapMDY ( SYSTEMTIME *pX ) {

   SwapUshort ( & pX->wYear, & pX->wDay ) ;
   SwapUshort ( & pX->wDay, & pX->wMonth ) ;

   if ( 0 ) DebugDateTime ( pX ) ;
}



static int DebugDateTime ( SYSTEMTIME *pX ) {

   printf ( "%d-%02d-%02d %02d:%02d:%02d.%03d\n", pX->wYear, pX->wMonth, pX->wDay, pX->wHour, pX->wMinute, pX->wSecond, pX->wMilliseconds ) ;

   return 0 ;
}



