// stringex.h

#ifndef STRINGEX_H
#define STRINGEX_H


#ifdef __cplusplus
extern "C" {
#endif


#ifndef CTYPE_FUNCTION_DECLARED
typedef int ( *CTYPE_FUNCTION ) ( int c ) ;
#define CTYPE_FUNCTION_DECLARED
#endif

////////////////////////////////////////////

// mbsnext  msc.h
// wcsnext  msc.h
// mbsnext_copy  msc.h
// wcsnext_copy  msc.h
int mbsprev ( const char *p, const char *start ) ;
int wcsprev ( const wchar_t *p ) ;

////////////////////////////////////////////

// strend  msc.h
// wcsend  msc.h
#if defined _MSC_VER && ! defined DEBUG_CONST_STRING
static inline wchar32_t *wcsend32 ( const wchar32_t *s ) {
   while ( *s ) s ++ ;
   return (wchar32_t*) s ;
}
#else
#define wcsend32(s)     wcschr32 ( s, 0 )
#endif
#define wcsend16     wcsend
#define mbsend       strend

////////////////////////////////////////////

// strcpy  CRT
// wcscpy  CRT
wchar32_t *wcscpy32 ( wchar32_t *dst, const wchar32_t *src ) ;
#define wcscpy16     wcscpy
#define mbscpy       strcpy

// strcat  CRT
// wcscat  CRT
wchar32_t *wcscat32 ( wchar32_t *dst, const wchar32_t *src ) ;
#define wcscat16     wcscat
#define mbscat       strcat

////////////////////////////////////////////

// strlcatlen  msc.h
// wcslcatlen  msc.h
size_t wcslcatlen16 ( wchar16_t *dst, const wchar16_t *src, size_t srclen, size_t bufsiz ) ;
size_t wcslcatlen32 ( wchar32_t *dst, const wchar32_t *src, size_t srclen, size_t bufsiz ) ;
size_t mbslcatlen ( char *dst, const char *src, size_t srclen, size_t bufsiz ) ;

// strlcat  msc.h
// wcslcat  msc.h
size_t wcslcat16 ( wchar16_t *dst, const wchar16_t *src, size_t bufsiz ) ;
size_t wcslcat32 ( wchar32_t *dst, const wchar32_t *src, size_t bufsiz ) ;
size_t mbslcat ( char *dst, const char *src, size_t bufsiz ) ;

////////////////////////////////////////////

// strlcpylen  msc.h
// wcslcpylen  msc.h
size_t wcslcpylen16 ( wchar16_t *dst, const wchar16_t *src, size_t srclen, size_t bufsiz ) ;
size_t wcslcpylen32 ( wchar32_t *dst, const wchar32_t *src, size_t srclen, size_t bufsiz ) ;
size_t mbslcpylen ( char *dst, const char *src, size_t srclen, size_t bufsiz ) ;

// strlcpy  msc.h
// wcslcpy  msc.h
size_t wcslcpy16 ( wchar16_t *dst, const wchar16_t *src, size_t bufsiz ) ;
size_t wcslcpy32 ( wchar32_t *dst, const wchar32_t *src, size_t bufsiz ) ;
size_t mbslcpy ( char *dst, const char *src, size_t bufsiz ) ;

////////////////////////////////////////////

char *strmove ( char *dst, const char *src ) ;
wchar_t *wcsmove ( wchar_t *dst, const wchar_t *src ) ;
wchar32_t *wcsmove32 ( wchar32_t *dst, const wchar32_t *src ) ;
#define wcsmove16    wcsmove
#define mbsmove      strmove

////////////////////////////////////////////

char *strinsert ( char *dst, const char *src, size_t dstlen ) ;
wchar_t *wcsinsert ( wchar_t *dst, const wchar_t *src, size_t dstlen ) ;
wchar32_t *wcsinsert32 ( wchar32_t *dst, const wchar32_t *src, size_t dstlen ) ;
#define wcsinsert16  wcsinsert
#define mbsinsert    strinsert

////////////////////////////////////////////

char *strlset ( char *dst, int c, size_t bufsiz ) ;
wchar_t *wcslset ( wchar_t *dst, int c, size_t bufsiz ) ;
wchar16_t *wcslset16 ( wchar16_t *dst, int c, size_t bufsiz ) ;
wchar32_t *wcslset32 ( wchar32_t *dst, int c, size_t bufsiz ) ;
char *mbslset ( char *dst, int c, size_t bufsiz ) ;

////////////////////////////////////////////

#if defined __BORLANDC__
#define stricmp stricmp_stringex_
#define strnicmp strnicmp_stringex_
#endif

// strcmp  CRT
// wcscmp  CRT
int wcscmp16 ( const wchar16_t *s1, const wchar16_t *s2 ) ;
int wcscmp32 ( const wchar32_t *s1, const wchar32_t *s2 ) ;
int mbscmp ( const char *s1, const char *s2 ) ;

// strncmp  CRT
// wcsncmp  CRT
int wcsncmp16 ( const wchar16_t *s1, const wchar16_t *s2, size_t n ) ;
int wcsncmp32 ( const wchar32_t *s1, const wchar32_t *s2, size_t n ) ;
int mbsncmp ( const char *s1, const char *s2, size_t n ) ;

int stricmp ( const char *s1, const char *s2 ) ;
int wcsicmp ( const wchar_t *s1, const wchar_t *s2 ) ;
int wcsicmp16 ( const wchar16_t *s1, const wchar16_t *s2 ) ;
int wcsicmp32 ( const wchar32_t *s1, const wchar32_t *s2 ) ;
int mbsicmp ( const char *s1, const char *s2 ) ;

int strnicmp ( const char *s1, const char *s2, size_t n ) ;
int wcsnicmp ( const wchar_t *s1, const wchar_t *s2, size_t n ) ;
int wcsnicmp16 ( const wchar16_t *s1, const wchar16_t *s2, size_t n ) ;
int wcsnicmp32 ( const wchar32_t *s1, const wchar32_t *s2, size_t n ) ;
int mbsnicmp ( const char *s1, const char *s2, size_t n ) ;

////////////////////////////////////////////

int strrcmp ( const char *s1, const char *s2 ) ;
int wcsrcmp ( const wchar_t *s1, const wchar_t *s2 ) ;
int wcsrcmp16 ( const wchar16_t *s1, const wchar16_t *s2 ) ;
int wcsrcmp32 ( const wchar32_t *s1, const wchar32_t *s2 ) ;
int mbsrcmp ( const char *s1, const char *s2 ) ;

int strrncmp ( const char *s1, const char *s2, size_t n ) ;
int wcsrncmp ( const wchar_t *s1, const wchar_t *s2, size_t n ) ;
int wcsrncmp16 ( const wchar16_t *s1, const wchar16_t *s2, size_t n ) ;
int wcsrncmp32 ( const wchar32_t *s1, const wchar32_t *s2, size_t n ) ;
int mbsrncmp ( const char *s1, const char *s2, size_t n ) ;

int strricmp ( const char *s1, const char *s2 ) ;
int wcsricmp ( const wchar_t *s1, const wchar_t *s2 ) ;
int wcsricmp16 ( const wchar16_t *s1, const wchar16_t *s2 ) ;
int wcsricmp32 ( const wchar32_t *s1, const wchar32_t *s2 ) ;
int mbsricmp ( const char *s1, const char *s2 ) ;

int strrnicmp ( const char *s1, const char *s2, size_t n ) ;
int wcsrnicmp ( const wchar_t *s1, const wchar_t *s2, size_t n ) ;
int wcsrnicmp16 ( const wchar16_t *s1, const wchar16_t *s2, size_t n ) ;
int wcsrnicmp32 ( const wchar32_t *s1, const wchar32_t *s2, size_t n ) ;
int mbsrnicmp ( const char *s1, const char *s2, size_t n ) ;

////////////////////////////////////////////

// Compares leading part of strings
int strlcmp ( const char *s, const char *p, size_t *l ) ;
int wcslcmp ( const wchar_t *s, const wchar_t *p, size_t *l ) ;
int wcslcmp16 ( const wchar16_t *s, const wchar16_t *p, size_t *l ) ;
int wcslcmp32 ( const wchar32_t *s, const wchar32_t *p, size_t *l ) ;
int mbslcmp ( const char *s, const char *p, size_t *l ) ;

int strlicmp ( const char *s, const char *p, size_t *l ) ;
int wcslicmp ( const wchar_t *s, const wchar_t *p, size_t *l ) ;
int wcslicmp16 ( const wchar16_t *s, const wchar16_t *p, size_t *l ) ;
int wcslicmp32 ( const wchar32_t *s, const wchar32_t *p, size_t *l ) ;
int mbslicmp ( const char *s, const char *p, size_t *l ) ;

int strlcmp_word ( const char *s, const char *p, size_t *l, CTYPE_FUNCTION d ) ;
int wcslcmp_word ( const wchar_t *s, const wchar_t *p, size_t *l, CTYPE_FUNCTION d ) ;
int wcslcmp16_word ( const wchar16_t *s, const wchar16_t *p, size_t *l, CTYPE_FUNCTION d ) ;
int wcslcmp32_word ( const wchar32_t *s, const wchar32_t *p, size_t *l, CTYPE_FUNCTION d ) ;
int mbslcmp_word ( const char *s, const char *p, size_t *l, CTYPE_FUNCTION d ) ;

int strlicmp_word ( const char *s, const char *p, size_t *l, CTYPE_FUNCTION d ) ;
int wcslicmp_word ( const wchar_t *s, const wchar_t *p, size_t *l, CTYPE_FUNCTION d ) ;
int wcslicmp16_word ( const wchar16_t *s, const wchar16_t *p, size_t *l, CTYPE_FUNCTION d ) ;
int wcslicmp32_word ( const wchar32_t *s, const wchar32_t *p, size_t *l, CTYPE_FUNCTION d ) ;
int mbslicmp_word ( const char *s, const char *p, size_t *l, CTYPE_FUNCTION d ) ;

////////////////////////////////////////////

// Compares trailing part of strings
int strtcmp ( const char *s, const char *p, size_t *l ) ;
int wcstcmp ( const wchar_t *s, const wchar_t *p, size_t *l ) ;
int wcstcmp16 ( const wchar16_t *s, const wchar16_t *p, size_t *l ) ;
int wcstcmp32 ( const wchar32_t *s, const wchar32_t *p, size_t *l ) ;
int mbstcmp ( const char *s, const char *p, size_t *l ) ;

int strticmp ( const char *s, const char *p, size_t *l ) ;
int wcsticmp ( const wchar_t *s, const wchar_t *p, size_t *l ) ;
int wcsticmp16 ( const wchar16_t *s, const wchar16_t *p, size_t *l ) ;
int wcsticmp32 ( const wchar32_t *s, const wchar32_t *p, size_t *l ) ;
int mbsticmp ( const char *s, const char *p, size_t *l ) ;

int strtcmp_word ( const char *s, const char *p, size_t *l, CTYPE_FUNCTION d ) ;
int wcstcmp_word ( const wchar_t *s, const wchar_t *p, size_t *l, CTYPE_FUNCTION d ) ;
int wcstcmp16_word ( const wchar16_t *s, const wchar16_t *p, size_t *l, CTYPE_FUNCTION d ) ;
int wcstcmp32_word ( const wchar32_t *s, const wchar32_t *p, size_t *l, CTYPE_FUNCTION d ) ;
int mbstcmp_word ( const char *s, const char *p, size_t *l, CTYPE_FUNCTION d ) ;

int strticmp_word ( const char *s, const char *p, size_t *l, CTYPE_FUNCTION d ) ;
int wcsticmp_word ( const wchar_t *s, const wchar_t *p, size_t *l, CTYPE_FUNCTION d ) ;
int wcsticmp16_word ( const wchar16_t *s, const wchar16_t *p, size_t *l, CTYPE_FUNCTION d ) ;
int wcsticmp32_word ( const wchar32_t *s, const wchar32_t *p, size_t *l, CTYPE_FUNCTION d ) ;
int mbsticmp_word ( const char *s, const char *p, size_t *l, CTYPE_FUNCTION d ) ;

////////////////////////////////////////////

// strchr  CRT
// wcschr  CRT
wchar16_t *wcschr16 ( const wchar16_t *s, int c ) ;
wchar32_t *wcschr32 ( const wchar32_t *s, int c ) ;
char *mbschr ( const char *s, int c ) ;

char *strchri ( const char *s, int c ) ;
wchar_t *wcschri ( const wchar_t *s, int c ) ;
wchar16_t *wcschri16 ( const wchar16_t *s, int c ) ;
wchar32_t *wcschri32 ( const wchar32_t *s, int c ) ;
char *mbschri ( const char *s, int c ) ;

// strrchr  CRT
// wcsrchr  CRT
wchar16_t *wcsrchr16 ( const wchar16_t *s, int c ) ;
wchar32_t *wcsrchr32 ( const wchar32_t *s, int c ) ;
char *mbsrchr ( const char *s, int c ) ;

char *strrchri ( const char *s, int c ) ;
wchar_t *wcsrchri ( const wchar_t *s, int c ) ;
wchar16_t *wcsrchri16 ( const wchar16_t *s, int c ) ;
wchar32_t *wcsrchri32 ( const wchar32_t *s, int c ) ;
char *mbsrchri ( const char *s, int c ) ;

////////////////////////////////////////////

// strstr  CRT
// wcsstr  CRT
wchar32_t *wcsstr32 ( const wchar32_t *s, const wchar32_t *p ) ;
char *mbsstr ( const char *s, const char *p ) ;

char *strstri ( const char *s, const char *p ) ;
wchar_t *wcsstri ( const wchar_t *s, const wchar_t *p ) ;
wchar32_t *wcsstri32 ( const wchar32_t *s, const wchar32_t *p ) ;
char *mbsstri ( const char *s, const char *p ) ;

char *strrstr ( const char *s, const char *p ) ;
wchar_t *wcsrstr ( const wchar_t *s, const wchar_t *p ) ;
wchar32_t *wcsrstr32 ( const wchar32_t *s, const wchar32_t *p ) ;
char *mbsrstr ( const char *s, const char *p ) ;

char *strrstri ( const char *s, const char *p ) ;
wchar_t *wcsrstri ( const wchar_t *s, const wchar_t *p ) ;
wchar32_t *wcsrstri32 ( const wchar32_t *s, const wchar32_t *p ) ;
char *mbsrstri ( const char *s, const char *p ) ;

char *strstr_word ( const char *s, const char *p, CTYPE_FUNCTION d ) ;
wchar_t *wcsstr_word ( const wchar_t *s, const wchar_t *p, CTYPE_FUNCTION d ) ;
wchar32_t *wcsstr32_word ( const wchar32_t *s, const wchar32_t *p, CTYPE_FUNCTION d ) ;
char *mbsstr_word ( const char *s, const char *p, CTYPE_FUNCTION d ) ;

char *strstri_word ( const char *s, const char *p, CTYPE_FUNCTION d ) ;
wchar_t *wcsstri_word ( const wchar_t *s, const wchar_t *p, CTYPE_FUNCTION d ) ;
wchar32_t *wcsstri32_word ( const wchar32_t *s, const wchar32_t *p, CTYPE_FUNCTION d ) ;
char *mbsstri_word ( const char *s, const char *p, CTYPE_FUNCTION d ) ;

char *strrstr_word ( const char *s, const char *p, CTYPE_FUNCTION d ) ;
wchar_t *wcsrstr_word ( const wchar_t *s, const wchar_t *p, CTYPE_FUNCTION d ) ;
wchar32_t *wcsrstr32_word ( const wchar32_t *s, const wchar32_t *p, CTYPE_FUNCTION d ) ;
char *mbsrstr_word ( const char *s, const char *p, CTYPE_FUNCTION d ) ;

char *strrstri_word ( const char *s, const char *p, CTYPE_FUNCTION d ) ;
wchar_t *wcsrstri_word ( const wchar_t *s, const wchar_t *p, CTYPE_FUNCTION d ) ;
wchar32_t *wcsrstri32_word ( const wchar32_t *s, const wchar32_t *p, CTYPE_FUNCTION d ) ;
char *mbsrstri_word ( const char *s, const char *p, CTYPE_FUNCTION d ) ;

#define wcsstr16           wcsstr
#define wcsstri16          wcsstri
#define wcsrstr16          wcsrstr
#define wcsrstri16         wcsrstri
#define wcsstr16_word      wcsstr_word
#define wcsstri16_word     wcsstri_word
#define wcsrstr16_word     wcsrstr_word
#define wcsrstri16_word    wcsrstri_word

////////////////////////////////////////////

size_t strcount ( const char *s, const char *p ) ;
size_t wcscount ( const wchar_t *s, const wchar_t *p ) ;
size_t wcscount16 ( const wchar16_t *s, const wchar16_t *p ) ;
size_t wcscount32 ( const wchar32_t *s, const wchar32_t *p ) ;
size_t mbscount ( const char *s, const char *p ) ;

size_t strcounti ( const char *s, const char *p ) ;
size_t wcscounti ( const wchar_t *s, const wchar_t *p ) ;
size_t wcscounti16 ( const wchar16_t *s, const wchar16_t *p ) ;
size_t wcscounti32 ( const wchar32_t *s, const wchar32_t *p ) ;
size_t mbscounti ( const char *s, const char *p ) ;

size_t strcount_word ( const char *s, const char *p, CTYPE_FUNCTION d ) ;
size_t wcscount_word ( const wchar_t *s, const wchar_t *p, CTYPE_FUNCTION d ) ;
size_t wcscount16_word ( const wchar16_t *s, const wchar16_t *p, CTYPE_FUNCTION d ) ;
size_t wcscount32_word ( const wchar32_t *s, const wchar32_t *p, CTYPE_FUNCTION d ) ;
size_t mbscount_word ( const char *s, const char *p, CTYPE_FUNCTION d ) ;

size_t strcounti_word ( const char *s, const char *p, CTYPE_FUNCTION d ) ;
size_t wcscounti_word ( const wchar_t *s, const wchar_t *p, CTYPE_FUNCTION d ) ;
size_t wcscounti16_word ( const wchar16_t *s, const wchar16_t *p, CTYPE_FUNCTION d ) ;
size_t wcscounti32_word ( const wchar32_t *s, const wchar32_t *p, CTYPE_FUNCTION d ) ;
size_t mbscounti_word ( const char *s, const char *p, CTYPE_FUNCTION d ) ;

#define wcscount16         wcscount
#define wcscounti16        wcscounti
#define wcscount16_word    wcscount_word
#define wcscounti16_word   wcscounti_word

////////////////////////////////////////////

size_t strreplace ( char *s, const char *p, const char *r, char **n, size_t m ) ;
size_t wcsreplace ( wchar_t *s, const wchar_t *p, const wchar_t *r, wchar_t **n, size_t m ) ;
size_t wcsreplace16 ( wchar16_t *s, const wchar16_t *p, const wchar16_t *r, wchar16_t **n, size_t m ) ;
size_t wcsreplace32 ( wchar32_t *s, const wchar32_t *p, const wchar32_t *r, wchar32_t **n, size_t m ) ;
size_t mbsreplace ( char *s, const char *p, const char *r, char **n, size_t m ) ;

size_t strreplacei ( char *s, const char *p, const char *r, char **n, size_t m ) ;
size_t wcsreplacei ( wchar_t *s, const wchar_t *p, const wchar_t *r, wchar_t **n, size_t m ) ;
size_t wcsreplacei16 ( wchar16_t *s, const wchar16_t *p, const wchar16_t *r, wchar16_t **n, size_t m ) ;
size_t wcsreplacei32 ( wchar32_t *s, const wchar32_t *p, const wchar32_t *r, wchar32_t **n, size_t m ) ;
size_t mbsreplacei ( char *s, const char *p, const char *r, char **n, size_t m ) ;

size_t strreplace_word ( char *s, const char *p, const char *r, char **n, size_t m, CTYPE_FUNCTION d ) ;
size_t wcsreplace_word ( wchar_t *s, const wchar_t *p, const wchar_t *r, wchar_t **n, size_t m, CTYPE_FUNCTION d ) ;
size_t wcsreplace16_word ( wchar16_t *s, const wchar16_t *p, const wchar16_t *r, wchar16_t **n, size_t m, CTYPE_FUNCTION d ) ;
size_t wcsreplace32_word ( wchar32_t *s, const wchar32_t *p, const wchar32_t *r, wchar32_t **n, size_t m, CTYPE_FUNCTION d ) ;
size_t mbsreplace_word ( char *s, const char *p, const char *r, char **n, size_t m, CTYPE_FUNCTION d ) ;

size_t strreplacei_word ( char *s, const char *p, const char *r, char **n, size_t m, CTYPE_FUNCTION d ) ;
size_t wcsreplacei_word ( wchar_t *s, const wchar_t *p, const wchar_t *r, wchar_t **n, size_t m, CTYPE_FUNCTION d ) ;
size_t wcsreplacei16_word ( wchar16_t *s, const wchar16_t *p, const wchar16_t *r, wchar16_t **n, size_t m, CTYPE_FUNCTION d ) ;
size_t wcsreplacei32_word ( wchar32_t *s, const wchar32_t *p, const wchar32_t *r, wchar32_t **n, size_t m, CTYPE_FUNCTION d ) ;
size_t mbsreplacei_word ( char *s, const char *p, const char *r, char **n, size_t m, CTYPE_FUNCTION d ) ;

#define wcsreplace16          wcsreplace
#define wcsreplacei16         wcsreplacei
#define wcsreplace16_word     wcsreplace_word
#define wcsreplacei16_word    wcsreplacei_word

////////////////////////////////////////////

int strltrim ( char *string ) ;
int wcsltrim ( wchar_t *string ) ;
int strrtrim ( char *string ) ;
int wcsrtrim ( wchar_t *string ) ;

////////////////////////////////////////////

char *strtokex ( char *string, char **p_next, const char *delimiter ) ;
wchar_t *wcstokex ( wchar_t *string, wchar_t **p_next, const wchar_t *delimiter ) ;
wchar32_t *wcstokex32 ( wchar32_t *string, wchar32_t **p_next, const wchar32_t *delimiter ) ;
#define wcstokex16   wcstokex

////////////////////////////////////////////

int strscan ( const char *string, const char *format, char *buffer, size_t size, size_t *len ) ;
int wcsscan ( const wchar_t *string, const wchar_t *format, wchar_t *buffer, size_t size, size_t *len ) ;
int wcsscan32 ( const wchar32_t *string, const wchar32_t *format, wchar32_t *buffer, size_t size, size_t *len ) ;
int mbsscan ( const char *string, const char *format, char *buffer, size_t size, size_t *len ) ;

////////////////////////////////////////////

// strduplen_expand  msc.h
// wcsduplen_expand  msc.h
wchar32_t *wcsduplen_expand32 ( const wchar32_t *string, size_t srclen, size_t maxlen, size_t addlen ) ;

#define wcsduplen16        wcsduplen
#define wcsdup_expand16    wcsdup_expand
#define wcsdup16           wcsdup
wchar32_t *wcsduplen32     ( const wchar32_t *string, size_t srclen ) ;
wchar32_t *wcsdup_expand32 ( const wchar32_t *string, size_t maxlen, size_t addlen ) ;
wchar32_t *wcsdup32        ( const wchar32_t *string ) ;

////////////////////////////////////////////

//                              Ԃ   |C^Ԃ
// ɍȂT     strspn       strspnp
// ɍT         strcspn      strpbrk

// strspn  CRT
// wcsspn  CRT
size_t wcsspn16 ( const wchar16_t *string, const wchar16_t *keys ) ;
size_t wcsspn32 ( const wchar32_t *string, const wchar32_t *keys ) ;
size_t mbsspn ( const char *string, const char *keys ) ;

// strcspn  CRT
// wcscspn  CRT
size_t wcscspn16 ( const wchar16_t *string, const wchar16_t *keys ) ;
size_t wcscspn32 ( const wchar32_t *string, const wchar32_t *keys ) ;
size_t mbscspn ( const char *string, const char *keys ) ;

char *strspnp ( const char *string, const char *keys ) ;
wchar_t *wcsspnp ( const wchar_t *string, const wchar_t *keys ) ;
wchar16_t *wcsspnp16 ( const wchar16_t *string, const wchar16_t *keys ) ;
wchar32_t *wcsspnp32 ( const wchar32_t *string, const wchar32_t *keys ) ;
char *mbsspnp ( const char *string, const char *keys ) ;

// strpbrk  CRT
// wcspbrk  CRT
wchar16_t *wcspbrk16 ( const wchar16_t *string, const wchar16_t *keys ) ;
wchar32_t *wcspbrk32 ( const wchar32_t *string, const wchar32_t *keys ) ;
char *mbspbrk ( const char *string, const char *keys ) ;

////////////////////////////////////////////

#if defined __BORLANDC__
#undef strlwr
#undef strupr
#endif
#if defined __BORLANDC__ || defined __DMC__
#define strlwr strlwr_stringex_
#define strupr strupr_stringex_
#define wcslwr wcslwr_stringex_
#define wcsupr wcsupr_stringex_
#endif

char *strlwr ( char *string ) ;
wchar_t *wcslwr ( wchar_t *string ) ;
wchar32_t *wcslwr32 ( wchar32_t *string ) ;
char *mbslwr ( char *string ) ;
wchar_t *wcslwrex ( wchar_t *string ) ;
#define wcslwr16     wcslwr

char *strupr ( char *string ) ;
wchar_t *wcsupr ( wchar_t *string ) ;
wchar32_t *wcsupr32 ( wchar32_t *string ) ;
char *mbsupr ( char *string ) ;
wchar_t *wcsuprex ( wchar_t *string ) ;
#define wcsupr16     wcsupr

////////////////////////////////////////////

char *strquote ( char *string, const char *left, const char *right ) ;
wchar_t *wcsquote ( wchar_t *string, const wchar_t *left, const wchar_t *right ) ;
wchar32_t *wcsquote32 ( wchar32_t *string, const wchar32_t *left, const wchar32_t *right ) ;
#define wcsquote16   wcsquote
#define mbsquote     strquote

////////////////////////////////////////////

#if defined __BORLANDC__
#define strrev strrev_stringex_
#endif

char *strrev ( char *string ) ;
wchar_t *wcsrev ( wchar_t *string ) ;
wchar16_t *wcsrev16 ( wchar16_t *string ) ;
wchar32_t *wcsrev32 ( wchar32_t *string ) ;
char *mbsrev ( char *string ) ;

////////////////////////////////////////////

char *strtrunc ( char *string, size_t len ) ;
wchar_t *wcstrunc ( wchar_t *string, size_t len ) ;
wchar16_t *wcstrunc16 ( wchar16_t *string, size_t len ) ;
wchar32_t *wcstrunc32 ( wchar32_t *string, size_t len ) ;
char *mbstrunc ( char *string, size_t len ) ;

////////////////////////////////////////////

// strlen  CRT
// wcslen  CRT
size_t wcslen16 ( const wchar16_t *string ) ;
size_t wcslen32 ( const wchar32_t *string ) ;
size_t mbslen ( const char *string ) ;

////////////////////////////////////////////

//                              Ԃ   |C^Ԃ
// ɍȂT     strspn_type  strspnp_type
// ɍT         Ȃ         Ȃ
//
// strcspn  strpbrk ɑ鑀́A֐tɂ strspn_type  strspnp_type g

size_t strspn_type ( const char *string, CTYPE_FUNCTION istype ) ;
size_t wcsspn_type ( const wchar_t *string, CTYPE_FUNCTION istype ) ;
size_t wcsspn16_type ( const wchar16_t *string, CTYPE_FUNCTION istype ) ;
size_t wcsspn32_type ( const wchar32_t *string, CTYPE_FUNCTION istype ) ;
size_t mbsspn_type ( const char *string, CTYPE_FUNCTION istype ) ;

char *strspnp_type ( const char *string, CTYPE_FUNCTION istype ) ;
wchar_t *wcsspnp_type ( const wchar_t *string, CTYPE_FUNCTION istype ) ;
wchar16_t *wcsspnp16_type ( const wchar16_t *string, CTYPE_FUNCTION istype ) ;
wchar32_t *wcsspnp32_type ( const wchar32_t *string, CTYPE_FUNCTION istype ) ;
char *mbsspnp_type ( const char *string, CTYPE_FUNCTION istype ) ;

////////////////////////////////////////////

int isstrtype ( const char *string, CTYPE_FUNCTION istype ) ;
int iswcstype ( const wchar_t *string, CTYPE_FUNCTION istype ) ;
int iswcstype16 ( const wchar16_t *string, CTYPE_FUNCTION istype ) ;
int iswcstype32 ( const wchar32_t *string, CTYPE_FUNCTION istype ) ;
int ismbstype ( const char *string, CTYPE_FUNCTION istype ) ;

int mbsbtype ( const char *string, size_t count ) ;
int ismbslead ( const char *string, const char *current ) ;
int ismbstrail ( const char *string, const char *current ) ;

////////////////////////////////////////////

int IS_CTYPE_ASCII  ( int c ) ;
int IS_CTYPE_ALPHA  ( int c ) ;
int IS_CTYPE_UPPER  ( int c ) ;
int IS_CTYPE_LOWER  ( int c ) ;
int IS_CTYPE_DIGIT  ( int c ) ;
int IS_CTYPE_XDIGIT ( int c ) ;
int IS_CTYPE_SPACE  ( int c ) ;
int IS_CTYPE_PUNCT  ( int c ) ;
int IS_CTYPE_ALNUM  ( int c ) ;
int IS_CTYPE_PRINT  ( int c ) ;
int IS_CTYPE_GRAPH  ( int c ) ;
int IS_CTYPE_CNTRL  ( int c ) ;
int IS_CTYPE_BLANK  ( int c ) ;
int IS_CTYPE_CSYM   ( int c ) ;

int IS_CTYPE_NO_ASCII  ( int c ) ;
int IS_CTYPE_NO_ALPHA  ( int c ) ;
int IS_CTYPE_NO_UPPER  ( int c ) ;
int IS_CTYPE_NO_LOWER  ( int c ) ;
int IS_CTYPE_NO_DIGIT  ( int c ) ;
int IS_CTYPE_NO_XDIGIT ( int c ) ;
int IS_CTYPE_NO_SPACE  ( int c ) ;
int IS_CTYPE_NO_PUNCT  ( int c ) ;
int IS_CTYPE_NO_ALNUM  ( int c ) ;
int IS_CTYPE_NO_PRINT  ( int c ) ;
int IS_CTYPE_NO_GRAPH  ( int c ) ;
int IS_CTYPE_NO_CNTRL  ( int c ) ;
int IS_CTYPE_NO_BLANK  ( int c ) ;
int IS_CTYPE_NO_CSYM   ( int c ) ;


////////////////////////////////////////////


#ifdef __cplusplus
}
#endif



#if defined DEBUG_CONST_STRING && defined __cplusplus    // for debug

#define FUNC_STR_INT(func,type)  \
   static const type *func##_ ( const type *s, int c ) { return func ( s, c ) ; } \
   static       type *func##_ (       type *s, int c ) { return func ( s, c ) ; }

#define FUNC_STR_STR(func,type)  \
   static const type *func##_ ( const type *s1, const type *s2 ) { return func ( s1, s2 ) ; } \
   static       type *func##_ (       type *s1, const type *s2 ) { return func ( s1, s2 ) ; }

#define FUNC_STR_STR_FNC(func,type) \
   static const type *func##_ ( const type *s1, const type *s2, CTYPE_FUNCTION f ) { return func ( s1, s2, f ) ; } \
   static       type *func##_ (       type *s1, const type *s2, CTYPE_FUNCTION f ) { return func ( s1, s2, f ) ; }

#define FUNC_STR_FNC(func,type)  \
   static const type *func##_ ( const type *s, CTYPE_FUNCTION f ) { return func ( s, f ) ; } \
   static       type *func##_ (       type *s, CTYPE_FUNCTION f ) { return func ( s, f ) ; }

FUNC_STR_INT ( wcschr16, wchar16_t )
FUNC_STR_INT ( wcschr32, wchar32_t )
FUNC_STR_INT ( mbschr, char )
FUNC_STR_INT ( strchri, char )
FUNC_STR_INT ( wcschri, wchar_t )
FUNC_STR_INT ( wcschri16, wchar16_t )
FUNC_STR_INT ( wcschri32, wchar32_t )
FUNC_STR_INT ( mbschri, char )
FUNC_STR_INT ( wcsrchr16, wchar16_t )
FUNC_STR_INT ( wcsrchr32, wchar32_t )
FUNC_STR_INT ( mbsrchr, char )
FUNC_STR_INT ( strrchri, char )
FUNC_STR_INT ( wcsrchri, wchar_t )
FUNC_STR_INT ( wcsrchri16 , wchar16_t )
FUNC_STR_INT ( wcsrchri32 , wchar32_t )
FUNC_STR_INT ( mbsrchri, char )

FUNC_STR_STR ( wcsstr32, wchar32_t )
FUNC_STR_STR ( mbsstr, char )
FUNC_STR_STR ( strstri, char )
FUNC_STR_STR ( wcsstri, wchar_t )
FUNC_STR_STR ( wcsstri32, wchar32_t )
FUNC_STR_STR ( mbsstri, char )
FUNC_STR_STR ( strrstr, char )
FUNC_STR_STR ( wcsrstr, wchar_t )
FUNC_STR_STR ( wcsrstr32, wchar32_t )
FUNC_STR_STR ( mbsrstr, char )
FUNC_STR_STR ( strrstri, char )
FUNC_STR_STR ( wcsrstri, wchar_t )
FUNC_STR_STR ( wcsrstri32, wchar32_t )
FUNC_STR_STR ( mbsrstri, char )
FUNC_STR_STR_FNC ( strstr_word, char )
FUNC_STR_STR_FNC ( wcsstr_word, wchar_t )
FUNC_STR_STR_FNC ( wcsstr32_word, wchar32_t )
FUNC_STR_STR_FNC ( mbsstr_word, char )
FUNC_STR_STR_FNC ( strstri_word, char )
FUNC_STR_STR_FNC ( wcsstri_word, wchar_t )
FUNC_STR_STR_FNC ( wcsstri32_word, wchar32_t )
FUNC_STR_STR_FNC ( mbsstri_word, char )
FUNC_STR_STR_FNC ( strrstr_word, char )
FUNC_STR_STR_FNC ( wcsrstr_word, wchar_t )
FUNC_STR_STR_FNC ( wcsrstr32_word, wchar32_t )
FUNC_STR_STR_FNC ( mbsrstr_word, char )
FUNC_STR_STR_FNC ( strrstri_word, char )
FUNC_STR_STR_FNC ( wcsrstri_word, wchar_t )
FUNC_STR_STR_FNC ( wcsrstri32_word, wchar32_t )
FUNC_STR_STR_FNC ( mbsrstri_word, char )

FUNC_STR_STR ( strspnp, char )
FUNC_STR_STR ( wcsspnp, wchar_t )
FUNC_STR_STR ( wcsspnp16, wchar_t )
FUNC_STR_STR ( wcsspnp32, wchar32_t )
FUNC_STR_STR ( mbsspnp, char )

FUNC_STR_STR ( wcspbrk16, wchar16_t )
FUNC_STR_STR ( wcspbrk32, wchar32_t )
FUNC_STR_STR ( mbspbrk, char )

FUNC_STR_FNC ( strspnp_type, char )
FUNC_STR_FNC ( wcsspnp_type, wchar_t )
FUNC_STR_FNC ( wcsspnp16_type, wchar16_t )
FUNC_STR_FNC ( wcsspnp32_type, wchar32_t )
FUNC_STR_FNC ( mbsspnp_type, char )

#undef FUNC_STR_INT
#undef FUNC_STR_STR
#undef FUNC_STR_STR_FNC
#undef FUNC_STR_FNC

#define wcschr16           wcschr16_
#define wcschr32           wcschr32_
#define mbschr             mbschr_
#define strchri            strchri_
#define wcschri            wcschri_
#define wcschri16          wcschri16_
#define wcschri32          wcschri32_
#define mbschri            mbschri_
#define wcsrchr16          wcsrchr16_
#define wcsrchr32          wcsrchr32_
#define mbsrchr            mbsrchr_
#define strrchri           strrchri_
#define wcsrchri           wcsrchri_
#define wcsrchri16         wcsrchri16_
#define wcsrchri32         wcsrchri32_
#define mbsrchri           mbsrchri_

#define wcsstr32           wcsstr32_
#define mbsstr             mbsstr_
#define strstri            strstri_
#define wcsstri            wcsstri_
#define wcsstri32          wcsstri32_
#define mbsstri            mbsstri_
#define strrstr            strrstr_
#define wcsrstr            wcsrstr_
#define wcsrstr32          wcsrstr32_
#define mbsrstr            mbsrstr_
#define strrstri           strrstri_
#define wcsrstri           wcsrstri_
#define wcsrstri32         wcsrstri32_
#define mbsrstri           mbsrstri_
#define strstr_word        strstr_word_
#define wcsstr_word        wcsstr_word_
#define wcsstr32_word      wcsstr32_word_
#define mbsstr_word        mbsstr_word_
#define strstri_word       strstri_word_
#define wcsstri_word       wcsstri_word_
#define wcsstri32_word     wcsstri32_word_
#define mbsstri_word       mbsstri_word_
#define strrstr_word       strrstr_word_
#define wcsrstr_word       wcsrstr_word_
#define wcsrstr32_word     wcsrstr32_word_
#define mbsrstr_word       mbsrstr_word_
#define strrstri_word      strrstri_word_
#define wcsrstri_word      wcsrstri_word_
#define wcsrstri32_word    wcsrstri32_word_
#define mbsrstri_word      mbsrstri_word_

#define strspnp      strspnp_
#define wcsspnp      wcsspnp_
#define wcsspnp16    wcsspnp16_
#define wcsspnp32    wcsspnp32_
#define mbsspnp      mbsspnp_

#define wcspbrk16    wcspbrk16_
#define wcspbrk32    wcspbrk32_
#define mbspbrk      mbspbrk_

#define strspnp_type    strspnp_type_
#define wcsspnp_type    wcsspnp_type_
#define wcsspnp16_type  wcsspnp16_type_
#define wcsspnp32_type  wcsspnp32_type_
#define mbsspnp_type    mbsspnp_type_

#endif // defined DEBUG_CONST_STRING && defined __cplusplus



#endif


