// storestr.h

#ifndef STORESTR_H
#define STORESTR_H


#ifdef __cplusplus
extern "C" {
#endif


#define STOREDSTRINGS_ERROR   ( (const void*) -1 )


// STOREDSTRINGS \
typedef struct STOREDSTRINGSA_TAG STOREDSTRINGSA ;
typedef struct STOREDSTRINGSW_TAG STOREDSTRINGSW ;

// ʒu̕ۑ
typedef struct {
   size_t nOffset ;
   size_t nCount ;
} STOREDSTRINGS_POSITION ;


int StoreStringA ( STOREDSTRINGSA **pStoredStrings, const char *szString ) ;
void FreeStoredStringsA ( STOREDSTRINGSA **pStoredStrings ) ;
const char *GetFirstStringA ( STOREDSTRINGSA *StoredStrings ) ;
const char *GetNextStringA ( STOREDSTRINGSA *StoredStrings ) ;
size_t GetStringsCountA ( const STOREDSTRINGSA *StoredStrings ) ;
int MergeStoredStringsA ( STOREDSTRINGSA **pStoredStrings, const STOREDSTRINGSA *StoredStringsToAdd ) ;
int GetStringPositionA ( const STOREDSTRINGSA *StoredStrings, STOREDSTRINGS_POSITION *Position, int IsReadingPosition ) ;
int SortStoredStringsA ( const STOREDSTRINGSA *StoredStrings, const STOREDSTRINGS_POSITION *Start, const STOREDSTRINGS_POSITION *End, int ( __cdecl *CompareFunction ) ( const char **, const char ** ), unsigned long dwMode ) ;
const char *FindStoredStringA ( const STOREDSTRINGSA *StoredStrings, const char *szPattern, size_t *pIndex, unsigned long dwMode ) ;

int StoreStringW ( STOREDSTRINGSW **pStoredStrings, const wchar_t *szString ) ;
void FreeStoredStringsW ( STOREDSTRINGSW **pStoredStrings ) ;
const wchar_t *GetFirstStringW ( STOREDSTRINGSW *StoredStrings ) ;
const wchar_t *GetNextStringW ( STOREDSTRINGSW *StoredStrings ) ;
size_t GetStringsCountW ( const STOREDSTRINGSW *StoredStrings ) ;
int MergeStoredStringsW ( STOREDSTRINGSW **pStoredStrings, const STOREDSTRINGSW *StoredStringsToAdd ) ;
int GetStringPositionW ( const STOREDSTRINGSW *StoredStrings, STOREDSTRINGS_POSITION *Position, int IsReadingPosition ) ;
int SortStoredStringsW ( const STOREDSTRINGSW *StoredStrings, const STOREDSTRINGS_POSITION *Start, const STOREDSTRINGS_POSITION *End, int ( __cdecl *CompareFunction ) ( const wchar_t **, const wchar_t ** ), unsigned long dwMode ) ;
const wchar_t *FindStoredStringW ( const STOREDSTRINGSW *StoredStrings, const wchar_t *szPattern, size_t *pIndex, unsigned long dwMode ) ;


#ifdef UNICODE
#define STOREDSTRINGS         STOREDSTRINGSW
#define StoreString           StoreStringW
#define FreeStoredStrings     FreeStoredStringsW
#define GetFirstString        GetFirstStringW
#define GetNextString         GetNextStringW
#define GetStringsCount       GetStringsCountW
#define MergeStoredStrings    MergeStoredStringsW
#define GetStringPosition     GetStringPositionW
#define SortStoredStrings     SortStoredStringsW
#define FindStoredString      FindStoredStringW
#else
#define STOREDSTRINGS         STOREDSTRINGSA
#define StoreString           StoreStringA
#define FreeStoredStrings     FreeStoredStringsA
#define GetFirstString        GetFirstStringA
#define GetNextString         GetNextStringA
#define GetStringsCount       GetStringsCountA
#define MergeStoredStrings    MergeStoredStringsA
#define GetStringPosition     GetStringPositionA
#define SortStoredStrings     SortStoredStringsA
#define FindStoredString      FindStoredStringA
#endif


// SortStoredStrings()
#define STORESTR_SORT_SYSTEM     1
#define STORESTR_SORT_NUMERICAL  2
#define STORESTR_SORT_REVERSE    4

// FindStoredString()
#define STORESTR_CMP_IGNORECASE  1


int CompareStringLogicalA ( const char *szSrc, const char *szDst ) ;
int CompareStringLogicalW ( const wchar_t *szSrc, const wchar_t *szDst ) ;


#ifdef UNICODE
#define CompareStringLogical CompareStringLogicalW
#else
#define CompareStringLogical CompareStringLogicalA
#endif


#ifdef __cplusplus
}
#endif

#endif


