// shfileop.cpp

#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include "msc.h"
#include "shfileop.h"



// SHFileOperation () ɂẴ
// "\\?\" n܂钷pXw肷ƁA֐͎sB
// ΃pXw肵ăt@C폜ƁAS~ɓȂƂB
// FOF_NORECURSION tÓAfBNgRs[ƂAfBNg̃t@CRs[
//   邩ǂw邽߂̂́B폜ɂ͊֗^ȂB



////////////////////////////////////////////
//                 ANSI                 //
////////////////////////////////////////////



// VF𗘗pĕ̃t@C폜iANSIŁj
// t@C̓tpXŎw肵A '\0' 邱
// t@Cɂ̓ChJ[hgp
// deMode  SHDELETE_VERBOSE w肷ƁAvOX_CAO\
// deMode  SHDELETE_NO_RECYCLEBIN w肷ƁAt@CS~ɓȂ
//  0 As 0 ȊOԂ
int ShellDeleteMultipleFilesA ( HWND hWnd, const char *szFileName, unsigned long dwMode ) {

   if ( ! szFileName ) return 1 ;

   SHFILEOPSTRUCTA ShFileOp = { 0 } ;
   ShFileOp.hwnd = hWnd ;
   ShFileOp.wFunc = FO_DELETE ;
   ShFileOp.pFrom = szFileName ;
   ShFileOp.fFlags = FOF_NOCONFIRMATION | FOF_NOERRORUI ;

   if ( ! ( dwMode & SHDELETE_VERBOSE ) ) ShFileOp.fFlags |= FOF_SILENT ;
   if ( ! ( dwMode & SHDELETE_NO_RECYCLEBIN ) ) ShFileOp.fFlags |= FOF_ALLOWUNDO ;

   return SHFileOperationA ( & ShFileOp ) || ShFileOp.fAnyOperationsAborted ;
}



// VF𗘗pĂP̃t@C폜iANSIŁj
// t@C̓tpXŎw肷邱
// t@Cɂ̓ChJ[hgp
// deMode  SHDELETE_VERBOSE w肷ƁAvOX_CAO\
// deMode  SHDELETE_NO_RECYCLEBIN w肷ƁAt@CS~ɓȂ
//  0 As 0 ȊOԂ
int ShellDeleteFileA ( HWND hWnd, const char *szFileName, unsigned long dwMode ) {

   if ( ! szFileName ) return 1 ;

   int nResult = 1 ;

   char *szBuffer = strdup_expand ( szFileName, MAX_PATH_LONG, 1 ) ;
   if ( szBuffer ) {

      *( strend ( szBuffer ) + 1 ) = 0 ;

      nResult = ShellDeleteMultipleFilesA ( hWnd, szBuffer, dwMode ) ;
   }

   free ( szBuffer ) ;

   return nResult ;
}



// VF𗘗pĕ̃t@CRs[EړiANSIŁj
// t@C̓tpXŎw肵A '\0' 邱
// Rs[t@Cɂ̓ChJ[hgp
// Rs[t@Cɂ́A\ ŏIfBNgw肷邱Ƃ
// deMode  SHCOPY_VERBOSE w肷ƁAvOX_CAO\
// deMode  SHCOPY_MOVEFILE w肷ƁAt@Cړ
//  0 As 0 ȊOԂ
int ShellCopyMultipleFilesA ( HWND hWnd, const char *szSrcFileName, const char *szDstFileName, unsigned long dwMode ) {

   if ( ! szSrcFileName ) return 1 ;
   if ( ! szDstFileName ) return 1 ;

   SHFILEOPSTRUCTA ShFileOp = { 0 } ;
   ShFileOp.hwnd = hWnd ;
   ShFileOp.wFunc = ( dwMode & SHCOPY_MOVEFILE ) ? FO_MOVE : FO_COPY ;
   ShFileOp.pFrom = szSrcFileName ;
   ShFileOp.pTo = szDstFileName ;
   ShFileOp.fFlags = FOF_NOCONFIRMATION | FOF_NOERRORUI | FOF_NOCONFIRMMKDIR ;

   if ( ! ( dwMode & SHCOPY_VERBOSE ) ) ShFileOp.fFlags |= FOF_SILENT ;
   if ( *( strend ( szDstFileName ) + 1 ) ) ShFileOp.fFlags |= FOF_MULTIDESTFILES ;

   return SHFileOperationA ( & ShFileOp ) || ShFileOp.fAnyOperationsAborted ;
}



// VF𗘗pĂP̃t@CRs[EړiANSIŁj
// t@C̓tpXŎw肷邱
// Rs[t@Cɂ̓ChJ[hgp
// Rs[t@Cɂ́A\ ŏIfBNgw肷邱Ƃ
// deMode  SHCOPY_VERBOSE w肷ƁAvOX_CAO\
// deMode  SHCOPY_MOVEFILE w肷ƁAt@Cړ
//  0 As 0 ȊOԂ
int ShellCopyFileA ( HWND hWnd, const char *szSrcFileName, const char *szDstFileName, unsigned long dwMode ) {

   if ( ! szSrcFileName ) return 1 ;
   if ( ! szDstFileName ) return 1 ;

   int nResult = 1 ;

   char *szSrcBuffer = strdup_expand ( szSrcFileName, MAX_PATH_LONG, 1 ) ;
   char *szDstBuffer = strdup_expand ( szDstFileName, MAX_PATH_LONG, 1 ) ;

   if ( szSrcBuffer && szDstBuffer ) {

      *( strend ( szSrcBuffer ) + 1 ) = 0 ;
      *( strend ( szDstBuffer ) + 1 ) = 0 ;

      nResult = ShellCopyMultipleFilesA ( hWnd, szSrcBuffer, szDstBuffer, dwMode ) ;
   }

   free ( szSrcBuffer ) ;
   free ( szDstBuffer ) ;

   return nResult ;
}



////////////////////////////////////////////
//               UNICODE                //
////////////////////////////////////////////



#if ! IS_NT_ONLY
#define SHFileOperationW SHFileOperationW_
static int SHFileOperationW ( LPSHFILEOPSTRUCTW lpFileOp ) ;
#endif



// VF𗘗pĕ̃t@C폜iUNICODEŁj
// t@C̓tpXŎw肵A '\0' 邱
// t@Cɂ̓ChJ[hgp
// deMode  SHDELETE_VERBOSE w肷ƁAvOX_CAO\
// deMode  SHDELETE_NO_RECYCLEBIN w肷ƁAt@CS~ɓȂ
//  0 As 0 ȊOԂ
int ShellDeleteMultipleFilesW ( HWND hWnd, const wchar_t *szFileName, unsigned long dwMode ) {

   if ( ! szFileName ) return 1 ;

   SHFILEOPSTRUCTW ShFileOp = { 0 } ;
   ShFileOp.hwnd = hWnd ;
   ShFileOp.wFunc = FO_DELETE ;
   ShFileOp.pFrom = szFileName ;
   ShFileOp.fFlags = FOF_NOCONFIRMATION | FOF_NOERRORUI ;

   if ( ! ( dwMode & SHDELETE_VERBOSE ) ) ShFileOp.fFlags |= FOF_SILENT ;
   if ( ! ( dwMode & SHDELETE_NO_RECYCLEBIN ) ) ShFileOp.fFlags |= FOF_ALLOWUNDO ;

   return SHFileOperationW ( & ShFileOp ) || ShFileOp.fAnyOperationsAborted ;
}



// VF𗘗pĂP̃t@C폜iUNICODEŁj
// t@C̓tpXŎw肷邱
// t@Cɂ̓ChJ[hgp
// deMode  SHDELETE_VERBOSE w肷ƁAvOX_CAO\
// deMode  SHDELETE_NO_RECYCLEBIN w肷ƁAt@CS~ɓȂ
//  0 As 0 ȊOԂ
int ShellDeleteFileW ( HWND hWnd, const wchar_t *szFileName, unsigned long dwMode ) {

   if ( ! szFileName ) return 1 ;

   int nResult = 1 ;

   wchar_t *szBuffer = wcsdup_expand ( szFileName, MAX_PATH_LONG, 1 ) ;
   if ( szBuffer ) {

      *( wcsend ( szBuffer ) + 1 ) = 0 ;

      nResult = ShellDeleteMultipleFilesW ( hWnd, szBuffer, dwMode ) ;
   }

   free ( szBuffer ) ;

   return nResult ;
}



// VF𗘗pĕ̃t@CRs[EړiUNICODEŁj
// t@C̓tpXŎw肵A '\0' 邱
// Rs[t@Cɂ̓ChJ[hgp
// Rs[t@Cɂ́A\ ŏIfBNgw肷邱Ƃ
// deMode  SHCOPY_VERBOSE w肷ƁAvOX_CAO\
// deMode  SHCOPY_MOVEFILE w肷ƁAt@Cړ
//  0 As 0 ȊOԂ
int ShellCopyMultipleFilesW ( HWND hWnd, const wchar_t *szSrcFileName, const wchar_t *szDstFileName, unsigned long dwMode ) {

   if ( ! szSrcFileName ) return 1 ;
   if ( ! szDstFileName ) return 1 ;

   SHFILEOPSTRUCTW ShFileOp = { 0 } ;
   ShFileOp.hwnd = hWnd ;
   ShFileOp.wFunc = ( dwMode & SHCOPY_MOVEFILE ) ? FO_MOVE : FO_COPY ;
   ShFileOp.pFrom = szSrcFileName ;
   ShFileOp.pTo = szDstFileName ;
   ShFileOp.fFlags = FOF_NOCONFIRMATION | FOF_NOERRORUI | FOF_NOCONFIRMMKDIR ;

   if ( ! ( dwMode & SHCOPY_VERBOSE ) ) ShFileOp.fFlags |= FOF_SILENT ;
   if ( *( wcsend ( szDstFileName ) + 1 ) ) ShFileOp.fFlags |= FOF_MULTIDESTFILES ;

   return SHFileOperationW ( & ShFileOp ) || ShFileOp.fAnyOperationsAborted ;
}



// VF𗘗pĂP̃t@CRs[EړiUNICODEŁj
// t@C̓tpXŎw肷邱
// Rs[t@Cɂ̓ChJ[hgp
// Rs[t@Cɂ́A\ ŏIfBNgw肷邱Ƃ
// deMode  SHCOPY_VERBOSE w肷ƁAvOX_CAO\
// deMode  SHCOPY_MOVEFILE w肷ƁAt@Cړ
//  0 As 0 ȊOԂ
int ShellCopyFileW ( HWND hWnd, const wchar_t *szSrcFileName, const wchar_t *szDstFileName, unsigned long dwMode ) {

   if ( ! szSrcFileName ) return 1 ;
   if ( ! szDstFileName ) return 1 ;

   int nResult = 1 ;

   wchar_t *szSrcBuffer = wcsdup_expand ( szSrcFileName, MAX_PATH_LONG, 1 ) ;
   wchar_t *szDstBuffer = wcsdup_expand ( szDstFileName, MAX_PATH_LONG, 1 ) ;

   if ( szSrcBuffer && szDstBuffer ) {

      *( wcsend ( szSrcBuffer ) + 1 ) = 0 ;
      *( wcsend ( szDstBuffer ) + 1 ) = 0 ;

      nResult = ShellCopyMultipleFilesW ( hWnd, szSrcBuffer, szDstBuffer, dwMode ) ;
   }

   free ( szSrcBuffer ) ;
   free ( szDstBuffer ) ;

   return nResult ;
}



////////////////////////////////////////////
//              NT FUNCTIONS              //
////////////////////////////////////////////



#if ! IS_NT_ONLY



typedef int ( WINAPI *SHFILEOPERATIONW ) ( LPSHFILEOPSTRUCTW lpFileOp ) ;
static HINSTANCE hShell32 ;
static int FreeLibraryOnDetach ( void ) ;



static int SHFileOperationW ( LPSHFILEOPSTRUCTW lpFileOp ) {
#undef SHFileOperationW

   static SHFILEOPERATIONW SHFileOperationW ;
   static volatile int IsTried ;

   if ( ! IsTried ) {
#ifdef _MT
      EnterCriticalSection ( & LoadDllSection ) ;
      __try {
         if ( ! IsTried ) {
#endif
            if ( ! hShell32 && ( hShell32 = LoadLibraryW ( L"SHELL32.DLL" ) ) ) FreeLibraryOnDetach () ;
            GETPROCADDRESS ( hShell32, SHFILEOPERATIONW, SHFileOperationW ) ;
            IsTried = 1 ;
#ifdef _MT
         }
      } __finally {
         LeaveCriticalSection ( & LoadDllSection ) ;
      }
#endif
   }
   if ( ! SHFileOperationW ) return TRUE ;

   return SHFileOperationW ( lpFileOp ) ;
}



static void __cdecl ExitProc ( void ) {
   if ( hShell32 ) FreeLibrary ( hShell32 ) ;
}



static int FreeLibraryOnDetach ( void ) {
#ifdef _USRDLL
   return atexit ( ExitProc ) ;
#else
   return 0 ;
#endif
}



#endif // ! IS_NT_ONLY



