// res.h

#ifndef RES_H
#define RES_H

#ifdef __cplusplus
extern "C" {
#endif


HINSTANCE GetResourceInstance ( void ) ;
HINSTANCE SetResourceInstance ( HINSTANCE hInstance ) ;

int GetResourceLanguage ( void ) ;
int SetResourceLanguage ( int nLangId ) ;

HINSTANCE GetSatelliteResourceInstance ( void ) ;
HINSTANCE SetSatelliteResourceInstance ( HINSTANCE hInstance ) ;


#define LANGID_NEUTRAL     MAKELANGID ( LANG_NEUTRAL, SUBLANG_NEUTRAL )
#define LANGID_ENGLISH     MAKELANGID ( LANG_ENGLISH, SUBLANG_ENGLISH_US )
#define LANGID_JAPANESE    MAKELANGID ( LANG_JAPANESE, SUBLANG_DEFAULT )


int LoadStringExA ( int nId, char *szBuffer, int nBufferSize ) ;
int LoadStringExW ( int nId, wchar_t *szBuffer, int nBufferSize ) ;
const char *GetStringA ( int nId ) ;
const wchar_t *GetStringW ( int nId ) ;
char *GetStringAllocA ( int nId ) ;
wchar_t *GetStringAllocW ( int nId ) ;


HICON GetIcon ( int nId, int nX, int nY ) ;


typedef struct {
   unsigned short nSize ;
   unsigned short nWeight ;
   unsigned char nItalic ;
   unsigned char nCharSet ;
   char szFaceName [ LF_FACESIZE ] ;
} DIALOGFONTA ;

typedef struct {
   unsigned short nSize ;
   unsigned short nWeight ;
   unsigned char nItalic ;
   unsigned char nCharSet ;
   wchar_t szFaceName [ LF_FACESIZE ] ;
} DIALOGFONTW ;

int GetDialogTemplateFontA ( int nTemplate, DIALOGFONTA *pDialogFont ) ;
int GetDialogTemplateFontW ( int nTemplate, DIALOGFONTW *pDialogFont ) ;
int GetDialogTemplateFontSize ( int nTemplate ) ;


INT_PTR DialogBoxParamEx ( int nTemplate, HWND hWnd, DLGPROC pDialogProc, LPARAM lParam ) ;
HWND CreateDialogParamEx ( int nTemplate, HWND hParent, DLGPROC pDialogProc, LPARAM lParam ) ;

#define DialogBoxEx(t,w,p)    DialogBoxParamEx ( t, w, p, 0 )
#define CreateDialogEx(t,w,p) CreateDialogParamEx ( t, w, p, 0 )

INT_PTR DialogBoxParamSizeEx ( int nTemplate, HWND hWnd, DLGPROC pDialogProc, LPARAM lParam, int nIncrement ) ;
HWND CreateDialogParamSizeEx ( int nTemplate, HWND hParent, DLGPROC pDialogProc, LPARAM lParam, int nIncrement ) ;


typedef struct {
   unsigned short wMajor ;
   unsigned short wMinor ;
   unsigned short wBuild ;
   unsigned short wPrivate ;
} FILEVERSION ;

typedef int ( *ENUMVERSIONINFO_CALLBACK ) ( int nLevel, const wchar_t *szKey, const wchar_t *szValue, const long *pValue, size_t nLength, LPARAM lParam ) ;

int GetFileVersion ( FILEVERSION *pFileVersion ) ;
int TranslateVersionInfo ( const FILEVERSION *pFileVersion ) ;
int CompareFileVersion ( const FILEVERSION *pFileVersion1, const FILEVERSION *pFileVersion2 ) ;
int EnumVersionInfo ( ENUMVERSIONINFO_CALLBACK Callback, LPARAM lParam ) ;
const char *GetVersionCopyrightA ( void ) ;
const wchar_t *GetVersionCopyrightW ( void ) ;


#ifdef UNICODE
#define LoadStringEx LoadStringExW
#define GetString GetStringW
#define GetStringAlloc GetStringAllocW
#define DIALOGFONT DIALOGFONTW
#define GetDialogFont GetDialogFontW
#define GetVersionCopyright GetVersionCopyrightW
#else
#define LoadStringEx LoadStringExA
#define GetString GetStringA
#define GetStringAlloc GetStringAllocA
#define DIALOGFONT DIALOGFONTA
#define GetDialogFont GetDialogFontA
#define GetVersionCopyright GetVersionCopyrightA
#endif


#ifdef __cplusplus
}
#endif

#endif


