// res.cpp

#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include "msc.h"
#include "res.h"



////////////////////////////////////////////
//         \[X̃CX^X         //
////////////////////////////////////////////



// \[X̃CX^X̃AhX擾
static inline HINSTANCE *GetResourceInstanceAddress ( void ) {
   static HINSTANCE hInstance ;
   return & hInstance ;
}



// \[X̃CX^XύX
// hInstance  NULL w肷ƁAƂɖ߂
// VlԂ
HINSTANCE SetResourceInstance ( HINSTANCE hInstance ) {
   return (HINSTANCE) InterlockedExchangePointer ( (PVOID*) GetResourceInstanceAddress (), hInstance ) ;
}



// \[X̃CX^X擾
HINSTANCE GetResourceInstance ( void ) {
   return *GetResourceInstanceAddress () ;
}



#if ! defined NOCRT
////////////////////////////////////////////
//        TeCg\[X̐ݒ        //
////////////////////////////////////////////



// p\[X̃CX^X̃AhX擾
static inline HINSTANCE *GetSatelliteResourceInstanceAddress ( void ) {
   static HINSTANCE hInstance ;
   return & hInstance ;
}



// p\[X̃CX^XύX
// hInstance  NULL w肷ƁAƂɖ߂
// VlԂ
HINSTANCE SetSatelliteResourceInstance ( HINSTANCE hInstance ) {
   return (HINSTANCE) InterlockedExchangePointer ( (PVOID*) GetSatelliteResourceInstanceAddress (), hInstance ) ;
}



// p\[X̃CX^X擾
HINSTANCE GetSatelliteResourceInstance ( void ) {
   return *GetSatelliteResourceInstanceAddress () ;
}



////////////////////////////////////////////
//            \[X̌              //
////////////////////////////////////////////



// \[X̌ꃍP[̃AhX擾
static inline long *GetResourceLanguageAddress ( void ) {
   static long nLangId = LANGID_NEUTRAL ;
   return & nLangId ;
}



// \[X̌ꃍP[ύX
// ȑǑꃍP[Ԃ
int SetResourceLanguage ( int nLangId ) {
   return InterlockedExchange ( GetResourceLanguageAddress (), nLangId ) ;
}



// \[X̌ꃍP[擾
int GetResourceLanguage ( void ) {

   int nLangId = *GetResourceLanguageAddress () ;

#if defined _CONSOLE
   if ( nLangId == LANGID_NEUTRAL ) {
      static int IsConsoleEnglish = -1 ;
      if ( IsConsoleEnglish < 0 ) {
         if ( GetConsoleOutputCP () != GetOEMCP () ) IsConsoleEnglish = 1 ;
         else                                        IsConsoleEnglish = 0 ;
      }
      if ( IsConsoleEnglish > 0 ) nLangId = LANGID_ENGLISH ;
   }
#endif

   return nLangId ;
}



////////////////////////////////////////////
//             񃊃\[X             //
////////////////////////////////////////////



// GetStringTableData ̉֐
//  0 As 0 ȊOԂ
static int GetStringTableDataSub ( int nId, const wchar_t **pVsString, int *pLength, HINSTANCE hInstance, int nLangId ) {

   HRSRC hRsrc ;
   if ( 1 ) hRsrc = FindResourceExW ( hInstance, MAKEINTRESOURCEW ( RT_STRING ), MAKEINTRESOURCEW ( ( (unsigned) nId / 0x10 + 1 ) ), (LANGID) nLangId ) ;
   else     hRsrc = FindResourceExA ( hInstance, MAKEINTRESOURCEA ( RT_STRING ), MAKEINTRESOURCEA ( ( (unsigned) nId / 0x10 + 1 ) ), (LANGID) nLangId ) ;
   if ( ! hRsrc ) return 1 ;

   HGLOBAL hGlobal = LoadResource ( hInstance, hRsrc ) ;
   if ( ! hGlobal ) return 1 ;

   const wchar_t *pStringTable = (const wchar_t*) LockResource ( hGlobal ) ;
   if ( ! pStringTable ) return 1 ;

   for ( int nCount = (unsigned) nId % 0x10 ; nCount > 0 ; nCount -- ) pStringTable += 1 + *pStringTable ;
   if ( ! *pStringTable ) return 1 ;

   *pLength = *pStringTable ;
   *pVsString = pStringTable + 1 ;

   return 0 ;
}



// LoadStringEx ̉֐
//  0 As 0 ȊOԂ
static int GetStringTableData ( int nId, const wchar_t **pVsString, int *pLength ) {

   HINSTANCE hInstance = GetResourceInstance () ;
   HINSTANCE hSatelliteInstance = GetSatelliteResourceInstance () ;
   int nLangId = GetResourceLanguage () ;

   if ( hSatelliteInstance        && ! GetStringTableDataSub ( nId, pVsString, pLength, hSatelliteInstance, nLangId ) ) return 0 ;
   if ( 1                         && ! GetStringTableDataSub ( nId, pVsString, pLength, hInstance, nLangId ) ) return 0 ;
   if ( nLangId != LANGID_ENGLISH && ! GetStringTableDataSub ( nId, pVsString, pLength, hInstance, LANGID_ENGLISH ) ) return 0 ;
   if ( nLangId != LANGID_NEUTRAL && ! GetStringTableDataSub ( nId, pVsString, pLength, hInstance, LANGID_NEUTRAL ) ) return 0 ;

   return 1 ;
}



// 񃊃\[X擾iANSIŁj
// obt@̃TCYȂƂ́A؂l߂
// \[X{̒̕ԂiI[k܂܂Ȃj
// s 0 Ԃ
int LoadStringExA ( int nId, char *szBuffer, int nBufferSize ) {

   if ( ! szBuffer ) return 0 ;
   if ( nBufferSize ) *szBuffer = 0 ;

   const wchar_t *szString ;
   int nLength ;
   if ( GetStringTableData ( nId, & szString, & nLength ) ) return 0 ;

   if ( nLength && ! *( szString + nLength - 1 ) ) nLength -- ;

   return (int) w2alcpylen ( szBuffer, szString, nLength, nBufferSize ) ;
}



// 񃊃\[X擾iUNICODEŁj
// obt@̃TCYȂƂ́A؂l߂
// \[X{̒̕ԂiI[k܂܂Ȃj
// s 0 Ԃ
// Win95/98/Me łgp
int LoadStringExW ( int nId, wchar_t *szBuffer, int nBufferSize ) {

   if ( ! szBuffer ) return 0 ;
   if ( nBufferSize ) *szBuffer = 0 ;

   const wchar_t *szString ;
   int nLength ;
   if ( GetStringTableData ( nId, & szString, & nLength ) ) return 0 ;

   if ( nLength && ! *( szString + nLength - 1 ) ) nLength -- ;

   return (int) wcslcpylen ( szBuffer, szString, nLength, nBufferSize ) ;
}



// 񃊃\[X擾iANSIŁj
// \[XȂ΁A[̕Ԃ
// ܂ꂽ͎ɂ̊֐Ă΂܂ŗL
const char *GetStringA ( int nId ) {

   THREAD_INTERNAL_DATA_ *p = GetThreadInternalData () ;
   if ( ! p ) return "" ;

   free ( p->szGetStringA ) ;
   p->szGetStringA = NULL ;

   const wchar_t *szString ;
   int nLength ;
   if ( GetStringTableData ( nId, & szString, & nLength ) ) return "" ;

   if ( nLength && ! *( szString + nLength - 1 ) ) nLength -- ;
   if ( ! nLength ) return "" ;

   p->szGetStringA = w2aduplen ( szString, nLength ) ;
   if ( ! p->szGetStringA ) return "" ;

   return p->szGetStringA ;
}



// 񃊃\[X擾iUNICODEŁj
// \[XȂ΁A[̕Ԃ
// ܂ꂽ͎ɂ̊֐Ă΂܂ŗL
// Win95/98/Me łgp
const wchar_t *GetStringW ( int nId ) {

   THREAD_INTERNAL_DATA_ *p = GetThreadInternalData () ;
   if ( ! p ) return L"" ;

   free ( p->szGetStringW ) ;
   p->szGetStringW = NULL ;

   const wchar_t *szString ;
   int nLength ;
   if ( GetStringTableData ( nId, & szString, & nLength ) ) return L"" ;

   if ( nLength && ! *( szString + nLength - 1 ) ) return szString ;
   if ( ! nLength ) return L"" ;

   p->szGetStringW = wcsduplen ( szString, nLength ) ;
   if ( ! p->szGetStringW ) return L"" ;

   return p->szGetStringW ;
}



// [mۂĕ񃊃\[X擾iANSIŁj
// free () gĉ邱
// \[XȂ΁ANULL Ԃ
char *GetStringAllocA ( int nId ) {

   const wchar_t *szString ;
   int nLength ;
   if ( GetStringTableData ( nId, & szString, & nLength ) ) return NULL ;

   if ( nLength && ! *( szString + nLength - 1 ) ) nLength -- ;
   if ( ! nLength ) return NULL ;

   return w2aduplen ( szString, nLength ) ;
}



// [mۂĕ񃊃\[X擾iUNICODEŁj
// free () gĉ邱
// \[XȂ΁ANULL Ԃ
// Win95/98/Me łgp
wchar_t *GetStringAllocW ( int nId ) {

   const wchar_t *szString ;
   int nLength ;
   if ( GetStringTableData ( nId, & szString, & nLength ) ) return NULL ;

   if ( nLength && ! *( szString + nLength - 1 ) ) nLength -- ;
   if ( ! nLength ) return NULL ;

   return wcsduplen ( szString, nLength ) ;
}



#endif // ! defined NOCRT



////////////////////////////////////////////
//           o[W\[X           //
////////////////////////////////////////////



// VS_VERSIONINFO, StringFileInfo, StringTable, String,...etc
#pragma pack(2)
typedef struct {
   unsigned short wLength ;
   unsigned short wValueLength ;
   unsigned short wType ;
   wchar_t szKey [ 1 ] ;
   // ȉȗ
} VS_TABLE ;
#pragma pack()



// 2 ̙p r ̔{ɐ؂グ
static inline size_t RoundUp ( size_t n, size_t r ) {
   return ( ( n + r - 1 ) / r ) * r ;
}

// 32rbgEɐ؂グ
#define RoundUpLong(Size)  RoundUp ( Size, sizeof(long) )

static inline const void *GetVsValue ( const VS_TABLE *pVs ) {
   if ( pVs->wValueLength ) return (char*) pVs + RoundUpLong ( (size_t) ( wcsend ( pVs->szKey ) + 1 ) - (size_t) pVs ) ;
   else                     return NULL ;
}

static inline const VS_TABLE *GetVsChildren ( const VS_TABLE *pVs ) {
   if ( pVs->wType ) return (const VS_TABLE*) ( (char*) pVs + RoundUpLong ( (size_t) ( wcsend ( pVs->szKey ) + 1 ) - (size_t) pVs ) + RoundUpLong ( pVs->wValueLength * sizeof(wchar_t) ) ) ;
   else              return (const VS_TABLE*) ( (char*) pVs + RoundUpLong ( (size_t) ( wcsend ( pVs->szKey ) + 1 ) - (size_t) pVs ) + RoundUpLong ( pVs->wValueLength * sizeof(char)    ) ) ;
}

static inline const VS_TABLE *GetVsEnd ( const VS_TABLE *pVs ) {
   return (const VS_TABLE*) ( (char*) pVs + pVs->wLength ) ;
}

static inline const VS_TABLE *GetVsNext ( const VS_TABLE *pVs ) {
   return (const VS_TABLE*) ( (char*) pVs + RoundUpLong ( pVs->wLength ) ) ;
}



// \[X VS_TABLE ւ̃|C^擾
// o[W\[XȂ NULL Ԃ
static const VS_TABLE *GetVersionInfo ( void ) {

   HINSTANCE hInstance = GetResourceInstance () ;

   HRSRC hRsrc ;
   if ( 1 ) hRsrc = FindResourceExW ( hInstance, MAKEINTRESOURCEW ( RT_VERSION ), MAKEINTRESOURCEW ( VS_VERSION_INFO ), MAKELANGID ( LANG_NEUTRAL, SUBLANG_NEUTRAL ) ) ;
   else     hRsrc = FindResourceExA ( hInstance, MAKEINTRESOURCEA ( RT_VERSION ), MAKEINTRESOURCEA ( VS_VERSION_INFO ), MAKELANGID ( LANG_NEUTRAL, SUBLANG_NEUTRAL ) ) ;
   if ( ! hRsrc ) return NULL ;

   HGLOBAL hGlobal = LoadResource ( hInstance, hRsrc ) ;
   if ( ! hGlobal ) return NULL ;

   const VS_TABLE *pVsVersionInfo = (const VS_TABLE*) LockResource ( hGlobal ) ;
   if ( ! pVsVersionInfo ) return NULL ;

   return pVsVersionInfo ;
}



// o[W擾
//  0 As 0 ȊOԂ
int GetFileVersion ( FILEVERSION *pFileVersion ) {

   const VS_TABLE *pVsVersionInfo = GetVersionInfo () ;
   if ( ! pVsVersionInfo ) return 1 ;

   const VS_FIXEDFILEINFO *pFixedFileInfo = (const VS_FIXEDFILEINFO*) GetVsValue ( pVsVersionInfo ) ;
   if ( ! pFixedFileInfo ) return 1 ;

   pFileVersion->wMajor = HIWORD ( pFixedFileInfo->dwFileVersionMS ) ;
   pFileVersion->wMinor = LOWORD ( pFixedFileInfo->dwFileVersionMS ) ;
   pFileVersion->wBuild = HIWORD ( pFixedFileInfo->dwFileVersionLS ) ;
   pFileVersion->wPrivate = LOWORD ( pFixedFileInfo->dwFileVersionLS ) ;

   return 0 ;
}



// o[Wr
int CompareFileVersion ( const FILEVERSION *pFileVersion1, const FILEVERSION *pFileVersion2 ) {

   unsigned short nValue1, nValue2 ;

   if ( pFileVersion1->wMajor != pFileVersion2->wMajor ) {
      nValue1 = pFileVersion1->wMajor ;
      nValue2 = pFileVersion2->wMajor ;
   }
   else if ( pFileVersion1->wMinor != pFileVersion2->wMinor ) {
      nValue1 = pFileVersion1->wMinor ;
      nValue2 = pFileVersion2->wMinor ;
   }
   else if ( pFileVersion1->wBuild != pFileVersion2->wBuild ) {
      nValue1 = pFileVersion1->wBuild ;
      nValue2 = pFileVersion2->wBuild ;
   }
   else {
      nValue1 = pFileVersion1->wPrivate ;
      nValue2 = pFileVersion2->wPrivate ;
   }

   if ( nValue1 > nValue2 ) return 1 ;
   if ( nValue1 < nValue2 ) return -1 ;

   return 0 ;
}



// o[W wMajor  wMinor 𐮐ɕϊ
// wMinor  99 Ƃ
int TranslateVersionInfo ( const FILEVERSION *pFileVersion ) {

   int nMajor = pFileVersion->wMajor ;
   int nMinor = pFileVersion->wMinor ;

   if ( nMinor > 99 ) nMinor = 99 ;

   return nMajor * 100 + nMinor ;
}



////////////////////////////////////////////
//        o[W\[Xi񋓁j      //
////////////////////////////////////////////



// R[obN֐ 0 ԂA񋓂p
//                    0 ȊOԂA񋓂~
//  0 As 0 ȊOԂ
static int EnumVsTable ( int nLevel, const VS_TABLE *pVsTable, ENUMVERSIONINFO_CALLBACK Callback, LPARAM lParam ) {

   if ( pVsTable->wType ) {
      if ( Callback ( nLevel, pVsTable->szKey, (const wchar_t*) GetVsValue ( pVsTable ), NULL, pVsTable->wValueLength, lParam ) ) return 0 ;
   }
   else {
      if ( Callback ( nLevel, pVsTable->szKey, NULL, (const long*) GetVsValue ( pVsTable ), ( pVsTable->wValueLength / sizeof(long) ), lParam ) ) return 0 ;
   }

   const VS_TABLE *pChildStart = GetVsChildren ( pVsTable ) ;
   const VS_TABLE *pChildEnd = GetVsEnd ( pVsTable ) ;

   for ( const VS_TABLE *pChild = pChildStart ; pChild < pChildEnd ; pChild = GetVsNext ( pChild ) ) {
      if ( EnumVsTable ( nLevel + 1, pChild, Callback, lParam ) ) return 1 ;
   }

   return 0 ;
}



// o[W
//  0 As 0 ȊOԂ
int EnumVersionInfo ( ENUMVERSIONINFO_CALLBACK Callback, LPARAM lParam ) {

   const VS_TABLE *pVsVersionInfo = GetVersionInfo () ;
   if ( ! pVsVersionInfo ) return 1 ;

   EnumVsTable ( 0, pVsVersionInfo, Callback, lParam ) ;

   return 0 ;
}



#if ! defined NOCRT
////////////////////////////////////////////
//     o[W\[Xi쌠\j   //
////////////////////////////////////////////



// \[X̒쌠\擾iANSIŁj
// ̌̏񂪂΁Aŏ̌̏Ԃ
// \[XȂ΁A[̕Ԃ
// ܂ꂽ͎ɂ̊֐Ă΂܂ŗL
const char *GetVersionCopyrightA ( void ) {

   THREAD_INTERNAL_DATA_ *p = GetThreadInternalData () ;
   if ( ! p ) return "" ;

   free ( p->szCopyrightA ) ;
   p->szCopyrightA = NULL ;

   const wchar_t *szString = GetVersionCopyrightW () ;

   p->szCopyrightA = w2adup ( szString ) ;

   if ( ! p->szCopyrightA ) return "" ;
   return p->szCopyrightA ;
}



typedef struct {
   int IsStringFileInfo ;
   const wchar_t *szResult ;
} FIND_COPYRIGHT_INFO ;



static int FindCopyrightCallback ( int nLevel, const wchar_t *szKey, const wchar_t *szValue, const long *pValue, size_t nLength, LPARAM lParam ) {

   FIND_COPYRIGHT_INFO *pInfo = (FIND_COPYRIGHT_INFO*) lParam ;

   if ( ! szKey ) return 0 ;

   switch ( nLevel ) {
      case 1 :
         if ( ! wcscmp ( szKey, L"StringFileInfo" ) ) pInfo->IsStringFileInfo = 1 ;
         else                                         pInfo->IsStringFileInfo = 0 ;
         break ;
      case 2 :
         if ( pInfo->szResult ) return 1 ;
         break ;
      case 3 :
         if ( pInfo->IsStringFileInfo && ! wcscmp ( szKey, L"LegalCopyright" ) ) {
            pInfo->szResult = szValue ;
            return 1 ;
         }
         break ;
   }

   return 0 ;
}



// \[X̒쌠\擾iUNICODEŁj
// ̌̏񂪂΁Aŏ̌̏Ԃ
// \[XȂ΁A[̕Ԃ
// Win95/98/Me łgp
const wchar_t *GetVersionCopyrightW ( void ) {

   FIND_COPYRIGHT_INFO Info = { 0 } ;
   EnumVersionInfo ( FindCopyrightCallback, (LPARAM) & Info ) ;
   if ( ! Info.szResult ) return L"" ;

   return Info.szResult ;
}



#endif // ! defined NOCRT



#if ( ! defined _CONSOLE && ! defined _USRDLL || defined LOAD_USER32_DLL ) && ! defined NOCRT
////////////////////////////////////////////
//            ACR\[X            //
////////////////////////////////////////////



// CfbNXAs 0 Ԃ
static int GetIconDataIndex ( int nId, int nX, int nY, HINSTANCE hInstance, int nLangId ) {

   HRSRC hRsrc ;
   if ( 1 ) hRsrc = FindResourceExW ( hInstance, MAKEINTRESOURCEW ( RT_GROUP_ICON ), MAKEINTRESOURCEW ( nId ), (LANGID) nLangId ) ;
   else     hRsrc = FindResourceExA ( hInstance, MAKEINTRESOURCEA ( RT_GROUP_ICON ), MAKEINTRESOURCEA ( nId ), (LANGID) nLangId ) ;
   if ( ! hRsrc ) return 0 ;

   HGLOBAL hGlobal = LoadResource ( hInstance, hRsrc ) ;
   if ( ! hGlobal ) return 0 ;

   unsigned char *pData = (unsigned char*) LockResource ( hGlobal ) ;
   if ( ! pData ) return 0 ;

   return LookupIconIdFromDirectoryEx ( pData, TRUE, nX, nY, LR_DEFAULTCOLOR ) ;
}



// nhAs NULL Ԃ
static HICON GetIconDataHandle ( int nId, int nX, int nY, HINSTANCE hInstance, int nLangId ) {

   HRSRC hRsrc ;
   if ( 1 ) hRsrc = FindResourceExW ( hInstance, MAKEINTRESOURCEW ( RT_ICON ), MAKEINTRESOURCEW ( nId ), (LANGID) nLangId ) ;
   else     hRsrc = FindResourceExA ( hInstance, MAKEINTRESOURCEA ( RT_ICON ), MAKEINTRESOURCEA ( nId ), (LANGID) nLangId ) ;
   if ( ! hRsrc ) return NULL ;

   HGLOBAL hGlobal = LoadResource ( hInstance, hRsrc ) ;
   if ( ! hGlobal ) return NULL ;

   unsigned char *pData = (unsigned char*) LockResource ( hGlobal ) ;
   if ( ! pData ) return NULL ;

   return CreateIconFromResourceEx ( pData, SizeofResource ( hInstance, hRsrc ), TRUE, 0x00030000, nX, nY, LR_DEFAULTCOLOR ) ;
}



// GetIconData ̉֐
//  0 As 0 ȊOԂ
static int GetIconDataSub ( int nId, int nX, int nY, HICON *pIcon, HINSTANCE hInstance, int nLangId ) {

   int nIndex = GetIconDataIndex ( nId, nX, nY, hInstance, nLangId ) ;
   if ( ! nIndex ) return 1 ;

   HICON hIcon = GetIconDataHandle ( nIndex, nX, nY, hInstance, nLangId ) ;
   if ( ! hIcon ) return 1 ;

   *pIcon = hIcon ;

   return 0 ;
}



// GetIconEx ̉֐
//  0 As 0 ȊOԂ
static int GetIconData ( int nId, int nX, int nY, HICON *pIcon ) {

   HINSTANCE hInstance = GetResourceInstance () ;
   HINSTANCE hSatelliteInstance = GetSatelliteResourceInstance () ;
   int nLangId = GetResourceLanguage () ;

   if ( hSatelliteInstance        && ! GetIconDataSub ( nId, nX, nY, pIcon, hSatelliteInstance, nLangId ) ) return 0 ;
   if ( 1                         && ! GetIconDataSub ( nId, nX, nY, pIcon, hInstance, nLangId ) ) return 0 ;
   if ( nLangId != LANGID_ENGLISH && ! GetIconDataSub ( nId, nX, nY, pIcon, hInstance, LANGID_ENGLISH ) ) return 0 ;
   if ( nLangId != LANGID_NEUTRAL && ! GetIconDataSub ( nId, nX, nY, pIcon, hInstance, LANGID_NEUTRAL ) ) return 0 ;

   return 1 ;
}



// ACRԂ
// nX, nY  0 w肷ƁAVXẽTCYŎ擾
// nX, nY ɕw肷ƁAVXȅACRTCYŎ擾
// gp DestroyIcon Ŕp邱
// s NULL Ԃ
HICON GetIcon ( int nId, int nX, int nY ) {

   if ( ! nX )        nX = GetSystemMetrics ( SM_CXICON ) ;
   else if ( nX < 0 ) nX = GetSystemMetrics ( SM_CXSMICON ) ;

   if ( ! nY )        nY = GetSystemMetrics ( SM_CYICON ) ;
   else if ( nY < 0 ) nY = GetSystemMetrics ( SM_CYSMICON ) ;

   HICON hIcon ;
   if ( GetIconData ( nId, nX, nY, & hIcon ) ) return NULL ;

   return hIcon ;
}



#endif // ( ! defined _CONSOLE && ! defined _USRDLL || defined LOAD_USER32_DLL ) && ! defined NOCRT



#if ! defined NOCRT
////////////////////////////////////////////
//           _CAO\[X           //
////////////////////////////////////////////



#define ORDER_OR_STRING_NEXT(s) ( ( *s == 0xFFFF ) ? s + 2 : wcsend ( s ) + 1 )



#pragma pack(2)
typedef struct {
   unsigned short dlgVer ;
   unsigned short signature ;
   unsigned long helpID ;
   unsigned long exStyle ;
   unsigned long style ;
   unsigned short cDlgItems ;
   short x ;
   short y ;
   short cx ;
   short cy ;
   // ȉȗ
} DLGTEMPLATEEX ;
#pragma pack()



// GetDialog ̉֐
//  0 ԂAʂ ppDlg ɕۑ
// s 0 ȊOԂ
static int GetDialogSub ( int nTemplate, const DLGTEMPLATE **ppDlg, HINSTANCE *pInstance, size_t *pSize, HINSTANCE hInstance, int nLangId ) {

   HRSRC hRsrc ;
   if ( 1 ) hRsrc = FindResourceExW ( hInstance, MAKEINTRESOURCEW ( RT_DIALOG ), MAKEINTRESOURCEW ( nTemplate ), (LANGID) nLangId ) ;
   else     hRsrc = FindResourceExA ( hInstance, MAKEINTRESOURCEA ( RT_DIALOG ), MAKEINTRESOURCEA ( nTemplate ), (LANGID) nLangId ) ;
   if ( ! hRsrc ) return 1 ;

   HGLOBAL hGlobal = LoadResource ( hInstance, hRsrc ) ;
   if ( ! hGlobal ) return 1 ;

   const DLGTEMPLATE *pDlg = (const DLGTEMPLATE*) LockResource ( hGlobal ) ;
   if ( ! pDlg ) return 1 ;

   *ppDlg = pDlg ;

   if ( pInstance ) {      // _CAOĂяo֐Ŏgp邽
      if ( ! hInstance ) {
         if ( IsNT () ) hInstance = GetModuleHandleW ( NULL ) ;
         else           hInstance = GetModuleHandleA ( NULL ) ;
      }
      *pInstance = hInstance ;
   }

   if ( pSize ) *pSize = SizeofResource ( hInstance, hRsrc ) ;

   return 0 ;
}



// \[X̃_CAOev[g̃AhX擾
// _CAOȂ NULL Ԃ
static const DLGTEMPLATE *GetDialog ( int nTemplate, HINSTANCE *pInstance, size_t *pSize ) {

   HINSTANCE hInstance = GetResourceInstance () ;
   HINSTANCE hSatelliteInstance = GetSatelliteResourceInstance () ;
   int nLangId = GetResourceLanguage () ;

   const DLGTEMPLATE *pDlg ;

   if ( hSatelliteInstance        && ! GetDialogSub ( nTemplate, & pDlg, pInstance, pSize, hSatelliteInstance, nLangId ) ) return pDlg ;
   if ( 1                         && ! GetDialogSub ( nTemplate, & pDlg, pInstance, pSize, hInstance, nLangId ) ) return pDlg ;
   if ( nLangId != LANGID_ENGLISH && ! GetDialogSub ( nTemplate, & pDlg, pInstance, pSize, hInstance, LANGID_ENGLISH ) ) return pDlg ;
   if ( nLangId != LANGID_NEUTRAL && ! GetDialogSub ( nTemplate, & pDlg, pInstance, pSize, hInstance, LANGID_NEUTRAL ) ) return pDlg ;

   return NULL ;
}



// _CAÕev[gtHg擾iANSIŁj
//  0 As 0 ȊOԂ
int GetDialogTemplateFontA ( int nTemplate, DIALOGFONTA *pDialogFont ) {

   DIALOGFONTW DialogFont ;
   if ( GetDialogTemplateFontW ( nTemplate, & DialogFont ) ) return 1 ;

   pDialogFont->nSize = DialogFont.nSize ;
   pDialogFont->nWeight = DialogFont.nWeight ;
   pDialogFont->nItalic = DialogFont.nItalic ;
   pDialogFont->nCharSet = DialogFont.nCharSet ;

   w2alcpylen ( pDialogFont->szFaceName, DialogFont.szFaceName, SIZE_MAX, LF_FACESIZE ) ;

   return 0 ;
}



// _CAÕev[gtHg擾iUNICODEŁj
//  0 As 0 ȊOԂ
int GetDialogTemplateFontW ( int nTemplate, DIALOGFONTW *pDialogFont ) {

   const DLGTEMPLATE *pDlg = GetDialog ( nTemplate, NULL, NULL ) ;
   if ( ! pDlg ) return 1 ;

   const DLGTEMPLATEEX *pDlgEx = (const DLGTEMPLATEEX*) pDlg ;
   if ( pDlgEx->signature != 0xFFFF ) pDlgEx = NULL ;

   if ( pDlgEx ) {
      if ( ! ( pDlgEx->style & DS_SETFONT ) ) return 1 ;
   }
   else {
      if ( ! ( pDlg->style & DS_SETFONT ) ) return 1 ;
   }

   const wchar_t *szMenu = ( ( pDlgEx ) ? (const wchar_t*) ( pDlgEx + 1 ) : (const wchar_t*) ( pDlg + 1 ) ) ;
   const wchar_t *szClass = ORDER_OR_STRING_NEXT ( szMenu ) ;
   const wchar_t *szTitle = ORDER_OR_STRING_NEXT ( szClass ) ;
   const wchar_t *pFontInfo = ORDER_OR_STRING_NEXT ( szTitle ) ;

   const wchar_t *szFaceName ;
   if ( pDlgEx ) {
      pDialogFont->nSize = pFontInfo [ 0 ] ;
      pDialogFont->nWeight = pFontInfo [ 1 ] ;
      pDialogFont->nItalic = LOBYTE ( pFontInfo [ 2 ] ) ;
      pDialogFont->nCharSet = HIBYTE ( pFontInfo [ 2 ] ) ;
      szFaceName = pFontInfo + 3 ;
   }
   else {
      pDialogFont->nSize = pFontInfo [ 0 ] ;
      pDialogFont->nWeight = FW_DONTCARE ;
      pDialogFont->nItalic = 0 ;
      pDialogFont->nCharSet = DEFAULT_CHARSET ;
      szFaceName = pFontInfo + 1 ;
   }

   wcslcpylen ( pDialogFont->szFaceName, szFaceName, SIZE_MAX, LF_FACESIZE ) ;

   return 0 ;
}



// _CAÕtHgTCY擾
// |CgAs 0 Ԃ
int GetDialogTemplateFontSize ( int nTemplate ) {

   DIALOGFONTW DialogFont ;
   if ( GetDialogTemplateFontW ( nTemplate, & DialogFont ) ) return 0 ;

   return DialogFont.nSize ;
}



// _CAÕtHgTCYύX
static int SetDialogTemplateFontSize ( DLGTEMPLATE *pDlg, int nIncrement ) {

   DLGTEMPLATEEX *pDlgEx = (DLGTEMPLATEEX*) pDlg ;
   if ( pDlgEx->signature != 0xFFFF ) pDlgEx = NULL ;

   if ( pDlgEx ) {
      if ( ! ( pDlgEx->style & DS_SETFONT ) ) return 1 ;
   }
   else {
      if ( ! ( pDlg->style & DS_SETFONT ) ) return 1 ;
   }

   wchar_t *szMenu = ( ( pDlgEx ) ? (wchar_t*) ( pDlgEx + 1 ) : (wchar_t*) ( pDlg + 1 ) ) ;
   wchar_t *szClass = ORDER_OR_STRING_NEXT ( szMenu ) ;
   wchar_t *szTitle = ORDER_OR_STRING_NEXT ( szClass ) ;
   wchar_t *pFontInfo = ORDER_OR_STRING_NEXT ( szTitle ) ;

   int nSize = pFontInfo [ 0 ] ;
   nSize += nIncrement ;
   if ( nSize < 0 ) nSize = 0 ;
   pFontInfo [ 0 ] = nSize ;

   return 0 ;
}



// _CAO𕡐
// free () gĉ邱
// s NULL Ԃ
static DLGTEMPLATE *DuplicateDialog ( int nTemplate, HINSTANCE *pInstance, size_t *pSize ) {

   size_t nSize ;
   const DLGTEMPLATE *pDlg = GetDialog ( nTemplate, pInstance, & nSize ) ;

   DLGTEMPLATE *pNewDlg = (DLGTEMPLATE*) malloc ( nSize ) ;
   if ( ! pNewDlg ) return NULL ;

   memmove ( pNewDlg, pDlg, nSize ) ;

   if ( pSize ) *pSize = nSize ;

   return pNewDlg ;
}



#endif // ! defined NOCRT



#if ( ! defined _CONSOLE && ! defined _USRDLL || defined LOAD_USER32_DLL ) && ! defined NOCRT
////////////////////////////////////////////
//          _CAŐN (1)          //
////////////////////////////////////////////



// P[ɉă_CAON
// s畉Ԃ
INT_PTR DialogBoxParamEx ( int nTemplate, HWND hWnd, DLGPROC pDialogProc, LPARAM lParam ) {

   HINSTANCE hInstance ;
   const DLGTEMPLATE *pDlg = GetDialog ( nTemplate, & hInstance, NULL ) ;
   if ( ! pDlg ) return -1 ;

   if ( IsNT () ) return DialogBoxIndirectParamW ( hInstance, pDlg, hWnd, pDialogProc, lParam ) ;
   else           return DialogBoxIndirectParamA ( hInstance, pDlg, hWnd, pDialogProc, lParam ) ;
}



// P[ɉă[hX_CAON
// s NULL Ԃ
HWND CreateDialogParamEx ( int nTemplate, HWND hParent, DLGPROC pDialogProc, LPARAM lParam ) {

   HINSTANCE hInstance ;
   const DLGTEMPLATE *pDlg = GetDialog ( nTemplate, & hInstance, NULL ) ;
   if ( ! pDlg ) return NULL ;

   if ( IsNT () ) return CreateDialogIndirectParamW ( hInstance, pDlg, hParent, pDialogProc, lParam ) ;
   else           return CreateDialogIndirectParamA ( hInstance, pDlg, hParent, pDialogProc, lParam ) ;
}



////////////////////////////////////////////
//          _CAŐN (2)          //
////////////////////////////////////////////



// P[ɉă_CAON
// nIncrement ɂ̓tHgTCY̑w肷
// s畉Ԃ
INT_PTR DialogBoxParamSizeEx ( int nTemplate, HWND hWnd, DLGPROC pDialogProc, LPARAM lParam, int nIncrement ) {

   if ( ! nIncrement ) return DialogBoxParamEx ( nTemplate, hWnd, pDialogProc, lParam ) ;

   HINSTANCE hInstance ;
   DLGTEMPLATE *pDlg = DuplicateDialog ( nTemplate, & hInstance, NULL ) ;
   if ( ! pDlg ) return -1 ;

   SetDialogTemplateFontSize ( pDlg, nIncrement ) ;

   INT_PTR nResult ;
   if ( IsNT () ) nResult = DialogBoxIndirectParamW ( hInstance, pDlg, hWnd, pDialogProc, lParam ) ;
   else           nResult = DialogBoxIndirectParamA ( hInstance, pDlg, hWnd, pDialogProc, lParam ) ;

   free ( pDlg ) ;

   return nResult ;
}



// P[ɉă[hX_CAON
// nIncrement ɂ̓tHgTCY̑w肷
// s NULL Ԃ
HWND CreateDialogParamSizeEx ( int nTemplate, HWND hParent, DLGPROC pDialogProc, LPARAM lParam, int nIncrement ) {

   if ( ! nIncrement ) return CreateDialogParamEx ( nTemplate, hParent, pDialogProc, lParam ) ;

   HINSTANCE hInstance ;
   DLGTEMPLATE *pDlg = DuplicateDialog ( nTemplate, & hInstance, NULL ) ;
   if ( ! pDlg ) return NULL ;

   SetDialogTemplateFontSize ( pDlg, nIncrement ) ;

   HWND hWnd ;
   if ( IsNT () ) hWnd = CreateDialogIndirectParamW ( hInstance, pDlg, hParent, pDialogProc, lParam ) ;
   else           hWnd = CreateDialogIndirectParamA ( hInstance, pDlg, hParent, pDialogProc, lParam ) ;

   free ( pDlg ) ;

   return hWnd ;
}



#endif // ( ! defined _CONSOLE && ! defined _USRDLL || defined LOAD_USER32_DLL ) && ! defined NOCRT



