// oemio.cpp

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <mbctype.h>
#include "msc.h"
#include "oemio.h"



// Unicode  OEM ɑΉXg[o͏

// \n  \r\n ϊ CTRL-Z ւ̑Ή
// ANSI/OEM Xg[Ȃ烉Cu[ɏ
// Unicode Xg[Ȃ玩Oŏ

// fwide () ̑Ή
//    r, r+ ͑Ή
//    w, w+ ͑Ή
//    a, a+ ͑Ή
//    stdin, stdout, stderr ̃R\[o͂͑ΉiȂj
//    stdout, stderr ̃_CNg > ͑Ή
//    stdout, stderr ̒ǉ_CNg >> ͑Ή
//    stdin ̃_CNg < ͑Ή
//    pCv͑Ή

// [h a ͓ǂݍ݂oȂ߁A擪 BOM 𔻕ʂłÂ܂܂ł͑Ήs\B
// t@CJƂɎI a+ ŊJƂɂAΉB


#define IS_DETECT_SURROGATE   0


#if defined _MSC_VER && _MSC_VER < 1900
#define IS_USE_CRT_STRUCT  1
#else
#define IS_USE_CRT_STRUCT  0
#endif



////////////////////////////////////////////
//             f[^ (1)             //
////////////////////////////////////////////



#if IS_USE_CRT_STRUCT



static inline int GET_MODE ( FILE *stream, int bit ) {
   return stream->_flag & bit ;
}



static inline void SET_MODE ( FILE *stream, int bit, int mode ) {
   if ( mode ) stream->_flag |=   bit ;
   else        stream->_flag &= ~ bit ;
}



#define CLEAR_MODE(s)      SET_MODE ( stream, 0, 0 )     // dummy

#define is_read_stream(stream)   GET_MODE ( stream, ( _IOREAD | _IORW ) )
#define is_write_stream(stream)  GET_MODE ( stream, ( _IOWRT  | _IORW ) )

#define set_eof(stream)          SET_MODE ( stream, _IOEOF, 1 )
#define set_error(stream)        SET_MODE ( stream, _IOERR, 1 )


// Xg[̃tǑ^ int łȂ΃RpCG[N
static int test_stream_flag_type ( FILE *stream ) { int *p = & stream->_flag ; return *p ; }



#endif



////////////////////////////////////////////
//             f[^ (2)             //
////////////////////////////////////////////



#if ! IS_USE_CRT_STRUCT



#define OEMIO_DATA_ARRAY_SIZE    0x80     // CRT \[Xt@C IOINFO_ARRAYS  64`128

typedef struct OEMIO_DATA_ARRAY_ {
   char data [ OEMIO_DATA_ARRAY_SIZE ] ;
   OEMIO_DATA_ARRAY_ *next ;
} OEMIO_DATA_ARRAY ;


static OEMIO_DATA_ARRAY OemioDataArray ;



static int GET_MODE ( FILE *stream, int bit ) {

   int n = _fileno ( stream ) ;
   if ( n < 0 ) return 0 ;

   OEMIO_DATA_ARRAY *p = & OemioDataArray ;

   for ( ; n >= OEMIO_DATA_ARRAY_SIZE ; n -= OEMIO_DATA_ARRAY_SIZE ) {
      if ( ! p->next ) return 0 ;
      p = p->next ;
   }

   return ( p->data [ n ] ) & bit ;
}



static void SET_MODE ( FILE *stream, int bit, int mode ) {

   int n = _fileno ( stream ) ;
   if ( n < 0 ) return ;

   OEMIO_DATA_ARRAY *p = & OemioDataArray ;

   for ( ; n >= OEMIO_DATA_ARRAY_SIZE ; n -= OEMIO_DATA_ARRAY_SIZE ) {
      if ( ! p->next ) {
         p->next = calloc_array ( OEMIO_DATA_ARRAY, 1 ) ;
         p->next->next = NULL ;
      }
      p = p->next ;
   }

   if ( mode ) ( p->data [ n ] ) |=   bit ;
   else        ( p->data [ n ] ) &= ~ bit ;
}



#define CLEAR_MODE(s)   SET_MODE ( stream, ~ 0, 0 )



static int is_read_stream ( FILE *stream ) {

   if ( stream == stdin ) return 1 ;
   if ( stream == stdout || stream == stderr ) return 0 ;

   HANDLE hFile = fget_osfhandle ( stream ) ;

   if ( DuplicateHandle ( GetCurrentProcess (), hFile, GetCurrentProcess (), & hFile, GENERIC_READ, 0, 0 ) ) {
      CloseHandle ( hFile ) ;
      return 1 ;
   }

   return 0 ;
}



static int is_write_stream ( FILE *stream ) {

   if ( stream == stdin ) return 0 ;
   if ( stream == stdout || stream == stderr ) return 1 ;

   HANDLE hFile = fget_osfhandle ( stream ) ;

   if ( DuplicateHandle ( GetCurrentProcess (), hFile, GetCurrentProcess (), & hFile, GENERIC_WRITE, 0, 0 ) ) {
      CloseHandle ( hFile ) ;
      return 1 ;
   }

   return 0 ;
}



#endif



////////////////////////////////////////////
//             f[^ (3)             //
////////////////////////////////////////////



#if IS_USE_CRT_STRUCT
#define OEMIO_UNICODE_MODE    0x01000000     // Unicode [h
#define OEMIO_TEXT_MODE       0x02000000     // Unicode [hŁAeLXg[h
#define OEMIO_TOUCHED         0x04000000     // łɓo͂sȂ
#define OEMIO_FWIDE_TOUCHED   0x08000000     // fwide Ń[hݒ肵
#define OEMIO_BOM_FOUND       0x10000000
#define OEMIO_BOM_NOT_FOUND   0x20000000
#else
#define OEMIO_UNICODE_MODE     0x1
#define OEMIO_TEXT_MODE        0x2
#define OEMIO_TOUCHED          0x4
#define OEMIO_FWIDE_TOUCHED    0x8
#define OEMIO_BOM_FOUND        0x10
#define OEMIO_BOM_NOT_FOUND    0x20
#define OEMIO_ERROR            0x40
#define OEMIO_EOF              0x80
#endif


#define get_unicode_mode(stream)          GET_MODE ( stream, OEMIO_UNICODE_MODE )
#define set_unicode_mode(stream,mode)     SET_MODE ( stream, OEMIO_UNICODE_MODE, mode )

#define get_text_mode(stream)             GET_MODE ( stream, OEMIO_TEXT_MODE )
#define set_text_mode(stream,mode)        SET_MODE ( stream, OEMIO_TEXT_MODE, mode )

#define get_is_touched(stream)            GET_MODE ( stream, OEMIO_TOUCHED )
#define set_is_touched(stream,mode)       SET_MODE ( stream, OEMIO_TOUCHED, mode )

#define get_fwide_touched(stream)         GET_MODE ( stream, OEMIO_FWIDE_TOUCHED )
#define set_fwide_touched(stream,mode)    SET_MODE ( stream, OEMIO_FWIDE_TOUCHED, mode )

#if ! IS_USE_CRT_STRUCT
#define get_eof(stream)       GET_MODE ( stream, OEMIO_EOF )
#define set_eof(stream)       SET_MODE ( stream, OEMIO_EOF, 1 )
#endif

#if ! IS_USE_CRT_STRUCT
#define get_error(stream)     GET_MODE ( stream, OEMIO_ERROR )
#define set_error(stream)     SET_MODE ( stream, OEMIO_ERROR, 1 )
#endif



static int get_bom_status ( FILE *stream, int *mode ) {

   int IsFound = GET_MODE ( stream, OEMIO_BOM_FOUND ) ;
   int IsNotFound = GET_MODE ( stream, OEMIO_BOM_NOT_FOUND ) ;

   if ( IsFound || IsNotFound ) {
      if ( IsFound && IsNotFound ) *mode = -1 ;
      else if ( IsFound ) *mode = 1 ;
      else if ( IsNotFound ) *mode = 0 ;
      return 0 ;
   }

   return 1 ;
}



static void set_bom_status ( FILE *stream, int mode ) {

   if ( mode > 0 ) SET_MODE ( stream, OEMIO_BOM_FOUND, 1 ) ;
   if ( mode == 0 ) SET_MODE ( stream, OEMIO_BOM_NOT_FOUND, 1 ) ;
   if ( mode < 0 ) {
      SET_MODE ( stream, OEMIO_BOM_FOUND, 1 ) ;
      SET_MODE ( stream, OEMIO_BOM_NOT_FOUND, 1 ) ;
   }
}



////////////////////////////////////////////
//              ʊ֐ (1)              //
////////////////////////////////////////////



static int do_fwide ( FILE *stream, int mode ) ;



// Xg[ Unicode [hݒ/擾
// mode   Ȃ Ansi [h
//          Ȃ Unicode [h
//         0 Ȃ ݂̃[h擾
// ߂ĺAAnsi [hȂ畉Ԃ
//           Unicode [hȂ琳Ԃ
// r ̂ƂA܂ r+, a+ Ŋt@C̒ 1 ȏ̂Ƃ́Amode 𖳎At@C擪画f
// w, w+ ̂ƂA܂ r+, a+ Ŋt@C̒ 0 ̂Ƃ́Aw肳ꂽ mode ɕύX
// [ȟ́A܂o͂sȂĂȂXg[ł̂݉\
// ȍ~́AłɌ肵[hԂ
int fwide ( FILE *stream, int mode ) {

   int result ;

   if ( mode ) result = do_fwide ( stream, ( mode > 0 ) ? 1 : 0 ) ;
   else        result = do_fwide ( stream, -1 ) ;

   return ( result ) ? 1 : -1 ;
}



static int peek_bom ( FILE *stream ) ;
static int truncate_even ( FILE *stream ) ;



// fwide ̉֐
// mode  0 Ȃ AnsiAȂ UnicodeAȂ₢킹̂
// Ansi Ȃ 0 AUnicode Ȃ 0 ȊOԂ
static int do_fwide ( FILE *stream, int mode ) {

   if ( fisatty ( stream ) ) return IsNT () ;
   if ( get_is_touched ( stream ) ) return get_unicode_mode ( stream ) ;
   if ( get_fwide_touched ( stream ) ) return get_unicode_mode ( stream ) ;

   int bom_status = peek_bom ( stream ) ;
   if ( bom_status >= 0 ) {
      if ( bom_status ) mode = 1 ;
      else              mode = 0 ;
   }

   if ( mode < 0 ) return get_unicode_mode ( stream ) ;

   set_fwide_touched ( stream, 1 ) ;

   int oldmode = get_unicode_mode ( stream ) ;
   set_unicode_mode ( stream, mode ) ;
   int newmode = get_unicode_mode ( stream ) ;  // l bool ł͂Ȃ̂ōēx擾Ĕr

   if ( newmode != oldmode ) {
      if ( newmode ) {
         if ( fsetmode ( stream, _O_BINARY ) == _O_TEXT ) set_text_mode ( stream, 1 ) ;
         else                                             set_text_mode ( stream, 0 ) ;
         truncate_even ( stream ) ;
      }
      else {
         if ( get_text_mode ( stream ) ) fsetmode ( stream, _O_TEXT ) ;
         set_text_mode ( stream, 0 ) ;
      }
   }

   return newmode ;
}



// t@C擪 BOM 
// Ansi Ȃ 0 AUnicode Ȃ琳AsȂ畉Ԃ
static int peek_bom ( FILE *stream ) {

   int mode = -1 ;

   if ( ! get_bom_status ( stream, & mode ) ) return mode ;

   HANDLE hFile = fget_osfhandle ( stream ) ;
   if ( hFile == INVALID_HANDLE_VALUE ) return mode ;

   // r, r+, w+, a+
   if ( is_read_stream ( stream ) ) {

      int nFileType = GetFileType ( hFile ) ;

      // pCv
      if ( nFileType == FILE_TYPE_PIPE ) {

         wchar_t wsz [ 1 ] ;
         unsigned long length ;
         int result ;

         while ( ( result = PeekNamedPipe ( hFile, wsz, sizeof(wchar_t), & length, NULL, NULL ) ) && ! length ) Sleep ( 100 ) ;

         if ( result && length == sizeof(wchar_t) && *wsz == BYTE_ORDER_MARK ) mode = 1 ;
         else if ( length )                                                    mode = 0 ;

      }
      // fBXN
      else if ( nFileType == FILE_TYPE_DISK ) {

         if ( ! SetFilePointer64 ( hFile, 0, FILE_CURRENT ) ) {

            wchar_t wsz [ 1 ] ;
            unsigned long length ;
            if ( ReadFile ( hFile, wsz, sizeof(wchar_t), & length, NULL ) ) {
               if ( length == sizeof(wchar_t) && *wsz == BYTE_ORDER_MARK ) mode = 1 ;
               else if ( length )                                          mode = 0 ;
            }

            SetFilePointer64 ( hFile, 0, FILE_BEGIN ) ;
         }
      }

   }
   // ǉ_CNg
   else if ( stream == stdout || stream == stderr ) {

      if ( GetFileType ( hFile ) == FILE_TYPE_DISK ) {

         int64_t nPosition = SetFilePointer64 ( hFile, 0, FILE_CURRENT ) ;
         if ( nPosition && nPosition != -1 ) {

            HANDLE hTmp ;

            if ( DuplicateHandle ( GetCurrentProcess (), hFile, GetCurrentProcess (), & hTmp, GENERIC_READ, 0, 0 ) ) {

               if ( SetFilePointer64 ( hTmp, 0, FILE_BEGIN ) != -1 ) {

                  wchar_t wsz [ 1 ] ;
                  unsigned long length ;
                  if ( ReadFile ( hTmp, wsz, sizeof(wchar_t), & length, NULL ) ) {
                     if ( length == sizeof(wchar_t) && *wsz == BYTE_ORDER_MARK ) mode = 1 ;
                     else if ( length )                                          mode = 0 ;
                  }

                  SetFilePointer64 ( hTmp, nPosition, FILE_BEGIN ) ;
               }

               CloseHandle ( hTmp ) ;
            }
         }
      }
   }

   set_bom_status ( stream, mode ) ;

   return mode ;
}



// t@CTCYɐ؂l߂
static int truncate_even ( FILE *stream ) {

   HANDLE hFile = fget_osfhandle ( stream ) ;
   if ( hFile == INVALID_HANDLE_VALUE ) return 0 ;

   // w, r+, w+, a+
   if ( is_write_stream ( stream ) ) {

      // fBXN
      if ( GetFileType ( hFile ) == FILE_TYPE_DISK ) {

         int64_t nCurrent = SetFilePointer64 ( hFile, 0, FILE_CURRENT ) ;
         if ( nCurrent != -1 ) {

            int64_t nEnd = SetFilePointer64 ( hFile, -1, FILE_END ) ;
            if ( nEnd != -1 && ! ( nEnd & 1 ) ) {

               static const wchar_t szSrc [] = { REPLACEMENT_CHARACTER } ;
               unsigned long nSize = sizeof(wchar_t) ;
               WriteFile ( hFile, szSrc, nSize, & nSize, NULL ) ;

               if ( nCurrent > nEnd ) nCurrent = nEnd + nSize ;
            }

            if ( nCurrent & 1 ) nCurrent -- ;

            SetFilePointer64 ( hFile, nCurrent, FILE_BEGIN ) ;
         }
      }
   }

   return 0 ;
}



////////////////////////////////////////////
//              ʊ֐ (2)              //
////////////////////////////////////////////



// CRT  fopen ()  r+, a+ Ńt@CJƂAeLXgt@CȂAt@CI[̕𒲂ׁA
// CTRL-Z ȂABt@CJƂ b w肳Ă΁A̓łB
// Unicode ͂QoCgڂ CTRL-Z 邱Ƃ̂ŁA r+, a+ ̂Ƃ́AUoCi[[hŊJA
// ƂŃeLXg[hɕύX邱ƂKvɂȂB

// CRT  fopen ()  a ł̓eLXgt@Cł CTRL-Z ȂB
// OS ̒ǉ_CNg >> ł CTRL-Z ȂB



#undef fopen
#undef fsopen
#undef wfopen
#undef wfsopen
#undef fclose

#define fsopen _fsopen
#define wfsopen _wfsopen



static int truncate_ctrlz ( FILE *stream ) ;

#define FOPEN_MODE_LEN_MAX    0x80



// t@CJiANSIŁj
// ߂l fsopen Ɠ
//  mode  a w肷ƁAI a+ ƂĊJ
FILE *oem_fsopen ( const char *filename, const char *mode, int shflag ) {

   while ( *mode == ' ' ) mode ++ ;

   FILE *stream ;

   if ( ( *mode == 'r' && strchr ( mode, '+' ) || *mode == 'a' ) && ! strchr ( mode, 'b' ) ) {

      char newmode [ FOPEN_MODE_LEN_MAX + 8 ] ;
      if ( *mode == 'r' ) strcpy ( newmode, "r+b" ) ;
      else                strcpy ( newmode, "a+b" ) ;

      for ( int n = 1 ; n < FOPEN_MODE_LEN_MAX && *( mode + n ) ; n ++ ) {
         if ( *( mode + n ) == '+' || *( mode + n ) == 'b' || *( mode + n ) == 't' ) continue ;
         char buffer [] = { *( mode + n ), 0 } ;
         strcat ( newmode, buffer ) ;
      }

      stream = fsopen ( filename, newmode, shflag ) ;
      if ( ! stream ) return NULL ;

      CLEAR_MODE ( stream ) ;

      int bom_status = peek_bom ( stream ) ;
      if ( ! bom_status ) truncate_ctrlz ( stream ) ;

      fsetmode ( stream, _O_TEXT ) ;
   }
   else {

      stream = fsopen ( filename, mode, shflag ) ;
      if ( ! stream ) return NULL ;

      CLEAR_MODE ( stream ) ;
   }

   return stream ;
}



// t@CJiUNICODEŁj
// ߂l wfsopen Ɠ
//  mode  a w肷ƁAI a+ ƂĊJ
FILE *oem_wfsopen ( const wchar_t *filename, const wchar_t *mode, int shflag ) {

   while ( *mode == ' ' ) mode ++ ;

   FILE *stream ;

   if ( ( *mode == 'r' && wcschr ( mode, '+' ) || *mode == 'a' ) && ! wcschr ( mode, 'b' ) ) {

      wchar_t newmode [ FOPEN_MODE_LEN_MAX + 8 ] ;
      if ( *mode == 'r' ) wcscpy ( newmode, L"r+b" ) ;
      else                wcscpy ( newmode, L"a+b" ) ;

      for ( int n = 1 ; n < FOPEN_MODE_LEN_MAX && *( mode + n ) ; n ++ ) {
         if ( *( mode + n ) == '+' || *( mode + n ) == 'b' || *( mode + n ) == 't' ) continue ;
         wchar_t buffer [] = { *( mode + n ), 0 } ;
         wcscat ( newmode, buffer ) ;
      }

      stream = wfsopen ( filename, newmode, shflag ) ;
      if ( ! stream ) return NULL ;

      CLEAR_MODE ( stream ) ;

      int bom_status = peek_bom ( stream ) ;
      if ( ! bom_status ) truncate_ctrlz ( stream ) ;

      fsetmode ( stream, _O_TEXT ) ;
   }
   else {

      stream = wfsopen ( filename, mode, shflag ) ;
      if ( ! stream ) return NULL ;

      CLEAR_MODE ( stream ) ;
   }

   return stream ;
}



// t@C CTRL-Z 폜
static int truncate_ctrlz ( FILE *stream ) {

   HANDLE hFile = fget_osfhandle ( stream ) ;
   if ( hFile == INVALID_HANDLE_VALUE ) return 0 ;

   // w, r+, w+, a+
   if ( is_write_stream ( stream ) ) {

      // fBXN
      if ( GetFileType ( hFile ) == FILE_TYPE_DISK ) {

         int64_t nCurrent = SetFilePointer64 ( hFile, 0, FILE_CURRENT ) ;
         if ( nCurrent != -1 ) {

            int64_t nEnd = SetFilePointer64 ( hFile, -1, FILE_END ) ;
            if ( nEnd != -1 ) {

               char sz [ 1 ] ;
               unsigned long length ;
               if ( ReadFile ( hFile, sz, sizeof(char), & length, NULL ) ) {
                  if ( length == sizeof(char) && *sz == CTRLZ ) {
                     if ( SetFilePointer64 ( hFile, nEnd, FILE_BEGIN ) != -1 ) {
                        SetEndOfFile ( hFile ) ;
                        if ( nCurrent > nEnd ) nCurrent = nEnd ;
                     }
                  }
               }

               SetFilePointer64 ( hFile, nCurrent, FILE_BEGIN ) ;
            }
         }
      }

   }

   return 0 ;
}



FILE *oem_fopen ( const char *filename, const char *mode ) {
   return oem_fsopen ( filename, mode, _SH_DENYNO ) ;
}



FILE *oem_wfopen ( const wchar_t *filename, const wchar_t *mode ) {
   return oem_wfsopen ( filename, mode, _SH_DENYNO ) ;
}



int oem_fclose ( FILE *stream ) {
   CLEAR_MODE ( stream ) ;
   return fclose ( stream ) ;
}



////////////////////////////////////////////
//              ʊ֐ (3)              //
////////////////////////////////////////////



#undef fseek
#undef fseek64
#undef fsetpos
#undef rewind
#undef ferror
#undef feof

#if defined _MSC_VER
#define fseek64 _fseeki64
#else
#define fseek64 fseek
#endif



int oem_fseek ( FILE *stream, long offset, int origin ) {
   HANDLE hFile = fget_osfhandle ( stream ) ;
   if ( hFile != INVALID_HANDLE_VALUE && GetFileType ( hFile ) == FILE_TYPE_DISK ) set_is_touched ( stream, 0 ) ;
   return fseek ( stream, offset, origin ) ;
}



int oem_fseek64 ( FILE *stream, int64_t offset, int origin ) {
   HANDLE hFile = fget_osfhandle ( stream ) ;
   if ( hFile != INVALID_HANDLE_VALUE && GetFileType ( hFile ) == FILE_TYPE_DISK ) set_is_touched ( stream, 0 ) ;
   return fseek64 ( stream, offset, origin ) ;
}



int oem_fsetpos ( FILE *stream, const fpos_t *pos ) {
   HANDLE hFile = fget_osfhandle ( stream ) ;
   if ( hFile != INVALID_HANDLE_VALUE && GetFileType ( hFile ) == FILE_TYPE_DISK ) set_is_touched ( stream, 0 ) ;
   return fsetpos ( stream, pos ) ;
}



void oem_rewind ( FILE *stream ) {
   HANDLE hFile = fget_osfhandle ( stream ) ;
   if ( hFile != INVALID_HANDLE_VALUE && GetFileType ( hFile ) == FILE_TYPE_DISK ) set_is_touched ( stream, 0 ) ;
   rewind ( stream ) ;
}



int oem_ferror ( FILE *stream ) {
#if IS_USE_CRT_STRUCT
   return ferror ( stream ) ;
#else
   return ferror ( stream ) | get_error ( stream ) ;
#endif
}



int oem_feof ( FILE *stream ) {
#if IS_USE_CRT_STRUCT
   return feof ( stream ) ;
#else
   return feof ( stream ) | get_eof ( stream ) ;
#endif
}



////////////////////////////////////////////
//                  o                  //
////////////////////////////////////////////



// eLXg[h   { Ansi [h   FLFCR+LF
//                  { Console [hFLFCR+LF
//                  { Unicode [hFLFCR+LF, 擪 BOM t
// oCi[[h { Ansi [h   FLF}}
//                  { Console [hFLF}}
//                  { Unicode [hFLF}}, 擪 BOM t
// [h     { Unicode [hF WEOF 폜, r BOM 폜



static size_t do_fwrites ( const char *string, size_t count, FILE *stream ) ;
static size_t do_fwritews ( const wchar_t *string, size_t count, FILE *stream ) ;


#define PRINTF_BUFFER_SIZE    ( MAX_PATH + 0x80 )


#undef printf
#undef fprintf
#undef vfprintf
#undef fputs

#undef wprintf
#undef fwprintf
#undef vfwprintf
#undef fputws



////////////////////////////////////////////
//             óiANSIŁj             //
////////////////////////////////////////////



// ߂l fwrite ƓiԂj
size_t __cdecl oem_fwrites ( const char *string, size_t length, FILE *stream ) {

   return do_fwrites ( string, length, stream ) ;
}



// ߂l fputs Ɠ
int __cdecl oem_fputs ( const char *string, FILE *stream ) {

   size_t length = strlen ( string ) ;

   if ( oem_fwrites ( string, length, stream ) != length ) return EOF ;

   return 0 ;
}



// ߂l printf Ɠ
int __cdecl oem_printf ( const char *format,... ) {

   va_list args ;
   va_start ( args, format ) ;

   int retvalue = oem_vfprintf ( stdout, format, args ) ;

   va_end ( args ) ;

   return retvalue ;
}



// ߂l fprintf Ɠ
int __cdecl oem_fprintf ( FILE *stream, const char *format,... ) {

   va_list args ;
   va_start ( args, format ) ;

   int retvalue = oem_vfprintf ( stream, format, args ) ;

   va_end ( args ) ;

   return retvalue ;
}



// ߂l vfprintf Ɠ
int __cdecl oem_vfprintf ( FILE *stream, const char *format, va_list args ) {

   int retvalue = EOF ;

   va_list args1 ;
   va_list args2 ;
   va_copy ( args1, args ) ;
   va_copy ( args2, args ) ;

   char buffer [ PRINTF_BUFFER_SIZE ] ;
   char *string = NULL ;
   int result ;

   if ( ( result = vsnprintf ( buffer, PRINTF_BUFFER_SIZE, format, args ) ) < 0 || result >= PRINTF_BUFFER_SIZE ) {

      int length ;
      if ( ( length = vscprintf ( format, args1 ) ) < 0 ) goto EXIT ;
      if ( ! ( string = malloc_array ( char, length + 1 ) ) ) goto EXIT ;
      if ( ( result = vsnprintf ( string, length + 1, format, args2 ) ) < 0 || result > length ) goto EXIT ;
   }

   if ( do_fwrites ( ( string ) ? string : buffer, result, stream ) == (size_t) result ) retvalue = result ;

   EXIT :

   free ( string ) ;

   va_end ( args1 ) ;
   va_end ( args2 ) ;

   return retvalue ;
}



////////////////////////////////////////////
//            óiUNICODEŁj           //
////////////////////////////////////////////



// ߂l fwrite ƓiԂj
size_t __cdecl oem_fwritews ( const wchar_t *string, size_t length, FILE *stream ) {

   return do_fwritews ( string, length, stream ) ;
}



// ߂l fputws Ɠ
int __cdecl oem_fputws ( const wchar_t *string, FILE *stream ) {

   size_t length = wcslen ( string ) ;

   if ( oem_fwritews ( string, length, stream ) != length ) return EOF ;

   return 0 ;
}



// ߂l wprintf Ɠ
int __cdecl oem_wprintf ( const wchar_t *format,... ) {

   va_list args ;
   va_start ( args, format ) ;

   int retvalue = oem_vfwprintf ( stdout, format, args ) ;

   va_end ( args ) ;

   return retvalue ;
}



// ߂l fwprintf Ɠ
int __cdecl oem_fwprintf ( FILE *stream, const wchar_t *format,... ) {

   va_list args ;
   va_start ( args, format ) ;

   int retvalue = oem_vfwprintf ( stream, format, args ) ;

   va_end ( args ) ;

   return retvalue ;
}



// ߂l vfwprintf Ɠ
int __cdecl oem_vfwprintf ( FILE *stream, const wchar_t *format, va_list args ) {

   int retvalue = EOF ;

   va_list args1 ;
   va_list args2 ;
   va_copy ( args1, args ) ;
   va_copy ( args2, args ) ;

   wchar_t buffer [ PRINTF_BUFFER_SIZE ] ;
   wchar_t *string = NULL ;
   int result ;

   if ( ( result = vsnwprintf ( buffer, PRINTF_BUFFER_SIZE, format, args ) ) < 0 || result >= PRINTF_BUFFER_SIZE ) {

      int length ;
      if ( ( length = vscwprintf ( format, args1 ) ) < 0 ) goto EXIT ;
      if ( ! ( string = malloc_array ( wchar_t, length + 1 ) ) ) goto EXIT ;
      if ( ( result = vsnwprintf ( string, length + 1, format, args2 ) ) < 0 || result > length ) goto EXIT ;
   }

   if ( do_fwritews ( ( string ) ? string : buffer, result, stream ) == (size_t) result ) retvalue = result ;

   EXIT :

   free ( string ) ;

   va_end ( args1 ) ;
   va_end ( args2 ) ;

   return retvalue ;
}



////////////////////////////////////////////
//                ֐                //
////////////////////////////////////////////



#define WRITE_CONSOLE_MAX_LEN    0x1000      // R\[o͂ SHRT_MAX ł͑傫



// o͂Ԃ
static size_t do_fwrites ( const char *string, size_t count, FILE *stream ) {

   // ڏo
   if ( fisatty ( stream ) ? GetACP () == GetConsoleOutputCP () : ! get_unicode_mode ( stream ) ) {

      set_is_touched ( stream, 1 ) ;

      size_t count_saved = count ;

      while ( count ) {

         size_t length = min ( count, WRITE_CONSOLE_MAX_LEN ) ;
         size_t written = fwrite ( string, sizeof(char), length, stream ) / sizeof(char) ;

         count -= written ;
         string += written ;

         if ( written != length ) break ;
      }

      return count_saved - count ;
   }
   // Unicode oRŏo
   else {

      size_t count_saved = count ;

      for ( ; count ; string ++, count -- ) {

         wchar_t wsz [ 1 ] ;
         int length ;

         if ( isascii ( *string ) ) {     // ̂
            wsz [ 0 ] = (unsigned char) *string ;
            length = 1 ;
         }
         else {
            length = mbsnext ( string ) ;
            if ( ! MultiByteToWideChar ( CP_ACP, 0, string, length, wsz, 1 ) ) break ;
         }

         if ( ! do_fwritews ( wsz, 1, stream ) ) break ;
         if ( length > 1 ) string ++, count -- ;
      }

      return count_saved - count ;
   }
}



static int fputwc_straight ( int c, FILE *stream ) ;
static int CallWriteConsoleW ( HANDLE hConsole, const wchar_t *szBuffer, int nSize ) ;



// o͂Ԃ
static size_t do_fwritews ( const wchar_t *string, size_t count, FILE *stream ) {

   int codepage = CP_ACP ;

   if ( fisatty ( stream ) ) {
      if ( IsNT () ) {

         HANDLE hConsole = fget_osfhandle ( stream ) ;
         if ( hConsole == INVALID_HANDLE_VALUE ) return 0 ;

         unsigned long dwDummy ;

         if ( GetConsoleMode ( hConsole, & dwDummy ) ) {

            set_is_touched ( stream, 1 ) ;

            fflush ( stream ) ;
            size_t count_saved = count ;

            while ( count ) {

               int length = (int) min ( count, WRITE_CONSOLE_MAX_LEN ) ;
               int written = CallWriteConsoleW ( hConsole, string, length ) ;

               count -= written ;
               string += written ;

               if ( written != length ) {
                  set_error ( stream ) ;
                  break ;
               }
            }

            return count_saved - count ;
         }
      }

      codepage = GetConsoleOutputCP () ;
   }


   if ( get_unicode_mode ( stream ) ) {

      int is_output_bom = 0 ;
      int is_text_mode = get_text_mode ( stream ) ;

      if ( is_text_mode && ! get_is_touched ( stream ) ) {

         HANDLE hFile = fget_osfhandle ( stream ) ;
         if ( hFile == INVALID_HANDLE_VALUE ) return 0 ;

         // pipe
         if ( GetFileType ( hFile ) == FILE_TYPE_PIPE ) is_output_bom = 1 ;
         // file
         else if ( ! ftell64 ( stream ) ) is_output_bom = 1 ;
      }

      set_is_touched ( stream, 1 ) ;

      if ( is_output_bom && fputwc_straight ( BYTE_ORDER_MARK, stream ) < 0 ) return 0 ;

      size_t count_saved = count ;

      for ( ; count ; string ++, count -- ) {
         int c = *string ;
         if ( is_text_mode ) {
            if ( c == BYTE_ORDER_MARK || c == WEOF ) continue ;
            if ( c == '\n' ) fputwc_straight ( '\r', stream ) ;
         }
         if ( fputwc_straight ( c, stream ) < 0 ) break ;
      }

      return count_saved - count ;
   }
   else {

      set_is_touched ( stream, 1 ) ;

      size_t count_saved = count ;

      for ( ; count ; string ++, count -- ) {

         char sz [ MB_LEN_MAX ] ;
         int length ;

         if ( isascii ( *string ) ) {     // ̂
            sz [ 0 ] = (unsigned char) *string ;
            length = 1 ;
         }
         else if ( IS_DETECT_SURROGATE && IsUnicodeHighSurrogate ( *string ) ) {
            if ( ! ( length = WideCharToMultiByte ( codepage, 0, string, 2, sz, MB_LEN_MAX, NULL, NULL ) ) ) {
               set_error ( stream ) ;
               break ;
            }
            if ( length == 2 && sz [ 0 ] == '?' && sz [ 1 ] == '?' ) length = 1 ;
            string ++, count -- ;
         }
         else {
            if ( ! ( length = WideCharToMultiByte ( codepage, 0, string, 1, sz, MB_LEN_MAX, NULL, NULL ) ) ) {
               set_error ( stream ) ;
               break ;
            }
         }

         for ( int i = 0 ; i < length ; i ++ ) {
            if ( fputc ( (unsigned char) sz [ i ], stream ) < 0 ) goto EXIT ;
         }
      }

      EXIT :

      return count_saved - count ;
   }
}



////////////////////////////////////////////
//                                    //
////////////////////////////////////////////



// eLXg[h   { Ansi [h   FCR+LFLF, CTRL-Z Ńt@CI[, r̃k폜
//                  { Console [hFCR+LFLF, s CTRL-Z Ńt@CI[
//                  { Unicode [hFCR+LFLF,  BOM 폜, r̃k폜
// oCi[[h { Ansi [h   FCR+LF}}, CTRL-Z ̓}}
//                  { Console [hFCR+LF}}, s CTRL-Z Ńt@CI[
//                  { Unicode [hFCR+LF}}, BOM ̓}}
// [h     { Ansi [h   FrłQoCg؂Ȃ
//                  { Unicode [hFrŃTQ[gyA؂Ȃ,  WEOF 폜



static size_t do_freads ( char *string, size_t count, int stop_char, FILE *stream ) ;
static size_t do_freadws ( wchar_t *string, size_t count, int stop_char, FILE *stream ) ;
static int do_fgetc ( FILE *stream, int is_unicode_mode, int is_text_mode, int codepage ) ;
static int do_fgetwc ( FILE *stream, int is_unicode_mode, int is_text_mode, int codepage ) ;

#undef fgets
#undef fgetws



////////////////////////////////////////////
//             ́iANSIŁj             //
////////////////////////////////////////////



// ߂l fread ƓioCgԂj
// obt@TCYPȂƂ
size_t __cdecl oem_freads ( char *string, size_t count, FILE *stream ) {

   return do_freads ( string, count, EOF, stream ) ;
}



// ߂l fgets Ɠ
// obt@TCYPȂƂ
char *__cdecl oem_fgets ( char *string, int count, FILE *stream ) {

   if ( count <= 0 ) return NULL ;

   size_t retvalue = do_freads ( string, count - 1, '\n', stream ) ;
   string [ retvalue ] = 0 ;

   if ( ! retvalue && feof ( stream ) ) return NULL ;
   return string ;
}



////////////////////////////////////////////
//            ́iUNICODEŁj           //
////////////////////////////////////////////



// ߂l fread Ɠi[hԂj
// obt@TCYPȂƂ
size_t __cdecl oem_freadws ( wchar_t *string, size_t count, FILE *stream ) {

   return do_freadws ( string, count, EOF, stream ) ;
}



// ߂l fgetws Ɠ
// obt@TCYPȂƂ
wchar_t *__cdecl oem_fgetws ( wchar_t *string, int count, FILE *stream ) {

   if ( count <= 0 ) return NULL ;

   size_t retvalue = do_freadws ( string, count - 1, '\n', stream ) ;
   string [ retvalue ] = 0 ;

   if ( ! retvalue && feof ( stream ) ) return NULL ;
   return string ;
}



////////////////////////////////////////////
//                ֐                //
////////////////////////////////////////////



// ͂Ԃ
static size_t do_freads ( char *string, size_t count, int stop_char, FILE *stream ) {

   set_is_touched ( stream, 1 ) ;

   int is_unicode_mode = get_unicode_mode ( stream ) ;
   int is_text_mode = ( is_unicode_mode ) ? get_text_mode ( stream ) : 0 ;

   int codepage = CP_ACP ;
   if ( fisatty ( stream ) && GetACP () != GetConsoleCP () ) codepage = GetConsoleCP () ;


   char *current = string ;
   char *end = string + count ;
   int is_first_in_line = 1 ;


   // trail byte ޏꍇɔ
   // if single-byte cp, then getmbcp () returns 0
   if ( getmbcp () ) end -- ;


   while ( current < end ) {

      int c ;

      if ( ( c = do_fgetc ( stream, is_unicode_mode, is_text_mode, codepage ) ) < 0 ) break ;

      if ( c == CTRLZ && is_first_in_line && fisatty ( stream ) ) {
         while ( ( c = do_fgetc ( stream, is_unicode_mode, is_text_mode, codepage ) ) >= 0 && c != '\n' ) ;
         set_eof ( stream ) ;
         break ;
      }

      if ( is_text_mode ) {
         if ( c == 0 ) continue ;
      }

      if ( c > 0x100 ) {
         *current ++ = ( c >> BYTE_BIT ) ;
         *current ++ = c ;
      }
      else {
         *current ++ = c ;
      }

      if ( c == '\n' ) is_first_in_line = 1 ;
      else             is_first_in_line = 0 ;

      if ( c == stop_char ) break ;
   }


   return current - string ;
}



// ͂Ԃ
static size_t do_freadws ( wchar_t *string, size_t count, int stop_char, FILE *stream ) {

   set_is_touched ( stream, 1 ) ;

   int is_unicode_mode = get_unicode_mode ( stream ) ;
   int is_text_mode = ( is_unicode_mode ) ? get_text_mode ( stream ) : 0 ;

   int codepage = CP_ACP ;
   if ( fisatty ( stream ) && GetACP () != GetConsoleCP () ) codepage = GetConsoleCP () ;


   wchar_t *current = string ;
   wchar_t *end = string + count ;
   int is_first_in_line = 1 ;


   // TQ[gyAޏꍇɔ
   end -- ;


   while ( current < end ) {

      int c ;

      if ( ( c = do_fgetwc ( stream, is_unicode_mode, is_text_mode, codepage ) ) < 0 ) break ;

      if ( IsUnicodeHighSurrogate ( c ) ) {
         *current ++ = c ;
         if ( ( c = do_fgetwc ( stream, is_unicode_mode, is_text_mode, codepage ) ) < 0 ) break ;
      }

      if ( c == CTRLZ && is_first_in_line && fisatty ( stream ) ) {
         while ( ( c = do_fgetwc ( stream, is_unicode_mode, is_text_mode, codepage ) ) >= 0 && c != '\n' ) ;
         set_eof ( stream ) ;
         break ;
      }

      if ( is_text_mode ) {
         if ( c == 0 ) continue ;
         if ( c == BYTE_ORDER_MARK ) continue ;
      }

      *current ++ = c ;

      if ( c == '\n' ) is_first_in_line = 1 ;
      else             is_first_in_line = 0 ;

      if ( c == stop_char ) break ;
   }


   return current - string ;
}



// 當As EOF Ԃ
static int do_fgetc ( FILE *stream, int is_unicode_mode, int is_text_mode, int codepage ) {

   // ړ
   if ( ! is_unicode_mode && codepage == CP_ACP ) {

      int c ;
      if ( ( c = fgetc ( stream ) ) < 0 ) return EOF ;

      if ( ismbblead ( c ) ) {
         int c2 ;
         if ( ( c2 = fgetc ( stream ) ) < 0 ) return EOF ;
         if ( iscntrl ( c2 ) ) {
            if ( is_text_mode ) return c2 ;  // sȕ
            else                ungetc ( c2, stream ) ;
         }
         else {
            c = ( c << BYTE_BIT ) + c2 ;
         }
      }

      return c ;
   }
   // Unicode oRœ
   else {

      char sz [ MB_LEN_MAX ] ;
      wchar_t wsz [ 1 ] ;
      int c ;

      while ( ( c = do_fgetwc ( stream, is_unicode_mode, is_text_mode, codepage ) ) == BYTE_ORDER_MARK || c == WEOF ) ;

      if ( c < 0 ) return EOF ;

      if ( isascii ( c ) ) return c ;     // ̂

      wsz [ 0 ] = c ;

      int size = WideCharToMultiByte ( CP_ACP, 0, wsz, 1, sz, MB_LEN_MAX, NULL, NULL ) ;
      if ( ! size ) return '?' ;

      if ( size == 2 ) {
         int c1 = (unsigned char) *sz ;
         int c2 = (unsigned char) *( sz + 1 ) ;
         return ( c1 << BYTE_BIT ) + c2 ;
      }
      else {
         return (unsigned char) *sz ;
      }
   }
}



static int fgetwc_straight ( FILE *stream ) ;
static int ungetwc_straight ( int c, FILE *stream ) ;
static int CallReadConsoleW ( HANDLE hConsole ) ;



// 當As EOF Ԃ
static int do_fgetwc ( FILE *stream, int is_unicode_mode, int is_text_mode, int codepage ) {

   if ( fisatty ( stream ) ) {
      if ( IsNT () ) {

         HANDLE hConsole = fget_osfhandle ( stream ) ;
         if ( hConsole == INVALID_HANDLE_VALUE ) return EOF ;

         unsigned long dwDummy ;

         if ( GetConsoleMode ( hConsole, & dwDummy ) ) {

            static int c_saved = EOF ;

            if ( c_saved != EOF ) {
               c_saved = EOF ;
               return c_saved ;
            }

            int c = CallReadConsoleW ( hConsole ) ;
            if ( c == EOF ) set_error ( stream ) ;

            if ( c == '\r' ) {
               int c2 = CallReadConsoleW ( hConsole ) ;
               if ( c2 == '\n' ) return '\n' ;
               if ( c2 != EOF ) c_saved = c2 ;     // ReadConsole PƂ \r ԂƂ͂܂ȂAÔ
               else             set_error ( stream ) ;
            }

            return c ;
         }
      }
   }


   // ړ
   if ( is_unicode_mode ) {

      int c = fgetwc_straight ( stream ) ;

      if ( is_text_mode && c == '\r' ) {
         int c2 = fgetwc_straight ( stream ) ;
         if ( c2 == '\n' ) return '\n' ;
         //  ungetwc_straight G[Ȃ \r ̂ĂāA̕Ԃ
         if ( c2 != EOF && ungetwc_straight ( c2, stream ) == EOF ) return c2 ;
      }

      return c ;
   }
   // ANSI oRœ
   else {

      char sz [ MB_LEN_MAX ] ;
      wchar_t wsz [ 1 ] ;
      int length ;
      int c ;

      if ( ( c = fgetc ( stream ) ) < 0 ) return EOF ;

      if ( isascii ( c ) ) return c ;     // ̂

      sz [ 0 ] = c ;
      length = 1 ;

      if ( IsDBCSLeadByteEx ( codepage, c ) ) {
         int c2 ;
         if ( ( c2 = fgetc ( stream ) ) < 0 ) return EOF ;
         if ( iscntrl ( c2 ) ) return c2 ;   // sȕ
         else {
            sz [ 1 ] = c2 ;
            length = 2 ;
         }
      }

      int size = MultiByteToWideChar ( codepage, 0, sz, length, wsz, 1 ) ;
      if ( ! size ) return '?' ;

      return *wsz ;
   }
}



////////////////////////////////////////////
//                ֐                //
////////////////////////////////////////////



// 當As EOF Ԃ
static int fputwc_straight ( int c, FILE *stream ) {
   if ( fputc ( c, stream ) < 0 ) return EOF ;
   if ( fputc ( c >> BYTE_BIT, stream ) < 0 ) return EOF ;
   return c ;
}



// 當As EOF Ԃ
static int fgetwc_straight ( FILE *stream ) {
   int c1, c2 ;
   if ( ( c1 = fgetc ( stream ) ) < 0 ) return EOF ;
   if ( ( c2 = fgetc ( stream ) ) < 0 ) return EOF ;
   return ( c2 << BYTE_BIT ) + c1 ;
}



// 當As EOF Ԃ
static int ungetwc_straight ( int c, FILE *stream ) {

   const int test = 0 ; // 0 or 1 or 2

   // VC++ ̎ł́Aobt@̑傫oCgȂ̂ŁAQA ungetc 
   // s邱Ƃ͂ȂAG[̎́ÂĂăt@Cʒuۑ

   if ( test > 1 || ungetc ( c >> BYTE_BIT, stream ) < 0 ) return EOF ;

   if ( test > 0 || ungetc ( c, stream ) < 0 ) {
      fgetc ( stream ) ;
      return EOF ;
   }

   return c ;
}



// 珑񂾃oCgAs 0 Ԃ
static int CallWriteConsoleW ( HANDLE hConsole, const wchar_t *szBuffer, int nSize ) {

   unsigned long nSizeWritten ;

   if ( ! WriteConsoleW ( hConsole, szBuffer, nSize, & nSizeWritten, NULL ) ) return 0 ;

   return nSizeWritten ;
}



// 當As EOF Ԃ
static int CallReadConsoleW ( HANDLE hConsole ) {

   wchar_t szBuffer [ 1 ] ;
   unsigned long nCharRead ;

   if ( ! ReadConsoleW ( hConsole, szBuffer, 1, & nCharRead, NULL ) || ! nCharRead ) return EOF ;

   return *szBuffer ;
}



////////////////////////////////////////////
//          R\[ɂPs\          //
////////////////////////////////////////////



// R\[ɂPŝݕ\
// R\[łȂΉȂ
// \Ԃ
int fputs_line ( const char *string, FILE *stream ) {

   if ( ! fisatty ( stream ) ) return 0 ;

   HANDLE hConsole = fget_osfhandle ( stream ) ;
   if ( hConsole == INVALID_HANDLE_VALUE ) return 0 ;

   CONSOLE_SCREEN_BUFFER_INFO ConsoleInfo ;
   if ( ! GetConsoleScreenBufferInfo ( hConsole, & ConsoleInfo ) ) return 0 ;
   int width = ConsoleInfo.dwSize.X - ConsoleInfo.dwCursorPosition.X ;

   const char *current = string ;
   const char *start = string ;

   while ( *current ) {

      int char_width = 1 ;

      if ( ismbblead ( (unsigned char) *current ) ) char_width = 2 ;
      else if ( iscntrl ( *current ) ) {
         if      ( *current == '\n' || *current == '\f' || *current == '\v' ) break ;
         else if ( *current == '\t' ) char_width = 8 ;
         else if ( *current == '\r' || *current == '\b' || *current == '\a' ) char_width = 0 ;
      }

      width -= char_width ;

      if ( width < 1 ) {

         oem_fwrites ( string, current - string, stream ) ;
         string = current ;

         CONSOLE_SCREEN_BUFFER_INFO ConsoleInfo ;
         if ( ! GetConsoleScreenBufferInfo ( hConsole, & ConsoleInfo ) ) break ;
         width = ConsoleInfo.dwSize.X - ConsoleInfo.dwCursorPosition.X ;
         width -= char_width ;

         if ( width < 1 ) break ;
      }

      current += mbsnext ( current ) ;
   }

   if ( width >= 1 ) oem_fwrites ( string, current - string, stream ) ;

   return (int) ( current - start ) ;
}



// R\[ɂPŝݕ\
// R\[łȂΉȂ
// \Ԃ
int fputws_line ( const wchar_t *string, FILE *stream ) {

   if ( ! fisatty ( stream ) ) return 0 ;

   HANDLE hConsole = fget_osfhandle ( stream ) ;
   if ( hConsole == INVALID_HANDLE_VALUE ) return 0 ;

   CONSOLE_SCREEN_BUFFER_INFO ConsoleInfo ;
   if ( ! GetConsoleScreenBufferInfo ( hConsole, & ConsoleInfo ) ) return 0 ;
   int width = ConsoleInfo.dwSize.X - ConsoleInfo.dwCursorPosition.X ;

   const wchar_t *current = string ;
   const wchar_t *start = string ;

   while ( *current ) {

      int char_width = 1 ;

      if ( ! isascii ( *current ) ) char_width = 2 ;
      else if ( iscntrl ( *current ) ) {
         if      ( *current == '\n' || *current == '\f' || *current == '\v' ) break ;
         else if ( *current == '\t' ) char_width = 8 ;
         else if ( *current == '\r' || *current == '\b' || *current == '\a' ) char_width = 0 ;
      }

      width -= char_width ;

      if ( width < 1 ) {

         oem_fwritews ( string, current - string, stream ) ;
         string = current ;

         CONSOLE_SCREEN_BUFFER_INFO ConsoleInfo ;
         if ( ! GetConsoleScreenBufferInfo ( hConsole, & ConsoleInfo ) ) break ;
         width = ConsoleInfo.dwSize.X - ConsoleInfo.dwCursorPosition.X ;
         width -= char_width ;

         if ( width < 1 ) break ;
      }

      current += wcsnext ( current ) ;
   }

   if ( width >= 1 ) oem_fwritews ( string, current - string, stream ) ;

   return (int) ( current - start ) ;
}



// R\[݈̌ʒus܂łNA
// is_start_from_linetop  0 ȊOw肷ƁAJ[\sɖ߂AsNA
// R\[łȂΉȂ
int console_clear_line ( int is_start_from_linetop ) {

   enum { nBufferSize = 0x100 } ;

   FILE *stream ;
   HANDLE hConsole ;
   CONSOLE_SCREEN_BUFFER_INFO ConsoleInfo ;

   for ( int nCount = 0 ; ; nCount ++ ) {

      switch ( nCount ) {
         case 0 : stream = stderr ; break ;
         case 1 : stream = stdout ; break ;
         case 2 : return 1 ;
      }

      hConsole = fget_osfhandle ( stream ) ;
      if ( hConsole == INVALID_HANDLE_VALUE ) continue ;

      if ( GetConsoleScreenBufferInfo ( hConsole, & ConsoleInfo ) ) break ;
   }


   if ( is_start_from_linetop ) {
      ConsoleInfo.dwCursorPosition.X = 0 ;
      SetConsoleCursorPosition ( hConsole, ConsoleInfo.dwCursorPosition ) ;
   }


   if ( IsNT () ) {

      CHAR_INFO CharInfo [ nBufferSize ] ;

      for ( int i = 0 ; i < nBufferSize ; i ++ ) {
         CHAR_INFO *p = CharInfo + i ;
         p->Char.UnicodeChar = ' ' ;
         p->Attributes = ConsoleInfo.wAttributes ;
      }

      COORD BufferSize ;
      BufferSize.X = nBufferSize ;
      BufferSize.Y = 1 ;

      COORD BufferCoord = { 0 } ;

      for ( int nLength = ConsoleInfo.dwSize.X - ConsoleInfo.dwCursorPosition.X ; nLength > 0 ; nLength -= nBufferSize ) {

         SMALL_RECT WriteRegion ;
         WriteRegion.Left = ConsoleInfo.dwSize.X - nLength ;
         WriteRegion.Right = ConsoleInfo.dwSize.X - 1 ;
         WriteRegion.Top = ConsoleInfo.dwCursorPosition.Y ;
         WriteRegion.Bottom = ConsoleInfo.dwCursorPosition.Y ;

         WriteConsoleOutputW ( hConsole, CharInfo, BufferSize, BufferCoord, & WriteRegion ) ;
      }
   }
   else {

      CHAR_INFO CharInfo [ nBufferSize ] ;

      for ( int i = 0 ; i < nBufferSize ; i ++ ) {
         CHAR_INFO *p = CharInfo + i ;
         p->Char.AsciiChar = ' ' ;
         p->Attributes = ConsoleInfo.wAttributes ;
      }

      COORD BufferSize ;
      BufferSize.X = nBufferSize ;
      BufferSize.Y = 1 ;

      COORD BufferCoord = { 0 } ;

      for ( int nLength = ConsoleInfo.dwSize.X - ConsoleInfo.dwCursorPosition.X ; nLength > 0 ; nLength -= nBufferSize ) {

         SMALL_RECT WriteRegion ;
         WriteRegion.Left = ConsoleInfo.dwSize.X - nLength ;
         WriteRegion.Right = ConsoleInfo.dwSize.X - 1 ;
         WriteRegion.Top = ConsoleInfo.dwCursorPosition.Y ;
         WriteRegion.Bottom = ConsoleInfo.dwCursorPosition.Y ;

         WriteConsoleOutputA ( hConsole, CharInfo, BufferSize, BufferCoord, & WriteRegion ) ;
      }
   }


   return 0 ;
}



////////////////////////////////////////////
//         R\[ǂ         //
////////////////////////////////////////////



// R\[Ȃ 0 ȊOԂ
int fiscon ( FILE *stream ) {

   // fisatty ł NUL Ȃǂ̃LN^foCX
   // łȂ̂ŁAAPI ɂR\[

   if ( ! fisatty ( stream ) ) return 0 ;

   HANDLE hConsole = fget_osfhandle ( stream ) ;
   if ( hConsole == INVALID_HANDLE_VALUE ) return 0 ;

   unsigned long dwDummy ;

   if ( GetConsoleMode ( hConsole, & dwDummy ) ) return 1 ;

   return 0 ;
}



