// msc.h



////////////////////////////////////////////
//              STRING LOCALE             //
////////////////////////////////////////////



#ifndef RC_INVOKED
#pragma setlocale ( "japanese" )
#endif



////////////////////////////////////////////
//             TO INCLUDE ONCE            //
////////////////////////////////////////////



#ifndef MSC_H
#define MSC_H



////////////////////////////////////////////
//             RESOURCE SCRIPT            //
////////////////////////////////////////////



#if defined RC_INVOKED

#include <winresrc.h>

#ifndef IDC_STATIC
#define IDC_STATIC      (-1)
#endif

#ifndef DS_SHELLFONT
#define DS_SHELLFONT    ( DS_SETFONT | DS_FIXEDSYS )
#endif

#ifndef CREATEPROCESS_MANIFEST_RESOURCE_ID
#define CREATEPROCESS_MANIFEST_RESOURCE_ID   1
#endif

#ifndef RT_MANIFEST
#define RT_MANIFEST     24
#endif

#else // defined RC_INVOKED



////////////////////////////////////////////
//               CONFORMANCE              //
////////////////////////////////////////////



#ifdef _MSC_VER
#pragma warning ( error: 4010 )     // single-line comment contains line-continuation character
#pragma warning ( error: 4018 )     // signed/unsigned mismatch ( '<', '>' )
#pragma warning ( error: 4389 )     // signed/unsigned mismatch ( '==' )
#pragma warning ( error: 4211 )     // redefined extern to static
#endif

#if _MSC_VER >= 1400
#pragma warning ( disable: 4996 )   // function was declared deprecated
#endif

#if _MSC_VER >= 1900
#pragma warning ( disable: 4838 )   // conversion requires a narrowing conversion
#endif

#if _MSC_VER < 1300
#define for    if (0) {} else for
#elif _MSC_VER < 1400
#pragma conform ( forScope, on )
#endif


#ifndef __cplusplus
#define inline __inline
#endif


#if defined __BORLANDC__
#pragma option -w-8008  // condition is always true
#pragma option -w-8027  // function is not expanded inline
#pragma option -w-8057  // parameter is never used
#pragma option -w-8060  // possibly incorrect assignment
#pragma option -w-8066  // unreachable code
#endif


#if defined __WATCOMC__
#include <stdio.h>
#define __cdecl
#endif


////////////////////////////////////////////
//                   SEH                  //
////////////////////////////////////////////



#if defined __WATCOMC__ || defined __MINGW32__
#define SEH_NOT_IMPLEMENTED   1
#define __try           if ( 1 )
#define __except(x)     else
#define __finally
#endif


#if defined __MINGW32__
#define GetExceptionCode()          0
#define GetExceptionInformation()   NULL
#endif



////////////////////////////////////////////
//                STDDEF.H                //
////////////////////////////////////////////



#include <stddef.h>


#if defined __DMC__ || defined __WATCOMC__
#include <wchar.h>
#endif


#if defined _MSC_VER || defined __BORLANDC__ && __BORLANDC__ < 1370

#ifndef _INTPTR_T_DEFINED
typedef int             intptr_t ;
#define _INTPTR_T_DEFINED
#endif
#ifndef _UINTPTR_T_DEFINED
typedef unsigned int    uintptr_t ;
#define _UINTPTR_T_DEFINED
#endif

#ifndef _INT64_T_DEFINED
typedef __int64            int64_t ;
#define _INT64_T_DEFINED
#endif
#ifndef _UINT64_T_DEFINED
typedef unsigned __int64   uint64_t ;
#define _UINT64_T_DEFINED
#endif

#else

#include <stdint.h>

#endif



////////////////////////////////////////////
//                LIMITS.H                //
////////////////////////////////////////////



#include <limits.h>


#define INT_BIT      32
#define SHORT_BIT    16
#define LONG_BIT     32
#define INT64_BIT    64


#ifdef _I64_MIN
#ifndef INT64_MAX
#define INT64_MAX       _I64_MAX
#endif
#ifndef INT64_MIN
#define INT64_MIN       _I64_MIN
#endif
#ifndef UINT64_MAX
#define UINT64_MAX      _UI64_MAX
#endif
#else
#ifndef INT64_MAX
#define INT64_MAX       0x7FFFFFFFFFFFFFFF
#endif
#ifndef INT64_MIN
#define INT64_MIN       ( - 0x7FFFFFFFFFFFFFFF - 1 )
#endif
#ifndef UINT64_MAX
#define UINT64_MAX      0xFFFFFFFFFFFFFFFF
#endif
#endif

#ifdef _WIN64
#ifndef INTPTR_MAX
#define INTPTR_MAX      INT64_MAX
#endif
#ifndef INTPTR_MIN
#define INTPTR_MIN      INT64_MIN
#endif
#ifndef UINTPTR_MAX
#define UINTPTR_MAX     UINT64_MAX
#endif
#else
#ifndef INTPTR_MAX
#define INTPTR_MAX      INT_MAX
#endif
#ifndef INTPTR_MIN
#define INTPTR_MIN      INT_MIN
#endif
#ifndef UINTPTR_MAX
#define UINTPTR_MAX     UINT_MAX
#endif
#endif

#ifndef PTRDIFF_MAX
#define PTRDIFF_MAX     INTPTR_MAX
#endif
#ifndef PTRDIFF_MIN
#define PTRDIFF_MIN     INTPTR_MIN
#endif
#ifndef SIZE_MAX
#define SIZE_MAX        UINTPTR_MAX
#endif



////////////////////////////////////////////
//                STDARG.H                //
////////////////////////////////////////////



#if defined FILENAME_MAX   // stdio.h


#include <stdarg.h>

#ifndef va_copy
#define va_copy(dst,src)   ( (void) ((dst)=(src)) )
#endif


#endif // defined FILENAME_MAX   // stdio.h



////////////////////////////////////////////
//                 STDIO.H                //
////////////////////////////////////////////



#if defined FILENAME_MAX   // stdio.h


// Non-ANSI Names
#define wfopen _wfopen
#define fsopen _fsopen
#define wfsopen _wfsopen
#define snprintf _snprintf
#define snwprintf _snwprintf
#define vsnprintf _vsnprintf
#define vsnwprintf _vsnwprintf


#ifndef MAX_PATH
#define MAX_PATH FILENAME_MAX
#endif


#if defined _MSC_VER && defined _CRT_DISABLE_PERFCRIT_LOCKS
#if _MSC_VER < 1400
static inline int __cdecl fgetc_inline ( FILE *stream ) { return getc ( stream ) ; }
static inline int __cdecl fputc_inline ( int c, FILE *stream ) { return putc ( c, stream ) ; }
#else
static inline int __cdecl fgetc_inline ( FILE *stream ) { return _fgetc_nolock ( stream ) ; }
static inline int __cdecl fputc_inline ( int c, FILE *stream ) { return _fputc_nolock ( c, stream ) ; }
#endif
#undef fgetc
#undef fputc
#define fgetc fgetc_inline
#define fputc fputc_inline
#endif

#if defined _CRT_DISABLE_PERFCRIT_LOCKS
#undef fclose
#endif


#ifdef __cplusplus
extern "C" {
#endif

#if defined _MSC_VER
#if _MSC_VER < 1400
int __cdecl _fseeki64 ( FILE *stream, int64_t offset, int origin ) ;
int64_t __cdecl _ftelli64 ( FILE *stream ) ;
#endif
#define fseek64 _fseeki64
#define ftell64 _ftelli64
#else
#define fseek64 fseek
#define ftell64 ftell
#endif

#if _MSC_VER >= 1400 || defined __DMC__ || defined __WATCOMC__
#define vswprintf(s,f,a)   vswprintf ( s, 0x7FFFFFFF, f, a )
static inline int __cdecl swprintf_ ( wchar_t *buffer, const wchar_t *format,... ) {
   va_list args ;
   va_start ( args, format ) ;
   int result = vswprintf ( buffer, format, args ) ;
   va_end ( args ) ;
   return result ;
}
#define swprintf swprintf_
#endif

#ifdef __cplusplus
}
#endif


// stdio.h header's bug
#if _MSC_VER == 1400 && defined _CRT_DISABLE_PERFCRIT_LOCKS    // stdio.h
#undef _fseeki64
#define _fseeki64(_stm,_offset,_origin)   _fseeki64_nolock(_stm,_offset,_origin)
#endif


// <stdio.h>
#if defined __BORLANDC__
#define _fdopen(h,m)    _fdopen(h,(char*)m)
#define _wfdopen(h,m)   _wfdopen(h,(wchar_t*)m)
#endif


// oemio.cpp
#define wprintf oem_wprintf
#define fwprintf oem_fwprintf
#define vfwprintf oem_vfwprintf
#define fputws oem_fputws
#define fgetws oem_fgetws


// winmain.cpp
#ifdef __cplusplus
extern "C" {
#endif

#if _MSC_VER < 1300
#ifdef va_start      // stdarg.h
int __cdecl vscprintf ( const char *format, va_list args ) ;
int __cdecl vscwprintf ( const wchar_t *format, va_list args ) ;
#endif
int __cdecl scprintf ( const char *format,... ) ;
int __cdecl scwprintf ( const wchar_t *format,... ) ;
#else
#define vscprintf _vscprintf
#define vscwprintf _vscwprintf
#define scprintf _scprintf
#define scwprintf _scwprintf
#endif

#ifdef __cplusplus
}
#endif


#endif // defined FILENAME_MAX



////////////////////////////////////////////
//        IO.H / FCNTL.H / SHARE.H        //
////////////////////////////////////////////



#if defined FILENAME_MAX   // stdio.h


#include <io.h>
#include <fcntl.h>
#include <share.h>


// Xg[[ǂ
// [Ȃ 0 ȊOA[łȂ 0 Ԃ
// is associated with tele-typewriter
#define fisatty(stream)          _isatty ( _fileno ( stream ) )

// Xg[̕ϊ[hύX
// O̕ϊ[hԂ
#define fsetmode(stream,mode)    _setmode ( _fileno ( stream ), mode )

// Xg[t@Cnh擾
#define fget_osfhandle(stream)   (HANDLE) _get_osfhandle ( _fileno ( stream ) )

// t@CnhXg[쐬
#if defined CreateFile     // HANDLE
FILE *fopen_osfhandle ( HANDLE hFile, const char *mode ) ;
FILE *wfopen_osfhandle ( HANDLE hFile, const wchar_t *mode ) ;
#endif


// <io.h>
#if defined __BORLANDC__ || ( defined __WATCOMC__ && __WATCOMC__ < 1280 )
#define _isatty isatty
#define _setmode setmode
#ifndef _fileno
#define _fileno fileno
#endif
#endif


// <share.h>
#if defined __BORLANDC__ || defined __WATCOMC__
#ifndef _SH_DENYNO
#define _SH_DENYNO SH_DENYNO
#define _SH_DENYWR SH_DENYWR
#endif
#endif


#endif // defined FILENAME_MAX



////////////////////////////////////////////
//                 CONIO.H                //
////////////////////////////////////////////



#if defined __BORLANDC__ || defined __DMC__ || defined __MINGW32__
int __cdecl _outp ( unsigned short port, int databyte ) ;
int __cdecl _inp ( unsigned short port ) ;
#endif


#if ! defined __WATCOMC__
#define outp _outp
#define inp _inp
#endif



////////////////////////////////////////////
//                 CTYPE.H                //
////////////////////////////////////////////



#undef isascii
#define isascii(c)      ( (unsigned) (c) < 0x80 )


#undef isalpha
#undef isupper
#undef islower
#undef isdigit
#undef isxdigit
#undef isspace
#undef ispunct
#undef isalnum
#undef isprint
#undef isgraph
#undef iscntrl
static inline int CTYPE_FILTER ( int c ) { return ( isascii ( c ) ? c : -1 ) ; }
#ifdef _MSC_VER
#define isalpha(c)   ( _pctype [ CTYPE_FILTER ( c ) ] & ( _UPPER | _LOWER ) )
#define isupper(c)   ( _pctype [ CTYPE_FILTER ( c ) ] & ( _UPPER ) )
#define islower(c)   ( _pctype [ CTYPE_FILTER ( c ) ] & ( _LOWER ) )
#define isdigit(c)   ( _pctype [ CTYPE_FILTER ( c ) ] & ( _DIGIT ) )
#define isxdigit(c)  ( _pctype [ CTYPE_FILTER ( c ) ] & ( _HEX ) )
#define isspace(c)   ( _pctype [ CTYPE_FILTER ( c ) ] & ( _SPACE ) )
#define ispunct(c)   ( _pctype [ CTYPE_FILTER ( c ) ] & ( _PUNCT ) )
#define isalnum(c)   ( _pctype [ CTYPE_FILTER ( c ) ] & ( _UPPER | _LOWER | _DIGIT ) )
#define isprint(c)   ( _pctype [ CTYPE_FILTER ( c ) ] & ( _BLANK | _PUNCT | _UPPER | _LOWER | _DIGIT ) )
#define isgraph(c)   ( _pctype [ CTYPE_FILTER ( c ) ] & ( _PUNCT | _UPPER | _LOWER | _DIGIT ) )
#define iscntrl(c)   ( _pctype [ CTYPE_FILTER ( c ) ] & ( _CONTROL ) )
#else
#define isalpha(c)      isalpha  ( CTYPE_FILTER ( c ) )
#define isupper(c)      isupper  ( CTYPE_FILTER ( c ) )
#define islower(c)      islower  ( CTYPE_FILTER ( c ) )
#define isdigit(c)      isdigit  ( CTYPE_FILTER ( c ) )
#define isxdigit(c)     isxdigit ( CTYPE_FILTER ( c ) )
#define isspace(c)      isspace  ( CTYPE_FILTER ( c ) )
#define ispunct(c)      ispunct  ( CTYPE_FILTER ( c ) )
#define isalnum(c)      isalnum  ( CTYPE_FILTER ( c ) )
#define isprint(c)      isprint  ( CTYPE_FILTER ( c ) )
#define isgraph(c)      isgraph  ( CTYPE_FILTER ( c ) )
#define iscntrl(c)      iscntrl  ( CTYPE_FILTER ( c ) )
#endif // else of _MSC_VER


#undef iscsym
#undef iscsymf
static inline int CTYPE_CSYM_FILTER ( int c ) { return ( c == '_' ) ? 'a' : c ; }
#define iscsym(c)    isalnum ( CTYPE_CSYM_FILTER ( c ) )    // a valid character in a C identifier
#define iscsymf(c)   isalpha ( CTYPE_CSYM_FILTER ( c ) )    // a valid first character in a C identifier


// ԂɊ܂܂邩
static inline int IS_BETWEEN ( int c, int min, int max ) { return ( (unsigned) ( c - min ) <= (unsigned) ( max - min ) ) ; }


#define toupper toupper_inline
#define tolower tolower_inline
static inline int toupper ( int c ) { return IS_BETWEEN ( c, 'a', 'z' ) ? ( c - 'a' + 'A' ) : c ; }
static inline int tolower ( int c ) { return IS_BETWEEN ( c, 'A', 'Z' ) ? ( c - 'A' + 'a' ) : c ; }

#define isblank isblank_inline
static inline int isblank ( int c ) { return c == ' ' || c == '\t' ; }



////////////////////////////////////////////
//                MBCTYPE.H               //
////////////////////////////////////////////



// Non-ANSI Names
#if defined NOCRT && defined CreateFile
#define ismbblead IsDBCSLeadByte
#else
#define ismbblead _ismbblead
#endif
#define ismbbtrail _ismbbtrail
#define ismbbkana _ismbbkana
#define getmbcp _getmbcp



////////////////////////////////////////////
//                STRING.H                //
////////////////////////////////////////////



// ̖ikjԂ
#if defined _MSC_VER && ! defined DEBUG_CONST_STRING
static inline char *strend ( const char *s ) {
   while ( *s ) s ++ ;
   return (char*) s ;
}
static inline wchar_t *wcsend ( const wchar_t *s ) {
   while ( *s ) s ++ ;
   return (wchar_t*) s ;
}
#else
#define strend(s)    strchr ( s, 0 )
#define wcsend(s)    wcschr ( s, 0 )
#endif


#define memzero(p,n)    memset ( p, 0, n )


#if defined DEBUG_CONST_STRING && defined __cplusplus && defined _INC_STRING     // for debug

#define FUNC_STR_STR(func,type)  \
   static const type *func##_ ( const type *s1, const type *s2 ) { return func ( s1, s2 ) ; } \
   static       type *func##_ (       type *s1, const type *s2 ) { return func ( s1, s2 ) ; }

#define FUNC_STR_INT(func,type)  \
   static const type *func##_ ( const type *s, int c ) { return func ( s, c ) ; } \
   static       type *func##_ (       type *s, int c ) { return func ( s, c ) ; }

#define FUNC_STR_INT_SIZET(func,type)  \
   static const type *func##_ ( const type *s, int c, size_t i ) { return func ( s, c, i ) ; } \
   static       type *func##_ (       type *s, int c, size_t i ) { return func ( s, c, i ) ; }

FUNC_STR_STR ( strstr, char )
FUNC_STR_STR ( wcsstr, wchar_t )
FUNC_STR_STR ( strpbrk, char )
FUNC_STR_STR ( wcspbrk, wchar_t )
FUNC_STR_INT ( strchr, char )
FUNC_STR_INT ( wcschr, wchar_t )
FUNC_STR_INT ( strrchr, char )
FUNC_STR_INT ( wcsrchr, wchar_t )
FUNC_STR_INT_SIZET ( memchr, void )

#undef FUNC_STR_STR
#undef FUNC_STR_INT
#undef FUNC_STR_INT_SIZET

#define strstr    strstr_
#define wcsstr    wcsstr_
#define strpbrk   strpbrk_
#define wcspbrk   wcspbrk_
#define strchr    strchr_
#define wcschr    wcschr_
#define strrchr   strrchr_
#define wcsrchr   wcsrchr_
#define memchr    memchr_

#endif // defined DEBUG_CONST_STRING && defined __cplusplus && defined _INC_STRING



////////////////////////////////////////////
//                STDLIB.H                //
////////////////////////////////////////////



#if defined EXIT_SUCCESS   // stdlib.h


#define ERRORLEVEL_MAX  255


// a, b ͕т̂ŕpɒ
#ifndef max
#define max(a,b)  ( ((a) > (b)) ? (a) : (b) )
#endif
#ifndef min
#define min(a,b)  ( ((a) < (b)) ? (a) : (b) )
#endif


#ifdef __cplusplus
extern "C" {
#endif

// winmain.cpp
#define rand rand_winmain_
#define srand srand_winmain_
int rand ( void ) ;
void srand ( unsigned int seed ) ;
int rand_r ( unsigned int *seed ) ;

#undef RAND_MAX
#define RAND_MAX  INT_MAX

#ifdef __cplusplus
}
#endif


// execute.cpp
#define system(s)    ExecuteViaComspecA ( s, NULL )
#define wsystem(s)   ExecuteViaComspecW ( s, NULL )

// environ.cpp
#define getenv GetEnvA
#define wgetenv GetEnvW
#define putenv PutEnvA
#define wputenv PutEnvW
#define setenv SetEnvA
#define wsetenv SetEnvW


#endif // defined EXIT_SUCCESS


// syntactic sugar for memory allocation
#define malloc_array(type,size)        (type*) malloc ( (size) * sizeof(type) )
#define realloc_array(p,type,size)     (type*) realloc ( (p), (size) * sizeof(type) )
#define calloc_array(type,count)       (type*) calloc ( (count), sizeof(type) )


#if defined DEBUG_CONST_STRING && defined __cplusplus && defined _INC_STDLIB     // for debug

#define FUNC_STR_STR_BASE(func,type,data) \
   static data func##_ ( const type *s1, const type **s2, int base ) { return func ( s1, (type**) s2, base ) ; } \
   static data func##_ (       type *s1,       type **s2, int base ) { return func ( s1,          s2, base ) ; }

#define FUNC_STR_STR(func,type,data)   \
   static data func##_ ( const type *s1, const type **s2 ) { return func ( s1, (type**) s2 ) ; } \
   static data func##_ (       type *s1,       type **s2 ) { return func ( s1,          s2 ) ; }

FUNC_STR_STR_BASE ( strtol, char, long )
FUNC_STR_STR_BASE ( strtoul, char, unsigned long )
FUNC_STR_STR ( strtod, char, double )
FUNC_STR_STR_BASE ( wcstol, wchar_t, long )
FUNC_STR_STR_BASE ( wcstoul, wchar_t, unsigned long )
FUNC_STR_STR ( wcstod, wchar_t, double )

#undef FUNC_STR_STR_BASE
#undef FUNC_STR_STR

#define strtol          strtol_
#define strtoul         strtoul_
#define strtod          strtod_
#define wcstol          wcstol_
#define wcstoul         wcstoul_
#define wcstod          wcstod_

#else

#define strtol(s,p,b)   strtol ( s, (char**) (p), b )
#define strtoul(s,p,b)  strtoul ( s, (char**) (p), b )
#define strtod(s,p)     strtod ( s, (char**) (p) )
#define wcstol(s,p,b)   wcstol ( s, (wchar_t**) (p), b )
#define wcstoul(s,p,b)  wcstoul ( s, (wchar_t**) (p), b )
#define wcstod(s,p)     wcstod ( s, (wchar_t**) (p) )

#endif // else of defined DEBUG_CONST_STRING && defined __cplusplus && defined _INC_STDLIB



////////////////////////////////////////////
//                 TIME.H                 //
////////////////////////////////////////////



// clock.cpp

#define clock clock_nt



////////////////////////////////////////////
//                 ERRNO.H                //
////////////////////////////////////////////



#ifdef ERANGE  // errno.h

#ifndef EILSEQ
#define EILSEQ    200
#endif

#endif



////////////////////////////////////////////
//                 UTILITY                //
////////////////////////////////////////////



// ž𐔂
#define NELEMOF(x)      ( sizeof(x) / sizeof(x[0]) )


// LARGE_INTEGER
#define MAKE_LARGE_INT(High,Low)       { (Low), (High) }


#if defined IMAGE_FILE_MACHINE_I386    // winnt.h
static inline int64_t MAKE_INT64 ( long high, unsigned long low ) {
   const LARGE_INTEGER X = MAKE_LARGE_INT ( high, low ) ;
   return X.QuadPart ;
}
#endif


// Storage Size
#define KILOBYTE     ( 1024 )                         // 0x400          // 1,024
#define MEGABYTE     ( KILOBYTE * 1024 )              // 0x100000       // 1,048,576
#define GIGABYTE     ( MEGABYTE * 1024 )              // 0x40000000     // 1,073,741,824
#define TERABYTE     ( (int64_t) GIGABYTE * 1024 )    // 0x10000000000  // 1,099,511,627,776


#if _MSC_VER < 1300
// Error C2520 conversion from unsigned __int64 to double not implemented (VC6)
#define ratio(whole,fraction,base)  ( ( (double)(int64_t) (fraction) / (double)(int64_t) (whole) ) * (double)(int64_t) (base) )
#else
#define ratio(whole,fraction,base)  ( ( (double) (fraction) / (double) (whole) ) * (double) (base) )
#endif

#define PERCENT_MAX  100
#define PERMIL_MAX   1000


// winmain.cpp
#ifdef __cplusplus
extern "C" {
#endif

int lzcnt ( unsigned long x ) ;
int tzcnt ( unsigned long x ) ;
int popcnt ( unsigned long x ) ;
unsigned long bitrev ( unsigned long x ) ;

#ifdef __cplusplus
}
#endif



////////////////////////////////////////////
//                 UNICODE                //
////////////////////////////////////////////



typedef wchar_t         wchar16_t ;
typedef unsigned long   wchar32_t ;


#define UTF16_MAX         0x10FFFF
#define UTF32_MAX       0x7FFFFFFF

#define UTF8_CHAR_LEN_MAX        6
#define UTF16_CHAR_LEN_MAX       2
#define UTF32_CHAR_LEN_MAX       1


#define IsUnicodeHighSurrogate(c)   ( ( (c) & 0xFFFFFC00 ) == 0xD800 )
#define IsUnicodeLowSurrogate(c)    ( ( (c) & 0xFFFFFC00 ) == 0xDC00 )
#define IsUnicodeSurrogate(c)       ( ( (c) & 0xFFFFF800 ) == 0xD800 )

// XJ[lTQ[gl쐬
#define MAKE_UNICODE_HIGH_SURROGATE(c)    ( (unsigned) ( (c) - 0x10000 ) / 0x400 + 0xD800 )
#define MAKE_UNICODE_LOW_SURROGATE(c)     ( (unsigned) ( (c) - 0x10000 ) % 0x400 + 0xDC00 )

// TQ[glXJ[l쐬
#define MAKE_UNICODE_SCALAR(high,low)     ( ( (high) - 0xD800 ) * 0x400 + ( (low) - 0xDC00 ) + 0x10000 )


// pr
#define BYTE_ORDER_MARK          0xFEFF
#define BYTE_ORDER_MARK_BE       0xFFFE
#define REPLACEMENT_CHARACTER    0xFFFD

// 䕶
#define CTRLZ     0x1A


#define IS_SINGLE_BYTE(c)     ( (unsigned) (c) < 0x100 )
#define IS_SINGLE_WORD(c)     ( (unsigned) (c) < 0x10000 )


#define BYTE_BIT     CHAR_BIT
#define WORD_BIT     SHORT_BIT



////////////////////////////////////////////
//             STRING UTILITY             //
////////////////////////////////////////////



#if defined _MBC_LEAD

// ̕܂ł̒ԂiMULTIBYTEŁj
static inline int mbsnext ( const char *p ) {
   if ( ismbblead ( (unsigned char) *p ) && *( p + 1 ) ) return 2 ;
   return 1 ;
}

// ̕܂ł̒ԂiUNICODEŁj
static inline int wcsnext ( const wchar_t *p ) {
   return 1 ;
}

// PRs[A̕܂ł̒ԂiMULTIBYTEŁj
static inline int mbsnext_copy ( char *q, const char *p ) {
   *q = *p ;
   if ( ismbblead ( (unsigned char) *p ) && *( p + 1 ) ) {
      *( q + 1 ) = *( p + 1 ) ;
      return 2 ;
   }
   return 1 ;
}

// PRs[A̕܂ł̒ԂiUNICODEŁj
static inline int wcsnext_copy ( wchar_t *q, const wchar_t *p ) {
   *q = *p ;
   return 1 ;
}

#endif


#if defined __BORLANDC__
#define strdup strdup_winmain_
#endif

// winmain.cpp
#ifdef __cplusplus
extern "C" {
#endif

size_t strlcatlen ( char *dst, size_t dstlen, const char *src, size_t srclen, size_t bufsiz ) ;
size_t wcslcatlen ( wchar_t *dst, size_t dstlen, const wchar_t *src, size_t srclen, size_t bufsiz ) ;
size_t strlcat ( char *dst, const char *src, size_t bufsiz ) ;
size_t wcslcat ( wchar_t *dst, const wchar_t *src, size_t bufsiz ) ;

size_t strlcpylen ( char *dst, const char *src, size_t srclen, size_t bufsiz ) ;
size_t wcslcpylen ( wchar_t *dst, const wchar_t *src, size_t srclen, size_t bufsiz ) ;
size_t strlcpy ( char *dst, const char *src, size_t bufsiz ) ;
size_t wcslcpy ( wchar_t *dst, const wchar_t *src, size_t bufsiz ) ;

size_t a2wlcpylen_cp ( wchar_t *dst, const char *src, size_t srclen, size_t bufsiz, int codepage ) ;
size_t w2alcpylen_cp ( char *dst, const wchar_t *src, size_t srclen, size_t bufsiz, int codepage ) ;
size_t a2wlcpy ( wchar_t *dst, const char *src, size_t bufsiz ) ;
size_t w2alcpy ( char *dst, const wchar_t *src, size_t bufsiz ) ;
size_t a2wlcpylen ( wchar_t *dst, const char *src, size_t srclen, size_t bufsiz ) ;
size_t w2alcpylen ( char *dst, const wchar_t *src, size_t srclen, size_t bufsiz ) ;
size_t a2wlcpy_cp ( wchar_t *dst, const char *src, size_t bufsiz, int codepage ) ;
size_t w2alcpy_cp ( char *dst, const wchar_t *src, size_t bufsiz, int codepage ) ;

char *strduplen_expand ( const char *string, size_t srclen, size_t maxlen, size_t addlen ) ;
wchar_t *wcsduplen_expand ( const wchar_t *string, size_t srclen, size_t maxlen, size_t addlen ) ;
char *strdup ( const char *string ) ;
wchar_t *wcsdup ( const wchar_t *string ) ;
char *strduplen ( const char *string, size_t srclen ) ;
wchar_t *wcsduplen ( const wchar_t *string, size_t srclen ) ;
char *strdup_expand ( const char *string, size_t maxlen, size_t addlen ) ;
wchar_t *wcsdup_expand ( const wchar_t *string, size_t maxlen, size_t addlen ) ;

wchar_t *a2wduplen_expand_cp ( const char *string, size_t srclen, size_t maxlen, size_t addlen, int codepage ) ;
char *w2aduplen_expand_cp ( const wchar_t *string, size_t srclen, size_t maxlen, size_t addlen, int codepage ) ;
wchar_t *a2wdup ( const char *string ) ;
char *w2adup ( const wchar_t *string ) ;
wchar_t *a2wduplen ( const char *string, size_t srclen ) ;
char *w2aduplen ( const wchar_t *string, size_t srclen ) ;
wchar_t *a2wdup_expand ( const char *string, size_t maxlen, size_t addlen ) ;
char *w2adup_expand ( const wchar_t *string, size_t maxlen, size_t addlen ) ;
wchar_t *a2wdup_cp ( const char *string, int codepage ) ;
char *w2adup_cp ( const wchar_t *string, int codepage ) ;

#ifdef __cplusplus
}
#endif



////////////////////////////////////////////
//             PATH / FILENAME            //
////////////////////////////////////////////



// pX؂蕶H
static inline int IsPathSeparator ( int c ) { return c == '\\' || c == '/' ; }


// MAX_PATH 𒴂pX
// max len of "\\?\C:\<path>", "\\?\UNC\<server>\<share>"
#ifdef MAX_PATH
#define MAX_PATH_LONG   0x8000
#endif

// URL ̍ő咷
#ifdef MAX_PATH
#define MAX_URL   2084     // INTERNET_MAX_URL_LENGTH (wininet.h)
#endif



////////////////////////////////////////////
//             WINDOWS VERSION            //
////////////////////////////////////////////



typedef struct {
   union {
      struct {
         unsigned long Build ;      // dwBuildNumber
         unsigned long Version ;    // ( dwMajorVersion << 8 ) + dwMinorVersion
      } ;
      uint64_t VersionBuild ;
   } ;
   unsigned long Platform ;   // dwPlatformId
} OS_VERSION_ ;

extern OS_VERSION_ OsVersion_ ;


#ifdef _WIN64
#define IS_WIN64  1
#else
#define IS_WIN64  0
#endif

#if _MSC_VER >= 1700
#define REQUIRED_MINIMUM_WINVER  0x600
#elif defined _WIN64
#define REQUIRED_MINIMUM_WINVER  0x502
#elif _MSC_VER >= 1600
#define REQUIRED_MINIMUM_WINVER  0x501
#elif _MSC_VER >= 1500
#define REQUIRED_MINIMUM_WINVER  0x500
#else
#define REQUIRED_MINIMUM_WINVER  0x400
#endif

#if REQUIRED_MINIMUM_WINVER >= 0x500
#define IS_NT_ONLY   1
#else
#define IS_NT_ONLY   0
#endif

#if IS_NT_ONLY
#define IsNT()    1
#else
#define IsNT()    ( OsVersion_.Platform >= 2 )
#endif


#define TEST_WINVER_(v)          ( REQUIRED_MINIMUM_WINVER <= (v)  && OsVersion_.Version == (v) )
#define TEST_WINVER2_(v1,v2)     ( REQUIRED_MINIMUM_WINVER <= (v1) && OsVersion_.Version >= (v1) && OsVersion_.Version <= (v2) )
#define TEST_WINVER_LATER_(v)    ( REQUIRED_MINIMUM_WINVER >= (v)  || OsVersion_.Version >= (v) )

#define IsWin95()                ( ! IsNT() && TEST_WINVER_ ( 0x400 ) )
#define IsWin98()                ( ! IsNT() && TEST_WINVER_ ( 0x40A ) )
#define IsWinME()                ( ! IsNT() && TEST_WINVER_ ( 0x45A ) )

#define IsWin95orLater()         ( ! IsNT() && TEST_WINVER_LATER_ ( 0x400 ) )
#define IsWin98orLater()         ( ! IsNT() && TEST_WINVER_LATER_ ( 0x40A ) )
#define IsWinMEorLater()         ( ! IsNT() && TEST_WINVER_LATER_ ( 0x45A ) )

#define IsWin95orNT4()           ( TEST_WINVER_ ( 0x400 ) )

#define IsWinNT4()               ( IsNT() && TEST_WINVER_  ( 0x400 ) )
#define IsWin2000()              ( IsNT() && TEST_WINVER_  ( 0x500 ) )
#define IsWinXP()                ( IsNT() && TEST_WINVER2_ ( 0x501, 0x502 ) )
#define IsWinVISTA()             ( IsNT() && TEST_WINVER_  ( 0x600 ) )
#define IsWin7()                 ( IsNT() && TEST_WINVER_  ( 0x601 ) )
#define IsWin8()                 ( IsNT() && TEST_WINVER2_ ( 0x602, 0x603 ) )

#define IsWinNT31orLater()       ( IsNT() && TEST_WINVER_LATER_ ( 0x30A ) )
#define IsWinNT35orLater()       ( IsNT() && TEST_WINVER_LATER_ ( 0x332 ) )
#define IsWinNT351orLater()      ( IsNT() && TEST_WINVER_LATER_ ( 0x333 ) )
#define IsWinNT4orLater()        ( IsNT() && TEST_WINVER_LATER_ ( 0x400 ) )
#define IsWin2000orLater()       ( IsNT() && TEST_WINVER_LATER_ ( 0x500 ) )
#define IsWinXPorLater()         ( IsNT() && TEST_WINVER_LATER_ ( 0x501 ) )
#define IsWinVISTAorLater()      ( IsNT() && TEST_WINVER_LATER_ ( 0x600 ) )
#define IsWin7orLater()          ( IsNT() && TEST_WINVER_LATER_ ( 0x601 ) )
#define IsWin8orLater()          ( IsNT() && TEST_WINVER_LATER_ ( 0x602 ) )


#define TEST_WINVER_BUILD_(v,b1,b2)       ( REQUIRED_MINIMUM_WINVER <= (v) && OsVersion_.VersionBuild >= ( ( (uint64_t)(v) << LONG_BIT ) + (b1) ) && OsVersion_.VersionBuild <= ( ( (uint64_t)(v) << LONG_BIT ) + (b2) ) )
#define TEST_WINVER_BUILD_LATER_(v,b)     ( REQUIRED_MINIMUM_WINVER <= (v) && OsVersion_.VersionBuild >= ( ( (uint64_t)(v) << LONG_BIT ) + (b)  ) )

#define IsWin10()                ( IsNT() && TEST_WINVER_BUILD_       ( 0xA00,     0, 22000 - 1 ) )
#define IsWin11()                ( IsNT() && TEST_WINVER_BUILD_LATER_ ( 0xA00, 22000 ) )

#define IsWin10orLater()         ( IsNT() && TEST_WINVER_LATER_       ( 0xA00 ) )
#define IsWin11orLater()         ( IsNT() && TEST_WINVER_BUILD_LATER_ ( 0xA00, 22000 ) )


// winmain.cpp
#ifdef __cplusplus
extern "C" {
#endif

#if defined _WIN64
#define IsWin64()    1
#else
int IsWin64 ( void ) ;
#endif

#ifdef __cplusplus
}
#endif



////////////////////////////////////////////
//               WINDOWS API              //
////////////////////////////////////////////



#if defined CreateFile     // windows.h


#if defined _MSC_VER || defined __BORLANDC__
#include <ntverp.h>
#endif

#include <commctrl.h>

#if VER_PRODUCTBUILD < 2257
#include <shlobj.h>
#else
#include <shtypes.h>
#endif

// \̂̓r̃o[܂ł̃TCY  (commctrl.h)
#ifndef CCSIZEOF_STRUCT
#define CCSIZEOF_STRUCT(structname,member)   ( offsetof ( structname, member ) + sizeof ( ( (structname*) 0 )->member ) )
#endif

// BaseTsd.h
#if VER_PRODUCTBUILD < 2257
#define LONG_PTR  LONG
#define ULONG_PTR ULONG
#define INT_PTR   INT
#define UINT_PTR  UINT
#define DWORD_PTR ULONG
#endif


#endif // defined CreateFile



////////////////////////////////////////////
//                WINBASE.H               //
////////////////////////////////////////////



#if defined CreateFile     // winbase.h


#ifndef INVALID_SET_FILE_POINTER
#define INVALID_SET_FILE_POINTER    ((DWORD)-1)
#endif
#ifndef INVALID_FILE_ATTRIBUTES
#define INVALID_FILE_ATTRIBUTES     ((DWORD)-1)
#endif

#if VER_PRODUCTBUILD < 2257
#undef FILE_ATTRIBUTE_ENCRYPTED     // bug
#endif

#ifndef FILE_ATTRIBUTE_DEVICE
#define FILE_ATTRIBUTE_DEVICE                0x00000040
#endif
#ifndef FILE_ATTRIBUTE_SPARSE_FILE
#define FILE_ATTRIBUTE_SPARSE_FILE           0x00000200
#endif
#ifndef FILE_ATTRIBUTE_REPARSE_POINT
#define FILE_ATTRIBUTE_REPARSE_POINT         0x00000400
#endif
#ifndef FILE_ATTRIBUTE_NOT_CONTENT_INDEXED
#define FILE_ATTRIBUTE_NOT_CONTENT_INDEXED   0x00002000
#endif
#ifndef FILE_ATTRIBUTE_ENCRYPTED
#define FILE_ATTRIBUTE_ENCRYPTED             0x00004000
#endif


// SetFileAttributes Őݒ\ȑ
#define FILE_ATTRIBUTES_RESETTABLE           \
      ( ~ ( FILE_ATTRIBUTE_COMPRESSED        \
          | FILE_ATTRIBUTE_DEVICE            \
          | FILE_ATTRIBUTE_DIRECTORY         \
          | FILE_ATTRIBUTE_ENCRYPTED         \
          | FILE_ATTRIBUTE_REPARSE_POINT     \
          | FILE_ATTRIBUTE_SPARSE_FILE       \
      ) )

#define FILE_ATTRIBUTES_TRADITIONAL       \
      (   FILE_ATTRIBUTE_READONLY         \
        | FILE_ATTRIBUTE_HIDDEN           \
        | FILE_ATTRIBUTE_SYSTEM           \
        | FILE_ATTRIBUTE_ARCHIVE          \
        | FILE_ATTRIBUTE_TEMPORARY        \
      )


#ifndef BELOW_NORMAL_PRIORITY_CLASS
#define BELOW_NORMAL_PRIORITY_CLASS    0x00004000
#endif
#ifndef ABOVE_NORMAL_PRIORITY_CLASS
#define ABOVE_NORMAL_PRIORITY_CLASS    0x00008000
#endif

#define FILETIME_PER_SEC         10000000
#define MILLISEC_PER_SEC             1000


//  0 As 0 ȊOԂ
#define GETPROCADDRESS(dll,type,function)          ( ! dll || ! function && ( function = (type) GetProcAddress ( dll, #function ) ) == NULL )

// GetBinaryType
#ifndef SCS_64BIT_BINARY
#define SCS_64BIT_BINARY   6
#endif


#if VER_PRODUCTBUILD < 2257 && ! defined ENUMRESLANGPROC
#define EnumResourceLanguagesW(h,t,n,f,p)    EnumResourceLanguagesW ( h, t, n, (ENUMRESLANGPROC) (f), p )
#endif


#if VER_PRODUCTBUILD < 2257
#define InterlockedExchange(t,v)                   InterlockedExchange ( (LONG*) (t), v )
#define InterlockedIncrement(t)                    InterlockedIncrement ( (LONG*) (t) )
#define InterlockedDecrement(t)                    InterlockedDecrement ( (LONG*) (t) )
#endif

#if ! defined _WIN64
#undef InterlockedExchangePointer
#undef InterlockedCompareExchangePointer
#define InterlockedExchangePointer(t,v)            (PVOID)(LONG_PTR) InterlockedExchange ( (LONG*) (t), (LONG)(LONG_PTR) (v) )
#define InterlockedCompareExchangePointer(d,e,c)   (PVOID)(LONG_PTR) InterlockedCompareExchange ( (LONG*) (d), (LONG)(LONG_PTR) (e), (LONG)(LONG_PTR) (c) )
#endif


// winmain.cpp
#ifdef __cplusplus
extern "C" {
#endif

int64_t GetFileSize64 ( HANDLE hFile ) ;
int64_t SetFilePointer64 ( HANDLE hFile, int64_t nDistanceToMove, unsigned long dwMoveMethod ) ;
int CompareFileTimeEx ( const FILETIME *pFileTime1, const FILETIME *pFileTime2, int IsCompareAsDosTime ) ;
int64_t GetDiskSize64A ( const char *szDirectoryName, int nMode ) ;
int64_t GetDiskSize64W ( const wchar_t *szDirectoryName, int nMode ) ;

#ifdef UNICODE
#define GetDiskSize64 GetDiskSize64W
#else
#define GetDiskSize64 GetDiskSize64A
#endif

// GetDiskSize64
#define GETDISKSIZE_TOTAL_SIZE         0
#define GETDISKSIZE_FREE_SPACE         1
#define GETDISKSIZE_AVAILABLE_SPACE    2


#if ! defined _MSC_VER
#define InterlockedExchangeAdd(a,i)    InterlockedExchangeAdd ( (LONG*) (a), i )
#elif ! IS_NT_ONLY
long WINAPI InterlockedExchangeAdd_95 ( volatile long *Addend, long Increment ) ;
#define InterlockedExchangeAdd InterlockedExchangeAdd_95
#endif

#if defined __DMC__
#define InterlockedCompareExchange(d,e,c)    (LONG) InterlockedCompareExchange ( (VOID**) (d), (VOID*) (e), (VOID*) (c) )
#elif ! defined _MSC_VER
#define InterlockedCompareExchange(d,e,c)    InterlockedCompareExchange ( (LONG*) (d), e, c )
#elif ! IS_NT_ONLY
long WINAPI InterlockedCompareExchange_95 ( volatile long *Destination, long Exchange, long Comperand ) ;
#define InterlockedCompareExchange InterlockedCompareExchange_95
#endif


#define InitializeCriticalSectionEx InitializeCriticalSectionEx_winmain_
int InitializeCriticalSectionEx ( PCRITICAL_SECTION pCriticalSection ) ;

#if ! defined NOCRT && defined _MT
extern CRITICAL_SECTION LoadDllSection ;
#endif

int CompareStringOrdinalA ( const char *szString1, int nLength1, const char *szString2, int nLength2, int IsIgnoreCase ) ;
int CompareStringOrdinalW ( const wchar_t *szString1, int nLength1, const wchar_t *szString2, int nLength2, int IsIgnoreCase ) ;

#ifdef UNICODE
#define CompareStringOrdinal CompareStringOrdinalW
#else
#define CompareStringOrdinal CompareStringOrdinalA
#endif

#ifdef __cplusplus
}
#endif


#endif // defined CreateFile



////////////////////////////////////////////
//               WINUSER.H                //
////////////////////////////////////////////



#if defined InsertMenuItem    // winuser.h


#if WINVER < 0x500 || REQUIRED_MINIMUM_WINVER < 0x500
#define MENUITEMINFO_STRUCT_SIZEA   CCSIZEOF_STRUCT ( MENUITEMINFOA, cch )
#define MENUITEMINFO_STRUCT_SIZEW   CCSIZEOF_STRUCT ( MENUITEMINFOW, cch )
#else
#define MENUITEMINFO_STRUCT_SIZEA   CCSIZEOF_STRUCT ( MENUITEMINFOA, hbmpItem )
#define MENUITEMINFO_STRUCT_SIZEW   CCSIZEOF_STRUCT ( MENUITEMINFOW, hbmpItem )
#endif
#ifdef UNICODE
#define MENUITEMINFO_STRUCT_SIZE MENUITEMINFO_STRUCT_SIZEW
#else
#define MENUITEMINFO_STRUCT_SIZE MENUITEMINFO_STRUCT_SIZEA
#endif

// WINVER >= 0x500
#ifndef MIIM_STRING
#define MIIM_STRING      0x00000040
#endif
#ifndef MIIM_BITMAP
#define MIIM_BITMAP      0x00000080
#endif
#ifndef MIIM_FTYPE
#define MIIM_FTYPE       0x00000100
#endif


#if WINVER < 0x600 || REQUIRED_MINIMUM_WINVER < 0x600
#define NONCLIENTMETRICS_STRUCT_SIZEA  CCSIZEOF_STRUCT ( NONCLIENTMETRICSA, lfMessageFont )
#define NONCLIENTMETRICS_STRUCT_SIZEW  CCSIZEOF_STRUCT ( NONCLIENTMETRICSW, lfMessageFont )
#else
#define NONCLIENTMETRICS_STRUCT_SIZEA  CCSIZEOF_STRUCT ( NONCLIENTMETRICSA, iPaddedBorderWidth )
#define NONCLIENTMETRICS_STRUCT_SIZEW  CCSIZEOF_STRUCT ( NONCLIENTMETRICSW, iPaddedBorderWidth )
#endif
#ifdef UNICODE
#define NONCLIENTMETRICS_STRUCT_SIZE NONCLIENTMETRICS_STRUCT_SIZEW
#else
#define NONCLIENTMETRICS_STRUCT_SIZE NONCLIENTMETRICS_STRUCT_SIZEA
#endif


// WM_CREATE
#define GetCreateParams(p)    ( ( (CREATESTRUCT*) (p) )->lpCreateParams )


#if ! defined _WIN64
#undef GetWindowLongPtrA
#undef GetWindowLongPtrW
#undef SetWindowLongPtrA
#undef SetWindowLongPtrW
#define GetWindowLongPtrA(h,i)      (LONG_PTR) GetWindowLongA ( h, i )
#define GetWindowLongPtrW(h,i)      (LONG_PTR) GetWindowLongW ( h, i )
#define SetWindowLongPtrA(h,i,v)    (LONG_PTR) SetWindowLongA ( h, i, (LONG)(LONG_PTR) (v) )
#define SetWindowLongPtrW(h,i,v)    (LONG_PTR) SetWindowLongW ( h, i, (LONG)(LONG_PTR) (v) )
#endif

#if VER_PRODUCTBUILD < 2257 && ( defined _MSC_VER || defined __DMC__ )
#ifdef UNICODE
#define GetWindowLongPtr   GetWindowLongPtrW
#define SetWindowLongPtr   SetWindowLongPtrW
#else
#define GetWindowLongPtr   GetWindowLongPtrA
#define SetWindowLongPtr   SetWindowLongPtrA
#endif
#define GWLP_HWNDPARENT    GWL_HWNDPARENT
#define GWLP_WNDPROC       GWL_WNDPROC
#define GWLP_USERDATA      GWL_USERDATA
#define DWLP_MSGRESULT     DWL_MSGRESULT
#define DWLP_DLGPROC       DWL_DLGPROC
#define DWLP_USER          DWL_USER
#endif


#undef MAKEINTRESOURCEW
#undef MAKEINTRESOURCEA
#define MAKEINTRESOURCEW(x)   (wchar_t*) ( (WORD)(LONG_PTR) (x) )
#define MAKEINTRESOURCEA(x)   (char*)    ( (WORD)(LONG_PTR) (x) )


#endif // defined InsertMenuItem



////////////////////////////////////////////
//                 WINNT.H                //
////////////////////////////////////////////



#if defined IMAGE_FILE_MACHINE_I386    // winnt.h


// VC7 or later
#ifndef IMAGE_FILE_MACHINE_AMD64
#define IMAGE_FILE_MACHINE_AMD64    0x8664   // AMD64 (K8)
#endif


#endif // defined IMAGE_FILE_MACHINE_I386



////////////////////////////////////////////
//               COMMCTRL.H               //
////////////////////////////////////////////



#if defined ODT_HEADER     // commctrl.h


// _WIN32_IE >= 0x0400
#ifndef INFOTIPSIZE
#define INFOTIPSIZE  1024
#endif


#endif // defined ODT_HEADER



////////////////////////////////////////////
//               COMMDLG.H                //
////////////////////////////////////////////



#if defined GetOpenFileName   // commdlg.h


#if _WIN32_WINNT < 0x500 || REQUIRED_MINIMUM_WINVER < 0x500
#define OPENFILENAME_STRUCT_SIZEA   CCSIZEOF_STRUCT ( OPENFILENAMEA, lpTemplateName )
#define OPENFILENAME_STRUCT_SIZEW   CCSIZEOF_STRUCT ( OPENFILENAMEW, lpTemplateName )
#else
#define OPENFILENAME_STRUCT_SIZEA   CCSIZEOF_STRUCT ( OPENFILENAMEA, FlagsEx )
#define OPENFILENAME_STRUCT_SIZEW   CCSIZEOF_STRUCT ( OPENFILENAMEW, FlagsEx )
#endif
#ifdef UNICODE
#define OPENFILENAME_STRUCT_SIZE OPENFILENAME_STRUCT_SIZEW
#else
#define OPENFILENAME_STRUCT_SIZE OPENFILENAME_STRUCT_SIZEA
#endif

// _WIN32_WINNT >= 0x0500
#ifndef OFN_DONTADDTORECENT
#define OFN_DONTADDTORECENT   0x02000000
#endif
#ifndef OFN_FORCESHOWHIDDEN
#define OFN_FORCESHOWHIDDEN   0x10000000
#endif


#endif



////////////////////////////////////////////
//               SHELLAPI.H               //
////////////////////////////////////////////



#if defined NIM_ADD     // shellapi.h


#if _WIN32_WINNT < 0x500 || REQUIRED_MINIMUM_WINVER < 0x500
#define NOTIFYICONDATA_TIP_SIZE  64
#define NOTIFYICONDATA_STRUCT_SIZEA    ( offsetof ( NOTIFYICONDATAA, szTip ) + NOTIFYICONDATA_TIP_SIZE * sizeof(char) )
#define NOTIFYICONDATA_STRUCT_SIZEW    ( offsetof ( NOTIFYICONDATAW, szTip ) + NOTIFYICONDATA_TIP_SIZE * sizeof(wchar_t) )
#else
#define NOTIFYICONDATA_TIP_SIZE  128
#if _WIN32_WINNT < 0x600 || REQUIRED_MINIMUM_WINVER < 0x600
#define NOTIFYICONDATA_STRUCT_SIZEA    CCSIZEOF_STRUCT ( NOTIFYICONDATAA, dwInfoFlags )
#define NOTIFYICONDATA_STRUCT_SIZEW    CCSIZEOF_STRUCT ( NOTIFYICONDATAW, dwInfoFlags )
#else
#define NOTIFYICONDATA_STRUCT_SIZEA    CCSIZEOF_STRUCT ( NOTIFYICONDATAA, hBalloonIcon )
#define NOTIFYICONDATA_STRUCT_SIZEW    CCSIZEOF_STRUCT ( NOTIFYICONDATAW, hBalloonIcon )
#endif
#endif
#ifdef UNICODE
#define NOTIFYICONDATA_STRUCT_SIZE NOTIFYICONDATA_STRUCT_SIZEW
#else
#define NOTIFYICONDATA_STRUCT_SIZE NOTIFYICONDATA_STRUCT_SIZEA
#endif


#endif // defined NIM_ADD



////////////////////////////////////////////
//                 STRING                 //
////////////////////////////////////////////



// x86 or x64
#define WIN3264BIT_SUFFIX_W      ( ( IS_WIN64 ) ? L"(64-bit)" : L"(32-bit)" )
#define WIN3264BIT_SUFFIX_A      ( ( IS_WIN64 ) ?  "(64-bit)" :  "(32-bit)" )

#ifdef UNICODE
#define WIN3264BIT_SUFFIX  WIN3264BIT_SUFFIX_W
#else
#define WIN3264BIT_SUFFIX  WIN3264BIT_SUFFIX_A
#endif



////////////////////////////////////////////
//               MULTITHREAD              //
////////////////////////////////////////////



typedef int ( *THREAD_ENTRY_POINT ) ( void *pInitialData ) ;


typedef struct {

   // thread.cpp
   THREAD_ENTRY_POINT pEntryPoint ;
   void *pInitialData ;

   // res.cpp
   char *szGetStringA ;
   wchar_t *szGetStringW ;
   char *szCopyrightA ;

   // environ.cpp
   char *szEnvironA ;
   wchar_t *szEnvironW ;

   // nls.cpp
   struct {
      void *pBuffer ;
      size_t nBufferSize ;
      size_t nCount ;
   } NlsEnumData ;

} THREAD_INTERNAL_DATA_ ;


#ifdef __cplusplus
extern "C" {
#endif

THREAD_INTERNAL_DATA_ *GetThreadInternalData ( void ) ;
THREAD_INTERNAL_DATA_ *AllocThreadInternalData ( void ) ;
int InitializeThreadInternalData ( THREAD_INTERNAL_DATA_ *p ) ;
void FreeThreadInternalData ( THREAD_INTERNAL_DATA_ *p ) ;

#ifdef __cplusplus
}
#endif



////////////////////////////////////////////
//           DEBUG (LAST ERROR)           //
////////////////////////////////////////////



// winmain.cpp
#ifdef __cplusplus
extern "C" {
#endif

char *GetLastErrorStringA ( int nError ) ;
wchar_t *GetLastErrorStringW ( int nError ) ;

#ifdef UNICODE
#define GetLastErrorString GetLastErrorStringW
#else
#define GetLastErrorString GetLastErrorStringA
#endif

#ifdef __cplusplus
}
#endif



////////////////////////////////////////////
//             DEBUG (MALLOC)             //
////////////////////////////////////////////



#if ! defined DEBUG_MALLOC && defined DEBUG_MALLOC_LEAK
#define DEBUG_MALLOC
#endif

#if defined DEBUG_MALLOC

void *realloc_debug ( void *mem, size_t size, int zero, const char *filename, int line ) ;
void free_debug ( void *mem, const char *filename, int line ) ;

#define malloc(n)       realloc_debug ( NULL, n, 0, __FILE__, __LINE__ )
#define realloc(p,n)    realloc_debug ( p, n, 0, __FILE__, __LINE__ )
#define calloc(n,s)     realloc_debug ( NULL, (size_t)(n)*(s), 1, __FILE__, __LINE__ )
#define free(p)         free_debug ( p, __FILE__, __LINE__ )

#endif



////////////////////////////////////////////
//             DEBUG (MALLOC)             //
////////////////////////////////////////////



#if defined DEBUG_BSEARCH

void *bsearch_debug ( const void *key, const void *base, size_t num, size_t width, int ( __cdecl *compare ) ( const void *, const void * ), const char *filename, int line ) ;

#define bsearch(key,base,num,width,compare)     bsearch_debug ( key, base, num, width, compare, __FILE__, __LINE__ )

#endif



////////////////////////////////////////////
//                 THE END                //
////////////////////////////////////////////



#endif // defined RC_INVOKED
#endif // MSC_H

