// longpath.h

#ifndef LONGPATH_H
#define LONGPATH_H

#ifdef __cplusplus
extern "C" {
#endif


size_t GetShortPathNameExA ( const char *szSrcFileName, char *szDstFileName, size_t nBufferSize ) ;
size_t GetShortPathNameExW ( const wchar_t *szSrcFileName, wchar_t *szDstFileName, size_t nBufferSize ) ;
size_t GetLongPathNameExA ( const char *szSrcFileName, char *szDstFileName, size_t nBufferSize ) ;
size_t GetLongPathNameExW ( const wchar_t *szSrcFileName, wchar_t *szDstFileName, size_t nBufferSize ) ;

char *GetShortPathNameAllocA ( const char *szFileName ) ;
wchar_t *GetShortPathNameAllocW ( const wchar_t *szFileName ) ;
char *GetLongPathNameAllocA ( const char *szFileName ) ;
wchar_t *GetLongPathNameAllocW ( const wchar_t *szFileName ) ;


#ifdef UNICODE
#define GetShortPathNameEx GetShortPathNameExW
#define GetLongPathNameEx GetLongPathNameExW
#define GetShortPathNameAlloc GetShortPathNameAllocW
#define GetLongPathNameAlloc GetLongPathNameAllocW
#else
#define GetShortPathNameEx GetShortPathNameExA
#define GetLongPathNameEx GetLongPathNameExA
#define GetShortPathNameAlloc GetShortPathNameAllocA
#define GetLongPathNameAlloc GetLongPathNameAllocA
#endif


#ifdef __cplusplus
}
#endif

#endif


