// longpath.cpp

#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <mbctype.h>
#include "msc.h"
#include "longpath.h"



////////////////////////////////////////////
//                 ANSI                 //
////////////////////////////////////////////



static size_t ConvertPathNameA ( char *szSrcFileName, char *szDstFileName, size_t nBufferSize, int IsToShortName ) ;



// ZpX擾iANSIŁj
// ϊis猳͕̕ۑȂj
//  szDstFileName  NULL ȂϊɕKvȃTCYԂiI[k܂܂Ȃj
// o͂̒ԂiI[k܂܂Ȃj
// s 0 Ԃ
size_t GetShortPathNameExA ( const char *szSrcFileName, char *szDstFileName, size_t nBufferSize ) {

   char *szTmp = strdup_expand ( szSrcFileName, MAX_PATH_LONG, 0 ) ;
   if ( ! szTmp ) return 0 ;

   size_t nResult = ConvertPathNameA ( szTmp, szDstFileName, nBufferSize, TRUE ) ;

   free ( szTmp ) ;
   return nResult ;
}



// pX擾iANSIŁj
// ϊis猳͕̕ۑȂj
//  szDstFileName  NULL ȂϊɕKvȃTCYԂiI[k܂܂Ȃj
// o͂̒ԂiI[k܂܂Ȃj
// s 0 Ԃ
size_t GetLongPathNameExA ( const char *szSrcFileName, char *szDstFileName, size_t nBufferSize ) {

   char *szTmp = strdup_expand ( szSrcFileName, MAX_PATH_LONG, 0 ) ;
   if ( ! szTmp ) return 0 ;

   size_t nResult = ConvertPathNameA ( szTmp, szDstFileName, nBufferSize, FALSE ) ;

   free ( szTmp ) ;
   return nResult ;
}



// ZpX擾ĕiANSIŁj
// free () gĉ邱
// s NULL Ԃ
char *GetShortPathNameAllocA ( const char *szFileName ) {

   char *szTmp = strdup_expand ( szFileName, MAX_PATH_LONG, 0 ) ;
   if ( ! szTmp ) return NULL ;

   char *szResult = NULL ;
   size_t nLength ;

   if ( ! ( nLength = ConvertPathNameA ( szTmp, NULL, 0, TRUE ) ) ) goto EXIT ;
   if ( ! ( szResult = malloc_array ( char, nLength + 1 ) ) ) goto EXIT ;
   if ( ! ( nLength = ConvertPathNameA ( szTmp, szResult, nLength + 1, TRUE ) ) ) goto EXIT ;

   free ( szTmp ) ;
   return szResult ;

   EXIT :
   free ( szTmp ) ;
   free ( szResult ) ;
   return NULL ;
}



// pX擾ĕiANSIŁj
// free () gĉ邱
// s NULL Ԃ
char *GetLongPathNameAllocA ( const char *szFileName ) {

   char *szTmp = strdup_expand ( szFileName, MAX_PATH_LONG, 0 ) ;
   if ( ! szTmp ) return NULL ;

   char *szResult = NULL ;
   size_t nLength ;

   if ( ! ( nLength = ConvertPathNameA ( szTmp, NULL, 0, FALSE ) ) ) goto EXIT ;
   if ( ! ( szResult = malloc_array ( char, nLength + 1 ) ) ) goto EXIT ;
   if ( ! ( nLength = ConvertPathNameA ( szTmp, szResult, nLength + 1, FALSE ) ) ) goto EXIT ;

   free ( szTmp ) ;
   return szResult ;

   EXIT :
   free ( szTmp ) ;
   free ( szResult ) ;
   return NULL ;
}



static char *NextPathSeparatorA ( char *szString ) ;
static inline int IsDotDirectoryA ( const char *szString ) ;



// ֐
static size_t ConvertPathNameA ( char *szSrcFileName, char *szDstFileName, size_t nBufferSize, int IsToShortName ) {

   int nCountDepth = 0 ;
   int IsError = 0 ;

   char *szSrc = szSrcFileName ;
   char *szDst = szDstFileName ;


   // pX̍ŏhCuȂ
   if ( *szSrc && *( szSrc + 1 ) == ':' ) {
      *szSrc = toupper ( *szSrc ) ;
      nCountDepth -= 1 ;
   }
   // pX̍ŏlbg[NȂ
   else if ( IsPathSeparator ( *szSrc ) && IsPathSeparator ( *( szSrc + 1 ) ) ) nCountDepth -= 2 ;


   while ( *szSrc ) {

      if ( IsPathSeparator ( *szSrc ) ) {
         if ( szDstFileName ) {
            if ( szDst - szDstFileName + (size_t) 1 < nBufferSize ) {
               szDst [ 0 ] = *szSrc ;
               szDst [ 1 ] = 0 ;
            }
            else IsError = 1 ;
         }
         szSrc ++ ;
         szDst ++ ;
         continue ;
      }

      nCountDepth ++ ;

      // \[X|C^̈̕ʒu֐i߂
      char *szNextPathSeparator = NextPathSeparatorA ( szSrc ) ;
      if ( szNextPathSeparator ) *szNextPathSeparator = 0 ;

      char *szPriorName = szSrc ;

      if ( ! (  strchr ( szSrc, '?' )        // ChJ[h܂܂ĂÂ܂
             || strchr ( szSrc, '*' )
             || IsDotDirectoryA ( szSrc )    // "."  ".." ́Â܂
             || nCountDepth <= 0             // hCuA}V{LtH_́Â܂
             )
      ) {

         // t@C擾
         WIN32_FIND_DATAA FindData ;
         HANDLE hFindFile = FindFirstFileA ( szSrcFileName, & FindData ) ;
         if ( hFindFile != INVALID_HANDLE_VALUE ) {

            FindClose ( hFindFile ) ;

            if ( IsToShortName ) {
               if ( *FindData.cAlternateFileName ) szPriorName = FindData.cAlternateFileName ;
               else                                szPriorName = FindData.cFileName ;
            }
            else szPriorName = FindData.cFileName ;
         }
      }

      size_t nLength = strlen ( szPriorName ) ;
      if ( szDstFileName ) {
         if ( szDst - szDstFileName + nLength < nBufferSize ) strcpy ( szDst, szPriorName ) ;
         else                                                 IsError = 1 ;
      }
      szSrc = ( szNextPathSeparator ) ? *szNextPathSeparator = '\\', szNextPathSeparator : strend ( szSrc ) ;
      szDst += nLength ;
   }

   if ( IsError ) return 0 ;

   return szDst - szDstFileName ;
}



// ̃pX؂蕶T
// Ȃ NULL Ԃ
static char *NextPathSeparatorA ( char *szString ) {

   for ( ; *szString ; szString += mbsnext ( szString ) ) {
      if ( IsPathSeparator ( *szString ) ) return szString ;
   }
   return NULL ;
}



// "."  ".." Ȃ 0 ȊOԂ
static inline int IsDotDirectoryA ( const char *szString ) {
   if ( 1 ) {
      return ( *szString == '.' && ( ! *( szString + 1 ) || *( szString + 1 ) == '.' && ! *( szString + 2 ) ) ) ;
   }
   else {
      return ( ! strcmp ( szString, "." ) || ! strcmp ( szString, ".." ) ) ;
   }
}



////////////////////////////////////////////
//               UNICODE                //
////////////////////////////////////////////



static size_t ConvertPathNameW ( wchar_t *szSrcFileName, wchar_t *szDstFileName, size_t nBufferSize, int IsToShortName ) ;



// ZpX擾iUNICODEŁj
// ϊis猳͕̕ۑȂj
//  szDstFileName  NULL ȂϊɕKvȃTCYԂiI[k܂܂Ȃj
// o͂̒ԂiI[k܂܂Ȃj
// s 0 Ԃ
size_t GetShortPathNameExW ( const wchar_t *szSrcFileName, wchar_t *szDstFileName, size_t nBufferSize ) {

   wchar_t *szTmp = wcsdup_expand ( szSrcFileName, MAX_PATH_LONG, 0 ) ;
   if ( ! szTmp ) return 0 ;

   size_t nResult = ConvertPathNameW ( szTmp, szDstFileName, nBufferSize, TRUE ) ;

   free ( szTmp ) ;
   return nResult ;
}



// pX擾iUNICODEŁj
// ϊis猳͕̕ۑȂj
//  szDstFileName  NULL ȂϊɕKvȃTCYԂiI[k܂܂Ȃj
// o͂̒ԂiI[k܂܂Ȃj
// s 0 Ԃ
size_t GetLongPathNameExW ( const wchar_t *szSrcFileName, wchar_t *szDstFileName, size_t nBufferSize ) {

   wchar_t *szTmp = wcsdup_expand ( szSrcFileName, MAX_PATH_LONG, 0 ) ;
   if ( ! szTmp ) return 0 ;

   size_t nResult = ConvertPathNameW ( szTmp, szDstFileName, nBufferSize, FALSE ) ;

   free ( szTmp ) ;
   return nResult ;
}



// ZpX擾ĕiUNICODEŁj
// free () gĉ邱
// s NULL Ԃ
wchar_t *GetShortPathNameAllocW ( const wchar_t *szFileName ) {

   wchar_t *szTmp = wcsdup_expand ( szFileName, MAX_PATH_LONG, 0 ) ;
   if ( ! szTmp ) return NULL ;

   wchar_t *szResult = NULL ;
   size_t nLength ;

   if ( ! ( nLength = ConvertPathNameW ( szTmp, NULL, 0, TRUE ) ) ) goto EXIT ;
   if ( ! ( szResult = malloc_array ( wchar_t, nLength + 1 ) ) ) goto EXIT ;
   if ( ! ( nLength = ConvertPathNameW ( szTmp, szResult, nLength + 1, TRUE ) ) ) goto EXIT ;

   free ( szTmp ) ;
   return szResult ;

   EXIT :
   free ( szTmp ) ;
   free ( szResult ) ;
   return NULL ;
}



// pX擾ĕiUNICODEŁj
// free () gĉ邱
// s NULL Ԃ
wchar_t *GetLongPathNameAllocW ( const wchar_t *szFileName ) {

   wchar_t *szTmp = wcsdup_expand ( szFileName, MAX_PATH_LONG, 0 ) ;
   if ( ! szTmp ) return NULL ;

   wchar_t *szResult = NULL ;
   size_t nLength ;

   if ( ! ( nLength = ConvertPathNameW ( szTmp, NULL, 0, FALSE ) ) ) goto EXIT ;
   if ( ! ( szResult = malloc_array ( wchar_t, nLength + 1 ) ) ) goto EXIT ;
   if ( ! ( nLength = ConvertPathNameW ( szTmp, szResult, nLength + 1, FALSE ) ) ) goto EXIT ;

   free ( szTmp ) ;
   return szResult ;

   EXIT :
   free ( szTmp ) ;
   free ( szResult ) ;
   return NULL ;
}



static wchar_t *NextPathSeparatorW ( wchar_t *szString ) ;
static inline int IsDotDirectoryW ( const wchar_t *szString ) ;



// ֐
static size_t ConvertPathNameW ( wchar_t *szSrcFileName, wchar_t *szDstFileName, size_t nBufferSize, int IsToShortName ) {

   int nCountDepth = 0 ;
   int IsError = 0 ;

   wchar_t *szSrc = szSrcFileName ;
   wchar_t *szDst = szDstFileName ;


   // pX̍ŏhCuȂ
   if ( *szSrc && *( szSrc + 1 ) == ':' ) {
      *szSrc = toupper ( *szSrc ) ;
      nCountDepth -= 1 ;
   }
   // pX̍ŏlbg[NȂ
   else if ( IsPathSeparator ( *szSrc ) && IsPathSeparator ( *( szSrc + 1 ) ) ) nCountDepth -= 2 ;


   while ( *szSrc ) {

      if ( IsPathSeparator ( *szSrc ) ) {
         if ( szDstFileName ) {
            if ( szDst - szDstFileName + (size_t) 1 < nBufferSize ) {
               szDst [ 0 ] = *szSrc ;
               szDst [ 1 ] = 0 ;
            }
            else IsError = 1 ;
         }
         szSrc ++ ;
         szDst ++ ;
         continue ;
      }

      nCountDepth ++ ;

      // \[X|C^̈̕ʒu֐i߂
      wchar_t *szNextPathSeparator = NextPathSeparatorW ( szSrc ) ;
      if ( szNextPathSeparator ) *szNextPathSeparator = 0 ;

      wchar_t *szPriorName = szSrc ;

      if ( ! (  wcschr ( szSrc, '?' )        // ChJ[h܂܂ĂÂ܂
             || wcschr ( szSrc, '*' )
             || IsDotDirectoryW ( szSrc )    // "."  ".." ́Â܂
             || nCountDepth <= 0             // hCuA}V{LtH_́Â܂
             )
      ) {

         // t@C擾
         WIN32_FIND_DATAW FindData ;
         HANDLE hFindFile = FindFirstFileW ( szSrcFileName, & FindData ) ;
         if ( hFindFile != INVALID_HANDLE_VALUE ) {

            FindClose ( hFindFile ) ;

            if ( IsToShortName ) {
               if ( *FindData.cAlternateFileName ) szPriorName = FindData.cAlternateFileName ;
               else                                szPriorName = FindData.cFileName ;
            }
            else szPriorName = FindData.cFileName ;
         }
      }

      size_t nLength = wcslen ( szPriorName ) ;
      if ( szDstFileName ) {
         if ( szDst - szDstFileName + nLength < nBufferSize ) wcscpy ( szDst, szPriorName ) ;
         else                                                 IsError = 1 ;
      }
      szSrc = ( szNextPathSeparator ) ? *szNextPathSeparator = '\\', szNextPathSeparator : wcsend ( szSrc ) ;
      szDst += nLength ;
   }

   if ( IsError ) return 0 ;

   return szDst - szDstFileName ;
}



// ̃pX؂蕶T
// Ȃ NULL Ԃ
static wchar_t *NextPathSeparatorW ( wchar_t *szString ) {

   for ( ; *szString ; szString += wcsnext ( szString ) ) {
      if ( IsPathSeparator ( *szString ) ) return szString ;
   }
   return NULL ;
}



// "."  ".." Ȃ 0 ȊOԂ
static inline int IsDotDirectoryW ( const wchar_t *szString ) {
   if ( 1 ) {
      return ( *szString == '.' && ( ! *( szString + 1 ) || *( szString + 1 ) == '.' && ! *( szString + 2 ) ) ) ;
   }
   else {
      return ( ! wcscmp ( szString, L"." ) || ! wcscmp ( szString, L".." ) ) ;
   }
}



