// int64.h

#ifndef INT64_H
#define INT64_H

#ifdef __cplusplus
extern "C" {
#endif


#define INT64_STRING_MAX   ( 64 * 2 + 1 )    // {rbg~i{R}j|P{k
#define FILESIZE_STRING_MAX   9              // {{_{{󔒁{PʂQ{{k


typedef struct {
   const char *szGrouping ;               // LOCALE_SGROUPING ̏ɏ
   const char *szThousandSeparator ;
   const char *szDecimalSeparator ;
   int nWidth ;                           // 񒷂Zΐ擪[Ŗ߂
} INT64_STRING_FORMATA ;

typedef struct {
   const wchar_t *szGrouping ;            // LOCALE_SGROUPING ̏ɏ
   const wchar_t *szThousandSeparator ;
   const wchar_t *szDecimalSeparator ;
   int nWidth ;                           // 񒷂Zΐ擪[Ŗ߂
} INT64_STRING_FORMATW ;


int Int64ToStringA ( int64_t X, char *szBuffer, int nBase, int IsCommify, const INT64_STRING_FORMATA *p ) ;
int Uint64ToStringA ( uint64_t X, char *szBuffer, int nBase, int IsCommify, const INT64_STRING_FORMATA *p ) ;
int StringToInt64A ( int64_t *pX, const char *szString, char **pNext, int nBase, const char *szIgnore ) ;
int StringToUint64A ( uint64_t *pX, const char *szString, char **pNext, int nBase, const char *szIgnore ) ;
int FormatByteSizeStringA ( int64_t nSize, char *szBuffer, const INT64_STRING_FORMATA *p ) ;

int Int64ToStringW ( int64_t X, wchar_t *szBuffer, int nBase, int IsCommify, const INT64_STRING_FORMATW *p ) ;
int Uint64ToStringW ( uint64_t X, wchar_t *szBuffer, int nBase, int IsCommify, const INT64_STRING_FORMATW *p ) ;
int StringToInt64W ( int64_t *pX, const wchar_t *szString, wchar_t **pNext, int nBase, const wchar_t *szIgnore ) ;
int StringToUint64W ( uint64_t *pX, const wchar_t *szString, wchar_t **pNext, int nBase, const wchar_t *szIgnore ) ;
int FormatByteSizeStringW ( int64_t nSize, wchar_t *szBuffer, const INT64_STRING_FORMATW *p ) ;


#ifdef UNICODE
#define INT64_STRING_FORMAT INT64_STRING_FORMATW
#define Int64ToString Int64ToStringW
#define Uint64ToString Uint64ToStringW
#define StringToInt64 StringToInt64W
#define StringToUint64 StringToUint64W
#define FormatByteSizeString FormatByteSizeStringW
#else
#define INT64_STRING_FORMAT INT64_STRING_FORMATA
#define Int64ToString Int64ToStringA
#define Uint64ToString Uint64ToStringA
#define StringToInt64 StringToInt64A
#define StringToUint64 StringToUint64A
#define FormatByteSizeString FormatByteSizeStringA
#endif


#ifdef __cplusplus
}
#endif


#if defined DEBUG_CONST_STRING && defined __cplusplus    // for debug

#define FUNC_INT64_STR_STR_INT_STR(func,type,data) \
   static int func##_ ( data *p, const type *s1, const type **s2, int b, const type *i ) { return func ( p, s1, (type**) s2, b, i ) ; } \
   static int func##_ ( data *p,       type *s1,       type **s2, int b, const type *i ) { return func ( p, s1,          s2, b, i ) ; }

FUNC_INT64_STR_STR_INT_STR ( StringToInt64A, char, int64_t )
FUNC_INT64_STR_STR_INT_STR ( StringToInt64W, wchar_t, int64_t )
FUNC_INT64_STR_STR_INT_STR ( StringToUint64A, char, uint64_t )
FUNC_INT64_STR_STR_INT_STR ( StringToUint64W, wchar_t, uint64_t )

#undef FUNC_INT64_STR_STR_INT_STR

#define StringToInt64A StringToInt64A_
#define StringToInt64W StringToInt64W_
#define StringToUint64A StringToUint64A_
#define StringToUint64W StringToUint64W_

#else

#define StringToInt64A(x,s,p,r,i)   StringToInt64A ( x, s, (char**) (p), r, i )
#define StringToUint64A(x,s,p,r,i)  StringToUint64A ( x, s, (char**) (p), r, i )
#define StringToInt64W(x,s,p,r,i)   StringToInt64W ( x, s, (wchar_t**) (p), r, i )
#define StringToUint64W(x,s,p,r,i)  StringToUint64W ( x, s, (wchar_t**) (p), r, i )

#endif


#endif


