// int64.cpp

#include <windows.h>
#include <stdio.h>
#include <ctype.h>
#include "msc.h"

#undef DEBUG_CONST_STRING
#include "int64.h"


// DEBUG_CONST_STRING
#undef StringToInt64A
#undef StringToUint64A
#undef StringToInt64W
#undef StringToUint64W



////////////////////////////////////////////
//           񉻁iANSIŁj           //
////////////////////////////////////////////



// 64rbg𕶎ɕϊiANSIŁj
// 當̒As 0 Ԃ
int Int64ToStringA ( int64_t X, char *szBuffer, int nBase, int IsCommify, const INT64_STRING_FORMATA *p ) {

   int nAddLen = 0 ;

   if ( X < 0 ) {
      X = - X ;
      nAddLen = 1 ;
   }

   int nResult = Uint64ToStringA ( X, szBuffer + nAddLen, nBase, IsCommify, p ) ;

   if ( nResult && nAddLen ) *szBuffer = '-' ;

   return nResult + nAddLen ;
}



static int ReadGroupingA ( const char *szString, const char **pNext ) ;



// Ȃ64rbg𕶎ɕϊiANSIŁj
// 當̒As 0 Ԃ
int Uint64ToStringA ( uint64_t X, char *szBuffer, int nBase, int IsCommify, const INT64_STRING_FORMATA *p ) {

   if ( ! nBase ) nBase = 10 ;
   if ( nBase < 2 || nBase > ( 10 + ( 'Z' - 'A' ) + 1 ) || ! szBuffer ) return 0 ;

   INT64_STRING_FORMATA Format = { 0 } ;
   if ( p ) Format = *p ;
   if ( ! Format.szGrouping ) Format.szGrouping = "3;0" ;
   if ( ! Format.szThousandSeparator ) Format.szThousandSeparator = "," ;
   if ( ! IsCommify ) Format.szGrouping = "" ;

   if ( Format.nWidth > 64 || Format.nWidth < 0 ) return 0 ;


   // tŏ
   char szTmpBuffer [ INT64_STRING_MAX ] ;
   char *szTmp = szTmpBuffer ;

   const char *szGrouping = Format.szGrouping ;
   int nGrouping = ReadGroupingA ( szGrouping, & szGrouping ) ;

   while ( 1 ) {

      int nRemainder = (int) ( X % nBase ) ;
      X /= nBase ;
      if ( nRemainder > 9 ) *szTmp ++ = nRemainder - 10 + 'A' ;
      else                  *szTmp ++ = nRemainder + '0' ;

      Format.nWidth -- ;
      if ( Format.nWidth <= 0 && ! X ) break ;

      nGrouping -- ;
      if ( ! nGrouping ) {
         *szTmp ++ = ',' ;
         nGrouping = ReadGroupingA ( szGrouping, & szGrouping ) ;
      }
   }


   // t
   char *szSrc = szTmp - 1 ;
   char *szDst = szBuffer ;

   while ( szSrc >= szTmpBuffer ) {
      if ( *szSrc == ',' ) {
         szDst += sprintf ( szDst, "%s", Format.szThousandSeparator ) ;
         szSrc -- ;
         continue ;
      }
      *szDst ++ = *szSrc -- ;
   }

   *szDst = 0 ;

   return (int) ( szDst - szBuffer ) ;
}



// ؂錅Lǂ
// s 0 ܂͕Ԃ
static int ReadGroupingA ( const char *szString, const char **pNext ) {

   int nGroup1, nGroup2, nLength ;
   int nResult = sscanf ( szString, "%d;%n%d", & nGroup1, & nLength, & nGroup2 ) ;

   switch ( nResult ) {
      case 2 :
         if ( nGroup2 ) *pNext = szString + nLength ;
         else           *pNext = szString ;
         return nGroup1 ;
      case 1 :
         *pNext = strend ( szString ) ;
         return nGroup1 ;
      default :
         *pNext = strend ( szString ) ;
         return 0 ;
   }
}



////////////////////////////////////////////
//         񉻁iUNICODEIŁj         //
////////////////////////////////////////////



// 64rbg𕶎ɕϊiUNICODEŁj
// 當̒As 0 Ԃ
int Int64ToStringW ( int64_t X, wchar_t *szBuffer, int nBase, int IsCommify, const INT64_STRING_FORMATW *p ) {

   int nAddLen = 0 ;

   if ( X < 0 ) {
      X = - X ;
      nAddLen = 1 ;
   }

   int nResult = Uint64ToStringW ( X, szBuffer + nAddLen, nBase, IsCommify, p ) ;

   if ( nResult && nAddLen ) *szBuffer = '-' ;

   return nResult + nAddLen ;
}



static int ReadGroupingW ( const wchar_t *szString, const wchar_t **pNext ) ;



// Ȃ64rbg𕶎ɕϊiUNICODEŁj
// 當̒As 0 Ԃ
int Uint64ToStringW ( uint64_t X, wchar_t *szBuffer, int nBase, int IsCommify, const INT64_STRING_FORMATW *p ) {

   if ( ! nBase ) nBase = 10 ;
   if ( nBase < 2 || nBase > ( 10 + ( 'Z' - 'A' ) + 1 ) || ! szBuffer ) return 0 ;

   INT64_STRING_FORMATW Format = { 0 } ;
   if ( p ) Format = *p ;
   if ( ! Format.szGrouping ) Format.szGrouping = L"3;0" ;
   if ( ! Format.szThousandSeparator ) Format.szThousandSeparator = L"," ;
   if ( ! IsCommify ) Format.szGrouping = L"" ;

   if ( Format.nWidth > 64 || Format.nWidth < 0 ) return 0 ;


   // tŏ
   wchar_t szTmpBuffer [ INT64_STRING_MAX ] ;
   wchar_t *szTmp = szTmpBuffer ;

   const wchar_t *szGrouping = Format.szGrouping ;
   int nGrouping = ReadGroupingW ( szGrouping, & szGrouping ) ;

   while ( 1 ) {

      int nRemainder = (int) ( X % nBase ) ;
      X /= nBase ;
      if ( nRemainder > 9 ) *szTmp ++ = nRemainder - 10 + 'A' ;
      else                  *szTmp ++ = nRemainder + '0' ;

      Format.nWidth -- ;
      if ( Format.nWidth <= 0 && ! X ) break ;

      nGrouping -- ;
      if ( ! nGrouping ) {
         *szTmp ++ = ',' ;
         nGrouping = ReadGroupingW ( szGrouping, & szGrouping ) ;
      }
   }


   // t
   wchar_t *szSrc = szTmp - 1 ;
   wchar_t *szDst = szBuffer ;

   while ( szSrc >= szTmpBuffer ) {
      if ( *szSrc == ',' ) {
         szDst += swprintf ( szDst, L"%s", Format.szThousandSeparator ) ;
         szSrc -- ;
         continue ;
      }
      *szDst ++ = *szSrc -- ;
   }

   *szDst = 0 ;

   return (int) ( szDst - szBuffer ) ;
}



// ؂錅Lǂ
// s 0 ܂͕Ԃ
static int ReadGroupingW ( const wchar_t *szString, const wchar_t **pNext ) {

   int nGroup1, nGroup2, nLength ;
   int nResult = swscanf ( szString, L"%d;%n%d", & nGroup1, & nLength, & nGroup2 ) ;

   switch ( nResult ) {
      case 2 :
         if ( nGroup2 ) *pNext = szString + nLength ;
         else           *pNext = szString ;
         return nGroup1 ;
      case 1 :
         *pNext = wcsend ( szString ) ;
         return nGroup1 ;
      default :
         *pNext = wcsend ( szString ) ;
         return 0 ;
   }
}



////////////////////////////////////////////
//            liANSIŁj            //
////////////////////////////////////////////



static int ReadDigitsA ( uint64_t *pX, const char *szString, const char **pNext, int nBase, const char *szIgnore ) ;
static int GetBaseA ( const char *szString, int *pBase ) ;



// 𕄍64rbgɕϊiANSIŁj
// nBase  0 ȂA񂩂 nBase ʂ
// ׂ szIgnore Ɏw肷iNULLłj
// ̕ʒu szNext Ɋi[iNULLłj
// LȕȂ΁ApNext ɐ擪̈ʒui[A0 ȊOԂ
// I[o[t[ INT64_MAX i[A0 ȊOԂ
// A_[t[ INT64_MIN i[A0 ȊOԂ
//  0 As 0 ȊOԂ
int StringToInt64A ( int64_t *pX, const char *szString, char **pNext, int nBase, const char *szIgnore ) {

   int64_t X = 0 ;
   const char *szNext = szString ;
   int nResult = 1 ;

   if ( ! ( nBase < 0 || nBase == 1 || nBase > ( 10 + ( 'Z' - 'A' ) + 1 ) ) ) {

      const char *szStart = szString ;

      while ( isspace ( *szString ) ) szString ++ ;

      int sign = 0 ;
      if      ( *szString == '+' ) szString ++ ;
      else if ( *szString == '-' ) {
         szString ++ ;
         sign = 1 ;
      }

      szString += GetBaseA ( szString, & nBase ) ;

      uint64_t Y ;

      int IsOverflow = ReadDigitsA ( & Y, szString, & szNext, nBase, szIgnore ) ;
      if ( szString == szNext ) szNext = szStart ;
      else                      nResult = 0 ;

      X = Y ;

      if ( sign ) {
         X = - X ;
         if ( X > 0 ) IsOverflow = 1 ;
      }
      else {
         if ( X < 0 ) IsOverflow = 1 ;
      }

      if ( IsOverflow ) {
         if ( sign ) X = INT64_MIN ;
         else        X = INT64_MAX ;
         nResult = 1 ;
      }
   }

   if ( pX ) *pX = X ;
   if ( pNext ) *pNext = (char*) szNext ;

   return nResult ;
}



// 𕄍Ȃ64rbgɕϊiANSIŁj
// nBase  0 ȂA񂩂 nBase ʂ
// ׂ szIgnore Ɏw肷iNULLłj
// ̕ʒu szNext Ɋi[iNULLłj
// LȕȂ΁ApNext ɐ擪̈ʒui[A0 ȊOԂ
// I[o[t[ UINT64_MAX i[A0 ȊOԂ
//  0 As 0 ȊOԂ
int StringToUint64A ( uint64_t *pX, const char *szString, char **pNext, int nBase, const char *szIgnore ) {

   uint64_t X = 0 ;
   const char *szNext = szString ;
   int nResult = 1 ;

   if ( ! ( nBase < 0 || nBase == 1 || nBase > ( 10 + ( 'Z' - 'A' ) + 1 ) ) ) {

      const char *szStart = szString ;

      while ( isspace ( *szString ) ) szString ++ ;

      if ( *szString == '+' ) szString ++ ;

      szString += GetBaseA ( szString, & nBase ) ;

      int IsOverflow = ReadDigitsA ( & X, szString, & szNext, nBase, szIgnore ) ;
      if ( szString == szNext ) szNext = szStart ;
      else                      nResult = 0 ;

      if ( IsOverflow ) {
         X = UINT64_MAX ;
         nResult = 1 ;
      }
   }

   if ( pX ) *pX = X ;
   if ( pNext ) *pNext = (char*) szNext ;

   return nResult ;
}



// I[o[t[ 0 ȊOԂ
static int ReadDigitsA ( uint64_t *pX, const char *szString, const char **pNext, int nBase, const char *szIgnore ) {

   int IsOverflow = 0 ;
   uint64_t X = 0 ;

   // I[o[t[O̍ől߂Ă
   const uint64_t nMaxX = UINT64_MAX / nBase ;
   const uint64_t nMaxC = UINT64_MAX % nBase ;


   for ( ; ; szString ++ ) {

      int C = *szString ;
      if ( szIgnore && C && strchr ( szIgnore, C ) ) continue ;

      if      ( isdigit ( C ) ) C = C - '0' ;
      else if ( isupper ( C ) ) C = C - 'A' + 10 ;
      else if ( islower ( C ) ) C = C - 'a' + 10 ;
      else                      break ;

      if ( C >= nBase ) break ;

      if ( X > nMaxX || ( X == nMaxX && C > nMaxC ) ) IsOverflow = 1 ;

      if ( ! IsOverflow ) X = X * nBase + C ;
   }


   *pX = X ;
   *pNext = szString ;

   return IsOverflow ;
}



// ǂݔ΂ׂԂ
static int GetBaseA ( const char *szString, int *pBase ) {

   if ( ! *pBase ) {

      if ( szString [ 0 ] == '0' ) {
         if ( szString [ 1 ] == 'x' || szString [ 1 ] == 'X' ) {
            *pBase = 0x10 ;
            return 2 ;
         }
         else *pBase = 8 ;
      }
      else *pBase = 10 ;

      return 0 ;
   }

   if ( *pBase == 0x10 ) {
      if ( szString [ 0 ] == '0' ) {
         if ( szString [ 1 ] == 'x' || szString [ 1 ] == 'X' ) return 2 ;
      }
   }

   return 0 ;
}



////////////////////////////////////////////
//          liUNICODEIŁj          //
////////////////////////////////////////////



static int ReadDigitsW ( uint64_t *pX, const wchar_t *szString, const wchar_t **pNext, int nBase, const wchar_t *szIgnore ) ;
static int GetBaseW ( const wchar_t *szString, int *pBase ) ;



// 𕄍64rbgɕϊiUNICODEŁj
// nBase  0 ȂA񂩂 nBase ʂ
// ׂ szIgnore Ɏw肷iNULLłj
// ̕ʒu szNext Ɋi[iNULLłj
// LȕȂ΁ApNext ɐ擪̈ʒui[A0 ȊOԂ
// I[o[t[ INT64_MAX i[A0 ȊOԂ
// A_[t[ INT64_MIN i[A0 ȊOԂ
//  0 As 0 ȊOԂ
int StringToInt64W ( int64_t *pX, const wchar_t *szString, wchar_t **pNext, int nBase, const wchar_t *szIgnore ) {

   int64_t X = 0 ;
   const wchar_t *szNext = szString ;
   int nResult = 1 ;

   if ( ! ( nBase < 0 || nBase == 1 || nBase > ( 10 + ( 'Z' - 'A' ) + 1 ) ) ) {

      const wchar_t *szStart = szString ;

      while ( isspace ( *szString ) ) szString ++ ;

      int sign = 0 ;
      if      ( *szString == '+' ) szString ++ ;
      else if ( *szString == '-' ) {
         szString ++ ;
         sign = 1 ;
      }

      szString += GetBaseW ( szString, & nBase ) ;

      uint64_t Y ;

      int IsOverflow = ReadDigitsW ( & Y, szString, & szNext, nBase, szIgnore ) ;
      if ( szString == szNext ) szNext = szStart ;
      else                      nResult = 0 ;

      X = Y ;

      if ( sign ) {
         X = - X ;
         if ( X > 0 ) IsOverflow = 1 ;
      }
      else {
         if ( X < 0 ) IsOverflow = 1 ;
      }

      if ( IsOverflow ) {
         if ( sign ) X = INT64_MIN ;
         else        X = INT64_MAX ;
         nResult = 1 ;
      }
   }

   if ( pX ) *pX = X ;
   if ( pNext ) *pNext = (wchar_t*) szNext ;

   return nResult ;
}



// 𕄍Ȃ64rbgɕϊiUNICODEŁj
// nBase  0 ȂA񂩂 nBase ʂ
// ׂ szIgnore Ɏw肷iNULLłj
// ̕ʒu szNext Ɋi[iNULLłj
// LȕȂ΁ApNext ɐ擪̈ʒui[A0 ȊOԂ
// I[o[t[ UINT64_MAX i[A0 ȊOԂ
//  0 As 0 ȊOԂ
int StringToUint64W ( uint64_t *pX, const wchar_t *szString, wchar_t **pNext, int nBase, const wchar_t *szIgnore ) {

   uint64_t X = 0 ;
   const wchar_t *szNext = szString ;
   int nResult = 1 ;

   if ( ! ( nBase < 0 || nBase == 1 || nBase > ( 10 + ( 'Z' - 'A' ) + 1 ) ) ) {

      const wchar_t *szStart = szString ;

      while ( isspace ( *szString ) ) szString ++ ;

      if ( *szString == '+' ) szString ++ ;

      szString += GetBaseW ( szString, & nBase ) ;

      int IsOverflow = ReadDigitsW ( & X, szString, & szNext, nBase, szIgnore ) ;
      if ( szString == szNext ) szNext = szStart ;
      else                      nResult = 0 ;

      if ( IsOverflow ) {
         X = UINT64_MAX ;
         nResult = 1 ;
      }
   }

   if ( pX ) *pX = X ;
   if ( pNext ) *pNext = (wchar_t*) szNext ;

   return nResult ;
}



// I[o[t[ 0 ȊOԂ
static int ReadDigitsW ( uint64_t *pX, const wchar_t *szString, const wchar_t **pNext, int nBase, const wchar_t *szIgnore ) {

   int IsOverflow = 0 ;
   uint64_t X = 0 ;

   // I[o[t[O̍ől߂Ă
   const uint64_t nMaxX = UINT64_MAX / nBase ;
   const uint64_t nMaxC = UINT64_MAX % nBase ;


   for ( ; ; szString ++ ) {

      int C = *szString ;
      if ( szIgnore && C && wcschr ( szIgnore, C ) ) continue ;

      if      ( isdigit ( C ) ) C = C - '0' ;
      else if ( isupper ( C ) ) C = C - 'A' + 10 ;
      else if ( islower ( C ) ) C = C - 'a' + 10 ;
      else                      break ;

      if ( C >= nBase ) break ;

      if ( X > nMaxX || ( X == nMaxX && C > nMaxC ) ) IsOverflow = 1 ;

      if ( ! IsOverflow ) X = X * nBase + C ;
   }


   *pX = X ;
   *pNext = szString ;

   return IsOverflow ;
}



// ǂݔ΂ׂԂ
static int GetBaseW ( const wchar_t *szString, int *pBase ) {

   if ( ! *pBase ) {

      if ( szString [ 0 ] == '0' ) {
         if ( szString [ 1 ] == 'x' || szString [ 1 ] == 'X' ) {
            *pBase = 0x10 ;
            return 2 ;
         }
         else *pBase = 8 ;
      }
      else *pBase = 10 ;

      return 0 ;
   }

   if ( *pBase == 0x10 ) {
      if ( szString [ 0 ] == '0' ) {
         if ( szString [ 1 ] == 'x' || szString [ 1 ] == 'X' ) return 2 ;
      }
   }

   return 0 ;
}



////////////////////////////////////////////
//                T\                //
////////////////////////////////////////////



// TCYTŕ\iANSIŁj
// ʂ 1000 oCgȂ 0 ȊOԂ
// INT64_MAX  8.00EB
int FormatByteSizeStringA ( int64_t nSize, char *szBuffer, const INT64_STRING_FORMATA *p ) {

   const char *szMinus = "" ;
   if ( nSize < 0 ) {
      nSize = - nSize ;
      if ( nSize < 0 ) nSize = INT64_MAX ;
      szMinus = "-" ;
   }

   const char *szDecimalSeparator = "." ;
   if ( p && p->szDecimalSeparator ) szDecimalSeparator = p->szDecimalSeparator ;

   static const char *const MetricArray [] = { NULL, "KB", "MB", "GB", "TB", "PB", "EB" } ;

   int nMetric = 1 ;
   int nLeft ;
   int nRight ;

   for ( ; ; nMetric ++ ) {
      int64_t nTmp = nSize >> ( nMetric * 10 ) ;
      if ( nTmp < 1000 ) {
         nLeft = (int) nTmp ;
         nRight = (int) ( nSize >> ( ( nMetric - 1 ) * 10 ) ) & 0x3FF ;
         nRight = ( nRight * 100 ) >> 10 ;
         break ;
      }
   }

   if      ( nLeft < 10 )  sprintf ( szBuffer, "%s%d%s%02d %s", szMinus, nLeft, szDecimalSeparator, nRight,      MetricArray [ nMetric ] ) ;
   else if ( nLeft < 100 ) sprintf ( szBuffer, "%s%d%s%d %s",   szMinus, nLeft, szDecimalSeparator, nRight / 10, MetricArray [ nMetric ] ) ;
   else                    sprintf ( szBuffer, "%s%d %s",       szMinus, nLeft,                                  MetricArray [ nMetric ] ) ;

   if ( nSize < 1000 ) return 1 ;

   return 0 ;
}



// TCYTŕ\iUNICODEŁj
// ʂ 1000 oCgȂ 0 ȊOԂ
// INT64_MAX  8.00EB
int FormatByteSizeStringW ( int64_t nSize, wchar_t *szBuffer, const INT64_STRING_FORMATW *p ) {

   const wchar_t *szMinus = L"" ;
   if ( nSize < 0 ) {
      nSize = - nSize ;
      if ( nSize < 0 ) nSize = INT64_MAX ;
      szMinus = L"-" ;
   }

   const wchar_t *szDecimalSeparator = L"." ;
   if ( p && p->szDecimalSeparator ) szDecimalSeparator = p->szDecimalSeparator ;

   static const wchar_t *const MetricArray [] = { NULL, L"KB", L"MB", L"GB", L"TB", L"PB", L"EB" } ;

   int nMetric = 1 ;
   int nLeft ;
   int nRight ;

   for ( ; ; nMetric ++ ) {
      int64_t nTmp = nSize >> ( nMetric * 10 ) ;
      if ( nTmp < 1000 ) {
         nLeft = (int) nTmp ;
         nRight = (int) ( nSize >> ( ( nMetric - 1 ) * 10 ) ) & 0x3FF ;
         nRight = ( nRight * 100 ) >> 10 ;
         break ;
      }
   }

   if      ( nLeft < 10 )  swprintf ( szBuffer, L"%s%d%s%02d %s", szMinus, nLeft, szDecimalSeparator, nRight,      MetricArray [ nMetric ] ) ;
   else if ( nLeft < 100 ) swprintf ( szBuffer, L"%s%d%s%d %s",   szMinus, nLeft, szDecimalSeparator, nRight / 10, MetricArray [ nMetric ] ) ;
   else                    swprintf ( szBuffer, L"%s%d %s",       szMinus, nLeft,                                  MetricArray [ nMetric ] ) ;

   if ( nSize < 1000 ) return 1 ;

   return 0 ;
}



