// findfile.h

#ifndef FINDFILE_H
#define FINDFILE_H

#ifdef __cplusplus
extern "C" {
#endif


// [h dwMode
#define FINDFILES_FILE                       1     // t@C
#define FINDFILES_DIR                        2     // fBNg
#define FINDFILES_HIDDEN                     4     // Bt@CEVXet@C
#define FINDFILES_SHORTNAME                  8     // V[gt@Co͂
#define FINDFILES_SUBDIR                  0x10     // TufBNg
#define FINDFILES_HIDDEN_SUBDIR           0x20     // BTufBNg
#define FINDFILES_WITHPATH                0x40     // pXtŏo
#define FINDFILES_SORT                    0x80     // \[g
#define FINDFILES_SORT_REVERSE           0x100     // tɃ\[g
#define FINDFILES_SORT_NUMERIC           0x200     // XPX^CŃ\[g (FINDFILES_SORT ܂ FINDFILES_SORT_REVERSE ƓɎw)
#define FINDFILES_NO_PIVOT_DIR           0x400     // fBNgo͂Ȃ
#define FINDFILES_SORT_CLASSIC           0x800     // 95X^CŃ\[g (FINDFILES_SORT ܂ FINDFILES_SORT_REVERSE ƓɎw)
#define FINDFILES_QUIT_AT_FIRST_FILE    0x2000     // Β~
#define FINDFILES_NO_EMPTY_DIR          0x4000     // t@ĈȂfBNgo͂ȂiFINDFILES_DIR ƓɎw)
#define FINDFILES_ONLY_EMPTY_DIR        0x8000     // t@CTufBNĝfBNgo͂ȂiFINDFILES_DIR ƓɎw)

#define FINDFILES_PEEKMESSAGE       0x80000000     // obsolete, no effect


//  FINDFILES_FILE  FINDFILES_DIR w肳ĂȂ
// I FINDFILES_FILE w


#define FINDFILES_ERROR ( (const void*) -1 )


// FINDFILES \
typedef struct FINDFILESA_TAG FINDFILESA ;
typedef struct FINDFILESW_TAG FINDFILESW ;


typedef int ( *FINDFILES_CALLBACKA ) ( const char *szPath, const WIN32_FIND_DATAA *pFindData, int nDepth, LPARAM lParam ) ;
typedef int ( *FINDFILES_CALLBACKW ) ( const wchar_t *szPath, const WIN32_FIND_DATAW *pFindData, int nDepth, LPARAM lParam ) ;


FINDFILESA *FindFilesA ( const char *szPath, unsigned long dwMode, volatile const int *pIsAbort, FINDFILES_CALLBACKA Callback, LPARAM lParam ) ;
void CloseFindFilesA ( FINDFILESA *pFindFiles ) ;
const char *GetFirstFileA ( FINDFILESA *pFindFiles ) ;
const char *GetNextFileA ( FINDFILESA *pFindFiles ) ;
size_t GetFilesCountA ( FINDFILESA *pFindFiles ) ;

FINDFILESW *FindFilesW ( const wchar_t *szPath, unsigned long dwMode, volatile const int *pIsAbort, FINDFILES_CALLBACKW Callback, LPARAM lParam ) ;
void CloseFindFilesW ( FINDFILESW *pFindFiles ) ;
const wchar_t *GetFirstFileW ( FINDFILESW *pFindFiles ) ;
const wchar_t *GetNextFileW ( FINDFILESW *pFindFiles ) ;
size_t GetFilesCountW ( FINDFILESW *pFindFiles ) ;


#ifdef UNICODE
#define FINDFILES             FINDFILESW
#define FINDFILES_CALLBACK    FINDFILES_CALLBACKW
#define FindFiles             FindFilesW
#define CloseFindFiles        CloseFindFilesW
#define GetFirstFile          GetFirstFileW
#define GetNextFile           GetNextFileW
#define GetFilesCount         GetFilesCountW
#else
#define FINDFILES             FINDFILESA
#define FINDFILES_CALLBACK    FINDFILES_CALLBACKA
#define FindFiles             FindFilesA
#define CloseFindFiles        CloseFindFilesA
#define GetFirstFile          GetFirstFileA
#define GetNextFile           GetNextFileA
#define GetFilesCount         GetFilesCountA
#endif


#ifdef __cplusplus
}
#endif

#endif


