// filename.h

#ifndef FILENAME_H
#define FILENAME_H

#ifdef __cplusplus
extern "C" {
#endif


char *GetFileNameA ( const char *szPathName ) ;
wchar_t *GetFileNameW ( const wchar_t *szPathName ) ;
char *ChangeFileNameA ( char *szPathName, const char *szFileName ) ;
wchar_t *ChangeFileNameW ( wchar_t *szPathName, const wchar_t *szFileName ) ;

char *GetExtensionA ( const char *szPathName ) ;
wchar_t *GetExtensionW ( const wchar_t *szPathName ) ;
char *ChangeExtensionA ( char *szPathName, const char *szExtension ) ;
wchar_t *ChangeExtensionW ( wchar_t *szPathName, const wchar_t *szExtension ) ;

size_t GetFileNamePositionA ( const char *szPathName ) ;
size_t GetFileNamePositionW ( const wchar_t *szPathName ) ;

char *GetAlternateDataStreamsNameA ( const char *szPathName ) ;
wchar_t *GetAlternateDataStreamsNameW ( const wchar_t *szPathName ) ;
char *ChangeAlternateDataStreamsNameA ( char *szPathName, const char *szAdsName ) ;
wchar_t *ChangeAlternateDataStreamsNameW ( wchar_t *szPathName, const wchar_t *szAdsName ) ;

char *AddToFileNameA ( char *szPathName, const char *szString ) ;
wchar_t *AddToFileNameW ( wchar_t *szPathName, const wchar_t *szString ) ;

size_t GetFullPathNameExA ( const char *szBasePath, const char *szFileName, char *szBuffer, size_t nBufferSize ) ;
size_t GetFullPathNameExW ( const wchar_t *szBasePath, const wchar_t *szFileName, wchar_t *szBuffer, size_t nBufferSize ) ;
char *GetFullPathNameAllocA ( const char *szBasePath, const char *szFileName ) ;
wchar_t *GetFullPathNameAllocW ( const wchar_t *szBasePath, const wchar_t *szFileName ) ;

int IsFullPathNameA ( const char *szPathName ) ;
int IsFullPathNameW ( const wchar_t *szPathName ) ;
int IsDriveNameA ( const char *szPathName ) ;
int IsDriveNameW ( const wchar_t *szPathName ) ;

int IsFileNameUrlW ( const wchar_t *szPathName ) ;
int IsFileNameUrlA ( const char *szPathName ) ;
int IsFileNameUncW ( const wchar_t *szPathName ) ;
int IsFileNameUncA ( const char *szPathName ) ;

int AddPathSeparatorA ( char *szPathName, int IsSlash ) ;
int AddPathSeparatorW ( wchar_t *szPathName, int IsSlash ) ;
int RemovePathSeparatorA ( char *szPathName ) ;
int RemovePathSeparatorW ( wchar_t *szPathName ) ;

char *WalkPathNameA ( const char *szPathName, int nIndex ) ;
wchar_t *WalkPathNameW ( const wchar_t *szPathName, int nIndex ) ;

char *QuoteFileNameA ( char *szPathName ) ;
wchar_t *QuoteFileNameW ( wchar_t *szPathName ) ;
char *UnquoteFileNameA ( char *szPathName ) ;
wchar_t *UnquoteFileNameW ( wchar_t *szPathName ) ;

int MakeRandomFileNameA ( char *szFileName, unsigned int *pSeed ) ;
int MakeRandomFileNameW ( wchar_t *szFileName, unsigned int *pSeed ) ;


#ifdef __cplusplus
}
#endif


#ifdef UNICODE
#define GetFileName GetFileNameW
#define ChangeFileName ChangeFileNameW
#define GetExtension GetExtensionW
#define ChangeExtension ChangeExtensionW
#define GetFileNamePosition GetFileNamePositionW
#define GetAlternateDataStreamsName GetAlternateDataStreamsNameW
#define ChangeAlternateDataStreamsName ChangeAlternateDataStreamsNameW
#define AddToFileName AddToFileNameW
#define GetFullPathNameEx GetFullPathNameExW
#define GetFullPathNameAlloc GetFullPathNameAllocW
#define IsFullPathName IsFullPathNameW
#define IsFileNameUnc IsFileNameUncW
#define IsFileNameUrl IsFileNameUrlW
#define AddPathSeparator AddPathSeparatorW
#define RemovePathSeparator RemovePathSeparatorW
#define WalkPathName WalkPathNameW
#define QuoteFileName QuoteFileNameW
#define UnquoteFileName UnquoteFileNameW
#define MakeRandomFileName MakeRandomFileNameW
#else
#define GetFileName GetFileNameA
#define ChangeFileName ChangeFileNameA
#define GetExtension GetExtensionA
#define ChangeExtension ChangeExtensionA
#define GetFileNamePosition GetFileNamePositionA
#define GetAlternateDataStreamsName GetAlternateDataStreamsNameA
#define ChangeAlternateDataStreamsName ChangeAlternateDataStreamsNameA
#define AddToFileName AddToFileNameA
#define GetFullPathNameEx GetFullPathNameExA
#define GetFullPathNameAlloc GetFullPathNameAllocA
#define IsFullPathName IsFullPathNameA
#define IsFileNameUnc IsFileNameUncA
#define IsFileNameUrl IsFileNameUrlA
#define AddPathSeparator AddPathSeparatorA
#define RemovePathSeparator RemovePathSeparatorA
#define WalkPathName WalkPathNameA
#define QuoteFileName QuoteFileNameA
#define UnquoteFileName UnquoteFileNameA
#define MakeRandomFileName MakeRandomFileNameA
#endif



#if defined DEBUG_CONST_STRING && defined __cplusplus    // for debug

#define FUNC_STR(func,type)   \
   static const type *func##_ ( const type *s ) { return func ( s ) ; } \
   static       type *func##_ (       type *s ) { return func ( s ) ; }

FUNC_STR ( GetExtensionA, char )
FUNC_STR ( GetExtensionW, wchar_t )
FUNC_STR ( GetFileNameA, char )
FUNC_STR ( GetFileNameW, wchar_t )
FUNC_STR ( GetAlternateDataStreamsNameA, char )
FUNC_STR ( GetAlternateDataStreamsNameW, wchar_t )

#define FUNC_STR_INT(func,type)  \
   static const type *func##_ ( const type *s, int n ) { return func ( s, n ) ; } \
   static       type *func##_ (       type *s, int n ) { return func ( s, n ) ; }

FUNC_STR_INT ( WalkPathNameA, char )
FUNC_STR_INT ( WalkPathNameW, wchar_t )

#undef FUNC_STR
#undef FUNC_STR_INT

#define GetExtensionA GetExtensionA_
#define GetExtensionW GetExtensionW_
#define GetFileNameA GetFileNameA_
#define GetFileNameW GetFileNameW_
#define GetAlternateDataStreamsNameA GetAlternateDataStreamsNameA_
#define GetAlternateDataStreamsNameW GetAlternateDataStreamsNameW_
#define WalkPathNameA WalkPathNameA_
#define WalkPathNameW WalkPathNameW_

#endif // defined DEBUG_CONST_STRING && defined __cplusplus


#endif


