// filename.cpp

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <mbctype.h>
#include "msc.h"

#undef DEBUG_CONST_STRING
#include "filename.h"



////////////////////////////////////////////
//            t@C擾            //
////////////////////////////////////////////



// pXt@CiANSIŁj
// Ȃ NULL Ԃ
char *GetFileNameA ( const char *szPathName ) {

   if (    szPathName [ 0 ] == '\\'
      &&   szPathName [ 1 ] == '\\'
      && ( szPathName [ 2 ] == '.' || szPathName [ 2 ] == '?' )
      &&   szPathName [ 3 ] == '\\'
   ) {
      szPathName += 4 ;
   }

   if ( isalpha ( szPathName [ 0 ] ) && szPathName [ 1 ] == ':' ) {
      szPathName += 2 ;
   }


   for ( const char *szString = szPathName ; *szString ; szString += mbsnext ( szString ) ) {
      if ( IsPathSeparator ( *szString ) ) szPathName = szString + 1 ;
   }

   if ( ! *szPathName ) szPathName = NULL ;

   return (char*) szPathName ;
}



// pXt@CiUNICODEŁj
// Ȃ NULL Ԃ
wchar_t *GetFileNameW ( const wchar_t *szPathName ) {

   if (    szPathName [ 0 ] == '\\'
      &&   szPathName [ 1 ] == '\\'
      && ( szPathName [ 2 ] == '.' || szPathName [ 2 ] == '?' )
      &&   szPathName [ 3 ] == '\\'
   ) {
      szPathName += 4 ;
   }

   if ( isalpha ( szPathName [ 0 ] ) && szPathName [ 1 ] == ':' ) {
      szPathName += 2 ;
   }


   for ( const wchar_t *szString = szPathName ; *szString ; szString += wcsnext ( szString ) ) {
      if ( IsPathSeparator ( *szString ) ) szPathName = szString + 1 ;
   }

   if ( ! *szPathName ) szPathName = NULL ;

   return (wchar_t*) szPathName ;
}



////////////////////////////////////////////
//            t@CύX            //
////////////////////////////////////////////



// pX̃t@CύXiANSIŁj
// t@C NULL w肷ƁAt@C폜
// pXԂ
char *ChangeFileNameA ( char *szPathName, const char *szFileName ) {

   char *szString = GetFileNameA ( szPathName ) ;
   if ( ! szString ) szString = strend ( szPathName ) ;

   if ( ! szFileName ) szFileName = "" ;
   strcpy ( szString, szFileName ) ;

   return szPathName ;
}



// pX̃t@CύXiUNICODEŁj
// t@C NULL w肷ƁAt@C폜
// pXԂ
wchar_t *ChangeFileNameW ( wchar_t *szPathName, const wchar_t *szFileName ) {

   wchar_t *szString = GetFileNameW ( szPathName ) ;
   if ( ! szString ) szString = wcsend ( szPathName ) ;

   if ( ! szFileName ) szFileName = L"" ;
   wcscpy ( szString, szFileName ) ;

   return szPathName ;
}



////////////////////////////////////////////
//              gq擾              //
////////////////////////////////////////////



// pXgqiANSIŁj
// gq '.' ܂܂Ȃ
// Ȃ NULL Ԃ
char *GetExtensionA ( const char *szPathName ) {

   const char *szExtension = NULL ;

   szPathName = GetFileNameA ( szPathName ) ;
   if ( szPathName ) {

      for ( const char *szString = szPathName ; *szString ; szString += mbsnext ( szString ) ) {
         if ( *szString == '.' ) szExtension = szString + 1 ;
      }

   }

   return (char*) szExtension ;
}



// pXgqiUNICODEŁj
// gq '.' ܂܂Ȃ
// Ȃ NULL Ԃ
wchar_t *GetExtensionW ( const wchar_t *szPathName ) {

   const wchar_t *szExtension = NULL ;

   szPathName = GetFileNameW ( szPathName ) ;
   if ( szPathName ) {

      for ( const wchar_t *szString = szPathName ; *szString ; szString += wcsnext ( szString ) ) {
         if ( *szString == '.' ) szExtension = szString + 1 ;
      }

   }

   return (wchar_t*) szExtension ;
}



////////////////////////////////////////////
//              gqύX              //
////////////////////////////////////////////



// pX̊gqύXiANSIŁj
// gq '.' ܂܂Ȃ
// gq NULL w肷ƁAgq폜
// pXԂ
char *ChangeExtensionA ( char *szPathName, const char *szExtension ) {

   char *szString = GetExtensionA ( szPathName ) ;

   if ( szString ) {
      if ( szExtension ) strcpy ( szString, szExtension ) ;
      else               *( szString - 1 ) = 0 ;
   }
   else {
      if ( szExtension ) {
         szString = strend ( szPathName ) ;
         *szString = '.' ;
         strcpy ( szString + 1, szExtension ) ;
      }
   }

   return szPathName ;
}



// pX̊gqύXiUNICODEŁj
// gq '.' ܂܂Ȃ
// gq NULL w肷ƁAgq폜
// pXԂ
wchar_t *ChangeExtensionW ( wchar_t *szPathName, const wchar_t *szExtension ) {

   wchar_t *szString = GetExtensionW ( szPathName ) ;

   if ( szString ) {
      if ( szExtension ) wcscpy ( szString, szExtension ) ;
      else               *( szString - 1 ) = 0 ;
   }
   else {
      if ( szExtension ) {
         szString = wcsend ( szPathName ) ;
         *szString = '.' ;
         wcscpy ( szString + 1, szExtension ) ;
      }
   }

   return szPathName ;
}



////////////////////////////////////////////
//         t@C̈ʒu擾         //
////////////////////////////////////////////



// pXt@C̈ʒuiANSIŁj
// ȂΕ񖖔̈ʒuԂ
size_t GetFileNamePositionA ( const char *szPathName ) {

   const char *szFileName = GetFileNameA ( szPathName ) ;
   if ( ! szFileName ) szFileName = strend ( szPathName ) ;

   return szFileName - szPathName ;
}



// pXt@C̈ʒuiUNICODEŁj
// ȂΕ񖖔̈ʒuԂ
size_t GetFileNamePositionW ( const wchar_t *szPathName ) {

   const wchar_t *szFileName = GetFileNameW ( szPathName ) ;
   if ( ! szFileName ) szFileName = wcsend ( szPathName ) ;

   return szFileName - szPathName ;
}



////////////////////////////////////////////
//         Xg[擾         //
////////////////////////////////////////////



// pX畛Xg[iANSIŁj
// ߂l ':' ܂܂Ȃ
// Ȃ NULL Ԃ
char *GetAlternateDataStreamsNameA ( const char *szPathName ) {

   szPathName = GetFileNameA ( szPathName ) ;
   if ( szPathName ) {

      for ( const char *szString = szPathName ; *szString ; szString += mbsnext ( szString ) ) {
         if ( *szString == ':' ) return (char*) szString + 1 ;
      }

   }

   return NULL ;
}



// pX畛Xg[iUNICODEŁj
// ߂l ':' ܂܂Ȃ
// Ȃ NULL Ԃ
wchar_t *GetAlternateDataStreamsNameW ( const wchar_t *szPathName ) {

   szPathName = GetFileNameW ( szPathName ) ;
   if ( szPathName ) {

      for ( const wchar_t *szString = szPathName ; *szString ; szString += wcsnext ( szString ) ) {
         if ( *szString == ':' ) return (wchar_t*) szString + 1 ;
      }

   }

   return NULL ;
}



////////////////////////////////////////////
//         Xg[ύX         //
////////////////////////////////////////////



// pX̕Xg[ύXiANSIŁj
// Xg[ ':' ܂܂Ȃ
// Xg[ NULL w肷ƁAXg[폜
// pXԂ
char *ChangeAlternateDataStreamsNameA ( char *szPathName, const char *szAdsName ) {

   char *szString = GetAlternateDataStreamsNameA ( szPathName ) ;

   if ( szString ) {
      if ( szAdsName ) strcpy ( szString, szAdsName ) ;
      else             *( szString - 1 ) = 0 ;
   }
   else {
      if ( szAdsName ) {
         szString = strend ( szPathName ) ;
         *szString = ':' ;
         strcpy ( szString + 1, szAdsName ) ;
      }
   }

   return szPathName ;
}



// pX̕Xg[ύXiUNICODEŁj
// Xg[ ':' ܂܂Ȃ
// Xg[ NULL w肷ƁAXg[폜
// pXԂ
wchar_t *ChangeAlternateDataStreamsNameW ( wchar_t *szPathName, const wchar_t *szAdsName ) {

   wchar_t *szString = GetAlternateDataStreamsNameW ( szPathName ) ;

   if ( szString ) {
      if ( szAdsName ) wcscpy ( szString, szAdsName ) ;
      else             *( szString - 1 ) = 0 ;
   }
   else {
      if ( szAdsName ) {
         szString = wcsend ( szPathName ) ;
         *szString = ':' ;
         wcscpy ( szString + 1, szAdsName ) ;
      }
   }

   return szPathName ;
}



////////////////////////////////////////////
//        t@Cɕt        //
////////////////////////////////////////////



// pX̃t@CɕtiANSIŁj
// gq΁Agq̑Oɕt
// pXԂ
char *AddToFileNameA ( char *szPathName, const char *szString ) {

   if ( ! szString || ! *szString ) return szPathName ;

   char *szExtension = GetExtensionA ( szPathName ) ;

   char *szEnd ;
   if ( szExtension ) szEnd = szExtension - 1 ;
   else               szEnd = strend ( szPathName ) ;

   size_t nLength = strlen ( szString ) ;

   memmove ( szEnd + nLength, szEnd, ( strlen ( szEnd ) + 1 ) * sizeof(char) ) ;
   memmove ( szEnd, szString, nLength * sizeof(char) ) ;

   return szPathName ;
}



// pX̃t@CɕtiUNICODEŁj
// gq΁Agq̑Oɕt
// pXԂ
wchar_t *AddToFileNameW ( wchar_t *szPathName, const wchar_t *szString ) {

   if ( ! szString || ! *szString ) return szPathName ;

   wchar_t *szExtension = GetExtensionW ( szPathName ) ;

   wchar_t *szEnd ;
   if ( szExtension ) szEnd = szExtension - 1 ;
   else               szEnd = wcsend ( szPathName ) ;

   size_t nLength = wcslen ( szString ) ;

   memmove ( szEnd + nLength, szEnd, ( wcslen ( szEnd ) + 1 ) * sizeof(wchar_t) ) ;
   memmove ( szEnd, szString, nLength * sizeof(wchar_t) ) ;

   return szPathName ;
}



////////////////////////////////////////////
//            tpX擾            //
////////////////////////////////////////////



// ΃pXtpXɕϊiANSIŁj
//  szBasePath ɂ \\ ŏI镶w
//  szBasePath  NULL ȂAJgfBNg̑΃pXƂ݂Ȃ
// ϊis猳͕̕ۑȂj
//  szBuffer  NULL ȂϊɕKvȃTCYԂiI[k܂܂Ȃj
// o͂̒ԂiI[k܂܂Ȃj
// s 0 Ԃ
size_t GetFullPathNameExA ( const char *szBasePath, const char *szFileName, char *szBuffer, size_t nBufferSize ) {

   if ( nBufferSize > MAX_PATH_LONG ) nBufferSize = MAX_PATH_LONG ;
   if ( ! szBuffer ) nBufferSize = 0 ;

   if ( ! szBasePath ) szBasePath = "" ;

   size_t nResult = 0 ;

   char *szTmpBuffer = malloc_array ( char, strlen ( szFileName ) + strlen ( szBasePath ) + 1 ) ;
   if ( szTmpBuffer ) {

      const char *szEnd ;
      if ( IsFullPathNameA ( szFileName ) ) {
         szEnd = szBasePath ;
      }
      else if ( IsPathSeparator ( *szFileName ) ) {
         szEnd = WalkPathNameA ( szBasePath, 0 ) ;
         if ( ! szEnd ) goto EXIT ;
         if ( szEnd > szBasePath && IsPathSeparator ( *( szEnd - 1 ) ) ) szEnd -- ;
      }
      else {
         szEnd = WalkPathNameA ( szBasePath, -1 ) ;
         if ( ! szEnd ) goto EXIT ;
      }

      int nBaseLength = (int) ( szEnd - szBasePath ) ;
      sprintf ( szTmpBuffer, "%.*s%s", nBaseLength, szBasePath, szFileName ) ;

      char *szDummy ;
      nResult = GetFullPathNameA ( szTmpBuffer, (unsigned long) nBufferSize, szBuffer, & szDummy ) ;
      if ( nResult ) {
         if ( ! szBuffer ) nResult -- ;
         else if ( nResult >= nBufferSize ) {

            // o͂镶obt@v邱Ƃ
            // pX𐳋KĒZȂ邱Ƃ邽
            char *szDstBuffer = malloc_array ( char, nResult ) ;
            if ( szDstBuffer ) {
               nResult = GetFullPathNameA ( szTmpBuffer, (unsigned long) nResult, szDstBuffer, & szDummy ) ;
               if ( nResult >= nBufferSize ) nResult = 0 ;
               else                          strcpy ( szBuffer, szDstBuffer ) ;
               free ( szDstBuffer ) ;
            }
         }
      }
   }

   EXIT :
   free ( szTmpBuffer ) ;

   return nResult ;
}



// ΃pXtpXɕϊiUNICODEŁj
//  szBasePath ɂ \\ ŏI镶w
//  szBasePath  NULL ȂAJgfBNg̑΃pXƂ݂Ȃ
// ϊis猳͕̕ۑȂj
//  szBuffer  NULL ȂϊɕKvȃTCYԂiI[k܂܂Ȃj
// o͂̒ԂiI[k܂܂Ȃj
// s 0 Ԃ
size_t GetFullPathNameExW ( const wchar_t *szBasePath, const wchar_t *szFileName, wchar_t *szBuffer, size_t nBufferSize ) {

   if ( nBufferSize > MAX_PATH_LONG ) nBufferSize = MAX_PATH_LONG ;
   if ( ! szBuffer ) nBufferSize = 0 ;

   if ( ! szBasePath ) szBasePath = L"" ;

   size_t nResult = 0 ;

   wchar_t *szTmpBuffer = malloc_array ( wchar_t, wcslen ( szFileName ) + wcslen ( szBasePath ) + 1 ) ;
   if ( szTmpBuffer ) {

      const wchar_t *szEnd ;
      if ( IsFullPathNameW ( szFileName ) ) {
         szEnd = szBasePath ;
      }
      else if ( IsPathSeparator ( *szFileName ) ) {
         szEnd = WalkPathNameW ( szBasePath, 0 ) ;
         if ( ! szEnd ) goto EXIT ;
         if ( szEnd > szBasePath && IsPathSeparator ( *( szEnd - 1 ) ) ) szEnd -- ;
      }
      else {
         szEnd = WalkPathNameW ( szBasePath, -1 ) ;
         if ( ! szEnd ) goto EXIT ;
      }

      int nBaseLength = (int) ( szEnd - szBasePath ) ;
      swprintf ( szTmpBuffer, L"%.*s%s", nBaseLength, szBasePath, szFileName ) ;

      wchar_t *szDummy ;
      nResult = GetFullPathNameW ( szTmpBuffer, (unsigned long) nBufferSize, szBuffer, & szDummy ) ;
      if ( nResult ) {
         if ( ! szBuffer ) nResult -- ;
         else if ( nResult >= nBufferSize ) {

            // o͂镶obt@v邱Ƃ
            // pX𐳋KĒZȂ邱Ƃ邽
            wchar_t *szDstBuffer = malloc_array ( wchar_t, nResult ) ;
            if ( szDstBuffer ) {
               nResult = GetFullPathNameW ( szTmpBuffer, (unsigned long) nResult, szDstBuffer, & szDummy ) ;
               if ( nResult >= nBufferSize ) nResult = 0 ;
               else                          wcscpy ( szBuffer, szDstBuffer ) ;
               free ( szDstBuffer ) ;
            }
         }
      }
   }

   EXIT :
   free ( szTmpBuffer ) ;

   return nResult ;
}



// ΃pXtpXɕϊĕiANSIŁj
//  szBasePath ɂ \\ ŏI镶w
//  szBasePath  NULL ȂAJgfBNg̑΃pXƂ݂Ȃ
// free () gĉ邱
// s NULL Ԃ
char *GetFullPathNameAllocA ( const char *szBasePath, const char *szFileName ) {

   char *szResult = NULL ;
   size_t nLength ;

   if ( strlen ( szFileName ) + 1 > MAX_PATH_LONG ) return NULL ;

   if ( ! ( nLength = GetFullPathNameExA ( szBasePath, szFileName, NULL, 0 ) ) ) goto EXIT ;
   if ( ! ( szResult = malloc_array ( char, nLength + 1 ) ) ) goto EXIT ;
   if ( ! ( nLength = GetFullPathNameExA ( szBasePath, szFileName, szResult, nLength + 1 ) ) ) goto EXIT ;

   return szResult ;

   EXIT :
   free ( szResult ) ;
   return NULL ;
}



// ΃pXtpXɕϊĕiUNICODEŁj
//  szBasePath ɂ \\ ŏI镶w
//  szBasePath  NULL ȂAJgfBNg̑΃pXƂ݂Ȃ
// free () gĉ邱
// s NULL Ԃ
wchar_t *GetFullPathNameAllocW ( const wchar_t *szBasePath, const wchar_t *szFileName ) {

   wchar_t *szResult = NULL ;
   size_t nLength ;

   if ( wcslen ( szFileName ) + 1 > MAX_PATH_LONG ) return NULL ;

   if ( ! ( nLength = GetFullPathNameExW ( szBasePath, szFileName, NULL, 0 ) ) ) goto EXIT ;
   if ( ! ( szResult = malloc_array ( wchar_t, nLength + 1 ) ) ) goto EXIT ;
   if ( ! ( nLength = GetFullPathNameExW ( szBasePath, szFileName, szResult, nLength + 1 ) ) ) goto EXIT ;

   return szResult ;

   EXIT :
   free ( szResult ) ;
   return NULL ;
}



////////////////////////////////////////////
//            tpX            //
////////////////////////////////////////////



// tpXiUNC܂ށjiANSIŁj
int IsFullPathNameA ( const char *szPathName ) {

   if ( isalpha ( szPathName [ 0 ] ) && szPathName [ 1 ] == ':' ) {
      if ( IsPathSeparator ( szPathName [ 2 ] ) ) return 1 ;
   }

   if ( szPathName [ 0 ] == '\\' && szPathName [ 1 ] == '\\' ) return 1 ;

   return 0 ;
}



// tpXiUNC܂ށjiUNICODEŁj
int IsFullPathNameW ( const wchar_t *szPathName ) {

   if ( isalpha ( szPathName [ 0 ] ) && szPathName [ 1 ] == ':' ) {
      if ( IsPathSeparator ( szPathName [ 2 ] ) ) return 1 ;
   }

   if ( szPathName [ 0 ] == '\\' && szPathName [ 1 ] == '\\' ) return 1 ;

   return 0 ;
}



////////////////////////////////////////////
//            hCu            //
////////////////////////////////////////////



// hCui"C:"̌`jiANSIŁj
int IsDriveNameA ( const char *szPathName ) {

   if ( isalpha ( szPathName [ 0 ] ) && szPathName [ 1 ] == ':' ) {
      if ( ! szPathName [ 2 ] ) return 1 ;
   }

   return 0 ;
}



// hCui"C:"̌`jiUNICODEŁj
int IsDriveNameW ( const wchar_t *szPathName ) {

   if ( isalpha ( szPathName [ 0 ] ) && szPathName [ 1 ] == ':' ) {
      if ( ! szPathName [ 2 ] ) return 1 ;
   }

   return 0 ;
}



////////////////////////////////////////////
//               UNC                //
////////////////////////////////////////////



// UNCiANSIŁj
int IsFileNameUncA ( const char *szPathName ) {

   if ( szPathName [ 0 ] == '\\' && szPathName [ 1 ] == '\\' ) return 1 ;

   return 0 ;
}



// UNCiUNICODEŁj
int IsFileNameUncW ( const wchar_t *szPathName ) {

   if ( szPathName [ 0 ] == '\\' && szPathName [ 1 ] == '\\' ) return 1 ;

   return 0 ;
}



////////////////////////////////////////////
//               URL                //
////////////////////////////////////////////



// RFC 3986
// URI    = scheme ":" hier-part [ "?" query ] [ "#" fragment ]
// scheme = ALPHA *( ALPHA / DIGIT / "+" / "-" / "." )



// URLiANSIŁj
int IsFileNameUrlA ( const char *szPathName ) {

   const char *szString = szPathName ;

   if ( ! isalpha ( *szString ) ) return 0 ;
   szString ++ ;
   while ( isalnum ( *szString ) || *szString == '+' || *szString == '-' || *szString == '.' ) szString ++ ;

   // hCur邽߁AXL[͂Qȏ݂̂Ƃ
   if ( szString - szPathName > 1 && *szString == ':' ) return 1 ;

   return 0 ;
}



// URLiUNICODEŁj
int IsFileNameUrlW ( const wchar_t *szPathName ) {

   const wchar_t *szString = szPathName ;

   if ( ! isalpha ( *szString ) ) return 0 ;
   szString ++ ;
   while ( isalnum ( *szString ) || *szString == '+' || *szString == '-' || *szString == '.' ) szString ++ ;

   // hCur邽߁AXL[͂Qȏ݂̂Ƃ
   if ( szString - szPathName > 1 && *szString == ':' ) return 1 ;

   return 0 ;
}



////////////////////////////////////////////
//            pX𒲐            //
////////////////////////////////////////////



// pX̖ \ ܂ / ǉiANSIŁj
// C:  C:\ ɂ͉Ȃ
// ύX 0 ȊOԂ
int AddPathSeparatorA ( char *szPathName, int IsSlash ) {

   if ( ! GetFileNameA ( szPathName ) ) return 0 ;

   if ( IsSlash ) strcat ( szPathName, "/" ) ;
   else           strcat ( szPathName, "\\" ) ;

   return 1 ;
}



// pX̖ \ ܂ / ǉiUNICODEŁj
// C:  C:\ ɂ͉Ȃ
// ύX 0 ȊOԂ
int AddPathSeparatorW ( wchar_t *szPathName, int IsSlash ) {

   if ( ! GetFileNameW ( szPathName ) ) return 0 ;

   if ( IsSlash ) wcscat ( szPathName, L"/" ) ;
   else           wcscat ( szPathName, L"\\" ) ;

   return 1 ;
}



// pX̖ \ ܂ / iANSIŁj
// C:  C:\ ɂ͉Ȃ
// ύX 0 ȊOԂ
int RemovePathSeparatorA ( char *szPathName ) {

   for ( char *szString = szPathName, *szMark = szPathName ; *szString ; szString += mbsnext ( szString ) ) {
      if ( *szString == ':' && IsPathSeparator ( *( szString + 1 ) ) ) {
         szMark = szString + 1 ;
         continue ;
      }
      if ( IsPathSeparator ( *szString ) ) {
         char *szEnd = szString ++ ;
         while ( IsPathSeparator ( *szString ) ) szString ++ ;
         if ( szEnd > szMark && ! *szString ) {
            *szEnd = 0 ;
            return 1 ;
         }
         continue ;
      }
   }

   return 0 ;
}



// pX̖ \ ܂ / iUNICODEŁj
// C:  C:\ ɂ͉Ȃ
// ύX 0 ȊOԂ
int RemovePathSeparatorW ( wchar_t *szPathName ) {

   for ( wchar_t *szString = szPathName, *szMark = szPathName ; *szString ; szString += wcsnext ( szString ) ) {
      if ( *szString == ':' && IsPathSeparator ( *( szString + 1 ) ) ) {
         szMark = szString + 1 ;
         continue ;
      }
      if ( IsPathSeparator ( *szString ) ) {
         wchar_t *szEnd = szString ++ ;
         while ( IsPathSeparator ( *szString ) ) szString ++ ;
         if ( szEnd > szMark && ! *szString ) {
            *szEnd = 0 ;
            return 1 ;
         }
         continue ;
      }
   }

   return 0 ;
}



////////////////////////////////////////////
//          pX̊Kwǂ          //
////////////////////////////////////////////



static inline int IsNoPathSeparator ( int c ) { return c && c != '\\' && c != '/' ; }



// pX̊KwǂiANSIŁj
// Ȃ擪AȂ疖炽ǂ
// nIndex  0 w肷
//     C:\dir ł dir Ԃ
//     \\?\C:\dir ł dir Ԃ
//     \\computer\share\dir ł dir Ԃ
//     \\?\UNC\computer\share\dir ł dir Ԃ
//     http://server/dir ł dir Ԃ
// s NULL 
char *WalkPathNameA ( const char *szPathName, int nIndex ) {

   if ( IsFileNameUrlA ( szPathName ) ) {
      while ( *szPathName != ':' )                szPathName += mbsnext ( szPathName ) ;  // scheme
      if ( *szPathName == ':' )                   szPathName ++ ;
      while ( IsPathSeparator ( *szPathName ) )   szPathName ++ ;
      while ( IsNoPathSeparator ( *szPathName ) ) szPathName += mbsnext ( szPathName ) ;  // server
      while ( IsPathSeparator ( *szPathName ) )   szPathName ++ ;
   }
   // UNC
   else if ( IsFileNameUncA ( szPathName ) ) {
      while ( IsPathSeparator ( *szPathName ) ) szPathName ++ ;
      if ( *szPathName == '?' ) {
         szPathName ++ ;
         while ( IsPathSeparator ( *szPathName ) )   szPathName ++ ;
         if ( isalpha ( szPathName [ 0 ] ) && szPathName [ 1 ] == ':' ) return WalkPathNameA ( szPathName + 2, nIndex ) ;
         while ( IsNoPathSeparator ( *szPathName ) ) szPathName += mbsnext ( szPathName ) ;  // "UNC"
         while ( IsPathSeparator ( *szPathName ) )   szPathName ++ ;
      }
      while ( IsNoPathSeparator ( *szPathName ) ) szPathName += mbsnext ( szPathName ) ;  // computer
      while ( IsPathSeparator ( *szPathName ) )   szPathName ++ ;
      while ( IsNoPathSeparator ( *szPathName ) ) szPathName += mbsnext ( szPathName ) ;  // shared folder
      while ( IsPathSeparator ( *szPathName ) )   szPathName ++ ;
   }
   // "C:\\", "C:"
   else if ( isalpha ( szPathName [ 0 ] ) && szPathName [ 1 ] == ':' ) {
      szPathName += 2 ;
      while ( IsPathSeparator ( *szPathName ) ) szPathName ++ ;
   }
   // "\\"
   else if ( IsPathSeparator ( *szPathName ) ) {
      while ( IsPathSeparator ( *szPathName ) ) szPathName ++ ;
   }


   int nSeparator = 0 ;

   // 擪
   for ( const char *szString = szPathName ; ; szString += mbsnext ( szString ) ) {

      if ( nIndex >= 0 && nIndex == nSeparator ) return (char*) szString ;

      if ( ! *szString ) break ;

      if ( IsPathSeparator ( *szString ) ) {
         if ( ! IsPathSeparator ( *( szString + 1 ) ) ) nSeparator ++ ;
         continue ;
      }
   }

   // 
   nIndex = nSeparator + nIndex + 1 ;

   for ( const char *szString = szPathName ; ; szString += mbsnext ( szString ) ) {

      if ( ! nIndex ) return (char*) szString ;

      if ( ! *szString ) break ;

      if ( IsPathSeparator ( *szString ) ) {
         if ( ! IsPathSeparator ( *( szString + 1 ) ) ) nIndex -- ;
         continue ;
      }
   }

   return NULL ;
}



// pX̊KwǂiUNICODEŁj
// nIndex  0 w肷
//     C:\dir ł dir Ԃ
//     \\?\C:\dir ł dir Ԃ
//     \\computer\share\dir ł dir Ԃ
//     \\?\UNC\computer\share\dir ł dir Ԃ
//     http://server/dir ł dir Ԃ
// s NULL 
wchar_t *WalkPathNameW ( const wchar_t *szPathName, int nIndex ) {

   if ( IsFileNameUrlW ( szPathName ) ) {
      while ( *szPathName != ':' )                szPathName += wcsnext ( szPathName ) ;  // scheme
      if ( *szPathName == ':' )                   szPathName ++ ;
      while ( IsPathSeparator ( *szPathName ) )   szPathName ++ ;
      while ( IsNoPathSeparator ( *szPathName ) ) szPathName += wcsnext ( szPathName ) ;  // server
      while ( IsPathSeparator ( *szPathName ) )   szPathName ++ ;
   }
   // UNC
   else if ( IsFileNameUncW ( szPathName ) ) {
      while ( IsPathSeparator ( *szPathName ) ) szPathName ++ ;
      if ( *szPathName == '?' ) {
         szPathName ++ ;
         while ( IsPathSeparator ( *szPathName ) )   szPathName ++ ;
         if ( isalpha ( szPathName [ 0 ] ) && szPathName [ 1 ] == ':' ) return WalkPathNameW ( szPathName + 2, nIndex ) ;
         while ( IsNoPathSeparator ( *szPathName ) ) szPathName += wcsnext ( szPathName ) ;  // "UNC"
         while ( IsPathSeparator ( *szPathName ) )   szPathName ++ ;
      }
      while ( IsNoPathSeparator ( *szPathName ) ) szPathName += wcsnext ( szPathName ) ;  // computer
      while ( IsPathSeparator ( *szPathName ) )   szPathName ++ ;
      while ( IsNoPathSeparator ( *szPathName ) ) szPathName += wcsnext ( szPathName ) ;  // shared folder
      while ( IsPathSeparator ( *szPathName ) )   szPathName ++ ;
   }
   // "C:\\", "C:"
   else if ( isalpha ( szPathName [ 0 ] ) && szPathName [ 1 ] == ':' ) {
      szPathName += 2 ;
      while ( IsPathSeparator ( *szPathName ) ) szPathName ++ ;
   }
   // "\\"
   else if ( IsPathSeparator ( *szPathName ) ) {
      while ( IsPathSeparator ( *szPathName ) ) szPathName ++ ;
   }


   int nSeparator = 0 ;

   // 擪
   for ( const wchar_t *szString = szPathName ; ; szString += wcsnext ( szString ) ) {

      if ( nIndex >= 0 && nIndex == nSeparator ) return (wchar_t*) szString ;

      if ( ! *szString ) break ;

      if ( IsPathSeparator ( *szString ) ) {
         if ( ! IsPathSeparator ( *( szString + 1 ) ) ) nSeparator ++ ;
         continue ;
      }
   }

   // 
   nIndex = nSeparator + nIndex + 1 ;

   for ( const wchar_t *szString = szPathName ; ; szString += wcsnext ( szString ) ) {

      if ( ! nIndex ) return (wchar_t*) szString ;

      if ( ! *szString ) break ;

      if ( IsPathSeparator ( *szString ) ) {
         if ( ! IsPathSeparator ( *( szString + 1 ) ) ) nIndex -- ;
         continue ;
      }
   }

   return NULL ;
}



////////////////////////////////////////////
//            dpt            //
////////////////////////////////////////////



// 󔒂Γdpň͂ށiANSIŁj
char *QuoteFileNameA ( char *szPathName ) {

   if ( strpbrk ( szPathName, " ,;=&\t" ) ) {
      size_t nLength = strlen ( szPathName ) ;
      memmove ( szPathName + 1, szPathName, ( nLength + 1 ) * sizeof(char) ) ;
      *szPathName = '\"' ;
      *( szPathName + nLength + 1 ) = '\"' ;
      *( szPathName + nLength + 2 ) = 0 ;
   }

   return szPathName ;
}



// 󔒂Γdpň͂ށiUNICODEŁj
wchar_t *QuoteFileNameW ( wchar_t *szPathName ) {

   if ( wcspbrk ( szPathName, L" ,;=&\t" ) ) {
      size_t nLength = wcslen ( szPathName ) ;
      memmove ( szPathName + 1, szPathName, ( nLength + 1 ) * sizeof(wchar_t) ) ;
      *szPathName = '\"' ;
      *( szPathName + nLength + 1 ) = '\"' ;
      *( szPathName + nLength + 2 ) = 0 ;
   }

   return szPathName ;
}



////////////////////////////////////////////
//            dp폜            //
////////////////////////////////////////////



// dpɈ͂܂ꂽt@Cdp菜iANSIŁj
char *UnquoteFileNameA ( char *szPathName ) {

   if ( *szPathName == '\"' ) {
      size_t nLength = strlen ( szPathName + 1 ) ;
      memmove ( szPathName, szPathName + 1, ( nLength + 1 ) * sizeof(char) ) ;
      if ( *( szPathName + nLength - 1 ) == '\"' ) *( szPathName + nLength - 1 ) = 0 ;
   }

   return szPathName ;
}



// dpɈ͂܂ꂽt@Cdp菜iUNICODEŁj
wchar_t *UnquoteFileNameW ( wchar_t *szPathName ) {

   if ( *szPathName == '\"' ) {
      size_t nLength = wcslen ( szPathName + 1 ) ;
      memmove ( szPathName, szPathName + 1, ( nLength + 1 ) * sizeof(wchar_t) ) ;
      if ( *( szPathName + nLength - 1 ) == '\"' ) *( szPathName + nLength - 1 ) = 0 ;
   }

   return szPathName ;
}



////////////////////////////////////////////
//       _ȃt@C𐶐       //
////////////////////////////////////////////



// t@C̖ɕAꎞt@C쐬iANSIŁj
// Œ 12 til X  UINT_MAX ̂ƂA".3Z141Z1.tmp"j
// At@C쐬A0 Ԃ
// s 0 ȊOԂ
int MakeRandomFileNameA ( char *szFileName, unsigned int *pSeed ) {

   static unsigned int nSeed ;
   static int IsInitialized ;

   if ( ! pSeed ) {
      pSeed = & nSeed ;
      if ( ! IsInitialized ) {
         nSeed = GetTickCount () ;
         IsInitialized = 1 ;
      }
   }


   for ( int nMode = ( GetFileNameA ( szFileName ) ) ? 0 : 1 ; nMode < 2 ; nMode ++ ) {

      if ( nMode ) ChangeFileNameA ( szFileName, NULL ) ;
      else         strcat ( szFileName, "." ) ;

      char *szStart = strend ( szFileName ) ;


      for ( int nCount = 0 ; nCount < SHRT_MAX ; nCount ++ ) {

         unsigned int X = rand_r ( pSeed ) ;

         char *szString = szStart ;

         do {
            const int nBase = 10 + ( 'Z' - 'A' ) + 1 ;
            int nRemainder = X % nBase ;
            X /= nBase ;
            if ( nRemainder > 9 ) *szString ++ = nRemainder - 10 + 'A' ;
            else                  *szString ++ = nRemainder + '0' ;
         } while ( X ) ;

         strcpy ( szString, ".tmp" ) ;

         HANDLE hFile = CreateFileA ( szFileName, GENERIC_WRITE, 0, NULL, CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL ) ;
         int nError = GetLastError () ;

         if ( hFile != INVALID_HANDLE_VALUE ) {
            CloseHandle ( hFile ) ;
            return 0 ;
         }

         if ( nError != ERROR_FILE_EXISTS && nError != ERROR_SHARING_VIOLATION ) break ;
      }
   }

   return 1 ;
}



// t@C̖ɕAꎞt@C쐬iUNICODEŁj
// Œ 12 til X  UINT_MAX ̂ƂA".3Z141Z1.tmp"j
// At@C쐬A0 Ԃ
// s 0 ȊOԂ
int MakeRandomFileNameW ( wchar_t *szFileName, unsigned int *pSeed ) {

   static unsigned int nSeed ;
   static int IsInitialized ;

   if ( ! pSeed ) {
      pSeed = & nSeed ;
      if ( ! IsInitialized ) {
         nSeed = GetTickCount () ;
         IsInitialized = 1 ;
      }
   }


   for ( int nMode = ( GetFileNameW ( szFileName ) ) ? 0 : 1 ; nMode < 2 ; nMode ++ ) {

      if ( nMode ) ChangeFileNameW ( szFileName, NULL ) ;
      else         wcscat ( szFileName, L"." ) ;

      wchar_t *szStart = wcsend ( szFileName ) ;


      for ( int nCount = 0 ; nCount < SHRT_MAX ; nCount ++ ) {

         unsigned int X = rand_r ( pSeed ) ;

         wchar_t *szString = szStart ;

         do {
            const int nBase = 10 + ( 'Z' - 'A' ) + 1 ;
            int nRemainder = X % nBase ;
            X /= nBase ;
            if ( nRemainder > 9 ) *szString ++ = nRemainder - 10 + 'A' ;
            else                  *szString ++ = nRemainder + '0' ;
         } while ( X ) ;

         wcscpy ( szString, L".tmp" ) ;

         HANDLE hFile = CreateFileW ( szFileName, GENERIC_WRITE, 0, NULL, CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL ) ;
         int nError = GetLastError () ;

         if ( hFile != INVALID_HANDLE_VALUE ) {
            CloseHandle ( hFile ) ;
            return 0 ;
         }

         if ( nError != ERROR_FILE_EXISTS && nError != ERROR_SHARING_VIOLATION ) break ;
      }
   }

   return 1 ;
}



