// delete.cpp

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
#include <signal.h>
#include "msc.h"

#include "access.h"
#include "ask.h"
#include "filename.h"
#include "findfile.h"
#include "int64.h"
#include "longpath.h"
#include "oemio.h"
#include "res.h"
#include "resource.h"
#include "shfileop.h"
#include "stringex.h"
#include "systime.h"
#include "winmain.h"



// ChJ[hWJpR[obNpϐ
// FILETIME  LocalFileTime ł͂Ȃ FileTime Ŏw
typedef struct {
   FILETIME       FileTimeMax ;           // ݓ
   FILETIME       FileTimeMin ;
   int64_t        nFileSizeMax ;          // t@CTCY
   int64_t        nFileSizeMin ;
} FILTER_INFO ;


typedef struct {
   int IsCriticalError ;
   int IsListFileError ;
} ERROR_DATA ;


typedef struct {
   int IsDeleteDirectory ;
   int IsDeleteHidden ;
   int IsDeleteReadOnly ;
   int IsSearchSubdir ;
   int IsNoRecycleBin ;

   int IsNotEcho ;
   int IsNotEchoTotal ;
   int nDepth ;

   const FILTER_INFO *pFilter ;        // ݒ肳Ȃ NULL 
   ERROR_DATA        *pError ;
} OPTION_INFO ;


// ~tO
static volatile int IsAbort ;


static int DeleteFilesA ( const char *szSrcPath, const OPTION_INFO *pInfo ) ;
static int DeleteFilesW ( const wchar_t *szSrcPath, const OPTION_INFO *pInfo ) ;
static int ReadListFileA ( const char *szListFileName, const OPTION_INFO *pInfo ) ;
static int ReadListFileW ( const wchar_t *szListFileName, const OPTION_INFO *pInfo ) ;
static int PrintFileTimeUsage ( int nSwitchChar, const wchar_t *szKeyWord ) ;
static int TranslateTimeLimits ( const wchar_t *szString, FILETIME *pFileTime, int IsBefore ) ;
static void __cdecl AbortProc ( int nSignal ) ;
static int Help ( void ) ;



int main ( int argc, char *argv [] ) {

   int IsPrintHelp = 0 ;
   int IsWriteInUnicode = 0 ;
   int nDeletedFile = 0 ;
   int nError = 0 ;
   int IsFilenameSpecified = 0 ;

   FILTER_INFO Filter = { 0 } ;
   Filter.FileTimeMax.dwHighDateTime = UINT_MAX ;
   Filter.FileTimeMax.dwLowDateTime = UINT_MAX ;
   Filter.nFileSizeMax = INT64_MAX ;

   ERROR_DATA ErrorData = { 0 } ;

   OPTION_INFO Info = { 0 } ;
   Info.pError = & ErrorData ;


   // IvV̎擾
   for ( int nCountArgv = 1 ; nCountArgv < argc ; nCountArgv ++ ) {

      const char *szArgv = argv [ nCountArgv ] ;

      if ( *szArgv == '/' || *szArgv == '-' ) {

         switch ( *( szArgv + 1 ) ) {

               size_t nLength ;
               const wchar_t *szTimeKeyWord ;

            case 'D' :
            case 'd' :
               Info.IsDeleteDirectory = 1 ;
               break ;
            case 'H' :
            case 'h' :
               Info.IsDeleteHidden = 1 ;
               break ;
            case 'R' :
            case 'r' :
               Info.IsDeleteReadOnly = 1 ;
               break ;
            case 'N' :
            case 'n' :
               Info.IsNotEcho = 1 ;
               break ;
            case 'U' :
            case 'u' :
               Info.IsNoRecycleBin = 1 ;
               break ;
            case 'Z' :
            case 'z' :
               Info.IsNotEchoTotal = 1 ;
               break ;

            case 'M' :
            case 'm' :
               if ( ! wcslicmp ( GetArgumentW ( nCountArgv ) + 1, L"max", & nLength ) ) {
                  Info.pFilter = & Filter ;
                  const wchar_t *szString = GetArgumentW ( nCountArgv ) + 1 + nLength ;
                  if ( *szString == ':' && isdigit ( *( szString + 1 ) ) ) {
                     int nResult = StringToInt64W ( & Filter.nFileSizeMax, szString + 1, & szString, 0, L"," ) ;
                     if ( nResult || *szString ) nError = nCountArgv ;
                     continue ;
                  }
                  nError = nCountArgv ;
                  continue ;
               }

               if ( ! wcslicmp ( GetArgumentW ( nCountArgv ) + 1, L"min", & nLength ) ) {
                  Info.pFilter = & Filter ;
                  const wchar_t *szString = GetArgumentW ( nCountArgv ) + 1 + nLength ;
                  if ( *szString == ':' && isdigit ( *( szString + 1 ) ) ) {
                     int nResult = StringToInt64W ( & Filter.nFileSizeMin, szString + 1, & szString, 0, L"," ) ;
                     if ( nResult || *szString ) nError = nCountArgv ;
                     continue ;
                  }
                  nError = nCountArgv ;
                  continue ;
               }

               nError = nCountArgv ;
               break ;

            case 'A' :
            case 'a' :
               if ( ! wcslicmp ( GetArgumentW ( nCountArgv ) + 1, ( szTimeKeyWord = L"after" ), & nLength ) ) {
                  Info.pFilter = & Filter ;
                  const wchar_t *szString = GetArgumentW ( nCountArgv ) + 1 + nLength ;
                  if ( *szString != ':' || TranslateTimeLimits ( szString + 1, & Filter.FileTimeMin, 0 ) ) {
                     fwprintf ( stderr, L"%s: %s\n", GetStringW ( IDS_PARAM_ERROR ), GetArgumentW ( nCountArgv ) ) ;
                     PrintFileTimeUsage ( *GetArgumentW ( nCountArgv ), szTimeKeyWord ) ;
                     return 1 ;
                  }
                  continue ;
               }

               nError = nCountArgv ;
               break ;

            case 'B' :
            case 'b' :
               if ( ! wcslicmp ( GetArgumentW ( nCountArgv ) + 1, ( szTimeKeyWord = L"before" ), & nLength ) ) {
                  Info.pFilter = & Filter ;
                  const wchar_t *szString = GetArgumentW ( nCountArgv ) + 1 + nLength ;
                  if ( *szString != ':' || TranslateTimeLimits ( szString + 1, & Filter.FileTimeMax, 1 ) ) {
                     fwprintf ( stderr, L"%s: %s\n", GetStringW ( IDS_PARAM_ERROR ), GetArgumentW ( nCountArgv ) ) ;
                     PrintFileTimeUsage ( *GetArgumentW ( nCountArgv ), szTimeKeyWord ) ;
                     return 1 ;
                  }
                  continue ;
               }

               nError = nCountArgv ;
               break ;

            case 'S' :
            case 's' :
               Info.IsSearchSubdir = 1 ;
               if ( *( szArgv + 2 ) == ':' && isdigit ( *( szArgv + 3 ) ) ) {
                  errno = 0 ;
                  Info.nDepth = strtoul ( szArgv + 3, & szArgv, 10 ) ;
                  if ( errno == ERANGE || *szArgv ) nError = nCountArgv ;
                  if ( ! Info.nDepth ) Info.IsSearchSubdir = 0 ;
                  continue ;
               }
               break ;

            case 'W' :
            case 'w' :
               IsWriteInUnicode = 1 ;
               break ;
            case '?' :
               IsPrintHelp = 1 ;
               break ;
            default :
               nError = nCountArgv ;
               break ;
         }
         if ( *( szArgv + 2 ) ) nError = nCountArgv ;
         continue ;
      }

      IsFilenameSpecified = 1 ;
   }


   // Wo͂ƃG[o͂ UNICODE 
   fwide ( stdout, ( IsWriteInUnicode ) ? 1 : -1 ) ;
   fwide ( stderr, ( IsWriteInUnicode ) ? 1 : -1 ) ;


   // wv\
   if ( IsPrintHelp || argc <= 1 ) {
      Help () ;
      return 1 ;
   }

   // G[\
   if ( nError ) {
      fwprintf ( stderr, L"%s: %s\n", GetStringW ( IDS_PARAM_ERROR ), GetArgumentW ( nError ) ) ;
      return 1 ;
   }

   // t@Cw肳ĂȂ
   if ( ! IsFilenameSpecified ) {
      fwprintf ( stderr, L"%s\n", GetStringW ( IDS_FILE_NOT_SPECIFIED ) ) ;
      return 1 ;
   }

   // IvV𒲐
   if ( Info.pFilter && Info.IsDeleteDirectory ) {
      fwprintf ( stderr, L"%s: %s\n", GetStringW ( IDS_PARAM_CONFLICTION ), L"-d" ) ;
      return 1 ;
   }


   // VOi֐w
   signal ( SIGINT, AbortProc ) ;


   // t@C̏
   for ( int nCountArgv = 1 ; nCountArgv < argc ; nCountArgv ++ ) {

      if ( IsAbort ) break ;
      if ( Info.pError->IsCriticalError ) break ;
      if ( Info.pError->IsListFileError ) break ;

      if ( IsNT () ) {
         const wchar_t *szArgv = GetArgumentW ( nCountArgv ) ;
         if ( *szArgv == '/' || *szArgv == '-' ) continue ;
         if ( *szArgv == '@' ) nDeletedFile += ReadListFileW ( szArgv + 1, & Info ) ;
         else                  nDeletedFile += DeleteFilesW ( szArgv, & Info ) ;
      }
      else {
         const char *szArgv = GetArgumentA ( nCountArgv ) ;
         if ( *szArgv == '/' || *szArgv == '-' ) continue ;
         if ( *szArgv == '@' ) nDeletedFile += ReadListFileA ( szArgv + 1, & Info ) ;
         else                  nDeletedFile += DeleteFilesA ( szArgv, & Info ) ;
      }
   }


   if ( Info.pError->IsListFileError ) return 1 ;

   if ( IsAbort ) {
      fwprintf ( stderr, L"- %s\n", GetStringW ( IDS_ABORTED ) ) ;
      return 1 ;
   }

   if ( Info.pError->IsCriticalError ) {
      fwprintf ( stderr, L"- %s\n", GetStringW ( IDS_UNKNOWN_ERROR ) ) ;
      return 1 ;
   }


   if ( ! Info.IsNotEcho && ! Info.IsNotEchoTotal ) {
      int IsPlural = ( nDeletedFile == 1 ) ? 0 : 1 ;
      if ( Info.IsDeleteDirectory ) printf ( "%d %s/%s deleted.\n", nDeletedFile, ( IsPlural ) ? "files" : "file", ( IsPlural ) ? "folders" : "folder" ) ;
      else                          printf ( "%d %s deleted.\n", nDeletedFile, ( IsPlural ) ? "files" : "file" ) ;
   }

   return 0 ;
}



// ChJ[h̃R[obN֐
// TufBNg̐[𐧌䂷
static int FindFilesCallbackA ( const char *szSrcPath, const WIN32_FIND_DATAA *pFindData, int nDepth, LPARAM lParam ) {

   const OPTION_INFO *pInfo = (OPTION_INFO*) lParam ;
   const FILTER_INFO *pFilter = pInfo->pFilter ;

   // TufBNg̐[
   if ( pInfo->nDepth && nDepth > pInfo->nDepth ) return -1 ;

   if ( pFindData && pFilter ) {

      const int64_t nFileSize = MAKE_INT64 ( pFindData->nFileSizeHigh, pFindData->nFileSizeLow ) ;

      // t@CݎԂ
      if ( CompareFileTime ( & pFindData->ftLastWriteTime, & pFilter->FileTimeMax ) > 0 ) return 1 ;
      if ( CompareFileTime ( & pFindData->ftLastWriteTime, & pFilter->FileTimeMin ) < 0 ) return 1 ;

      // t@CTCY
      if ( nFileSize > pFilter->nFileSizeMax ) return 1 ;
      if ( nFileSize < pFilter->nFileSizeMin ) return 1 ;
   }

   return 0 ;
}



// ChJ[h̃R[obN֐
// TufBNg̐[𐧌䂷
static int FindFilesCallbackW ( const wchar_t *szSrcPath, const WIN32_FIND_DATAW *pFindData, int nDepth, LPARAM lParam ) {

   const OPTION_INFO *pInfo = (OPTION_INFO*) lParam ;
   const FILTER_INFO *pFilter = pInfo->pFilter ;

   // TufBNg̐[
   if ( pInfo->nDepth && nDepth > pInfo->nDepth ) return -1 ;

   if ( pFindData && pFilter ) {

      const int64_t nFileSize = MAKE_INT64 ( pFindData->nFileSizeHigh, pFindData->nFileSizeLow ) ;

      // t@CݎԂ
      if ( CompareFileTime ( & pFindData->ftLastWriteTime, & pFilter->FileTimeMax ) > 0 ) return 1 ;
      if ( CompareFileTime ( & pFindData->ftLastWriteTime, & pFilter->FileTimeMin ) < 0 ) return 1 ;

      // t@CTCY
      if ( nFileSize > pFilter->nFileSizeMax ) return 1 ;
      if ( nFileSize < pFilter->nFileSizeMin ) return 1 ;
   }

   return 0 ;
}



////////////////////////////////////////////
//             siANSIŁj             //
////////////////////////////////////////////



static int PrintNowA ( const char *szFileName, const OPTION_INFO *pInfo ) ;
static int PrintSuccessA ( const char *szFileName, const OPTION_INFO *pInfo ) ;
static int PrintAccessErrorA ( const char *szFileName, const OPTION_INFO *pInfo ) ;



// t@Cw肵č폜iChJ[hj
// ۂɍ폜t@C̐Ԃ
static int DeleteFilesA ( const char *szSrcPath, const OPTION_INFO *pInfo ) {

   if ( IsAbort ) return 0 ;

   unsigned long dwFindFilesMode = FINDFILES_FILE | FINDFILES_SORT ;
   if ( pInfo->IsDeleteDirectory ) dwFindFilesMode |= FINDFILES_DIR ;
   if ( pInfo->IsDeleteHidden ) dwFindFilesMode |= FINDFILES_HIDDEN | FINDFILES_HIDDEN_SUBDIR ;
   if ( pInfo->IsSearchSubdir ) dwFindFilesMode |= FINDFILES_SUBDIR ;

   // foCXr
   if ( IsFileAccessibleA ( szSrcPath, FILE_ACCESS_DEVICE | FILE_ACCESS_EXIST ) ) return 0 ;

   // t@Cɕϊ
   char szSrcPathLongName [ MAX_PATH ] ;
   if ( ! GetLongPathNameExA ( szSrcPath, szSrcPathLongName, MAX_PATH ) ) {
      PrintAccessErrorA ( szSrcPath, pInfo ) ;
      return 0 ;
   }
   szSrcPath = szSrcPathLongName ;


   // ChJ[hWJ
   FINDFILESA *pFindFile = FindFilesA ( szSrcPath, dwFindFilesMode, & IsAbort, FindFilesCallbackA, (LPARAM) pInfo ) ;
   if ( pFindFile == NULL || pFindFile == FINDFILES_ERROR ) return 0 ;


   int nCount = 0 ;
   unsigned long dwDeletionMode = ( pInfo->IsNoRecycleBin ) ? SHDELETE_NO_RECYCLEBIN : 0 ;

   char *szDirName = NULL ;


   for ( const char *szString = GetFirstFileA ( pFindFile ) ; szString ; szString = GetNextFileA ( pFindFile ) ) {

      if ( IsAbort ) break ;

      // tH_̎擾
      if ( ! GetFileNameA ( szString ) ) {
         free ( szDirName ) ;
         szDirName = strdup_expand ( szString, MAX_PATH_LONG, MAX_PATH ) ;
         if ( ! szDirName ) { pInfo->pError->IsCriticalError = 1 ; break ; }
         continue ;
      }

      // t@C̎擾
      const char *szFileName ;
      if ( szDirName ) szFileName = ChangeFileNameA ( szDirName, szString ) ;
      else             szFileName = szString ;

      // t@CANZX
      unsigned long dwAttributes = GetFileAttributesA ( szFileName ) ;
      if ( dwAttributes == INVALID_FILE_ATTRIBUTES ) continue ;
      if ( ! pInfo->IsDeleteDirectory && dwAttributes & FILE_ATTRIBUTE_DIRECTORY ) continue ;
      if ( ! pInfo->IsDeleteReadOnly && dwAttributes & FILE_ATTRIBUTE_READONLY ) {
         PrintAccessErrorA ( szFileName, pInfo ) ;
         continue ;
      }

      // tpX̎擾
      char szFullPathName [ MAX_PATH + 1 ] ;
      size_t nFullPathNameLen = GetFullPathNameExA ( NULL, szFileName, szFullPathName, MAX_PATH ) ;
      if ( ! nFullPathNameLen ) {
         PrintAccessErrorA ( szFileName, pInfo ) ;
         continue ;
      }
      *( szFullPathName + nFullPathNameLen + 1 ) = 0 ;   // ShellDeleteMultipleFiles ̂

      PrintNowA ( szFileName, pInfo ) ;

      // 폜s
      if ( ShellDeleteMultipleFilesA ( NULL, szFullPathName, dwDeletionMode ) ) {
         PrintAccessErrorA ( szFileName, pInfo ) ;
         continue ;
      }

      PrintSuccessA ( szFileName, pInfo ) ;
      nCount ++ ;
   }


   free ( szDirName ) ;

   CloseFindFilesA ( pFindFile ) ;
   return nCount ;
}



static int PrintNowA ( const char *szFileName, const OPTION_INFO *pInfo ) {

   if ( ! pInfo->IsNotEcho ) {
      fputs_line ( "Deleting  ", stdout ) ;
      fputs_line ( szFileName, stdout ) ;
   }

   return 0 ;
}



static int PrintSuccessA ( const char *szFileName, const OPTION_INFO *pInfo ) {

   if ( ! pInfo->IsNotEcho ) {
      fputs_line ( "\r", stdout ) ;
      printf ( "Deleted   %s\n", szFileName ) ;
   }

   return 0 ;
}



static int PrintAccessErrorA ( const char *szFileName, const OPTION_INFO *pInfo ) {

   if ( ! pInfo->IsNotEcho ) {
      fputs_line ( "\r", stdout ) ;
      printf ( "%s - %s\n", szFileName, GetStringA ( IDS_ACCESS_DENIED ) ) ;
   }

   return 0 ;
}



////////////////////////////////////////////
//            siUNICODEŁj           //
////////////////////////////////////////////



static int PrintNowW ( const wchar_t *szFileName, const OPTION_INFO *pInfo ) ;
static int PrintSuccessW ( const wchar_t *szFileName, const OPTION_INFO *pInfo ) ;
static int PrintAccessErrorW ( const wchar_t *szFileName, const OPTION_INFO *pInfo ) ;



// t@Cw肵č폜iChJ[hj
// ۂɍ폜t@C̐Ԃ
static int DeleteFilesW ( const wchar_t *szSrcPath, const OPTION_INFO *pInfo ) {

   if ( IsAbort ) return 0 ;

   unsigned long dwFindFilesMode = FINDFILES_FILE | FINDFILES_SORT ;
   if ( pInfo->IsDeleteDirectory ) dwFindFilesMode |= FINDFILES_DIR ;
   if ( pInfo->IsDeleteHidden ) dwFindFilesMode |= FINDFILES_HIDDEN | FINDFILES_HIDDEN_SUBDIR ;
   if ( pInfo->IsSearchSubdir ) dwFindFilesMode |= FINDFILES_SUBDIR ;

   // foCXr
   if ( IsFileAccessibleW ( szSrcPath, FILE_ACCESS_DEVICE | FILE_ACCESS_EXIST ) ) return 0 ;

   // t@Cɕϊ
   wchar_t szSrcPathLongName [ MAX_PATH ] ;
   if ( ! GetLongPathNameExW ( szSrcPath, szSrcPathLongName, MAX_PATH ) ) {
      PrintAccessErrorW ( szSrcPath, pInfo ) ;
      return 0 ;
   }
   szSrcPath = szSrcPathLongName ;


   // ChJ[hWJ
   FINDFILESW *pFindFile = FindFilesW ( szSrcPath, dwFindFilesMode, & IsAbort, FindFilesCallbackW, (LPARAM) pInfo ) ;
   if ( pFindFile == NULL || pFindFile == FINDFILES_ERROR ) return 0 ;


   int nCount = 0 ;
   unsigned long dwDeletionMode = ( pInfo->IsNoRecycleBin ) ? SHDELETE_NO_RECYCLEBIN : 0 ;

   wchar_t *szDirName = NULL ;


   for ( const wchar_t *szString = GetFirstFileW ( pFindFile ) ; szString ; szString = GetNextFileW ( pFindFile ) ) {

      if ( IsAbort ) break ;

      // tH_̎擾
      if ( ! GetFileNameW ( szString ) ) {
         free ( szDirName ) ;
         szDirName = wcsdup_expand ( szString, MAX_PATH_LONG, MAX_PATH ) ;
         if ( ! szDirName ) { pInfo->pError->IsCriticalError = 1 ; break ; }
         continue ;
      }

      // t@C̎擾
      const wchar_t *szFileName ;
      if ( szDirName ) szFileName = ChangeFileNameW ( szDirName, szString ) ;
      else             szFileName = szString ;

      // t@CANZX
      unsigned long dwAttributes = GetFileAttributesW ( szFileName ) ;
      if ( dwAttributes == INVALID_FILE_ATTRIBUTES ) continue ;
      if ( ! pInfo->IsDeleteDirectory && dwAttributes & FILE_ATTRIBUTE_DIRECTORY ) continue ;
      if ( ! pInfo->IsDeleteReadOnly && dwAttributes & FILE_ATTRIBUTE_READONLY ) {
         PrintAccessErrorW ( szFileName, pInfo ) ;
         continue ;
      }

      // tpX̎擾
      wchar_t szFullPathName [ MAX_PATH + 1 ] ;
      size_t nFullPathNameLen = GetFullPathNameExW ( NULL, szFileName, szFullPathName, MAX_PATH ) ;
      if ( ! nFullPathNameLen ) {
         PrintAccessErrorW ( szFileName, pInfo ) ;
         continue ;
      }
      *( szFullPathName + nFullPathNameLen + 1 ) = 0 ;   // ShellDeleteMultipleFiles ̂

      PrintNowW ( szFileName, pInfo ) ;

      // 폜s
      if ( ShellDeleteMultipleFilesW ( NULL, szFullPathName, dwDeletionMode ) ) {
         PrintAccessErrorW ( szFileName, pInfo ) ;
         continue ;
      }

      PrintSuccessW ( szFileName, pInfo ) ;
      nCount ++ ;
   }


   free ( szDirName ) ;

   CloseFindFilesW ( pFindFile ) ;
   return nCount ;
}



static int PrintNowW ( const wchar_t *szFileName, const OPTION_INFO *pInfo ) {

   if ( ! pInfo->IsNotEcho ) {
      fputws_line ( L"Deleting  ", stdout ) ;
      fputws_line ( szFileName, stdout ) ;
   }

   return 0 ;
}



static int PrintSuccessW ( const wchar_t *szFileName, const OPTION_INFO *pInfo ) {

   if ( ! pInfo->IsNotEcho ) {
      fputws_line ( L"\r", stdout ) ;
      wprintf ( L"Deleted   %s\n", szFileName ) ;
   }

   return 0 ;
}



static int PrintAccessErrorW ( const wchar_t *szFileName, const OPTION_INFO *pInfo ) {

   if ( ! pInfo->IsNotEcho ) {
      fputws_line ( L"\r", stdout ) ;
      wprintf ( L"%s - %s\n", szFileName, GetStringW ( IDS_ACCESS_DENIED ) ) ;
   }

   return 0 ;
}



////////////////////////////////////////////
//                  MISC                  //
////////////////////////////////////////////



#define LINE_BUFFER_SIZE   ( MAX_PATH * 2 )



static int ReadListFileA ( const char *szListFileName, const OPTION_INFO *pInfo ) {


   FILE *Fin = fopen ( szListFileName, "r" ) ;
   if ( ! Fin ) {
      fprintf ( stderr, "%s - \"%s\"\n", GetStringA ( IDS_LIST_FILE_ERROR ), szListFileName ) ;
      return 0 ;
   }
   fwide ( Fin, 0 ) ;


   char szLineBuffer [ LINE_BUFFER_SIZE ] ;

   int nCount = 0 ;
   int nLineNumber = 0 ;


   while ( fgets ( szLineBuffer, LINE_BUFFER_SIZE, Fin ) ) {

      nLineNumber ++ ;

      char *szString ;

      if ( ( szString = strchr ( szLineBuffer, L'\n' ) ) ) *szString = 0 ;
      else if ( ! feof ( Fin ) ) {
         fprintf ( stderr, "%s - \"%s\" (%d)\n", GetStringA ( IDS_LIST_FILE_ERROR ), szListFileName, nLineNumber ) ;
         pInfo->pError->IsListFileError = 1 ;
         break ;
      }

      if ( ! *szLineBuffer ) continue ;

      UnquoteFileNameA ( szLineBuffer ) ;

      nCount += DeleteFilesA ( szLineBuffer, pInfo ) ;
   }

   fclose ( Fin ) ;

   return nCount ;
}



static int ReadListFileW ( const wchar_t *szListFileName, const OPTION_INFO *pInfo ) {


   FILE *Fin = wfopen ( szListFileName, L"r" ) ;
   if ( ! Fin ) {
      fwprintf ( stderr, L"%s - \"%s\"\n", GetStringW ( IDS_LIST_FILE_ERROR ), szListFileName ) ;
      return 0 ;
   }
   fwide ( Fin, 0 ) ;


   wchar_t szLineBuffer [ LINE_BUFFER_SIZE ] ;

   int nCount = 0 ;
   int nLineNumber = 0 ;


   while ( fgetws ( szLineBuffer, LINE_BUFFER_SIZE, Fin ) ) {

      nLineNumber ++ ;

      wchar_t *szString ;

      if ( ( szString = wcschr ( szLineBuffer, L'\n' ) ) ) *szString = 0 ;
      else if ( ! feof ( Fin ) ) {
         fwprintf ( stderr, L"%s - \"%s\" (%d)\n", GetStringW ( IDS_LIST_FILE_ERROR ), szListFileName, nLineNumber ) ;
         pInfo->pError->IsListFileError = 1 ;
         break ;
      }

      if ( ! *szLineBuffer ) continue ;

      UnquoteFileNameW ( szLineBuffer ) ;

      nCount += DeleteFilesW ( szLineBuffer, pInfo ) ;
   }

   fclose ( Fin ) ;

   return nCount ;
}



// t@C̓tEw̓ǂݎ
//  0 As 0 ȊOԂ
static int TranslateTimeLimits ( const wchar_t *szString, FILETIME *pFileTime, int IsBefore ) {

   const unsigned long dwMode = ( IsBefore ) ? SYSTIME_SCAN_CEILING : 0 ;

   if ( ScanDateTimeW ( szString, & szString, pFileTime, NULL, dwMode ) ) return 1 ;
   if ( *szString ) return 1 ;

   return 0 ;
}



static int PrintFileTimeUsage ( int nSwitchChar, const wchar_t *szKeyWord ) {

   fwprintf ( stderr, GetStringW ( IDS_HELP_FILETIME_USAGE ) ) ;
   fwprintf ( stderr, L"     \"%c%s:2000-12-21,14:30\", \"%c%s:2000-12-21\", \"%c%s:14:30\"\n", nSwitchChar, szKeyWord, nSwitchChar, szKeyWord, nSwitchChar, szKeyWord ) ;
   fwprintf ( stderr, L"     \"%c%s:1monthsago\", \"%c%s:30daysago\", \"%c%s:24hoursago\"\n", nSwitchChar, szKeyWord, nSwitchChar, szKeyWord, nSwitchChar, szKeyWord ) ;

   return 0 ;
}



////////////////////////////////////////////
//                  ~                  //
////////////////////////////////////////////



static void __cdecl AbortProc ( int nSignal ) {
   signal ( nSignal, AbortProc ) ;
   IsAbort = 1 ;
}



////////////////////////////////////////////
//                 wv                 //
////////////////////////////////////////////



static int Help ( void ) {

   // R}h
   static const wchar_t szCommandName [] = L"DELETE.EXE" ;

   int nVersion = 0 ;

   int IsAskEach = fiscon ( stdout ) && fiscon ( stderr ) ;

   FILEVERSION FileVersion ;
   if ( ! GetFileVersion ( & FileVersion ) ) nVersion = TranslateVersionInfo ( & FileVersion ) ;

   fwprintf ( stdout, L" %s   version %d.%02d  %s  %s\n\n", szCommandName, nVersion / 100, nVersion % 100, GetVersionCopyrightW (), WIN3264BIT_SUFFIX_W ) ;

   fwprintf ( stdout, L"%s: ", GetStringW ( IDS_HELP_CMDLINE_HDR ) ) ;
   fwprintf ( stdout, L"%s  %s\n", szCommandName, GetStringW ( IDS_HELP_CMDLINE ) ) ;

   fputws ( GetStringW ( IDS_HELP_001 ), stdout ) ;

   if ( IsAskEach && AskW ( GetStringW ( IDS_PRESS_ANY_KEY ), MB_OK ) ) return 1 ;

   fputws ( GetStringW ( IDS_HELP_002 ), stdout ) ;

   return 0 ;
}



