// access.h

#ifndef ACCESS_H
#define ACCESS_H

#ifdef __cplusplus
extern "C" {
#endif


int IsFileAccessibleA ( const char *szFileName, unsigned long dwFlags ) ;
int IsFileAccessibleW ( const wchar_t *szFileName, unsigned long dwFlags ) ;


#ifdef UNICODE
#define IsFileAccessible IsFileAccessibleW
#else
#define IsFileAccessible IsFileAccessibleA
#endif


// for dwFlags

// ̂̂P܂͕
#define FILE_ACCESS_EXIST                    1     // ݂邩
#define FILE_ACCESS_READ                     2     // ǂ݂݉\
#define FILE_ACCESS_WRITE                    4     // ݉\
#define FILE_ACCESS_VALID                    8     // OL

// ̂̂P܂͕
#define FILE_ACCESS_FILE               0x10000     // t@CifoCX܂܂j
#define FILE_ACCESS_DIRECTORY          0x20000     // fBNg
#define FILE_ACCESS_DEVICE             0x40000     // LN^^foCX


#define IsFileExistA(fn)      IsFileAccessibleA ( fn, FILE_ACCESS_EXIST | FILE_ACCESS_FILE )
#define IsFileExistW(fn)      IsFileAccessibleW ( fn, FILE_ACCESS_EXIST | FILE_ACCESS_FILE )
#define IsFolderExistA(fn)    IsFileAccessibleA ( fn, FILE_ACCESS_EXIST | FILE_ACCESS_DIRECTORY )
#define IsFolderExistW(fn)    IsFileAccessibleW ( fn, FILE_ACCESS_EXIST | FILE_ACCESS_DIRECTORY )
#define IsFileReadableA(fn)   IsFileAccessibleA ( fn, FILE_ACCESS_READ | FILE_ACCESS_FILE )
#define IsFileReadableW(fn)   IsFileAccessibleW ( fn, FILE_ACCESS_READ | FILE_ACCESS_FILE )
#define IsFileWritableA(fn)   IsFileAccessibleA ( fn, FILE_ACCESS_WRITE | FILE_ACCESS_FILE )
#define IsFileWritableW(fn)   IsFileAccessibleW ( fn, FILE_ACCESS_WRITE | FILE_ACCESS_FILE )


#ifdef UNICODE
#define IsFileExist IsFileExistW
#define IsFolderExist IsFolderExistW
#define IsFileReadable IsFileReadableW
#define IsFileWritable IsFileWritableW
#else
#define IsFileExist IsFileExistA
#define IsFolderExist IsFolderExistA
#define IsFileReadable IsFileReadableA
#define IsFileWritable IsFileWritableA
#endif


#ifdef __cplusplus
}
#endif

#endif


