// access.cpp

#include <windows.h>
#include <string.h>
#include "msc.h"
#include "access.h"
#include "filename.h"



#define FILE_ACCESS_TESTMODE     ( FILE_ACCESS_EXIST | FILE_ACCESS_READ | FILE_ACCESS_WRITE | FILE_ACCESS_VALID )
#define FILE_ACCESS_TESTTYPE     ( FILE_ACCESS_FILE | FILE_ACCESS_DIRECTORY | FILE_ACCESS_DEVICE )



////////////////////////////////////////////
//                 ANSI                 //
////////////////////////////////////////////



static int GetFileTypeExA ( const char *szFileName, unsigned long dwAccess, int nCreation ) ;



// t@C̃ANZXiANSIŁj
// dwFlags Ɏw肳ꂽɍȂ 0 ȊOԂ
int IsFileAccessibleA ( const char *szFileName, unsigned long dwFlags ) {


   if ( ! ( dwFlags & FILE_ACCESS_TESTTYPE ) ) dwFlags |= FILE_ACCESS_TESTTYPE ;
   if ( ! ( dwFlags & FILE_ACCESS_TESTMODE ) ) dwFlags |= FILE_ACCESS_EXIST ;


   // 95n ł̓foCX̑擾łȂ
   // NTn ł̓foCX̑擾ł
   unsigned long dwAttributes = GetFileAttributesA ( szFileName ) ;


   // fBNg܂̓t@C݂Ȃ
   if ( dwAttributes == INVALID_FILE_ATTRIBUTES ) {

      // t@CƂď߂邩H
      if ( dwFlags & ( FILE_ACCESS_FILE | FILE_ACCESS_DIRECTORY ) ) {
         if ( dwFlags & ( FILE_ACCESS_WRITE | FILE_ACCESS_VALID ) ) {
            int nFileType = GetFileTypeExA ( szFileName, GENERIC_READ, CREATE_NEW ) ;
            if ( nFileType == FILE_TYPE_DISK ) return 1 ;
         }
      }

      // foCXƂēǂݍ߂邩H
      if ( dwFlags & FILE_ACCESS_DEVICE ) {
         if ( dwFlags & ( FILE_ACCESS_READ | FILE_ACCESS_EXIST | FILE_ACCESS_VALID ) ) {
            int nFileType = GetFileTypeExA ( szFileName, GENERIC_READ, OPEN_EXISTING ) ;
            if ( nFileType == FILE_TYPE_CHAR || nFileType == FILE_TYPE_UNKNOWN ) return 1 ;
         }
         if ( dwFlags & ( FILE_ACCESS_WRITE | FILE_ACCESS_EXIST | FILE_ACCESS_VALID ) ) {
            int nFileType = GetFileTypeExA ( szFileName, GENERIC_WRITE, OPEN_EXISTING ) ;
            if ( nFileType == FILE_TYPE_CHAR || nFileType == FILE_TYPE_UNKNOWN ) return 1 ;
         }
      }

   }
   // fBNg
   else if ( dwAttributes & FILE_ATTRIBUTE_DIRECTORY ) {

      // fBNgeXg
      if ( dwFlags & FILE_ACCESS_DIRECTORY ) {
         if ( dwFlags & ( FILE_ACCESS_EXIST | FILE_ACCESS_VALID ) ) {
            return 1 ;
         }
         if ( dwFlags & FILE_ACCESS_READ ) {
            return 1 ;
         }
         if ( dwFlags & FILE_ACCESS_WRITE ) {
            if ( ! ( dwAttributes & FILE_ATTRIBUTE_READONLY ) ) return 1 ;
         }
      }

   }
   // t@C
   else {

      // t@CeXg
      if ( dwFlags & FILE_ACCESS_FILE ) {
         if ( dwFlags & ( FILE_ACCESS_EXIST | FILE_ACCESS_VALID ) ) {
            int nFileType = GetFileTypeExA ( szFileName, 0, OPEN_EXISTING ) ;
            if ( nFileType == FILE_TYPE_DISK ) return 1 ;
         }
         if ( dwFlags & FILE_ACCESS_READ ) {
            int nFileType = GetFileTypeExA ( szFileName, GENERIC_READ, OPEN_EXISTING ) ;
            if ( nFileType == FILE_TYPE_DISK ) return 1 ;
         }
         if ( dwFlags & FILE_ACCESS_WRITE ) {
            int nFileType = GetFileTypeExA ( szFileName, GENERIC_WRITE, OPEN_EXISTING ) ;
            if ( nFileType == FILE_TYPE_DISK ) return 1 ;
         }
      }

      // foCXeXg
      if ( dwFlags & FILE_ACCESS_DEVICE ) {
         if ( dwFlags & ( FILE_ACCESS_READ | FILE_ACCESS_EXIST | FILE_ACCESS_VALID ) ) {
            int nFileType = GetFileTypeExA ( szFileName, GENERIC_READ, OPEN_EXISTING ) ;
            if ( nFileType == FILE_TYPE_CHAR || nFileType == FILE_TYPE_UNKNOWN ) return 1 ;
         }
         if ( dwFlags & ( FILE_ACCESS_WRITE | FILE_ACCESS_EXIST | FILE_ACCESS_VALID ) ) {
            int nFileType = GetFileTypeExA ( szFileName, GENERIC_WRITE, OPEN_EXISTING ) ;
            if ( nFileType == FILE_TYPE_CHAR || nFileType == FILE_TYPE_UNKNOWN ) return 1 ;
         }
      }

   }

   return 0 ;
}



static int GetFileTypeExA ( const char *szFileName, unsigned long dwAccess, int nCreation ) {

   unsigned long dwAttributes = FILE_ATTRIBUTE_NORMAL ;
   if ( nCreation == CREATE_NEW ) dwAttributes = FILE_ATTRIBUTE_TEMPORARY | FILE_FLAG_DELETE_ON_CLOSE ;

   unsigned long dwShare = FILE_SHARE_READ | FILE_SHARE_WRITE ;

   int nFileType = -1 ;

   HANDLE hFile = INVALID_HANDLE_VALUE ;
   HANDLE hFileSub = INVALID_HANDLE_VALUE ;
   char *szFileNameSub = NULL ;


   // Xg[쐬ꍇ́AXg[ꎞIɍ쐬
   if ( nCreation == CREATE_NEW && GetAlternateDataStreamsNameA ( szFileName ) ) {

      szFileNameSub = strdup ( szFileName ) ;
      if ( ! szFileNameSub ) goto EXIT ;

      ChangeAlternateDataStreamsNameA ( szFileNameSub, NULL ) ;
      if ( ! GetFileNameA ( szFileNameSub ) ) goto EXIT ;

      hFileSub = CreateFileA ( szFileNameSub, 0, dwShare, NULL, nCreation, dwAttributes, NULL ) ;

      dwShare |= FILE_SHARE_DELETE ;
   }

   hFile = CreateFileA ( szFileName, dwAccess, dwShare, NULL, nCreation, dwAttributes, NULL ) ;
   if ( hFile == INVALID_HANDLE_VALUE ) goto EXIT ;

   nFileType = GetFileType ( hFile ) ;


   EXIT :

   if ( hFile != INVALID_HANDLE_VALUE ) CloseHandle ( hFile ) ;
   if ( hFileSub != INVALID_HANDLE_VALUE ) CloseHandle ( hFileSub ) ;
   free ( szFileNameSub ) ;

   return nFileType ;
}



////////////////////////////////////////////
//               UNICODE                //
////////////////////////////////////////////



static int GetFileTypeExW ( const wchar_t *szFileName, unsigned long dwAccess, int nCreation ) ;



// t@C̃ANZXiUNICODEŁj
// dwFlags Ɏw肳ꂽɍȂ 0 ȊOԂ
int IsFileAccessibleW ( const wchar_t *szFileName, unsigned long dwFlags ) {


   if ( ! ( dwFlags & FILE_ACCESS_TESTTYPE ) ) dwFlags |= FILE_ACCESS_TESTTYPE ;
   if ( ! ( dwFlags & FILE_ACCESS_TESTMODE ) ) dwFlags |= FILE_ACCESS_EXIST ;


   // 95n ł̓foCX̑擾łȂ
   // NTn ł̓foCX̑擾ł
   unsigned long dwAttributes = GetFileAttributesW ( szFileName ) ;


   // fBNg܂̓t@C݂Ȃ
   if ( dwAttributes == INVALID_FILE_ATTRIBUTES ) {

      // t@CƂď߂邩H
      if ( dwFlags & ( FILE_ACCESS_FILE | FILE_ACCESS_DIRECTORY ) ) {
         if ( dwFlags & ( FILE_ACCESS_WRITE | FILE_ACCESS_VALID ) ) {
            int nFileType = GetFileTypeExW ( szFileName, GENERIC_READ, CREATE_NEW ) ;
            if ( nFileType == FILE_TYPE_DISK ) return 1 ;
         }
      }

      // foCXƂēǂݍ߂邩H
      if ( dwFlags & FILE_ACCESS_DEVICE ) {
         if ( dwFlags & ( FILE_ACCESS_READ | FILE_ACCESS_EXIST | FILE_ACCESS_VALID ) ) {
            int nFileType = GetFileTypeExW ( szFileName, GENERIC_READ, OPEN_EXISTING ) ;
            if ( nFileType == FILE_TYPE_CHAR || nFileType == FILE_TYPE_UNKNOWN ) return 1 ;
         }
         if ( dwFlags & ( FILE_ACCESS_WRITE | FILE_ACCESS_EXIST | FILE_ACCESS_VALID ) ) {
            int nFileType = GetFileTypeExW ( szFileName, GENERIC_WRITE, OPEN_EXISTING ) ;
            if ( nFileType == FILE_TYPE_CHAR || nFileType == FILE_TYPE_UNKNOWN ) return 1 ;
         }
      }

   }
   // fBNg
   else if ( dwAttributes & FILE_ATTRIBUTE_DIRECTORY ) {

      // fBNgeXg
      if ( dwFlags & FILE_ACCESS_DIRECTORY ) {
         if ( dwFlags & ( FILE_ACCESS_EXIST | FILE_ACCESS_VALID ) ) {
            return 1 ;
         }
         if ( dwFlags & FILE_ACCESS_READ ) {
            return 1 ;
         }
         if ( dwFlags & FILE_ACCESS_WRITE ) {
            if ( ! ( dwAttributes & FILE_ATTRIBUTE_READONLY ) ) return 1 ;
         }
      }

   }
   // t@C
   else {

      // t@CeXg
      if ( dwFlags & FILE_ACCESS_FILE ) {
         if ( dwFlags & ( FILE_ACCESS_EXIST | FILE_ACCESS_VALID ) ) {
            int nFileType = GetFileTypeExW ( szFileName, 0, OPEN_EXISTING ) ;
            if ( nFileType == FILE_TYPE_DISK ) return 1 ;
         }
         if ( dwFlags & FILE_ACCESS_READ ) {
            int nFileType = GetFileTypeExW ( szFileName, GENERIC_READ, OPEN_EXISTING ) ;
            if ( nFileType == FILE_TYPE_DISK ) return 1 ;
         }
         if ( dwFlags & FILE_ACCESS_WRITE ) {
            int nFileType = GetFileTypeExW ( szFileName, GENERIC_WRITE, OPEN_EXISTING ) ;
            if ( nFileType == FILE_TYPE_DISK ) return 1 ;
         }
      }

      // foCXeXg
      if ( dwFlags & FILE_ACCESS_DEVICE ) {
         if ( dwFlags & ( FILE_ACCESS_READ | FILE_ACCESS_EXIST | FILE_ACCESS_VALID ) ) {
            int nFileType = GetFileTypeExW ( szFileName, GENERIC_READ, OPEN_EXISTING ) ;
            if ( nFileType == FILE_TYPE_CHAR || nFileType == FILE_TYPE_UNKNOWN ) return 1 ;
         }
         if ( dwFlags & ( FILE_ACCESS_WRITE | FILE_ACCESS_EXIST | FILE_ACCESS_VALID ) ) {
            int nFileType = GetFileTypeExW ( szFileName, GENERIC_WRITE, OPEN_EXISTING ) ;
            if ( nFileType == FILE_TYPE_CHAR || nFileType == FILE_TYPE_UNKNOWN ) return 1 ;
         }
      }

   }

   return 0 ;
}



static int GetFileTypeExW ( const wchar_t *szFileName, unsigned long dwAccess, int nCreation ) {

   unsigned long dwAttributes = FILE_ATTRIBUTE_NORMAL ;
   if ( nCreation == CREATE_NEW ) dwAttributes = FILE_ATTRIBUTE_TEMPORARY | FILE_FLAG_DELETE_ON_CLOSE ;

   unsigned long dwShare = FILE_SHARE_READ | FILE_SHARE_WRITE ;

   int nFileType = -1 ;

   HANDLE hFile = INVALID_HANDLE_VALUE ;
   HANDLE hFileSub = INVALID_HANDLE_VALUE ;
   wchar_t *szFileNameSub = NULL ;


   // Xg[쐬ꍇ́AXg[ꎞIɍ쐬
   if ( nCreation == CREATE_NEW && GetAlternateDataStreamsNameW ( szFileName ) ) {

      szFileNameSub = wcsdup ( szFileName ) ;
      if ( ! szFileNameSub ) goto EXIT ;

      ChangeAlternateDataStreamsNameW ( szFileNameSub, NULL ) ;
      if ( ! GetFileNameW ( szFileNameSub ) ) goto EXIT ;

      hFileSub = CreateFileW ( szFileNameSub, 0, dwShare, NULL, nCreation, dwAttributes, NULL ) ;

      dwShare |= FILE_SHARE_DELETE ;
   }

   hFile = CreateFileW ( szFileName, dwAccess, dwShare, NULL, nCreation, dwAttributes, NULL ) ;
   if ( hFile == INVALID_HANDLE_VALUE ) goto EXIT ;

   nFileType = GetFileType ( hFile ) ;


   EXIT :

   if ( hFile != INVALID_HANDLE_VALUE ) CloseHandle ( hFile ) ;
   if ( hFileSub != INVALID_HANDLE_VALUE ) CloseHandle ( hFileSub ) ;
   free ( szFileNameSub ) ;

   return nFileType ;
}



