;------------------------------------------------------------------------
; TITLE : LED LIGHT LED-CONTROLL
; MCU PIC12F683 Microchip 
; MCU CLOCK	4MHZ (INT_RC)
;
; Version 	1.00 2010.DEC.12@LEDdqH̑f@iZp]_Ёj
;
; YS Design Studio 2000-2010
; URL http://www5b.biglobe.ne.jp/~YASUSI
;------------------------------------------------------------------------
;  LED-CONTROLL 30% - 50% - 100% - BLINK
;------------------------------------------
;PIC12F629 PIN ASSIGN
;------------------------------------------
; PIN Assign
; (8) GND
; (7) GPIO-0 LED (PWM-OUT)
; (6) GPIO-1 NC
; (5) GPIO-2 NC
; (4) GPIO-3 PULL UP 10kohm-VDD
; (3) GPIO-4 NC
; (2) GPIO-5 NC
; (1) VDD
;---------------------------------------------------------------------------

	list	p=12f683
 	include	p12f683.inc
	__CONFIG _CP_OFF & _CPD_OFF & _WDT_OFF & _BOD_ON & _PWRTE_OFF & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF

;------------------------------------------------------------
; Defain
;------------------------------------------------------------
WAIT1		EQU	0x20	; EFCgJEgp	
WAIT2		EQU	0x21	; EFCgJEgp

FLAG		EQU	0x23	; BIT0:2b^C}[tO
MODE		EQU	0x24	; [hl
NOW_MODE	EQU	0x25	; ݂̃[hl
PULSE_HIGH	EQU	0x26	; ovl@ghfg
PULSE_LOW	EQU	0x27	; ovl@knv@
TIMER_2SEC	EQU	0x28	; Qb^C}[QJE^[

EEPROM_ADDR	EQU	0x30	; ddoqnlEANZXEAhX

W_SAVE 		EQU	0X40	; vWX^ޔp
STATUS_SAVE 	EQU	0X41	; STATUSWX^ޔp
   
;-----------------------------------------------------------
; ddoqnlftHgݒ
;-----------------------------------------------------------
	ORG	0x2100		; f[^ލŏ̃AhX
	de	0x04		; mode l

;------------------------------------------------------------
; Power On vector
;------------------------------------------------------------
	ORG	0x00
       	goto	MAIN
;------------------------------------------------------------
; Interrupt vector
;------------------------------------------------------------
	ORG	0x04
	goto	INTERRUPT

;===================================================================
; Interrupt Routine
;===================================================================
INTERRUPT
	movwf	W_SAVE		; [LOWX^̑ޔ
	swapf	STATUS,W
	movwf	STATUS_SAVE	; Xe[^XWX^̑ޔ

;------------------------------
; TMR0-2sec TIMER
;------------------------------
TMR0_INT
	decfsz	TIMER_2SEC,F	; QiڃJE^[Z
	goto	INTERRUPT_ESC	; ܂AQbɓBĂȂB

	bsf	FLAG,0		; Qbo߂ŃtOP|nm

;------------------------------
; Interrupt ESC
;------------------------------
INTERRUPT_ESC
	clrf	TMR0
	bcf	INTCON,T0IF

	swapf	STATUS_SAVE,W
	movwf	STATUS		; Xe[^XWX^̕
	swapf	W_SAVE,F
	swapf	W_SAVE,W	; [LOWX^̕

	retfie
;===================================================================
;                               MAIN
;===================================================================


MAIN

;------------------------------------
; Initialize PIC Microchip
;------------------------------------
	bcf	INTCON,GIE	; Interrupt Disable

	movlw	b'00000111'	; Rp[^[͎gpȂB
	movwf	CMCON0 		; CMCON = CM0/CM1/CM2 ON (COMPARATOR OFF)

	bsf	STATUS,RP0	; oNPɐ؂ւ

	movlw	b'11111110'	; |[go͐ݒ  
	movwf	TRISIO

	movlw	b'00000111'
	movwf	OPTION_REG	; TMR0 ݒ@NbNJEg{vXP[ 256

	movlw	B'01100000'	; INT OSC 8Mhz 
	movwf	OSCCON	

	bcf	STATUS,RP0	; oNOɐ؂ւi߂j

	clrf	FLAG

	clrf	GPIO		; |[g

	call	WAIT50MS	; lbt҂̃AChOE[v

;------------------------------------
; MODE CHANGE
;------------------------------------
	movlw	0x00
	movwf	EEPROM_ADDR	; SET READ ADDRES

	call	EEPROM_READ	; EEPROM READ (mode )

	movfw	MODE
	movwf	NOW_MODE	; ݂̃[hm

	bcf	STATUS,C	; MODE INCREMENT
	rlf	MODE,F

	btfss	MODE,4		; [hS܂ōsH 2010.JUL.04
	goto	MODE_SAVE

	movlw	b'00000001'	; [hS܂ōsOɖ߂B
	movwf	MODE
;------------------------------------
; V[hۑ
;------------------------------------
MODE_SAVE

	call	EEPROM_WRITE	; MODE SAVE

;------------------------------------
; LIGHT ON (GPIO-0 OUT)
;------------------------------------
LIGHT_ON
	btfsc	NOW_MODE,0	; [hO̔
	goto	MODE0

	btfsc	NOW_MODE,1	; [hP̔
	goto	MODE1

	btfsc	NOW_MODE,2	; [hQ̔@POO
	goto	MODE0

	btfsc	NOW_MODE,3	; [hR̔@uN[h 2010.JUL.04
	goto	BLINK_START

MODE0
	movlw	0x01		; T
	movwf	PULSE_HIGH	; [hO@ghfgԂ̐ݒ

	movlw	0x21		; XT
	movwf	PULSE_LOW	; [hO@knv@Ԃ̐ݒ

	goto	PWM_SATRT
MODE1
	movlw	0x0B		; RO
	movwf	PULSE_HIGH	; [hP@ghfgԂ̐ݒ

	movlw	0x1A		; VO
	movwf	PULSE_LOW	; [hP@knv@Ԃ̐ݒ


;------------------------------------
; 2sec TIMER & PWM
;------------------------------------
PWM_SATRT
	movlw	D'30'
	movwf	TIMER_2SEC	; Qb^C}@ROݒ@(1.966sec)

	clrf	TMR0		; slqO@NA

	bsf	INTCON,T0IE	; slqO@荞݊Jn

WAIT2SEC_LOOP
;------------------------------------
; ovl@PTCN@HIGH@@LOW
;------------------------------------
	bcf	GPIO,0		; GPIO ghfg
	
	btfsc	NOW_MODE,2	; DUTY@POÓ@HIGHŒ@[hQ
	goto	WAIT2SEC_LOOP_1	;
	
	movfw	PULSE_HIGH	; HIGH@EFCg
	movwf	WAIT1
		
	decfsz	WAIT1,F
	goto	$-1

	bsf	GPIO,0		; GPIO knv

	movfw	PULSE_LOW	; LOW@EFCg
	movwf	WAIT1
		
	decfsz	WAIT1,F
	goto	$-1

WAIT2SEC_LOOP_1
	btfsc	FLAG,1		; ݊tO
	goto	WRITE_END_CHECK

	btfss	FLAG,0		; QbԃEFCg
	goto	WAIT2SEC_LOOP
;------------------------------------
; Qbo
;------------------------------------
	bcf	FLAG,0		; Qbo߃tONA

	bcf	INTCON,T0IE	; slqO@荞݋֎~
				; ȍ~AFLAG-0@Zbg邱Ƃ͂ȂB

;------------------------------------
; [hɖ߂B@݊Jn
;------------------------------------
	movfw	NOW_MODE	; ݂̃[hۑ
	movwf	MODE

	call	EEPROM_WRITE_2	; MODE SAVE

	bsf	FLAG,1		; ݊tOPɃZbg@ݒ

	goto	WAIT2SEC_LOOP	; [v

;------------------------------------
; ݊mF
;------------------------------------
WRITE_END_CHECK
	bsf	STATUS,RP0	; Set BANK0

	btfss	EECON1,WR	; WRITE wait	
	goto	WRITE_COMPLETE

	bcf	STATUS,RP0	; Set BANK0

	goto	WAIT2SEC_LOOP	; begin write
;------------------------------------
;݊Ƃ̏
;------------------------------------
WRITE_COMPLETE
	bcf	EECON1,WREN	; Disable writes

	bcf	STATUS,RP0	; Set BANK0

	bsf	INTCON,GIE	; Enable INTs.

	bcf	FLAG,1		; ݊tOOɃZbg@݊

	goto	WAIT2SEC_LOOP	; [v

;------------------------------------------------------------------------
; uN[h
; 2sec TIMER & BLINK
; 2010.JUL.04
;------------------------------------------------------------------------
BLINK_START
	movlw	D'30'
	movwf	TIMER_2SEC	; Qb^C}@ROݒ@(1.966sec)

	clrf	TMR0		; slqO@NA

	bsf	INTCON,T0IE	; slqO@荞݊Jn

BLINK_WAIT2SEC_LOOP
;------------------------------------------------------
; uN@PTCN@HIGH 500ms@@LOW 500ms
;------------------------------------------------------
	bcf	GPIO,0			; GPIO ghfg
	
	call	WAIT50MS
	call	WAIT50MS
	call	WAIT50MS
	call	WAIT50MS
	call	WAIT50MS

	call	WAIT50MS
	call	WAIT50MS
	call	WAIT50MS
	call	WAIT50MS
	call	WAIT50MS

	bsf	GPIO,0			; GPIO knv

	call	WAIT50MS
	call	WAIT50MS
	call	WAIT50MS
	call	WAIT50MS
	call	WAIT50MS

	call	WAIT50MS
	call	WAIT50MS
	call	WAIT50MS
	call	WAIT50MS
	call	WAIT50MS

	btfsc	FLAG,1			; ݊tO
	goto	BLINK_WRITE_END_CHECK

	btfss	FLAG,0			; QbԃEFCg
	goto	BLINK_WAIT2SEC_LOOP
;------------------------------------
; Qbo
;------------------------------------
	bcf	FLAG,0			; Qbo߃tONA

	bcf	INTCON,T0IE		; slqO@荞݋֎~
					; ȍ~AFLAG-0@Zbg邱Ƃ͂ȂB

;------------------------------------
; [hɖ߂B@݊Jn
;------------------------------------
	movfw	NOW_MODE		; ݂̃[hۑ
	movwf	MODE

	call	EEPROM_WRITE_2		; MODE SAVE

	bsf	FLAG,1			; ݊tOPɃZbg@ݒ

	goto	BLINK_WAIT2SEC_LOOP	; [v

;------------------------------------
; ݊mF
;------------------------------------
BLINK_WRITE_END_CHECK
	bsf	STATUS,RP0		; Set BANK0

	btfss	EECON1,WR		; WRITE wait	
	goto	BLINK_WRITE_COMPLETE

	bcf	STATUS,RP0		; Set BANK0

	goto	BLINK_WAIT2SEC_LOOP	; begin write
;------------------------------------
;݊Ƃ̏
;------------------------------------
BLINK_WRITE_COMPLETE
	bcf	EECON1,WREN		; Disable writes

	bcf	STATUS,RP0		; Set BANK0

	bsf	INTCON,GIE		; Enable INTs.

	bcf	FLAG,1			; ݊tOOɃZbg@݊

	goto	BLINK_WAIT2SEC_LOOP	; [v

;=============================================================================
;                                  MAIN END
;                             SUB ROUTINE START
;=============================================================================

;-------------------------------------------------------------
;EEPROM READ
;-------------------------------------------------------------
EEPROM_READ
	movfw	EEPROM_ADDR	;

	bsf	STATUS,RP0

	movwf	EEADR		; Data Memory Address to read

	bsf	EECON1,RD	; EE Read

	movfw	EEDATA		; W = EEDATA

	bcf	STATUS,RP0

	movwf	MODE

	return

;-------------------------------------------------------
;EEPROM WRITE
;-------------------------------------------------------
EEPROM_WRITE

	movfw	EEPROM_ADDR	;

	bsf	STATUS,RP0	; Set BANK0
	movwf	EEADR		; Data Memory Address to write
	bcf	STATUS,RP0	; Set BANK0

	movfw	MODE		;

	bsf	STATUS,RP0	; Set BANK0
	movwf	EEDAT		; Data Memory Value to write
	bsf	EECON1,WREN	; Enable writes
	bcf	STATUS,RP0	; Set BANK0

	bcf	INTCON,GIE	; Disable INTs.

	bsf	STATUS,RP0	; Set BANK0

	movlw	0x55		;
	movwf	EECON2		; Write 55h

	movlw	0xAA		;
	movwf	EECON2		; Write AAh

	bsf	EECON1,WR	; Set WR BIT to

	btfsc	EECON1,WR	; WRITE wait	
	goto	$-1		; begin write

	bcf	EECON1,WREN	; Disable writes

	bcf	STATUS,RP0	; Set BANK0

	bsf	INTCON,GIE	; Enable INTs.

	return
;-------------------------------------------------------
; EEPROM WRITE 2
; ݒ̏ł悤ɁAݎwシ߂B
; ovl̃[vŏ݊`FbNB
; ddhd荞݂łł܂A͂̕@őΉ
;-------------------------------------------------------
EEPROM_WRITE_2

	movfw	EEPROM_ADDR	;

	bsf	STATUS,RP0	; Set BANK0
	movwf	EEADR		; Data Memory Address to write
	bcf	STATUS,RP0	; Set BANK0

	movfw	MODE		;

	bsf	STATUS,RP0	; Set BANK0
	movwf	EEDAT		; Data Memory Value to write
	bsf	EECON1,WREN	; Enable writes
	bcf	STATUS,RP0	; Set BANK0

	bcf	INTCON,GIE	; Disable INTs.

	bsf	STATUS,RP0	; Set BANK0

	movlw	0x55		;
	movwf	EECON2		; Write 55h

	movlw	0xAA		;
	movwf	EECON2		; Write AAh

	bsf	EECON1,WR	; Set WR BIT to

	bcf	STATUS,RP0	; Set BANK0

	return
;------------------------------------------------------------
; WAIT
;------------------------------------------------------------

;----------------------------
; WAIT 10MS
;----------------------------
WAIT10MS
	movlw	0xC0
	movwf	WAIT1

WAIT10MS_LOOP
	movlw	0x10
	movwf	WAIT2
	
	decfsz	WAIT2,F
	goto	$-1	

	decfsz	WAIT1,F
	goto	WAIT10MS_LOOP

	goto	$+1
	goto	$+1
	goto	$+1
	goto	$+1
	goto	$+1
	nop

	return

;----------------------------
; WAIT 50MS
;----------------------------
WAIT50MS
	call	WAIT10MS
	call	WAIT10MS
	call	WAIT10MS
	call	WAIT10MS
	call	WAIT10MS

	return 

	END

           
